from distutils.core import setup, Extension

sfc_module = Extension('igeBullet',
	sources=[
        'bullet/BulletSoftBody/btSoftSoftCollisionAlgorithm.cpp',
        'bullet/BulletSoftBody/btDeformableContactProjection.cpp',
        'bullet/BulletSoftBody/btSoftBodyConcaveCollisionAlgorithm.cpp',
        'bullet/BulletSoftBody/btDeformableContactConstraint.cpp',
        'bullet/BulletSoftBody/btSoftRigidCollisionAlgorithm.cpp',
        'bullet/BulletSoftBody/btDefaultSoftBodySolver.cpp',
        'bullet/BulletSoftBody/btDeformableBodySolver.cpp',
        'bullet/BulletSoftBody/btDeformableMultiBodyDynamicsWorld.cpp',
        'bullet/BulletSoftBody/btSoftBody.cpp',
        'bullet/BulletSoftBody/btSoftMultiBodyDynamicsWorld.cpp',
        'bullet/BulletSoftBody/btSoftRigidDynamicsWorld.cpp',
        'bullet/BulletSoftBody/btSoftBodyRigidBodyCollisionConfiguration.cpp',
        'bullet/BulletSoftBody/btDeformableMultiBodyConstraintSolver.cpp',
        'bullet/BulletSoftBody/btSoftBodyHelpers.cpp',
        'bullet/BulletSoftBody/btDeformableBackwardEulerObjective.cpp',
        'bullet/BulletCollision/BroadphaseCollision/btQuantizedBvh.cpp',
        'bullet/BulletCollision/BroadphaseCollision/btDbvt.cpp',
        'bullet/BulletCollision/BroadphaseCollision/btAxisSweep3.cpp',
        'bullet/BulletCollision/BroadphaseCollision/btOverlappingPairCache.cpp',
        'bullet/BulletCollision/BroadphaseCollision/btDbvtBroadphase.cpp',
        'bullet/BulletCollision/BroadphaseCollision/btSimpleBroadphase.cpp',
        'bullet/BulletCollision/BroadphaseCollision/btDispatcher.cpp',
        'bullet/BulletCollision/BroadphaseCollision/btBroadphaseProxy.cpp',
        'bullet/BulletCollision/BroadphaseCollision/btCollisionAlgorithm.cpp',
        'bullet/BulletCollision/NarrowPhaseCollision/btMinkowskiPenetrationDepthSolver.cpp',
        'bullet/BulletCollision/NarrowPhaseCollision/btGjkPairDetector.cpp',
        'bullet/BulletCollision/NarrowPhaseCollision/btConvexCast.cpp',
        'bullet/BulletCollision/NarrowPhaseCollision/btGjkConvexCast.cpp',
        'bullet/BulletCollision/NarrowPhaseCollision/btContinuousConvexCollision.cpp',
        'bullet/BulletCollision/NarrowPhaseCollision/btGjkEpa2.cpp',
        'bullet/BulletCollision/NarrowPhaseCollision/btPersistentManifold.cpp',
        'bullet/BulletCollision/NarrowPhaseCollision/btVoronoiSimplexSolver.cpp',
        'bullet/BulletCollision/NarrowPhaseCollision/btGjkEpaPenetrationDepthSolver.cpp',
        'bullet/BulletCollision/NarrowPhaseCollision/btPolyhedralContactClipping.cpp',
        'bullet/BulletCollision/NarrowPhaseCollision/btSubSimplexConvexCast.cpp',
        'bullet/BulletCollision/NarrowPhaseCollision/btRaycastCallback.cpp',
        'bullet/BulletCollision/CollisionDispatch/btBox2dBox2dCollisionAlgorithm.cpp',
        'bullet/BulletCollision/CollisionDispatch/btInternalEdgeUtility.cpp',
        'bullet/BulletCollision/CollisionDispatch/btUnionFind.cpp',
        'bullet/BulletCollision/CollisionDispatch/btCollisionWorld.cpp',
        'bullet/BulletCollision/CollisionDispatch/btGhostObject.cpp',
        'bullet/BulletCollision/CollisionDispatch/btSphereTriangleCollisionAlgorithm.cpp',
        'bullet/BulletCollision/CollisionDispatch/btSimulationIslandManager.cpp',
        'bullet/BulletCollision/CollisionDispatch/btSphereBoxCollisionAlgorithm.cpp',
        'bullet/BulletCollision/CollisionDispatch/btCollisionDispatcherMt.cpp',
        'bullet/BulletCollision/CollisionDispatch/btManifoldResult.cpp',
        'bullet/BulletCollision/CollisionDispatch/btCollisionWorldImporter.cpp',
        'bullet/BulletCollision/CollisionDispatch/btActivatingCollisionAlgorithm.cpp',
        'bullet/BulletCollision/CollisionDispatch/btConvex2dConvex2dAlgorithm.cpp',
        'bullet/BulletCollision/CollisionDispatch/SphereTriangleDetector.cpp',
        'bullet/BulletCollision/CollisionDispatch/btCollisionDispatcher.cpp',
        'bullet/BulletCollision/CollisionDispatch/btDefaultCollisionConfiguration.cpp',
        'bullet/BulletCollision/CollisionDispatch/btConvexConcaveCollisionAlgorithm.cpp',
        'bullet/BulletCollision/CollisionDispatch/btConvexPlaneCollisionAlgorithm.cpp',
        'bullet/BulletCollision/CollisionDispatch/btCompoundCollisionAlgorithm.cpp',
        'bullet/BulletCollision/CollisionDispatch/btConvexConvexAlgorithm.cpp',
        'bullet/BulletCollision/CollisionDispatch/btHashedSimplePairCache.cpp',
        'bullet/BulletCollision/CollisionDispatch/btEmptyCollisionAlgorithm.cpp',
        'bullet/BulletCollision/CollisionDispatch/btSphereSphereCollisionAlgorithm.cpp',
        'bullet/BulletCollision/CollisionDispatch/btBoxBoxDetector.cpp',
        'bullet/BulletCollision/CollisionDispatch/btCompoundCompoundCollisionAlgorithm.cpp',
        'bullet/BulletCollision/CollisionDispatch/btBoxBoxCollisionAlgorithm.cpp',
        'bullet/BulletCollision/CollisionDispatch/btCollisionObject.cpp',
        'bullet/BulletCollision/Gimpact/gim_tri_collision.cpp',
        'bullet/BulletCollision/Gimpact/btGImpactQuantizedBvh.cpp',
        'bullet/BulletCollision/Gimpact/gim_contact.cpp',
        'bullet/BulletCollision/Gimpact/btContactProcessing.cpp',
        'bullet/BulletCollision/Gimpact/gim_box_set.cpp',
        'bullet/BulletCollision/Gimpact/btTriangleShapeEx.cpp',
        'bullet/BulletCollision/Gimpact/btGenericPoolAllocator.cpp',
        'bullet/BulletCollision/Gimpact/btGImpactBvh.cpp',
        'bullet/BulletCollision/Gimpact/btGImpactCollisionAlgorithm.cpp',
        'bullet/BulletCollision/Gimpact/btGImpactShape.cpp',
        'bullet/BulletCollision/Gimpact/gim_memory.cpp',
        'bullet/BulletCollision/CollisionShapes/btMultiSphereShape.cpp',
        'bullet/BulletCollision/CollisionShapes/btConvexTriangleMeshShape.cpp',
        'bullet/BulletCollision/CollisionShapes/btSdfCollisionShape.cpp',
        'bullet/BulletCollision/CollisionShapes/btConvex2dShape.cpp',
        'bullet/BulletCollision/CollisionShapes/btConvexShape.cpp',
        'bullet/BulletCollision/CollisionShapes/btTriangleIndexVertexArray.cpp',
        'bullet/BulletCollision/CollisionShapes/btTriangleCallback.cpp',
        'bullet/BulletCollision/CollisionShapes/btBox2dShape.cpp',
        'bullet/BulletCollision/CollisionShapes/btConeShape.cpp',
        'bullet/BulletCollision/CollisionShapes/btShapeHull.cpp',
        'bullet/BulletCollision/CollisionShapes/btCompoundShape.cpp',
        'bullet/BulletCollision/CollisionShapes/btCylinderShape.cpp',
        'bullet/BulletCollision/CollisionShapes/btCollisionShape.cpp',
        'bullet/BulletCollision/CollisionShapes/btStaticPlaneShape.cpp',
        'bullet/BulletCollision/CollisionShapes/btMultimaterialTriangleMeshShape.cpp',
        'bullet/BulletCollision/CollisionShapes/btTetrahedronShape.cpp',
        'bullet/BulletCollision/CollisionShapes/btConcaveShape.cpp',
        'bullet/BulletCollision/CollisionShapes/btConvexInternalShape.cpp',
        'bullet/BulletCollision/CollisionShapes/btTriangleMesh.cpp',
        'bullet/BulletCollision/CollisionShapes/btTriangleMeshShape.cpp',
        'bullet/BulletCollision/CollisionShapes/btMinkowskiSumShape.cpp',
        'bullet/BulletCollision/CollisionShapes/btStridingMeshInterface.cpp',
        'bullet/BulletCollision/CollisionShapes/btTriangleBuffer.cpp',
        'bullet/BulletCollision/CollisionShapes/btBvhTriangleMeshShape.cpp',
        'bullet/BulletCollision/CollisionShapes/btSphereShape.cpp',
        'bullet/BulletCollision/CollisionShapes/btOptimizedBvh.cpp',
        'bullet/BulletCollision/CollisionShapes/btCapsuleShape.cpp',
        'bullet/BulletCollision/CollisionShapes/btConvexPolyhedron.cpp',
        'bullet/BulletCollision/CollisionShapes/btScaledBvhTriangleMeshShape.cpp',
        'bullet/BulletCollision/CollisionShapes/btUniformScalingShape.cpp',
        'bullet/BulletCollision/CollisionShapes/btEmptyShape.cpp',
        'bullet/BulletCollision/CollisionShapes/btMiniSDF.cpp',
        'bullet/BulletCollision/CollisionShapes/btConvexHullShape.cpp',
        'bullet/BulletCollision/CollisionShapes/btBoxShape.cpp',
        'bullet/BulletCollision/CollisionShapes/btTriangleIndexVertexMaterialArray.cpp',
        'bullet/BulletCollision/CollisionShapes/btHeightfieldTerrainShape.cpp',
        'bullet/BulletCollision/CollisionShapes/btPolyhedralConvexShape.cpp',
        'bullet/BulletCollision/CollisionShapes/btConvexPointCloudShape.cpp',
        'bullet/BulletDynamics/Dynamics/btSimulationIslandManagerMt.cpp',
        'bullet/BulletDynamics/Dynamics/btDiscreteDynamicsWorld.cpp',
        'bullet/BulletDynamics/Dynamics/btRigidBody.cpp',
        'bullet/BulletDynamics/Dynamics/btSimpleDynamicsWorld.cpp',
        'bullet/BulletDynamics/Dynamics/btDiscreteDynamicsWorldMt.cpp',
        'bullet/BulletDynamics/Vehicle/btRaycastVehicle.cpp',
        'bullet/BulletDynamics/Vehicle/btWheelInfo.cpp',
        'bullet/BulletDynamics/Character/btKinematicCharacterController.cpp',
        'bullet/BulletDynamics/Featherstone/btMultiBodyFixedConstraint.cpp',
        'bullet/BulletDynamics/Featherstone/btMultiBodyDynamicsWorld.cpp',
        'bullet/BulletDynamics/Featherstone/btMultiBodySphericalJointMotor.cpp',
        'bullet/BulletDynamics/Featherstone/btMultiBodySliderConstraint.cpp',
        'bullet/BulletDynamics/Featherstone/btMultiBodyConstraintSolver.cpp',
        'bullet/BulletDynamics/Featherstone/btMultiBodyMLCPConstraintSolver.cpp',
        'bullet/BulletDynamics/Featherstone/btMultiBodyPoint2Point.cpp',
        'bullet/BulletDynamics/Featherstone/btMultiBodyJointMotor.cpp',
        'bullet/BulletDynamics/Featherstone/btMultiBody.cpp',
        'bullet/BulletDynamics/Featherstone/btMultiBodyConstraint.cpp',
        'bullet/BulletDynamics/Featherstone/btMultiBodyJointLimitConstraint.cpp',
        'bullet/BulletDynamics/Featherstone/btMultiBodyGearConstraint.cpp',
        'bullet/BulletDynamics/MLCPSolvers/btLemkeAlgorithm.cpp',
        'bullet/BulletDynamics/MLCPSolvers/btMLCPSolver.cpp',
        'bullet/BulletDynamics/MLCPSolvers/btDantzigLCP.cpp',
        'bullet/BulletDynamics/ConstraintSolver/btGearConstraint.cpp',
        'bullet/BulletDynamics/ConstraintSolver/btContactConstraint.cpp',
        'bullet/BulletDynamics/ConstraintSolver/btSequentialImpulseConstraintSolver.cpp',
        'bullet/BulletDynamics/ConstraintSolver/btConeTwistConstraint.cpp',
        'bullet/BulletDynamics/ConstraintSolver/btTypedConstraint.cpp',
        'bullet/BulletDynamics/ConstraintSolver/btSliderConstraint.cpp',
        'bullet/BulletDynamics/ConstraintSolver/btHingeConstraint.cpp',
        'bullet/BulletDynamics/ConstraintSolver/btBatchedConstraints.cpp',
        'bullet/BulletDynamics/ConstraintSolver/btGeneric6DofConstraint.cpp',
        'bullet/BulletDynamics/ConstraintSolver/btUniversalConstraint.cpp',
        'bullet/BulletDynamics/ConstraintSolver/btSolve2LinearConstraint.cpp',
        'bullet/BulletDynamics/ConstraintSolver/btHinge2Constraint.cpp',
        'bullet/BulletDynamics/ConstraintSolver/btGeneric6DofSpring2Constraint.cpp',
        'bullet/BulletDynamics/ConstraintSolver/btPoint2PointConstraint.cpp',
        'bullet/BulletDynamics/ConstraintSolver/btSequentialImpulseConstraintSolverMt.cpp',
        'bullet/BulletDynamics/ConstraintSolver/btFixedConstraint.cpp',
        'bullet/BulletDynamics/ConstraintSolver/btNNCGConstraintSolver.cpp',
        'bullet/BulletDynamics/ConstraintSolver/btGeneric6DofSpringConstraint.cpp',
        'bullet/LinearMath/btQuickprof.cpp',
        'bullet/LinearMath/btSerializer64.cpp',
        'bullet/LinearMath/btConvexHullComputer.cpp',
        'bullet/LinearMath/btThreads.cpp',
        'bullet/LinearMath/btSerializer.cpp',
        'bullet/LinearMath/btGeometryUtil.cpp',
        'bullet/LinearMath/btPolarDecomposition.cpp',
        'bullet/LinearMath/btVector3.cpp',
        'bullet/LinearMath/btConvexHull.cpp',
        'bullet/LinearMath/btAlignedAllocator.cpp',
        'bullet/LinearMath/TaskScheduler/btThreadSupportPosix.cpp',
        'bullet/LinearMath/TaskScheduler/btThreadSupportWin32.cpp',
        'bullet/LinearMath/TaskScheduler/btTaskScheduler.cpp',
		'igeBullet.cpp',
		'graphicsHelper.cpp'
	],
    include_dirs=['bullet'])

setup(name='igeBullet', version='0.3.6',
		author=u'Kiharu Shishikura',
		author_email='dev@indigames.net',
		description='Bullet physics library for python.',
		ext_modules=[sfc_module],
		long_description='Bullet physics library for python.',
		license='MIT',
		classifiers=[
			'Intended Audience :: Developers',
			'License :: OSI Approved :: MIT License',
			'Programming Language :: Python :: 3',
			'Operating System :: MacOS :: MacOS X',
			'Operating System :: POSIX :: Linux',
			'Operating System :: Microsoft :: Windows',
			'Topic :: Games/Entertainment',
		],
      )
