"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Network = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk_vpc_1 = require("@pepperize/cdk-vpc");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_ec2_1 = require("aws-cdk-lib/aws-ec2");
const constructs_1 = require("constructs");
/**
 * Network settings for the manager and runners
 *
 *  All EC2 instances should belong to the same subnet, availability zone and vpc.
 */
class Network extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.vpc =
            props?.vpc ??
                new cdk_vpc_1.CheapVpc(scope, `Vpc`, {
                    maxAzs: 1,
                });
        this.subnet = this.findSubnet(this.vpc, props?.subnetSelection);
        this.availabilityZone = this.subnet.availabilityZone;
        if (!this.hasPrivateSubnets()) {
            aws_cdk_lib_1.Annotations.of(this).addWarning(`No private network found in ${this.vpc.vpcId}, using public addresses.`);
        }
    }
    hasPrivateSubnets() {
        return !!this.vpc.privateSubnets.length;
    }
    /**
     * Returns the first private or public subnet. Optionally filters by AZ.
     *
     * @exception Throws an error if no private or public is found.
     */
    findSubnet(vpc, subnetSelection) {
        const selectedSubnets = vpc.selectSubnets(subnetSelection || {
            subnetType: this.hasPrivateSubnets() ? aws_ec2_1.SubnetType.PRIVATE_WITH_NAT : aws_ec2_1.SubnetType.PUBLIC,
            availabilityZones: vpc.availabilityZones,
        });
        const subnet = selectedSubnets.subnets.find(() => true);
        if (!subnet) {
            throw new Error(`Neither a private nor a public subnet is found in ${vpc.vpcId}`);
        }
        return subnet;
    }
}
exports.Network = Network;
_a = JSII_RTTI_SYMBOL_1;
Network[_a] = { fqn: "@pepperize/cdk-autoscaling-gitlab-runner.Network", version: "0.2.245" };
//# sourceMappingURL=data:application/json;base64,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