"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFormationProduct = exports.Product = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const association_manager_1 = require("./private/association-manager");
const validation_1 = require("./private/validation");
const servicecatalog_generated_1 = require("./servicecatalog.generated");
class ProductBase extends core_1.Resource {
    /**
     * (experimental) Associate Tag Options.
     *
     * A TagOption is a key-value pair managed in AWS Service Catalog.
     * It is not an AWS tag, but serves as a template for creating an AWS tag based on the TagOption.
     *
     * @experimental
     */
    associateTagOptions(tagOptions) {
        association_manager_1.AssociationManager.associateTagOptions(this, this.productId, tagOptions);
    }
}
/**
 * (experimental) Abstract class for Service Catalog Product.
 *
 * @experimental
 */
class Product extends ProductBase {
    /**
     * (experimental) Creates a Product construct that represents an external product.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param productArn Product Arn.
     * @experimental
     */
    static fromProductArn(scope, id, productArn) {
        const arn = core_1.Stack.of(scope).splitArn(productArn, core_1.ArnFormat.SLASH_RESOURCE_NAME);
        const productId = arn.resourceName;
        if (!productId) {
            throw new Error('Missing required Portfolio ID from Portfolio ARN: ' + productArn);
        }
        return new class extends ProductBase {
            constructor() {
                super(...arguments);
                this.productId = productId;
                this.productArn = productArn;
            }
        }(scope, id);
    }
}
exports.Product = Product;
_a = JSII_RTTI_SYMBOL_1;
Product[_a] = { fqn: "@aws-cdk/aws-servicecatalog.Product", version: "1.140.0" };
/**
 * (experimental) A Service Catalog Cloudformation Product.
 *
 * @experimental
 */
class CloudFormationProduct extends Product {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_servicecatalog_CloudFormationProductProps(props);
        this.validateProductProps(props);
        const product = new servicecatalog_generated_1.CfnCloudFormationProduct(this, 'Resource', {
            acceptLanguage: props.messageLanguage,
            description: props.description,
            distributor: props.distributor,
            name: props.productName,
            owner: props.owner,
            provisioningArtifactParameters: this.renderProvisioningArtifacts(props),
            replaceProvisioningArtifacts: props.replaceProductVersionIds,
            supportDescription: props.supportDescription,
            supportEmail: props.supportEmail,
            supportUrl: props.supportUrl,
        });
        this.productId = product.ref;
        this.productArn = core_1.Stack.of(this).formatArn({
            service: 'catalog',
            resource: 'product',
            resourceName: product.ref,
        });
        if (props.tagOptions !== undefined) {
            this.associateTagOptions(props.tagOptions);
        }
    }
    renderProvisioningArtifacts(props) {
        return props.productVersions.map(productVersion => {
            const template = productVersion.cloudFormationTemplate.bind(this);
            validation_1.InputValidator.validateUrl(this.node.path, 'provisioning template url', template.httpUrl);
            return {
                name: productVersion.productVersionName,
                description: productVersion.description,
                disableTemplateValidation: productVersion.validateTemplate === false ? true : false,
                info: {
                    LoadTemplateFromURL: template.httpUrl,
                },
            };
        });
    }
    ;
    validateProductProps(props) {
        validation_1.InputValidator.validateLength(this.node.path, 'product product name', 1, 100, props.productName);
        validation_1.InputValidator.validateLength(this.node.path, 'product owner', 1, 8191, props.owner);
        validation_1.InputValidator.validateLength(this.node.path, 'product description', 0, 8191, props.description);
        validation_1.InputValidator.validateLength(this.node.path, 'product distributor', 0, 8191, props.distributor);
        validation_1.InputValidator.validateEmail(this.node.path, 'support email', props.supportEmail);
        validation_1.InputValidator.validateUrl(this.node.path, 'support url', props.supportUrl);
        validation_1.InputValidator.validateLength(this.node.path, 'support description', 0, 8191, props.supportDescription);
        if (props.productVersions.length == 0) {
            throw new Error(`Invalid product versions for resource ${this.node.path}, must contain at least 1 product version`);
        }
        props.productVersions.forEach(productVersion => {
            validation_1.InputValidator.validateLength(this.node.path, 'provisioning artifact name', 0, 100, productVersion.productVersionName);
            validation_1.InputValidator.validateLength(this.node.path, 'provisioning artifact description', 0, 8191, productVersion.description);
        });
    }
}
exports.CloudFormationProduct = CloudFormationProduct;
_b = JSII_RTTI_SYMBOL_1;
CloudFormationProduct[_b] = { fqn: "@aws-cdk/aws-servicecatalog.CloudFormationProduct", version: "1.140.0" };
//# sourceMappingURL=data:application/json;base64,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