#  zerogram - Telegram MTProto API Client Library for Python
#  Copyright (C) 2017-present Dan <https://github.com/delivrance>
#
#  This file is part of zerogram.
#
#  zerogram is free software: you can redistribute it and/or modify
#  it under the terms of the GNU Lesser General Public License as published
#  by the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  zerogram is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public License
#  along with zerogram.  If not, see <http://www.gnu.org/licenses/>.

from uuid import uuid4

import zerogram
from zerogram import types
from ..object import Object


class InlineQueryResult(Object):
    """One result of an inline query.

    - :obj:`~zerogram.types.InlineQueryResultCachedAudio`
    - :obj:`~zerogram.types.InlineQueryResultCachedDocument`
    - :obj:`~zerogram.types.InlineQueryResultCachedAnimation`
    - :obj:`~zerogram.types.InlineQueryResultCachedPhoto`
    - :obj:`~zerogram.types.InlineQueryResultCachedSticker`
    - :obj:`~zerogram.types.InlineQueryResultCachedVideo`
    - :obj:`~zerogram.types.InlineQueryResultCachedVoice`
    - :obj:`~zerogram.types.InlineQueryResultArticle`
    - :obj:`~zerogram.types.InlineQueryResultAudio`
    - :obj:`~zerogram.types.InlineQueryResultContact`
    - :obj:`~zerogram.types.InlineQueryResultDocument`
    - :obj:`~zerogram.types.InlineQueryResultAnimation`
    - :obj:`~zerogram.types.InlineQueryResultLocation`
    - :obj:`~zerogram.types.InlineQueryResultPhoto`
    - :obj:`~zerogram.types.InlineQueryResultVenue`
    - :obj:`~zerogram.types.InlineQueryResultVideo`
    - :obj:`~zerogram.types.InlineQueryResultVoice`
    """

    def __init__(
        self,
        type: str,
        id: str,
        input_message_content: "types.InputMessageContent",
        reply_markup: "types.InlineKeyboardMarkup"
    ):
        super().__init__()

        self.type = type
        self.id = str(uuid4()) if id is None else str(id)
        self.input_message_content = input_message_content
        self.reply_markup = reply_markup

    async def write(self, client: "zerogram.Client"):
        pass
