/*
 * Decompiled with CFR 0.152.
 */
package numpy.core;

import com.google.common.base.Charsets;
import com.google.common.collect.Iterables;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import numpy.DType;
import numpy.core.NDArrayUtil;
import org.jpmml.python.CustomPythonObject;
import org.jpmml.python.HasArray;
import org.jpmml.python.HasContent;

public class Scalar
extends CustomPythonObject
implements HasArray,
HasContent<List<?>> {
    private List<?> content = null;
    private static final String[] INIT_ATTRIBUTES = new String[]{"dtype", "obj"};

    public Scalar(String module, String name) {
        super(module, name);
    }

    @Override
    public void __init__(Object[] args) {
        super.__setstate__(Scalar.createAttributeMap(INIT_ATTRIBUTES, args));
    }

    @Override
    public List<?> getArrayContent() {
        Object content = this.getContent();
        return content;
    }

    @Override
    public int[] getArrayShape() {
        Object content = this.getContent();
        return new int[]{content.size()};
    }

    @Override
    public DType getArrayType() {
        return this.getDType();
    }

    public Object getOnlyElement() {
        Object content = this.getContent();
        return Iterables.getOnlyElement((Iterable)content);
    }

    @Override
    public List<?> getContent() {
        if (this.content == null) {
            this.content = this.loadContent();
        }
        return this.content;
    }

    @Override
    public void clearContent() {
        this.content = null;
    }

    private List<?> loadContent() {
        List list;
        DType dtype = this.getDType();
        byte[] obj = this.getObj();
        ByteArrayInputStream is = new ByteArrayInputStream(obj);
        try {
            list = (List)NDArrayUtil.parseData(is, dtype, new Object[0]);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        ((InputStream)is).close();
        return list;
    }

    public DType getDType() {
        return (DType)this.get("dtype");
    }

    public byte[] getObj() {
        Object obj = this.get("obj");
        if (obj instanceof String) {
            String string = (String)obj;
            return string.getBytes(Charsets.ISO_8859_1);
        }
        return (byte[])obj;
    }
}

