/*
 * Decompiled with CFR 0.152.
 */
package com.sklearn2pmml;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.dmg.pmml.PMML;
import org.jpmml.converter.Application;
import org.jpmml.model.metro.MetroJAXBUtil;
import org.jpmml.python.CastFunction;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.python.PickleUtil;
import org.jpmml.python.Storage;
import org.jpmml.python.StorageUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn2pmml.pipeline.PMMLPipeline;

public class Main
extends Application {
    @Parameter(names={"--pkl-pipeline-input", "--pkl-input"}, required=true)
    private File inputFile = null;
    @Parameter(names={"--pmml-output"}, required=true)
    private File outputFile = null;

    public static void main(String ... args) throws Exception {
        Main main = new Main();
        JCommander commander = JCommander.newBuilder().addObject((Object)main).build();
        commander.parse(args);
        try {
            Application.setInstance((Application)main);
            main.run();
        }
        finally {
            Application.setInstance(null);
        }
    }

    private void run() throws Exception {
        File absoluteOutputFile;
        File outputDir;
        Object object;
        SkLearnEncoder encoder = new SkLearnEncoder();
        try (Storage storage = StorageUtil.createStorage((File)this.inputFile);){
            object = PickleUtil.unpickle((Storage)storage);
        }
        CastFunction<PMMLPipeline> castFunction = new CastFunction<PMMLPipeline>(PMMLPipeline.class){

            protected String formatMessage(Object object) {
                return "The unpickled object (" + ClassDictUtil.formatClass((Object)object) + ") is not a PMMLPipeline";
            }
        };
        PMMLPipeline pmmlPipeline = (PMMLPipeline)castFunction.apply(object);
        PMML pmml = pmmlPipeline.encodePMML(encoder);
        if (!this.outputFile.exists() && !(outputDir = (absoluteOutputFile = this.outputFile.getAbsoluteFile()).getParentFile()).exists()) {
            outputDir.mkdirs();
        }
        try (FileOutputStream os = new FileOutputStream(this.outputFile);){
            MetroJAXBUtil.marshalPMML((PMML)pmml, (OutputStream)os);
        }
    }
}

