/*
 * Decompiled with CFR 0.152.
 */
package sklearn.multioutput;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.Model;
import org.dmg.pmml.mining.Segmentation;
import org.jpmml.converter.MultiLabel;
import org.jpmml.converter.Schema;
import org.jpmml.converter.mining.MiningModelUtil;
import sklearn.Estimator;

public class MultiOutputUtil {
    private MultiOutputUtil() {
    }

    public static <E extends Estimator> Model encodeEstimators(List<E> estimators, Schema schema) {
        if (estimators.size() == 1) {
            Estimator estimator = (Estimator)estimators.get(0);
            return estimator.encodeModel(schema);
        }
        if (estimators.size() >= 2) {
            MultiLabel multiLabel = (MultiLabel)schema.getLabel();
            ArrayList<Model> models = new ArrayList<Model>();
            for (int i = 0; i < estimators.size(); ++i) {
                Estimator estimator = (Estimator)estimators.get(i);
                Schema segmentSchema = schema.toRelabeledSchema(multiLabel.getLabel(i));
                Model model = estimator.encodeModel(segmentSchema);
                models.add(model);
            }
            return MiningModelUtil.createMultiModelChain(models, (Segmentation.MissingPredictionTreatment)Segmentation.MissingPredictionTreatment.CONTINUE);
        }
        throw new IllegalArgumentException();
    }
}

