/*
 * Decompiled with CFR 0.152.
 */
package h2o.estimators;

import hex.genmodel.MojoModel;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureList;
import org.jpmml.converter.Label;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.Schema;
import org.jpmml.h2o.Converter;
import org.jpmml.h2o.ConverterFactory;
import org.jpmml.h2o.H2OEncoder;
import org.jpmml.h2o.MojoModelUtil;
import sklearn.Estimator;
import sklearn.HasClasses;

public class H2OEstimator
extends Estimator
implements HasClasses {
    private MojoModel mojoModel = null;

    public H2OEstimator(String module, String name) {
        super(module, name);
    }

    public MiningFunction getMiningFunction() {
        String estimatorType;
        switch (estimatorType = this.getEstimatorType()) {
            case "classifier": {
                return MiningFunction.CLASSIFICATION;
            }
            case "regressor": {
                return MiningFunction.REGRESSION;
            }
        }
        throw new IllegalArgumentException(estimatorType);
    }

    public List<?> getClasses() {
        int responseIdx;
        MojoModel mojoModel = this.getMojoModel();
        String[] responseValues = mojoModel.getDomainValues(responseIdx = mojoModel.getResponseIdx());
        if (responseValues == null) {
            throw new IllegalArgumentException();
        }
        return Arrays.asList(responseValues);
    }

    public boolean hasProbabilityDistribution() {
        String estimatorType;
        switch (estimatorType = this.getEstimatorType()) {
            case "classifier": {
                return true;
            }
            case "regressor": {
                return false;
            }
        }
        throw new IllegalArgumentException(estimatorType);
    }

    public Model encodeModel(Schema schema) {
        Converter converter;
        MojoModel mojoModel = this.getMojoModel();
        try {
            ConverterFactory converterFactory = ConverterFactory.newConverterFactory();
            converter = converterFactory.newConverter(mojoModel);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        PMMLEncoder encoder = schema.getEncoder();
        Label label = schema.getLabel();
        List features = schema.getFeatures();
        H2OEncoder h2oEncoder = new H2OEncoder();
        Schema h2oSchema = converter.encodeSchema(h2oEncoder);
        List h2oFeatures = h2oSchema.getFeatures();
        ArrayList<Feature> sortedFeatures = new ArrayList<Feature>();
        for (Feature h2oFeature : h2oFeatures) {
            Feature feature;
            String name = h2oFeature.getName();
            if (features instanceof FeatureList) {
                FeatureList namedFeatures = (FeatureList)features;
                feature = namedFeatures.resolveFeature(name);
            } else {
                int index = Integer.parseInt(name.substring(1)) - 1;
                feature = (Feature)features.get(index);
            }
            sortedFeatures.add(feature);
        }
        Schema mojoModelSchema = converter.toMojoModelSchema(new Schema(encoder, label, sortedFeatures));
        return converter.encodeModel(mojoModelSchema);
    }

    public String getEstimatorType() {
        return this.getString("_estimator_type");
    }

    public String getMojoPath() {
        return this.getString("_mojo_path");
    }

    public H2OEstimator setMojoPath(String mojoPath) {
        this.put("_mojo_path", mojoPath);
        return this;
    }

    private MojoModel getMojoModel() {
        if (this.mojoModel == null) {
            this.mojoModel = this.loadMojoModel();
        }
        return this.mojoModel;
    }

    private MojoModel loadMojoModel() {
        MojoModel mojoModel;
        String mojoPath = this.getMojoPath();
        try {
            mojoModel = MojoModelUtil.readFrom((File)new File(mojoPath), (boolean)false);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return mojoModel;
    }
}

