/*
 * Decompiled with CFR 0.152.
 */
package optbinning;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import optbinning.Binning;
import org.jpmml.python.ClassDictUtil;

public class ContinuousOptimalBinning
extends Binning {
    public ContinuousOptimalBinning(String module, String name) {
        super(module, name);
    }

    public List<Double> getCategories() {
        List<Integer> numberOfRecords = this.getNumberOfRecords();
        List<Number> sums = this.getSums();
        ClassDictUtil.checkSize((Collection[])new Collection[]{numberOfRecords, sums});
        ArrayList<Double> result = new ArrayList<Double>();
        for (int i = 0; i < numberOfRecords.size(); ++i) {
            double mean = sums.get(i).doubleValue() / (double)numberOfRecords.get(i).intValue();
            result.add(mean);
        }
        return result;
    }

    public List<Integer> getNumberOfRecords() {
        return this.getIntegerArray("_n_records");
    }

    public List<Number> getSums() {
        return this.getNumberArray("_sums");
    }
}

