/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.h2o.testing;

import com.google.common.base.Equivalence;
import hex.genmodel.MojoModel;
import java.io.InputStream;
import java.util.function.Predicate;
import org.dmg.pmml.PMML;
import org.jpmml.converter.testing.ModelEncoderBatch;
import org.jpmml.evaluator.ResultField;
import org.jpmml.h2o.Converter;
import org.jpmml.h2o.ConverterFactory;
import org.jpmml.h2o.MojoModelUtil;
import org.jpmml.h2o.testing.H2OEncoderBatchTest;

public abstract class H2OEncoderBatch
extends ModelEncoderBatch {
    public H2OEncoderBatch(String algorithm, String dataset, Predicate<ResultField> columnFilter, Equivalence<Object> equivalence) {
        super(algorithm, dataset, columnFilter, equivalence);
    }

    public abstract H2OEncoderBatchTest getArchiveBatchTest();

    public String getMojoPath() {
        return "/mojo/" + this.getAlgorithm() + this.getDataset() + ".zip";
    }

    public PMML getPMML() throws Exception {
        MojoModel mojoModel;
        try (InputStream is = this.open(this.getMojoPath());){
            mojoModel = MojoModelUtil.readFrom(is);
        }
        ConverterFactory converterFactory = ConverterFactory.newConverterFactory();
        Converter<? extends MojoModel> converter = converterFactory.newConverter(mojoModel);
        PMML pmml = converter.encodePMML();
        this.validatePMML(pmml);
        return pmml;
    }
}

