









with Ada.Containers;              use Ada.Containers;
with Ada.Containers.Hashed_Maps;
with Ada.Containers.Hashed_Sets;
with Ada.Containers.Ordered_Maps;
with Ada.Strings.Unbounded;       use Ada.Strings.Unbounded;
with Ada.Strings.Unbounded.Hash;
with Ada.Unchecked_Conversion;
with Ada.Unchecked_Deallocation;

with System; use System;

   with GNATCOLL.Traces;
with GNATCOLL.GMP.Integers;
with GNATCOLL.VFS; use GNATCOLL.VFS;

with Langkit_Support.Adalog.Abstract_Relation;
use Langkit_Support.Adalog.Abstract_Relation;
with Langkit_Support.Adalog.Eq_Same;
with Langkit_Support.Bump_Ptr;     use Langkit_Support.Bump_Ptr;
with Langkit_Support.Cheap_Sets;
with Langkit_Support.File_Readers; use Langkit_Support.File_Readers;
with Langkit_Support.Lexical_Envs; use Langkit_Support.Lexical_Envs;
with Langkit_Support.Lexical_Envs_Impl;
with Langkit_Support.Symbols;      use Langkit_Support.Symbols;
with Langkit_Support.Token_Data_Handlers;
use Langkit_Support.Token_Data_Handlers;
with Langkit_Support.Types;        use Langkit_Support.Types;
with Langkit_Support.Vectors;

with Librflxlang.Parsers; use Librflxlang.Parsers;
with Librflxlang.Common;  use Librflxlang.Common;
with Librflxlang.Lexer_Implementation;
use Librflxlang.Lexer_Implementation;




--  Internal package: low-level primitives to implement public types and
--  operations in Librflxlang.Analysis.

private package Librflxlang.Implementation is

   use Support.Diagnostics, Support.Slocs, Support.Text;

   type Analysis_Context_Type;
   type Internal_Context is access all Analysis_Context_Type;

   Unexpected_Call_Depth : exception;
   --  Raised when the Call_Depth for two matching calls to Enter_Call and
   --  Exit_Call don't match, i.e. when there is a bug in the counting of
   --  recursive calls.

   procedure Enter_Call
     (Context : Internal_Context; Call_Depth : access Natural);
   --  Increment the call depth in Context. If the depth exceeds Context's
   --  maximum, raise a Property_Error for "stack overflow".
   --
   --  Note that in the case of an exception, the depth is still incremented.
   --  This means that all calls to Enter_Call must be wrapped in an exception
   --  handler which calls Exit_Call on exception.
   --
   --  Put in Call_Depth the incremented call depth.

   procedure Exit_Call (Context : Internal_Context; Call_Depth : Natural);
   --  Decrement the call depth in Context. If Call_Depth does not match the
   --  current call depth, raise an Unexpected_Call_Depth.

   type Analysis_Unit_Type;
   type Internal_Unit is access all Analysis_Unit_Type;

   type Root_Node_Record;
   type Bare_RFLX_Node is access all Root_Node_Record;
   No_Bare_RFLX_Node : constant Bare_RFLX_Node := null;
   --  Most generic AST node type

   function "<" (Left, Right : Bare_RFLX_Node) return Boolean;
   --  Abritrary but deterministic ordering criteria for parsing nodes. This
   --  handles null nodes as well. Raise a Property_Error for synthetic nodes.

   function Is_Null (Node : Bare_RFLX_Node) return Boolean;
   function Kind (Node : Bare_RFLX_Node) return RFLX_Node_Kind_Type;

         subtype Bare_AbstractID is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_AbstractID)
               or else Kind (Bare_AbstractID) in RFLX_AbstractID;
         subtype Bare_ID is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_ID)
               or else Kind (Bare_ID) in RFLX_ID_Range;
         subtype Bare_NullID is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_NullID)
               or else Kind (Bare_NullID) in RFLX_NullID_Range;
         subtype Bare_UnqualifiedID is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_UnqualifiedID)
               or else Kind (Bare_UnqualifiedID) in RFLX_UnqualifiedID_Range;
         subtype Bare_Aspect is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Aspect)
               or else Kind (Bare_Aspect) in RFLX_Aspect_Range;
         subtype Bare_Attr is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Attr)
               or else Kind (Bare_Attr) in RFLX_Attr;
         subtype Bare_Attr_First is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Attr_First)
               or else Kind (Bare_Attr_First) in RFLX_Attr_First_Range;
         subtype Bare_Attr_Has_Data is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Attr_Has_Data)
               or else Kind (Bare_Attr_Has_Data) in RFLX_Attr_Has_Data_Range;
         subtype Bare_Attr_Head is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Attr_Head)
               or else Kind (Bare_Attr_Head) in RFLX_Attr_Head_Range;
         subtype Bare_Attr_Last is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Attr_Last)
               or else Kind (Bare_Attr_Last) in RFLX_Attr_Last_Range;
         subtype Bare_Attr_Opaque is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Attr_Opaque)
               or else Kind (Bare_Attr_Opaque) in RFLX_Attr_Opaque_Range;
         subtype Bare_Attr_Present is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Attr_Present)
               or else Kind (Bare_Attr_Present) in RFLX_Attr_Present_Range;
         subtype Bare_Attr_Size is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Attr_Size)
               or else Kind (Bare_Attr_Size) in RFLX_Attr_Size_Range;
         subtype Bare_Attr_Valid is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Attr_Valid)
               or else Kind (Bare_Attr_Valid) in RFLX_Attr_Valid_Range;
         subtype Bare_Attr_Valid_Checksum is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Attr_Valid_Checksum)
               or else Kind (Bare_Attr_Valid_Checksum) in RFLX_Attr_Valid_Checksum_Range;
         subtype Bare_Attr_Stmt is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Attr_Stmt)
               or else Kind (Bare_Attr_Stmt) in RFLX_Attr_Stmt;
         subtype Bare_Attr_Stmt_Append is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Attr_Stmt_Append)
               or else Kind (Bare_Attr_Stmt_Append) in RFLX_Attr_Stmt_Append_Range;
         subtype Bare_Attr_Stmt_Extend is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Attr_Stmt_Extend)
               or else Kind (Bare_Attr_Stmt_Extend) in RFLX_Attr_Stmt_Extend_Range;
         subtype Bare_Attr_Stmt_Read is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Attr_Stmt_Read)
               or else Kind (Bare_Attr_Stmt_Read) in RFLX_Attr_Stmt_Read_Range;
         subtype Bare_Attr_Stmt_Write is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Attr_Stmt_Write)
               or else Kind (Bare_Attr_Stmt_Write) in RFLX_Attr_Stmt_Write_Range;
         subtype Bare_Base_Aggregate is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Base_Aggregate)
               or else Kind (Bare_Base_Aggregate) in RFLX_Base_Aggregate;
         subtype Bare_Message_Aggregate_Associations is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Message_Aggregate_Associations)
               or else Kind (Bare_Message_Aggregate_Associations) in RFLX_Message_Aggregate_Associations_Range;
         subtype Bare_Null_Message_Aggregate is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Null_Message_Aggregate)
               or else Kind (Bare_Null_Message_Aggregate) in RFLX_Null_Message_Aggregate_Range;
         subtype Bare_Base_Checksum_Val is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Base_Checksum_Val)
               or else Kind (Bare_Base_Checksum_Val) in RFLX_Base_Checksum_Val;
         subtype Bare_Checksum_Val is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Checksum_Val)
               or else Kind (Bare_Checksum_Val) in RFLX_Checksum_Val_Range;
         subtype Bare_Checksum_Value_Range is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Checksum_Value_Range)
               or else Kind (Bare_Checksum_Value_Range) in RFLX_Checksum_Value_Range_Range;
         subtype Bare_Base_State_Body is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Base_State_Body)
               or else Kind (Bare_Base_State_Body) in RFLX_Base_State_Body;
         subtype Bare_Null_State_Body is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Null_State_Body)
               or else Kind (Bare_Null_State_Body) in RFLX_Null_State_Body_Range;
         subtype Bare_State_Body is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_State_Body)
               or else Kind (Bare_State_Body) in RFLX_State_Body_Range;
         subtype Bare_Byte_Order_Type is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Byte_Order_Type)
               or else Kind (Bare_Byte_Order_Type) in RFLX_Byte_Order_Type;
         subtype Bare_Byte_Order_Type_Highorderfirst is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Byte_Order_Type_Highorderfirst)
               or else Kind (Bare_Byte_Order_Type_Highorderfirst) in RFLX_Byte_Order_Type_Highorderfirst_Range;
         subtype Bare_Byte_Order_Type_Loworderfirst is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Byte_Order_Type_Loworderfirst)
               or else Kind (Bare_Byte_Order_Type_Loworderfirst) in RFLX_Byte_Order_Type_Loworderfirst_Range;
         subtype Bare_Channel_Attribute is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Channel_Attribute)
               or else Kind (Bare_Channel_Attribute) in RFLX_Channel_Attribute;
         subtype Bare_Readable is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Readable)
               or else Kind (Bare_Readable) in RFLX_Readable_Range;
         subtype Bare_Writable is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Writable)
               or else Kind (Bare_Writable) in RFLX_Writable_Range;
         subtype Bare_Checksum_Assoc is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Checksum_Assoc)
               or else Kind (Bare_Checksum_Assoc) in RFLX_Checksum_Assoc_Range;
         subtype Bare_Declaration is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Declaration)
               or else Kind (Bare_Declaration) in RFLX_Declaration;
         subtype Bare_Refinement_Decl is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Refinement_Decl)
               or else Kind (Bare_Refinement_Decl) in RFLX_Refinement_Decl_Range;
         subtype Bare_Session_Decl is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Session_Decl)
               or else Kind (Bare_Session_Decl) in RFLX_Session_Decl_Range;
         subtype Bare_Type_Decl is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Type_Decl)
               or else Kind (Bare_Type_Decl) in RFLX_Type_Decl_Range;
         subtype Bare_Description is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Description)
               or else Kind (Bare_Description) in RFLX_Description_Range;
         subtype Bare_Element_Value_Assoc is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Element_Value_Assoc)
               or else Kind (Bare_Element_Value_Assoc) in RFLX_Element_Value_Assoc_Range;
         subtype Bare_Expr is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Expr)
               or else Kind (Bare_Expr) in RFLX_Expr;
         subtype Bare_Attribute is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Attribute)
               or else Kind (Bare_Attribute) in RFLX_Attribute_Range;
         subtype Bare_Bin_Op is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Bin_Op)
               or else Kind (Bare_Bin_Op) in RFLX_Bin_Op_Range;
         subtype Bare_Binding is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Binding)
               or else Kind (Bare_Binding) in RFLX_Binding_Range;
         subtype Bare_Call is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Call)
               or else Kind (Bare_Call) in RFLX_Call_Range;
         subtype Bare_Comprehension is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Comprehension)
               or else Kind (Bare_Comprehension) in RFLX_Comprehension_Range;
         subtype Bare_Context_Item is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Context_Item)
               or else Kind (Bare_Context_Item) in RFLX_Context_Item_Range;
         subtype Bare_Conversion is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Conversion)
               or else Kind (Bare_Conversion) in RFLX_Conversion_Range;
         subtype Bare_Message_Aggregate is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Message_Aggregate)
               or else Kind (Bare_Message_Aggregate) in RFLX_Message_Aggregate_Range;
         subtype Bare_Negation is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Negation)
               or else Kind (Bare_Negation) in RFLX_Negation_Range;
         subtype Bare_Numeric_Literal is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Numeric_Literal)
               or else Kind (Bare_Numeric_Literal) in RFLX_Numeric_Literal_Range;
         subtype Bare_Paren_Expression is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Paren_Expression)
               or else Kind (Bare_Paren_Expression) in RFLX_Paren_Expression_Range;
         subtype Bare_Quantified_Expression is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Quantified_Expression)
               or else Kind (Bare_Quantified_Expression) in RFLX_Quantified_Expression_Range;
         subtype Bare_Select_Node is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Select_Node)
               or else Kind (Bare_Select_Node) in RFLX_Select_Node_Range;
         subtype Bare_Sequence_Literal is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Sequence_Literal)
               or else Kind (Bare_Sequence_Literal) in RFLX_Sequence_Literal;
         subtype Bare_Concatenation is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Concatenation)
               or else Kind (Bare_Concatenation) in RFLX_Concatenation_Range;
         subtype Bare_Sequence_Aggregate is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Sequence_Aggregate)
               or else Kind (Bare_Sequence_Aggregate) in RFLX_Sequence_Aggregate_Range;
         subtype Bare_String_Literal is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_String_Literal)
               or else Kind (Bare_String_Literal) in RFLX_String_Literal_Range;
         subtype Bare_Variable is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Variable)
               or else Kind (Bare_Variable) in RFLX_Variable_Range;
         subtype Bare_Formal_Decl is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Formal_Decl)
               or else Kind (Bare_Formal_Decl) in RFLX_Formal_Decl;
         subtype Bare_Formal_Channel_Decl is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Formal_Channel_Decl)
               or else Kind (Bare_Formal_Channel_Decl) in RFLX_Formal_Channel_Decl_Range;
         subtype Bare_Formal_Function_Decl is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Formal_Function_Decl)
               or else Kind (Bare_Formal_Function_Decl) in RFLX_Formal_Function_Decl_Range;
         subtype Bare_Formal_Private_Type_Decl is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Formal_Private_Type_Decl)
               or else Kind (Bare_Formal_Private_Type_Decl) in RFLX_Formal_Private_Type_Decl_Range;
         subtype Bare_Local_Decl is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Local_Decl)
               or else Kind (Bare_Local_Decl) in RFLX_Local_Decl;
         subtype Bare_Renaming_Decl is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Renaming_Decl)
               or else Kind (Bare_Renaming_Decl) in RFLX_Renaming_Decl_Range;
         subtype Bare_Variable_Decl is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Variable_Decl)
               or else Kind (Bare_Variable_Decl) in RFLX_Variable_Decl_Range;
         subtype Bare_Message_Aggregate_Association is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Message_Aggregate_Association)
               or else Kind (Bare_Message_Aggregate_Association) in RFLX_Message_Aggregate_Association_Range;
         subtype Bare_Message_Aspect is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Message_Aspect)
               or else Kind (Bare_Message_Aspect) in RFLX_Message_Aspect;
         subtype Bare_Byte_Order_Aspect is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Byte_Order_Aspect)
               or else Kind (Bare_Byte_Order_Aspect) in RFLX_Byte_Order_Aspect_Range;
         subtype Bare_Checksum_Aspect is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Checksum_Aspect)
               or else Kind (Bare_Checksum_Aspect) in RFLX_Checksum_Aspect_Range;
         subtype Bare_Message_Field is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Message_Field)
               or else Kind (Bare_Message_Field) in RFLX_Message_Field_Range;
         subtype Bare_Message_Fields is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Message_Fields)
               or else Kind (Bare_Message_Fields) in RFLX_Message_Fields_Range;
         subtype Bare_Null_Message_Field is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Null_Message_Field)
               or else Kind (Bare_Null_Message_Field) in RFLX_Null_Message_Field_Range;
         subtype Bare_Op is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Op)
               or else Kind (Bare_Op) in RFLX_Op;
         subtype Bare_Op_Add is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Op_Add)
               or else Kind (Bare_Op_Add) in RFLX_Op_Add_Range;
         subtype Bare_Op_And is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Op_And)
               or else Kind (Bare_Op_And) in RFLX_Op_And_Range;
         subtype Bare_Op_Div is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Op_Div)
               or else Kind (Bare_Op_Div) in RFLX_Op_Div_Range;
         subtype Bare_Op_Eq is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Op_Eq)
               or else Kind (Bare_Op_Eq) in RFLX_Op_Eq_Range;
         subtype Bare_Op_Ge is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Op_Ge)
               or else Kind (Bare_Op_Ge) in RFLX_Op_Ge_Range;
         subtype Bare_Op_Gt is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Op_Gt)
               or else Kind (Bare_Op_Gt) in RFLX_Op_Gt_Range;
         subtype Bare_Op_In is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Op_In)
               or else Kind (Bare_Op_In) in RFLX_Op_In_Range;
         subtype Bare_Op_Le is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Op_Le)
               or else Kind (Bare_Op_Le) in RFLX_Op_Le_Range;
         subtype Bare_Op_Lt is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Op_Lt)
               or else Kind (Bare_Op_Lt) in RFLX_Op_Lt_Range;
         subtype Bare_Op_Mod is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Op_Mod)
               or else Kind (Bare_Op_Mod) in RFLX_Op_Mod_Range;
         subtype Bare_Op_Mul is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Op_Mul)
               or else Kind (Bare_Op_Mul) in RFLX_Op_Mul_Range;
         subtype Bare_Op_Neq is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Op_Neq)
               or else Kind (Bare_Op_Neq) in RFLX_Op_Neq_Range;
         subtype Bare_Op_Notin is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Op_Notin)
               or else Kind (Bare_Op_Notin) in RFLX_Op_Notin_Range;
         subtype Bare_Op_Or is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Op_Or)
               or else Kind (Bare_Op_Or) in RFLX_Op_Or_Range;
         subtype Bare_Op_Pow is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Op_Pow)
               or else Kind (Bare_Op_Pow) in RFLX_Op_Pow_Range;
         subtype Bare_Op_Sub is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Op_Sub)
               or else Kind (Bare_Op_Sub) in RFLX_Op_Sub_Range;
         subtype Bare_Package_Node is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Package_Node)
               or else Kind (Bare_Package_Node) in RFLX_Package_Node_Range;
         subtype Bare_Parameter is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Parameter)
               or else Kind (Bare_Parameter) in RFLX_Parameter_Range;
         subtype Bare_Parameters is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Parameters)
               or else Kind (Bare_Parameters) in RFLX_Parameters_Range;
         subtype Bare_Quantifier is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Quantifier)
               or else Kind (Bare_Quantifier) in RFLX_Quantifier;
         subtype Bare_Quantifier_All is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Quantifier_All)
               or else Kind (Bare_Quantifier_All) in RFLX_Quantifier_All_Range;
         subtype Bare_Quantifier_Some is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Quantifier_Some)
               or else Kind (Bare_Quantifier_Some) in RFLX_Quantifier_Some_Range;
         subtype Bare_RFLX_Node_Base_List is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_RFLX_Node_Base_List)
               or else Kind (Bare_RFLX_Node_Base_List) in RFLX_RFLX_Node_Base_List;
         subtype Bare_Aspect_List is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Aspect_List)
               or else Kind (Bare_Aspect_List) in RFLX_Aspect_List_Range;
         subtype Bare_Base_Checksum_Val_List is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Base_Checksum_Val_List)
               or else Kind (Bare_Base_Checksum_Val_List) in RFLX_Base_Checksum_Val_List_Range;
         subtype Bare_Channel_Attribute_List is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Channel_Attribute_List)
               or else Kind (Bare_Channel_Attribute_List) in RFLX_Channel_Attribute_List_Range;
         subtype Bare_Checksum_Assoc_List is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Checksum_Assoc_List)
               or else Kind (Bare_Checksum_Assoc_List) in RFLX_Checksum_Assoc_List_Range;
         subtype Bare_Conditional_Transition_List is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Conditional_Transition_List)
               or else Kind (Bare_Conditional_Transition_List) in RFLX_Conditional_Transition_List_Range;
         subtype Bare_Context_Item_List is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Context_Item_List)
               or else Kind (Bare_Context_Item_List) in RFLX_Context_Item_List_Range;
         subtype Bare_Declaration_List is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Declaration_List)
               or else Kind (Bare_Declaration_List) in RFLX_Declaration_List_Range;
         subtype Bare_Element_Value_Assoc_List is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Element_Value_Assoc_List)
               or else Kind (Bare_Element_Value_Assoc_List) in RFLX_Element_Value_Assoc_List_Range;
         subtype Bare_Expr_List is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Expr_List)
               or else Kind (Bare_Expr_List) in RFLX_Expr_List_Range;
         subtype Bare_Formal_Decl_List is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Formal_Decl_List)
               or else Kind (Bare_Formal_Decl_List) in RFLX_Formal_Decl_List_Range;
         subtype Bare_Local_Decl_List is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Local_Decl_List)
               or else Kind (Bare_Local_Decl_List) in RFLX_Local_Decl_List_Range;
         subtype Bare_Message_Aggregate_Association_List is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Message_Aggregate_Association_List)
               or else Kind (Bare_Message_Aggregate_Association_List) in RFLX_Message_Aggregate_Association_List_Range;
         subtype Bare_Message_Aspect_List is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Message_Aspect_List)
               or else Kind (Bare_Message_Aspect_List) in RFLX_Message_Aspect_List_Range;
         subtype Bare_Message_Field_List is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Message_Field_List)
               or else Kind (Bare_Message_Field_List) in RFLX_Message_Field_List_Range;
         subtype Bare_Numeric_Literal_List is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Numeric_Literal_List)
               or else Kind (Bare_Numeric_Literal_List) in RFLX_Numeric_Literal_List_Range;
         subtype Bare_Parameter_List is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Parameter_List)
               or else Kind (Bare_Parameter_List) in RFLX_Parameter_List_Range;
         subtype Bare_State_List is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_State_List)
               or else Kind (Bare_State_List) in RFLX_State_List_Range;
         subtype Bare_Statement_List is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Statement_List)
               or else Kind (Bare_Statement_List) in RFLX_Statement_List_Range;
         subtype Bare_Term_Assoc_List is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Term_Assoc_List)
               or else Kind (Bare_Term_Assoc_List) in RFLX_Term_Assoc_List_Range;
         subtype Bare_Then_Node_List is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Then_Node_List)
               or else Kind (Bare_Then_Node_List) in RFLX_Then_Node_List_Range;
         subtype Bare_Type_Argument_List is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Type_Argument_List)
               or else Kind (Bare_Type_Argument_List) in RFLX_Type_Argument_List_Range;
         subtype Bare_UnqualifiedID_List is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_UnqualifiedID_List)
               or else Kind (Bare_UnqualifiedID_List) in RFLX_UnqualifiedID_List_Range;
         subtype Bare_Session_Aspects is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Session_Aspects)
               or else Kind (Bare_Session_Aspects) in RFLX_Session_Aspects_Range;
         subtype Bare_Specification is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Specification)
               or else Kind (Bare_Specification) in RFLX_Specification_Range;
         subtype Bare_State is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_State)
               or else Kind (Bare_State) in RFLX_State_Range;
         subtype Bare_Statement is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Statement)
               or else Kind (Bare_Statement) in RFLX_Statement;
         subtype Bare_Assignment is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Assignment)
               or else Kind (Bare_Assignment) in RFLX_Assignment_Range;
         subtype Bare_Attribute_Statement is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Attribute_Statement)
               or else Kind (Bare_Attribute_Statement) in RFLX_Attribute_Statement_Range;
         subtype Bare_Reset is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Reset)
               or else Kind (Bare_Reset) in RFLX_Reset_Range;
         subtype Bare_Term_Assoc is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Term_Assoc)
               or else Kind (Bare_Term_Assoc) in RFLX_Term_Assoc_Range;
         subtype Bare_Then_Node is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Then_Node)
               or else Kind (Bare_Then_Node) in RFLX_Then_Node_Range;
         subtype Bare_Transition is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Transition)
               or else Kind (Bare_Transition) in RFLX_Transition_Range;
         subtype Bare_Conditional_Transition is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Conditional_Transition)
               or else Kind (Bare_Conditional_Transition) in RFLX_Conditional_Transition_Range;
         subtype Bare_Type_Argument is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Type_Argument)
               or else Kind (Bare_Type_Argument) in RFLX_Type_Argument_Range;
         subtype Bare_Type_Def is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Type_Def)
               or else Kind (Bare_Type_Def) in RFLX_Type_Def;
         subtype Bare_Abstract_Message_Type_Def is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Abstract_Message_Type_Def)
               or else Kind (Bare_Abstract_Message_Type_Def) in RFLX_Abstract_Message_Type_Def;
         subtype Bare_Message_Type_Def is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Message_Type_Def)
               or else Kind (Bare_Message_Type_Def) in RFLX_Message_Type_Def_Range;
         subtype Bare_Null_Message_Type_Def is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Null_Message_Type_Def)
               or else Kind (Bare_Null_Message_Type_Def) in RFLX_Null_Message_Type_Def_Range;
         subtype Bare_Enumeration_Def is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Enumeration_Def)
               or else Kind (Bare_Enumeration_Def) in RFLX_Enumeration_Def;
         subtype Bare_Named_Enumeration_Def is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Named_Enumeration_Def)
               or else Kind (Bare_Named_Enumeration_Def) in RFLX_Named_Enumeration_Def_Range;
         subtype Bare_Positional_Enumeration_Def is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Positional_Enumeration_Def)
               or else Kind (Bare_Positional_Enumeration_Def) in RFLX_Positional_Enumeration_Def_Range;
         subtype Bare_Enumeration_Type_Def is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Enumeration_Type_Def)
               or else Kind (Bare_Enumeration_Type_Def) in RFLX_Enumeration_Type_Def_Range;
         subtype Bare_Integer_Type_Def is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Integer_Type_Def)
               or else Kind (Bare_Integer_Type_Def) in RFLX_Integer_Type_Def;
         subtype Bare_Modular_Type_Def is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Modular_Type_Def)
               or else Kind (Bare_Modular_Type_Def) in RFLX_Modular_Type_Def_Range;
         subtype Bare_Range_Type_Def is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Range_Type_Def)
               or else Kind (Bare_Range_Type_Def) in RFLX_Range_Type_Def_Range;
         subtype Bare_Sequence_Type_Def is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Sequence_Type_Def)
               or else Kind (Bare_Sequence_Type_Def) in RFLX_Sequence_Type_Def_Range;
         subtype Bare_Type_Derivation_Def is Bare_RFLX_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Type_Derivation_Def)
               or else Kind (Bare_Type_Derivation_Def) in RFLX_Type_Derivation_Def_Range;

   package Alloc_AST_List_Array is new Langkit_Support.Bump_Ptr.Array_Alloc
     (Element_T  => Bare_RFLX_Node,
      Index_Type => Positive);
   --  Allocator for array of nodes, used in list nodes

   type Rewriting_Handle_Pointer is new System.Address;
   No_Rewriting_Handle_Pointer : constant Rewriting_Handle_Pointer :=
      Rewriting_Handle_Pointer (System.Null_Address);

      Properties_Traces : constant GNATCOLL.Traces.Trace_Handle :=
         GNATCOLL.Traces.Create
           ("LANGKIT.PROPERTIES", GNATCOLL.Traces.On
           );

   function Short_Text_Image (Self : Bare_RFLX_Node) return Text_Type;
   --  Return a short representation of the node, containing just the kind
   --  name and the sloc, or "None" if Self is null.

   function Is_Token_Node (Node : Bare_RFLX_Node) return Boolean;
   --  Return whether this node is a node that contains only a single token.

   function Is_Synthetic (Node : Bare_RFLX_Node) return Boolean;
   --  Return whether this node is synthetic.

   ---------------------------
   -- Iterators safety nets --
   ---------------------------

   type Iterator_Safety_Net is record
      Context         : Internal_Context;
      Context_Serial  : Version_Number;
      Context_Version : Natural;
      --  Analysis context, its serial number and version number at the time
      --  this safety net was produced.
   end record;

   No_Iterator_Safety_Net : constant Iterator_Safety_Net := (null, 0, 0);

   function Create_Safety_Net
     (Context : Internal_Context) return Iterator_Safety_Net;
   --  Create an iterator safety net from the given Context

   procedure Check_Safety_Net (Self : Iterator_Safety_Net);
   --  Check that the given iterator safety net is still valid, raising a
   --  Stale_Reference_Error if it is not.

   ---------------------------
   -- Environments handling --
   ---------------------------

   
      type Internal_Metadata;
      

   

      

      type Internal_Metadata is record

            null;
      end record
        with Convention => C;




   
      function Hash (R : Internal_Metadata) return Hash_Type;


      function Trace_Image (R : Internal_Metadata) return String;


   
      


      No_Metadata : constant Internal_Metadata :=
      (null record);


   
      type Internal_Inner_Env_Assoc;
      

   

      

      type Internal_Inner_Env_Assoc is record

               Key : aliased Symbol_Type;
               
               
               Val : aliased Bare_RFLX_Node;
               
               
               Metadata : aliased Internal_Metadata;
               
               
      end record
        with Convention => C;




   


      function Trace_Image (R : Internal_Inner_Env_Assoc) return String;


   
      


      No_Inner_Env_Assoc : constant Internal_Inner_Env_Assoc :=
      (
               Key => null, 
               Val => No_Bare_RFLX_Node, 
               Metadata => No_Metadata
      );

   function Get_Key (Self : Internal_Inner_Env_Assoc) return Symbol_Type
   is (Self.Key);
   function Get_Node
     (Self : Internal_Inner_Env_Assoc) return Bare_RFLX_Node
   is (Self.Val);
   function Get_Metadata
     (Self : Internal_Inner_Env_Assoc) return Internal_Metadata
   is (Self.Metadata);

   
   type Internal_Inner_Env_Assoc_Array_Record;
   type Internal_Inner_Env_Assoc_Array_Access is access all Internal_Inner_Env_Assoc_Array_Record;

      
   type Internal_Internal_Inner_Env_Assoc_Iterator;
   type Internal_Inner_Env_Assoc_Iterator_Access is access all Internal_Internal_Inner_Env_Assoc_Iterator;


   

   

   type Internal_Internal_Inner_Env_Assoc_Array is
      array (Positive range <>) of Internal_Inner_Env_Assoc;

   type Internal_Inner_Env_Assoc_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Internal_Inner_Env_Assoc_Array (1 .. N);
   end record;

   Empty_Inner_Env_Assoc_Array_Record : aliased Internal_Inner_Env_Assoc_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Internal_Inner_Env_Assoc_Array_Type : constant Internal_Inner_Env_Assoc_Array_Access :=
      Empty_Inner_Env_Assoc_Array_Record'Access;


   function Create_Internal_Inner_Env_Assoc_Array (Items_Count : Natural) return Internal_Inner_Env_Assoc_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Internal_Inner_Env_Assoc_Array
     (Items : Internal_Internal_Inner_Env_Assoc_Array) return Internal_Inner_Env_Assoc_Array_Access;
   --  Create a new array from an existing collection of elements


   function Get
     (T       : Internal_Inner_Env_Assoc_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Inner_Env_Assoc;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Internal_Inner_Env_Assoc_Array_Access) return Internal_Inner_Env_Assoc_Array_Access;

   function Length (T : Internal_Inner_Env_Assoc_Array_Access) return Natural;

   procedure Inc_Ref (T : Internal_Inner_Env_Assoc_Array_Access);
   procedure Dec_Ref (T : in out Internal_Inner_Env_Assoc_Array_Access);

   function Equivalent (L, R : Internal_Inner_Env_Assoc_Array_Access) return Boolean;


      function Trace_Image (A : Internal_Inner_Env_Assoc_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Internal_Inner_Env_Assoc_Array_Record, Internal_Inner_Env_Assoc_Array_Access);

      

   

   type Internal_Internal_Inner_Env_Assoc_Iterator is record
      Ref_Count : Integer;
      --  Reference count. The iterator is freed when this drops to zero.
      --  Negative values are interpreted as "always living singleton".

      Safety_Net : Iterator_Safety_Net;
      --  Safety net for the iterator. Used to check that values produced by
      --  the iterator are still valid. Unlike for other types, we put the
      --  safety net in the internal type so that it can be used in all other
      --  APIs (Python, ...).
      --
      --  While other types (except nodes) are "deeply" converted to native
      --  APIs (for instance: internal arrays are turned into native Python
      --  lists, likewise for array items, etc.), iterators are lazy, so the
      --  deep conversion is not possible.

      Elements : Internal_Inner_Env_Assoc_Array_Access;
      Index    : Positive;
   end record;

   Empty_Internal_Internal_Inner_Env_Assoc_Iterator : aliased Internal_Internal_Inner_Env_Assoc_Iterator :=
     (Ref_Count  => -1,
      Safety_Net => No_Iterator_Safety_Net,
      Elements   => No_Internal_Inner_Env_Assoc_Array_Type,
      Index      => 1);
   No_Internal_Inner_Env_Assoc_Iterator_Type : constant Internal_Inner_Env_Assoc_Iterator_Access :=
      Empty_Internal_Internal_Inner_Env_Assoc_Iterator'Access;

   function Next
     (T       : Internal_Inner_Env_Assoc_Iterator_Access;
      Element : out Internal_Inner_Env_Assoc) return Boolean;

   procedure Inc_Ref (T : Internal_Inner_Env_Assoc_Iterator_Access);
   procedure Dec_Ref (T : in out Internal_Inner_Env_Assoc_Iterator_Access);

      function Trace_Image (A : Internal_Inner_Env_Assoc_Iterator_Access) return String;

   procedure Free is new Ada.Unchecked_Deallocation
     (Internal_Internal_Inner_Env_Assoc_Iterator, Internal_Inner_Env_Assoc_Iterator_Access);


   function Inner_Env_Assoc_Get
     (Self  : Internal_Inner_Env_Assoc_Array_Access;
      Index : Positive) return Internal_Inner_Env_Assoc
   is (Self.Items (Index));

   function Combine
     (L, R : Internal_Metadata) return Internal_Metadata;
   --  The combine function on environments metadata does a boolean Or on every
   --  boolean component of the env metadata.

   function Can_Reach (El, From : Bare_RFLX_Node) return Boolean;
   --  Return whether El can reach From, from a sequential viewpoint. If
   --  elements are declared in different units, it will always return True,
   --  eg this does not handle general visibility issues, just sequentiality of
   --  declarations.

   function AST_Envs_Node_Text_Image
     (Node  : Bare_RFLX_Node;
      Short : Boolean := True) return Text_Type;
   --  Return a "sourcefile:lineno:columnno" corresponding to the starting sloc
   --  of Node. Used to create a human-readable representation for env.
   --  rebindings.

   function Is_Rebindable (Node : Bare_RFLX_Node) return Boolean;

   function Acquire_Rebinding
     (Node             : Bare_RFLX_Node;
      Parent           : Env_Rebindings;
      Old_Env, New_Env : Lexical_Env) return Env_Rebindings;
   --  Initialize and return a fresh rebinding

   procedure Release_Rebinding (Self : in out Env_Rebindings);
   --  Mark the rebinding as unused, so that a future call to Acquire_Rebinding
   --  can return it.

   procedure Register_Rebinding
     (Node : Bare_RFLX_Node; Rebinding : Env_Rebindings);
   --  Register a rebinding to be destroyed when Node's analysis unit is
   --  destroyed or reparsed.

   function Element_Parent
     (Node : Bare_RFLX_Node) return Bare_RFLX_Node;

   function Hash (Node : Bare_RFLX_Node) return Hash_Type;
   function Node_Unit (Node : Bare_RFLX_Node) return Generic_Unit_Ptr;
   function Named_Hash (Node : Bare_RFLX_Node) return Hash_Type is
     (Hash (Node));

   No_Analysis_Unit : constant Internal_Unit := null;

   function Convert_Unit is new Ada.Unchecked_Conversion
     (Generic_Unit_Ptr, Internal_Unit);
   function Convert_Unit is new Ada.Unchecked_Conversion
     (Internal_Unit, Generic_Unit_Ptr);

   function Unit_Version (Unit : Generic_Unit_Ptr) return Version_Number;
   --  Return the version for Unit. Version is a number that is incremented
   --  every time Unit changes.

   type Ref_Category is
     (Nocat);
   type Ref_Categories is array (Ref_Category) of Boolean;
   pragma Pack (Ref_Categories);

   package AST_Envs is new Langkit_Support.Lexical_Envs_Impl
     (Get_Unit_Version         => Unit_Version,
      Node_Type                => Bare_RFLX_Node,
      Node_Metadata            => Internal_Metadata,
      No_Node                  => null,
      Empty_Metadata           => No_Metadata,
      Node_Unit                => Node_Unit,
      Node_Hash                => Named_Hash,
      Metadata_Hash            => Hash,
      Combine                  => Combine,
      Node_Text_Image          => AST_Envs_Node_Text_Image,
      Acquire_Rebinding        => Acquire_Rebinding,
      Register_Rebinding       => Register_Rebinding,
      Ref_Category             => Ref_Category,
      Ref_Categories           => Ref_Categories,
      Inner_Env_Assoc          => Internal_Inner_Env_Assoc,
      Inner_Env_Assoc_Array    => Internal_Inner_Env_Assoc_Array_Access,
      Get                      => Inner_Env_Assoc_Get);

   use AST_Envs;
   subtype Internal_Entity is AST_Envs.Entity;
   subtype Internal_Entity_Info is AST_Envs.Entity_Info;

   No_Entity_Info : constant Internal_Entity_Info :=
     (No_Metadata, null, False);
   No_Entity : constant Internal_Entity :=
     (null, No_Entity_Info);

   function Hash_Entity (Self : Internal_Entity) return Hash_Type;
   --  Hash function to use in the public API. It's like the regular one, but
   --  disregards metadata.

   function Compare_Entity (Left, Right : Internal_Entity) return Boolean;
   --  Equality function to use in the public API. It's like the regular one,
   --  but disregards metadata.

   function Create_Dynamic_Lexical_Env
     (Self              : Bare_RFLX_Node;
      Assocs_Getter     : Inner_Env_Assocs_Resolver;
      Assoc_Resolver    : Entity_Resolver;
      Transitive_Parent : Boolean) return Lexical_Env;
   --  Helper for properties code generation: wrapper around
   --  AST_Envs.Create_Dynamic_Lexical_Env.

      function Hash (B : Boolean) return Hash_Type;



   --------------------------
   -- Big integers wrapper --
   --------------------------

   type Big_Integer_Record is limited record
      Value     : GNATCOLL.GMP.Integers.Big_Integer;
      Ref_Count : Integer;
      --  Number of owners. When it drops to 0, this record can be destroyed.
      --  If -1, this is a static big integer: Inc_Ref and Dec_Ref are no-ops.
   end record;

   type Big_Integer_Type is access all Big_Integer_Record;

   function Create_Big_Integer
     (Image : String; Base : Integer := 10) return Big_Integer_Type;
   function Create_Big_Integer
     (Big_Int : GNATCOLL.GMP.Integers.Big_Integer) return Big_Integer_Type;
   function Create_Big_Integer (Int : Integer) return Big_Integer_Type;
   function Create_Public_Big_Integer
     (Big_Int : Big_Integer_Type) return GNATCOLL.GMP.Integers.Big_Integer;

   No_Big_Integer_Record : aliased Big_Integer_Record :=
     (Value => <>, Ref_Count => -1);
   No_Big_Integer : constant Big_Integer_Type := No_Big_Integer_Record'Access;

   function To_Integer (Big_Int : Big_Integer_Type) return Integer;
   --  Convert Big_Int into a regular integer, raising a Property_Error if it
   --  is out of range.

   procedure Inc_Ref (Big_Int : Big_Integer_Type);
   procedure Dec_Ref (Big_Int : in out Big_Integer_Type);

   function Equivalent (Left, Right : Big_Integer_Type) return Boolean;
   function "<" (Left, Right : Big_Integer_Type) return Boolean;
   function "<=" (Left, Right : Big_Integer_Type) return Boolean;
   function ">" (Left, Right : Big_Integer_Type) return Boolean;
   function ">=" (Left, Right : Big_Integer_Type) return Boolean;

   function "+" (Left, Right : Big_Integer_Type) return Big_Integer_Type;
   function "-" (Left, Right : Big_Integer_Type) return Big_Integer_Type;

   function Trace_Image (I : Big_Integer_Type) return String;

      function Trace_Image
        (Node       : Bare_RFLX_Node;
         Decoration : Boolean := True) return String;

   function Is_Incomplete (Node : Bare_RFLX_Node) return Boolean;
   --  Return whether this node is incomplete or not.  Incomplete nodes are a
   --  result of the parsing of a node failing as a result of a NoBacktrack
   --  parser annotation.

   function Kind_Name (Node : Bare_RFLX_Node) return String;
   --  Return the concrete kind for Node

   ---------------------------
   -- Adalog instantiations --
   ---------------------------

   function Text_Image (Ent : Internal_Entity) return Text_Type;
   function Image (Ent : Internal_Entity) return String;
   --  Return a representation of this entity as a string.

   package Eq_Node is new Langkit_Support.Adalog.Eq_Same
     (LR_Type       => Internal_Entity,
      Element_Image => Image);
   subtype Logic_Var is Eq_Node.Refs.Raw_Var;
   subtype Logic_Var_Record is Eq_Node.Refs.Var;
   Null_Var : constant Logic_Var := null;
   Null_Var_Record : constant Logic_Var_Record := (Reset => True, others => <>);

   subtype Logic_Equation is Relation;
   Null_Logic_Equation : constant Logic_Equation := null;

      function Trace_Image (K : Analysis_Unit_Kind) return String;
      function Trace_Image (B : Boolean) return String;
      function Trace_Image (I : Integer) return String;
      function Trace_Image (S : Symbol_Type) return String;
      function Trace_Image (Env : Lexical_Env) return String;
      function Trace_Image (R : Env_Rebindings) return String;
      function Trace_Image (Unit : Internal_Unit) return String;
      function Trace_Image (Eq : Logic_Equation) return String;
      function Trace_Image (Var : Logic_Var) return String;

   


   -----------------------------------------------
   -- Structure types (incomplete declarations) --
   -----------------------------------------------

         

         

         
      type Internal_Entity_AbstractID;
      

         
      type Internal_Entity_Type_Def;
      

         
      type Internal_Entity_Abstract_Message_Type_Def;
      

         
      type Internal_Entity_Aspect;
      

         
      type Internal_Entity_RFLX_Node_Base_List;
      

         
      type Internal_Entity_Aspect_List;
      

         
      type Internal_Entity_Statement;
      

         
      type Internal_Entity_Assignment;
      

         
      type Internal_Entity_Attr;
      

         
      type Internal_Entity_Attr_First;
      

         
      type Internal_Entity_Attr_Has_Data;
      

         
      type Internal_Entity_Attr_Head;
      

         
      type Internal_Entity_Attr_Last;
      

         
      type Internal_Entity_Attr_Opaque;
      

         
      type Internal_Entity_Attr_Present;
      

         
      type Internal_Entity_Attr_Size;
      

         
      type Internal_Entity_Attr_Stmt;
      

         
      type Internal_Entity_Attr_Stmt_Append;
      

         
      type Internal_Entity_Attr_Stmt_Extend;
      

         
      type Internal_Entity_Attr_Stmt_Read;
      

         
      type Internal_Entity_Attr_Stmt_Write;
      

         
      type Internal_Entity_Attr_Valid;
      

         
      type Internal_Entity_Attr_Valid_Checksum;
      

         
      type Internal_Entity_Expr;
      

         
      type Internal_Entity_Attribute;
      

         
      type Internal_Entity_Attribute_Statement;
      

         
      type Internal_Entity_Base_Aggregate;
      

         
      type Internal_Entity_Base_Checksum_Val;
      

         
      type Internal_Entity_Base_Checksum_Val_List;
      

         
      type Internal_Entity_Base_State_Body;
      

         
      type Internal_Entity_Bin_Op;
      

         
      type Internal_Entity_Binding;
      

         
      type Internal_Entity_Message_Aspect;
      

         
      type Internal_Entity_Byte_Order_Aspect;
      

         
      type Internal_Entity_Byte_Order_Type;
      

         
      type Internal_Entity_Byte_Order_Type_Highorderfirst;
      

         
      type Internal_Entity_Byte_Order_Type_Loworderfirst;
      

         
      type Internal_Entity_Call;
      

         
      type Internal_Entity_Channel_Attribute;
      

         
      type Internal_Entity_Channel_Attribute_List;
      

         
      type Internal_Entity_Checksum_Aspect;
      

         
      type Internal_Entity_Checksum_Assoc;
      

         
      type Internal_Entity_Checksum_Assoc_List;
      

         
      type Internal_Entity_Checksum_Val;
      

         
      type Internal_Entity_Checksum_Value_Range;
      

         
      type Internal_Entity_Comprehension;
      

         
      type Internal_Entity_Sequence_Literal;
      

         
      type Internal_Entity_Concatenation;
      

         
      type Internal_Entity_Transition;
      

         
      type Internal_Entity_Conditional_Transition;
      

         
      type Internal_Entity_Conditional_Transition_List;
      

         
      type Internal_Entity_Context_Item;
      

         
      type Internal_Entity_Context_Item_List;
      

         
      type Internal_Entity_Conversion;
      

         
      type Internal_Entity_Declaration;
      

         
      type Internal_Entity_Declaration_List;
      

         
      type Internal_Entity_Description;
      

         
      type Internal_Entity_Element_Value_Assoc;
      

         
      type Internal_Entity_Element_Value_Assoc_List;
      

         
      type Internal_Entity_Enumeration_Def;
      

         
      type Internal_Entity_Enumeration_Type_Def;
      

         
      type Internal_Entity_Expr_List;
      

         
      type Internal_Entity_Formal_Decl;
      

         
      type Internal_Entity_Formal_Channel_Decl;
      

         
      type Internal_Entity_Formal_Decl_List;
      

         
      type Internal_Entity_Formal_Function_Decl;
      

         
      type Internal_Entity_Formal_Private_Type_Decl;
      

         
      type Internal_Entity_ID;
      

         
      type Internal_Entity_Integer_Type_Def;
      

         
      type Internal_Entity_Local_Decl;
      

         
      type Internal_Entity_Local_Decl_List;
      

         
      type Internal_Entity_Message_Aggregate;
      

         
      type Internal_Entity_Message_Aggregate_Association;
      

         
      type Internal_Entity_Message_Aggregate_Association_List;
      

         
      type Internal_Entity_Message_Aggregate_Associations;
      

         
      type Internal_Entity_Message_Aspect_List;
      

         
      type Internal_Entity_Message_Field;
      

         
      type Internal_Entity_Message_Field_List;
      

         
      type Internal_Entity_Message_Fields;
      

         
      type Internal_Entity_Message_Type_Def;
      

         
      type Internal_Entity_Modular_Type_Def;
      

         
      type Internal_Entity_Named_Enumeration_Def;
      

         
      type Internal_Entity_Negation;
      

         
      type Internal_Entity_NullID;
      

         
      type Internal_Entity_Null_Message_Aggregate;
      

         
      type Internal_Entity_Null_Message_Field;
      

         
      type Internal_Entity_Null_Message_Type_Def;
      

         
      type Internal_Entity_Null_State_Body;
      

         
      type Internal_Entity_Numeric_Literal;
      

         
      type Internal_Entity_Numeric_Literal_List;
      

         
      type Internal_Entity_Op;
      

         
      type Internal_Entity_Op_Add;
      

         
      type Internal_Entity_Op_And;
      

         
      type Internal_Entity_Op_Div;
      

         
      type Internal_Entity_Op_Eq;
      

         
      type Internal_Entity_Op_Ge;
      

         
      type Internal_Entity_Op_Gt;
      

         
      type Internal_Entity_Op_In;
      

         
      type Internal_Entity_Op_Le;
      

         
      type Internal_Entity_Op_Lt;
      

         
      type Internal_Entity_Op_Mod;
      

         
      type Internal_Entity_Op_Mul;
      

         
      type Internal_Entity_Op_Neq;
      

         
      type Internal_Entity_Op_Notin;
      

         
      type Internal_Entity_Op_Or;
      

         
      type Internal_Entity_Op_Pow;
      

         
      type Internal_Entity_Op_Sub;
      

         
      type Internal_Entity_Package_Node;
      

         
      type Internal_Entity_Parameter;
      

         
      type Internal_Entity_Parameter_List;
      

         
      type Internal_Entity_Parameters;
      

         
      type Internal_Entity_Paren_Expression;
      

         
      type Internal_Entity_Positional_Enumeration_Def;
      

         
      type Internal_Entity_Quantified_Expression;
      

         
      type Internal_Entity_Quantifier;
      

         
      type Internal_Entity_Quantifier_All;
      

         
      type Internal_Entity_Quantifier_Some;
      

         
      type Internal_Entity_Range_Type_Def;
      

         
      type Internal_Entity_Readable;
      

         
      type Internal_Entity_Refinement_Decl;
      

         
      type Internal_Entity_Renaming_Decl;
      

         
      type Internal_Entity_Reset;
      

         
      type Internal_Entity_Select_Node;
      

         
      type Internal_Entity_Sequence_Aggregate;
      

         
      type Internal_Entity_Sequence_Type_Def;
      

         
      type Internal_Entity_Session_Aspects;
      

         
      type Internal_Entity_Session_Decl;
      

         
      type Internal_Entity_Specification;
      

         
      type Internal_Entity_State;
      

         
      type Internal_Entity_State_Body;
      

         
      type Internal_Entity_State_List;
      

         
      type Internal_Entity_Statement_List;
      

         
      type Internal_Entity_String_Literal;
      

         
      type Internal_Entity_Term_Assoc;
      

         
      type Internal_Entity_Term_Assoc_List;
      

         
      type Internal_Entity_Then_Node;
      

         
      type Internal_Entity_Then_Node_List;
      

         
      type Internal_Entity_Type_Argument;
      

         
      type Internal_Entity_Type_Argument_List;
      

         
      type Internal_Entity_Type_Decl;
      

         
      type Internal_Entity_Type_Derivation_Def;
      

         
      type Internal_Entity_UnqualifiedID;
      

         
      type Internal_Entity_UnqualifiedID_List;
      

         
      type Internal_Entity_Variable;
      

         
      type Internal_Entity_Variable_Decl;
      

         
      type Internal_Entity_Writable;
      

         
      type Internal_Env_Assoc;
      


   -------------------------------------------
   -- Array types (incomplete declarations) --
   -------------------------------------------

         
   type Bare_RFLX_Node_Array_Record;
   type Bare_RFLX_Node_Array_Access is access all Bare_RFLX_Node_Array_Record;

         
   type Character_Type_Array_Record;
   type Character_Type_Array_Access is access all Character_Type_Array_Record;

         
   type Internal_Entity_Array_Record;
   type Internal_Entity_Array_Access is access all Internal_Entity_Array_Record;

         
   type Lexical_Env_Array_Record;
   type Lexical_Env_Array_Access is access all Lexical_Env_Array_Record;

         
   type Symbol_Type_Array_Record;
   type Symbol_Type_Array_Access is access all Symbol_Type_Array_Record;


   ----------------------------------------------
   -- Iterator types (incomplete declarations) --
   ----------------------------------------------

         
   type Internal_Bare_RFLX_Node_Iterator;
   type Bare_RFLX_Node_Iterator_Access is access all Internal_Bare_RFLX_Node_Iterator;

         
   type Internal_Internal_Entity_Iterator;
   type Internal_Entity_Iterator_Access is access all Internal_Internal_Entity_Iterator;


   -----------------------------------------
   -- Structure types (full declarations) --
   -----------------------------------------

         





   
      function Hash (R : Internal_Entity_Info) return Hash_Type;


      function Trace_Image (R : Internal_Entity_Info) return String;


         



      function Create_Internal_Entity
        (Node : Bare_RFLX_Node; Info : Internal_Entity_Info)
         return Internal_Entity;


   
      function Hash (R : Internal_Entity) return Hash_Type;


      function Trace_Image (R : Internal_Entity) return String;


         

      

      type Internal_Entity_AbstractID is record

               Node : aliased Bare_AbstractID;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_AbstractID : constant Internal_Entity_AbstractID;


      function Create_Internal_Entity_AbstractID
        (Node : Bare_AbstractID; Info : Internal_Entity_Info)
         return Internal_Entity_AbstractID;


   


      function Trace_Image (R : Internal_Entity_AbstractID) return String;


         

      

      type Internal_Entity_Type_Def is record

               Node : aliased Bare_Type_Def;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Type_Def : constant Internal_Entity_Type_Def;


      function Create_Internal_Entity_Type_Def
        (Node : Bare_Type_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Type_Def;


   


      function Trace_Image (R : Internal_Entity_Type_Def) return String;


         

      

      type Internal_Entity_Abstract_Message_Type_Def is record

               Node : aliased Bare_Abstract_Message_Type_Def;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Abstract_Message_Type_Def : constant Internal_Entity_Abstract_Message_Type_Def;


      function Create_Internal_Entity_Abstract_Message_Type_Def
        (Node : Bare_Abstract_Message_Type_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Abstract_Message_Type_Def;


   


      function Trace_Image (R : Internal_Entity_Abstract_Message_Type_Def) return String;


         

      

      type Internal_Entity_Aspect is record

               Node : aliased Bare_Aspect;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Aspect : constant Internal_Entity_Aspect;


      function Create_Internal_Entity_Aspect
        (Node : Bare_Aspect; Info : Internal_Entity_Info)
         return Internal_Entity_Aspect;


   


      function Trace_Image (R : Internal_Entity_Aspect) return String;


         

      

      type Internal_Entity_RFLX_Node_Base_List is record

               Node : aliased Bare_RFLX_Node_Base_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_RFLX_Node_Base_List : constant Internal_Entity_RFLX_Node_Base_List;


      function Create_Internal_Entity_RFLX_Node_Base_List
        (Node : Bare_RFLX_Node_Base_List; Info : Internal_Entity_Info)
         return Internal_Entity_RFLX_Node_Base_List;


   


      function Trace_Image (R : Internal_Entity_RFLX_Node_Base_List) return String;


         

      

      type Internal_Entity_Aspect_List is record

               Node : aliased Bare_Aspect_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Aspect_List : constant Internal_Entity_Aspect_List;


      function Create_Internal_Entity_Aspect_List
        (Node : Bare_Aspect_List; Info : Internal_Entity_Info)
         return Internal_Entity_Aspect_List;


   


      function Trace_Image (R : Internal_Entity_Aspect_List) return String;


         

      

      type Internal_Entity_Statement is record

               Node : aliased Bare_Statement;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Statement : constant Internal_Entity_Statement;


      function Create_Internal_Entity_Statement
        (Node : Bare_Statement; Info : Internal_Entity_Info)
         return Internal_Entity_Statement;


   


      function Trace_Image (R : Internal_Entity_Statement) return String;


         

      

      type Internal_Entity_Assignment is record

               Node : aliased Bare_Assignment;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Assignment : constant Internal_Entity_Assignment;


      function Create_Internal_Entity_Assignment
        (Node : Bare_Assignment; Info : Internal_Entity_Info)
         return Internal_Entity_Assignment;


   


      function Trace_Image (R : Internal_Entity_Assignment) return String;


         

      

      type Internal_Entity_Attr is record

               Node : aliased Bare_Attr;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Attr : constant Internal_Entity_Attr;


      function Create_Internal_Entity_Attr
        (Node : Bare_Attr; Info : Internal_Entity_Info)
         return Internal_Entity_Attr;


   


      function Trace_Image (R : Internal_Entity_Attr) return String;


         

      

      type Internal_Entity_Attr_First is record

               Node : aliased Bare_Attr_First;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Attr_First : constant Internal_Entity_Attr_First;


      function Create_Internal_Entity_Attr_First
        (Node : Bare_Attr_First; Info : Internal_Entity_Info)
         return Internal_Entity_Attr_First;


   


      function Trace_Image (R : Internal_Entity_Attr_First) return String;


         

      

      type Internal_Entity_Attr_Has_Data is record

               Node : aliased Bare_Attr_Has_Data;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Attr_Has_Data : constant Internal_Entity_Attr_Has_Data;


      function Create_Internal_Entity_Attr_Has_Data
        (Node : Bare_Attr_Has_Data; Info : Internal_Entity_Info)
         return Internal_Entity_Attr_Has_Data;


   


      function Trace_Image (R : Internal_Entity_Attr_Has_Data) return String;


         

      

      type Internal_Entity_Attr_Head is record

               Node : aliased Bare_Attr_Head;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Attr_Head : constant Internal_Entity_Attr_Head;


      function Create_Internal_Entity_Attr_Head
        (Node : Bare_Attr_Head; Info : Internal_Entity_Info)
         return Internal_Entity_Attr_Head;


   


      function Trace_Image (R : Internal_Entity_Attr_Head) return String;


         

      

      type Internal_Entity_Attr_Last is record

               Node : aliased Bare_Attr_Last;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Attr_Last : constant Internal_Entity_Attr_Last;


      function Create_Internal_Entity_Attr_Last
        (Node : Bare_Attr_Last; Info : Internal_Entity_Info)
         return Internal_Entity_Attr_Last;


   


      function Trace_Image (R : Internal_Entity_Attr_Last) return String;


         

      

      type Internal_Entity_Attr_Opaque is record

               Node : aliased Bare_Attr_Opaque;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Attr_Opaque : constant Internal_Entity_Attr_Opaque;


      function Create_Internal_Entity_Attr_Opaque
        (Node : Bare_Attr_Opaque; Info : Internal_Entity_Info)
         return Internal_Entity_Attr_Opaque;


   


      function Trace_Image (R : Internal_Entity_Attr_Opaque) return String;


         

      

      type Internal_Entity_Attr_Present is record

               Node : aliased Bare_Attr_Present;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Attr_Present : constant Internal_Entity_Attr_Present;


      function Create_Internal_Entity_Attr_Present
        (Node : Bare_Attr_Present; Info : Internal_Entity_Info)
         return Internal_Entity_Attr_Present;


   


      function Trace_Image (R : Internal_Entity_Attr_Present) return String;


         

      

      type Internal_Entity_Attr_Size is record

               Node : aliased Bare_Attr_Size;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Attr_Size : constant Internal_Entity_Attr_Size;


      function Create_Internal_Entity_Attr_Size
        (Node : Bare_Attr_Size; Info : Internal_Entity_Info)
         return Internal_Entity_Attr_Size;


   


      function Trace_Image (R : Internal_Entity_Attr_Size) return String;


         

      

      type Internal_Entity_Attr_Stmt is record

               Node : aliased Bare_Attr_Stmt;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Attr_Stmt : constant Internal_Entity_Attr_Stmt;


      function Create_Internal_Entity_Attr_Stmt
        (Node : Bare_Attr_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Attr_Stmt;


   


      function Trace_Image (R : Internal_Entity_Attr_Stmt) return String;


         

      

      type Internal_Entity_Attr_Stmt_Append is record

               Node : aliased Bare_Attr_Stmt_Append;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Attr_Stmt_Append : constant Internal_Entity_Attr_Stmt_Append;


      function Create_Internal_Entity_Attr_Stmt_Append
        (Node : Bare_Attr_Stmt_Append; Info : Internal_Entity_Info)
         return Internal_Entity_Attr_Stmt_Append;


   


      function Trace_Image (R : Internal_Entity_Attr_Stmt_Append) return String;


         

      

      type Internal_Entity_Attr_Stmt_Extend is record

               Node : aliased Bare_Attr_Stmt_Extend;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Attr_Stmt_Extend : constant Internal_Entity_Attr_Stmt_Extend;


      function Create_Internal_Entity_Attr_Stmt_Extend
        (Node : Bare_Attr_Stmt_Extend; Info : Internal_Entity_Info)
         return Internal_Entity_Attr_Stmt_Extend;


   


      function Trace_Image (R : Internal_Entity_Attr_Stmt_Extend) return String;


         

      

      type Internal_Entity_Attr_Stmt_Read is record

               Node : aliased Bare_Attr_Stmt_Read;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Attr_Stmt_Read : constant Internal_Entity_Attr_Stmt_Read;


      function Create_Internal_Entity_Attr_Stmt_Read
        (Node : Bare_Attr_Stmt_Read; Info : Internal_Entity_Info)
         return Internal_Entity_Attr_Stmt_Read;


   


      function Trace_Image (R : Internal_Entity_Attr_Stmt_Read) return String;


         

      

      type Internal_Entity_Attr_Stmt_Write is record

               Node : aliased Bare_Attr_Stmt_Write;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Attr_Stmt_Write : constant Internal_Entity_Attr_Stmt_Write;


      function Create_Internal_Entity_Attr_Stmt_Write
        (Node : Bare_Attr_Stmt_Write; Info : Internal_Entity_Info)
         return Internal_Entity_Attr_Stmt_Write;


   


      function Trace_Image (R : Internal_Entity_Attr_Stmt_Write) return String;


         

      

      type Internal_Entity_Attr_Valid is record

               Node : aliased Bare_Attr_Valid;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Attr_Valid : constant Internal_Entity_Attr_Valid;


      function Create_Internal_Entity_Attr_Valid
        (Node : Bare_Attr_Valid; Info : Internal_Entity_Info)
         return Internal_Entity_Attr_Valid;


   


      function Trace_Image (R : Internal_Entity_Attr_Valid) return String;


         

      

      type Internal_Entity_Attr_Valid_Checksum is record

               Node : aliased Bare_Attr_Valid_Checksum;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Attr_Valid_Checksum : constant Internal_Entity_Attr_Valid_Checksum;


      function Create_Internal_Entity_Attr_Valid_Checksum
        (Node : Bare_Attr_Valid_Checksum; Info : Internal_Entity_Info)
         return Internal_Entity_Attr_Valid_Checksum;


   


      function Trace_Image (R : Internal_Entity_Attr_Valid_Checksum) return String;


         

      

      type Internal_Entity_Expr is record

               Node : aliased Bare_Expr;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Expr : constant Internal_Entity_Expr;


      function Create_Internal_Entity_Expr
        (Node : Bare_Expr; Info : Internal_Entity_Info)
         return Internal_Entity_Expr;


   


      function Trace_Image (R : Internal_Entity_Expr) return String;


         

      

      type Internal_Entity_Attribute is record

               Node : aliased Bare_Attribute;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Attribute : constant Internal_Entity_Attribute;


      function Create_Internal_Entity_Attribute
        (Node : Bare_Attribute; Info : Internal_Entity_Info)
         return Internal_Entity_Attribute;


   


      function Trace_Image (R : Internal_Entity_Attribute) return String;


         

      

      type Internal_Entity_Attribute_Statement is record

               Node : aliased Bare_Attribute_Statement;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Attribute_Statement : constant Internal_Entity_Attribute_Statement;


      function Create_Internal_Entity_Attribute_Statement
        (Node : Bare_Attribute_Statement; Info : Internal_Entity_Info)
         return Internal_Entity_Attribute_Statement;


   


      function Trace_Image (R : Internal_Entity_Attribute_Statement) return String;


         

      

      type Internal_Entity_Base_Aggregate is record

               Node : aliased Bare_Base_Aggregate;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Base_Aggregate : constant Internal_Entity_Base_Aggregate;


      function Create_Internal_Entity_Base_Aggregate
        (Node : Bare_Base_Aggregate; Info : Internal_Entity_Info)
         return Internal_Entity_Base_Aggregate;


   


      function Trace_Image (R : Internal_Entity_Base_Aggregate) return String;


         

      

      type Internal_Entity_Base_Checksum_Val is record

               Node : aliased Bare_Base_Checksum_Val;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Base_Checksum_Val : constant Internal_Entity_Base_Checksum_Val;


      function Create_Internal_Entity_Base_Checksum_Val
        (Node : Bare_Base_Checksum_Val; Info : Internal_Entity_Info)
         return Internal_Entity_Base_Checksum_Val;


   


      function Trace_Image (R : Internal_Entity_Base_Checksum_Val) return String;


         

      

      type Internal_Entity_Base_Checksum_Val_List is record

               Node : aliased Bare_Base_Checksum_Val_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Base_Checksum_Val_List : constant Internal_Entity_Base_Checksum_Val_List;


      function Create_Internal_Entity_Base_Checksum_Val_List
        (Node : Bare_Base_Checksum_Val_List; Info : Internal_Entity_Info)
         return Internal_Entity_Base_Checksum_Val_List;


   


      function Trace_Image (R : Internal_Entity_Base_Checksum_Val_List) return String;


         

      

      type Internal_Entity_Base_State_Body is record

               Node : aliased Bare_Base_State_Body;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Base_State_Body : constant Internal_Entity_Base_State_Body;


      function Create_Internal_Entity_Base_State_Body
        (Node : Bare_Base_State_Body; Info : Internal_Entity_Info)
         return Internal_Entity_Base_State_Body;


   


      function Trace_Image (R : Internal_Entity_Base_State_Body) return String;


         

      

      type Internal_Entity_Bin_Op is record

               Node : aliased Bare_Bin_Op;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Bin_Op : constant Internal_Entity_Bin_Op;


      function Create_Internal_Entity_Bin_Op
        (Node : Bare_Bin_Op; Info : Internal_Entity_Info)
         return Internal_Entity_Bin_Op;


   


      function Trace_Image (R : Internal_Entity_Bin_Op) return String;


         

      

      type Internal_Entity_Binding is record

               Node : aliased Bare_Binding;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Binding : constant Internal_Entity_Binding;


      function Create_Internal_Entity_Binding
        (Node : Bare_Binding; Info : Internal_Entity_Info)
         return Internal_Entity_Binding;


   


      function Trace_Image (R : Internal_Entity_Binding) return String;


         

      

      type Internal_Entity_Message_Aspect is record

               Node : aliased Bare_Message_Aspect;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Message_Aspect : constant Internal_Entity_Message_Aspect;


      function Create_Internal_Entity_Message_Aspect
        (Node : Bare_Message_Aspect; Info : Internal_Entity_Info)
         return Internal_Entity_Message_Aspect;


   


      function Trace_Image (R : Internal_Entity_Message_Aspect) return String;


         

      

      type Internal_Entity_Byte_Order_Aspect is record

               Node : aliased Bare_Byte_Order_Aspect;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Byte_Order_Aspect : constant Internal_Entity_Byte_Order_Aspect;


      function Create_Internal_Entity_Byte_Order_Aspect
        (Node : Bare_Byte_Order_Aspect; Info : Internal_Entity_Info)
         return Internal_Entity_Byte_Order_Aspect;


   


      function Trace_Image (R : Internal_Entity_Byte_Order_Aspect) return String;


         

      

      type Internal_Entity_Byte_Order_Type is record

               Node : aliased Bare_Byte_Order_Type;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Byte_Order_Type : constant Internal_Entity_Byte_Order_Type;


      function Create_Internal_Entity_Byte_Order_Type
        (Node : Bare_Byte_Order_Type; Info : Internal_Entity_Info)
         return Internal_Entity_Byte_Order_Type;


   


      function Trace_Image (R : Internal_Entity_Byte_Order_Type) return String;


         

      

      type Internal_Entity_Byte_Order_Type_Highorderfirst is record

               Node : aliased Bare_Byte_Order_Type_Highorderfirst;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Byte_Order_Type_Highorderfirst : constant Internal_Entity_Byte_Order_Type_Highorderfirst;


      function Create_Internal_Entity_Byte_Order_Type_Highorderfirst
        (Node : Bare_Byte_Order_Type_Highorderfirst; Info : Internal_Entity_Info)
         return Internal_Entity_Byte_Order_Type_Highorderfirst;


   


      function Trace_Image (R : Internal_Entity_Byte_Order_Type_Highorderfirst) return String;


         

      

      type Internal_Entity_Byte_Order_Type_Loworderfirst is record

               Node : aliased Bare_Byte_Order_Type_Loworderfirst;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Byte_Order_Type_Loworderfirst : constant Internal_Entity_Byte_Order_Type_Loworderfirst;


      function Create_Internal_Entity_Byte_Order_Type_Loworderfirst
        (Node : Bare_Byte_Order_Type_Loworderfirst; Info : Internal_Entity_Info)
         return Internal_Entity_Byte_Order_Type_Loworderfirst;


   


      function Trace_Image (R : Internal_Entity_Byte_Order_Type_Loworderfirst) return String;


         

      

      type Internal_Entity_Call is record

               Node : aliased Bare_Call;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Call : constant Internal_Entity_Call;


      function Create_Internal_Entity_Call
        (Node : Bare_Call; Info : Internal_Entity_Info)
         return Internal_Entity_Call;


   


      function Trace_Image (R : Internal_Entity_Call) return String;


         

      

      type Internal_Entity_Channel_Attribute is record

               Node : aliased Bare_Channel_Attribute;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Channel_Attribute : constant Internal_Entity_Channel_Attribute;


      function Create_Internal_Entity_Channel_Attribute
        (Node : Bare_Channel_Attribute; Info : Internal_Entity_Info)
         return Internal_Entity_Channel_Attribute;


   


      function Trace_Image (R : Internal_Entity_Channel_Attribute) return String;


         

      

      type Internal_Entity_Channel_Attribute_List is record

               Node : aliased Bare_Channel_Attribute_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Channel_Attribute_List : constant Internal_Entity_Channel_Attribute_List;


      function Create_Internal_Entity_Channel_Attribute_List
        (Node : Bare_Channel_Attribute_List; Info : Internal_Entity_Info)
         return Internal_Entity_Channel_Attribute_List;


   


      function Trace_Image (R : Internal_Entity_Channel_Attribute_List) return String;


         

      

      type Internal_Entity_Checksum_Aspect is record

               Node : aliased Bare_Checksum_Aspect;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Checksum_Aspect : constant Internal_Entity_Checksum_Aspect;


      function Create_Internal_Entity_Checksum_Aspect
        (Node : Bare_Checksum_Aspect; Info : Internal_Entity_Info)
         return Internal_Entity_Checksum_Aspect;


   


      function Trace_Image (R : Internal_Entity_Checksum_Aspect) return String;


         

      

      type Internal_Entity_Checksum_Assoc is record

               Node : aliased Bare_Checksum_Assoc;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Checksum_Assoc : constant Internal_Entity_Checksum_Assoc;


      function Create_Internal_Entity_Checksum_Assoc
        (Node : Bare_Checksum_Assoc; Info : Internal_Entity_Info)
         return Internal_Entity_Checksum_Assoc;


   


      function Trace_Image (R : Internal_Entity_Checksum_Assoc) return String;


         

      

      type Internal_Entity_Checksum_Assoc_List is record

               Node : aliased Bare_Checksum_Assoc_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Checksum_Assoc_List : constant Internal_Entity_Checksum_Assoc_List;


      function Create_Internal_Entity_Checksum_Assoc_List
        (Node : Bare_Checksum_Assoc_List; Info : Internal_Entity_Info)
         return Internal_Entity_Checksum_Assoc_List;


   


      function Trace_Image (R : Internal_Entity_Checksum_Assoc_List) return String;


         

      

      type Internal_Entity_Checksum_Val is record

               Node : aliased Bare_Checksum_Val;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Checksum_Val : constant Internal_Entity_Checksum_Val;


      function Create_Internal_Entity_Checksum_Val
        (Node : Bare_Checksum_Val; Info : Internal_Entity_Info)
         return Internal_Entity_Checksum_Val;


   


      function Trace_Image (R : Internal_Entity_Checksum_Val) return String;


         

      

      type Internal_Entity_Checksum_Value_Range is record

               Node : aliased Bare_Checksum_Value_Range;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Checksum_Value_Range : constant Internal_Entity_Checksum_Value_Range;


      function Create_Internal_Entity_Checksum_Value_Range
        (Node : Bare_Checksum_Value_Range; Info : Internal_Entity_Info)
         return Internal_Entity_Checksum_Value_Range;


   


      function Trace_Image (R : Internal_Entity_Checksum_Value_Range) return String;


         

      

      type Internal_Entity_Comprehension is record

               Node : aliased Bare_Comprehension;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Comprehension : constant Internal_Entity_Comprehension;


      function Create_Internal_Entity_Comprehension
        (Node : Bare_Comprehension; Info : Internal_Entity_Info)
         return Internal_Entity_Comprehension;


   


      function Trace_Image (R : Internal_Entity_Comprehension) return String;


         

      

      type Internal_Entity_Sequence_Literal is record

               Node : aliased Bare_Sequence_Literal;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Sequence_Literal : constant Internal_Entity_Sequence_Literal;


      function Create_Internal_Entity_Sequence_Literal
        (Node : Bare_Sequence_Literal; Info : Internal_Entity_Info)
         return Internal_Entity_Sequence_Literal;


   


      function Trace_Image (R : Internal_Entity_Sequence_Literal) return String;


         

      

      type Internal_Entity_Concatenation is record

               Node : aliased Bare_Concatenation;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Concatenation : constant Internal_Entity_Concatenation;


      function Create_Internal_Entity_Concatenation
        (Node : Bare_Concatenation; Info : Internal_Entity_Info)
         return Internal_Entity_Concatenation;


   


      function Trace_Image (R : Internal_Entity_Concatenation) return String;


         

      

      type Internal_Entity_Transition is record

               Node : aliased Bare_Transition;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Transition : constant Internal_Entity_Transition;


      function Create_Internal_Entity_Transition
        (Node : Bare_Transition; Info : Internal_Entity_Info)
         return Internal_Entity_Transition;


   


      function Trace_Image (R : Internal_Entity_Transition) return String;


         

      

      type Internal_Entity_Conditional_Transition is record

               Node : aliased Bare_Conditional_Transition;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Conditional_Transition : constant Internal_Entity_Conditional_Transition;


      function Create_Internal_Entity_Conditional_Transition
        (Node : Bare_Conditional_Transition; Info : Internal_Entity_Info)
         return Internal_Entity_Conditional_Transition;


   


      function Trace_Image (R : Internal_Entity_Conditional_Transition) return String;


         

      

      type Internal_Entity_Conditional_Transition_List is record

               Node : aliased Bare_Conditional_Transition_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Conditional_Transition_List : constant Internal_Entity_Conditional_Transition_List;


      function Create_Internal_Entity_Conditional_Transition_List
        (Node : Bare_Conditional_Transition_List; Info : Internal_Entity_Info)
         return Internal_Entity_Conditional_Transition_List;


   


      function Trace_Image (R : Internal_Entity_Conditional_Transition_List) return String;


         

      

      type Internal_Entity_Context_Item is record

               Node : aliased Bare_Context_Item;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Context_Item : constant Internal_Entity_Context_Item;


      function Create_Internal_Entity_Context_Item
        (Node : Bare_Context_Item; Info : Internal_Entity_Info)
         return Internal_Entity_Context_Item;


   


      function Trace_Image (R : Internal_Entity_Context_Item) return String;


         

      

      type Internal_Entity_Context_Item_List is record

               Node : aliased Bare_Context_Item_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Context_Item_List : constant Internal_Entity_Context_Item_List;


      function Create_Internal_Entity_Context_Item_List
        (Node : Bare_Context_Item_List; Info : Internal_Entity_Info)
         return Internal_Entity_Context_Item_List;


   


      function Trace_Image (R : Internal_Entity_Context_Item_List) return String;


         

      

      type Internal_Entity_Conversion is record

               Node : aliased Bare_Conversion;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Conversion : constant Internal_Entity_Conversion;


      function Create_Internal_Entity_Conversion
        (Node : Bare_Conversion; Info : Internal_Entity_Info)
         return Internal_Entity_Conversion;


   


      function Trace_Image (R : Internal_Entity_Conversion) return String;


         

      

      type Internal_Entity_Declaration is record

               Node : aliased Bare_Declaration;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Declaration : constant Internal_Entity_Declaration;


      function Create_Internal_Entity_Declaration
        (Node : Bare_Declaration; Info : Internal_Entity_Info)
         return Internal_Entity_Declaration;


   


      function Trace_Image (R : Internal_Entity_Declaration) return String;


         

      

      type Internal_Entity_Declaration_List is record

               Node : aliased Bare_Declaration_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Declaration_List : constant Internal_Entity_Declaration_List;


      function Create_Internal_Entity_Declaration_List
        (Node : Bare_Declaration_List; Info : Internal_Entity_Info)
         return Internal_Entity_Declaration_List;


   


      function Trace_Image (R : Internal_Entity_Declaration_List) return String;


         

      

      type Internal_Entity_Description is record

               Node : aliased Bare_Description;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Description : constant Internal_Entity_Description;


      function Create_Internal_Entity_Description
        (Node : Bare_Description; Info : Internal_Entity_Info)
         return Internal_Entity_Description;


   


      function Trace_Image (R : Internal_Entity_Description) return String;


         

      

      type Internal_Entity_Element_Value_Assoc is record

               Node : aliased Bare_Element_Value_Assoc;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Element_Value_Assoc : constant Internal_Entity_Element_Value_Assoc;


      function Create_Internal_Entity_Element_Value_Assoc
        (Node : Bare_Element_Value_Assoc; Info : Internal_Entity_Info)
         return Internal_Entity_Element_Value_Assoc;


   


      function Trace_Image (R : Internal_Entity_Element_Value_Assoc) return String;


         

      

      type Internal_Entity_Element_Value_Assoc_List is record

               Node : aliased Bare_Element_Value_Assoc_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Element_Value_Assoc_List : constant Internal_Entity_Element_Value_Assoc_List;


      function Create_Internal_Entity_Element_Value_Assoc_List
        (Node : Bare_Element_Value_Assoc_List; Info : Internal_Entity_Info)
         return Internal_Entity_Element_Value_Assoc_List;


   


      function Trace_Image (R : Internal_Entity_Element_Value_Assoc_List) return String;


         

      

      type Internal_Entity_Enumeration_Def is record

               Node : aliased Bare_Enumeration_Def;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Enumeration_Def : constant Internal_Entity_Enumeration_Def;


      function Create_Internal_Entity_Enumeration_Def
        (Node : Bare_Enumeration_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Enumeration_Def;


   


      function Trace_Image (R : Internal_Entity_Enumeration_Def) return String;


         

      

      type Internal_Entity_Enumeration_Type_Def is record

               Node : aliased Bare_Enumeration_Type_Def;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Enumeration_Type_Def : constant Internal_Entity_Enumeration_Type_Def;


      function Create_Internal_Entity_Enumeration_Type_Def
        (Node : Bare_Enumeration_Type_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Enumeration_Type_Def;


   


      function Trace_Image (R : Internal_Entity_Enumeration_Type_Def) return String;


         

      

      type Internal_Entity_Expr_List is record

               Node : aliased Bare_Expr_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Expr_List : constant Internal_Entity_Expr_List;


      function Create_Internal_Entity_Expr_List
        (Node : Bare_Expr_List; Info : Internal_Entity_Info)
         return Internal_Entity_Expr_List;


   


      function Trace_Image (R : Internal_Entity_Expr_List) return String;


         

      

      type Internal_Entity_Formal_Decl is record

               Node : aliased Bare_Formal_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Formal_Decl : constant Internal_Entity_Formal_Decl;


      function Create_Internal_Entity_Formal_Decl
        (Node : Bare_Formal_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Formal_Decl;


   


      function Trace_Image (R : Internal_Entity_Formal_Decl) return String;


         

      

      type Internal_Entity_Formal_Channel_Decl is record

               Node : aliased Bare_Formal_Channel_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Formal_Channel_Decl : constant Internal_Entity_Formal_Channel_Decl;


      function Create_Internal_Entity_Formal_Channel_Decl
        (Node : Bare_Formal_Channel_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Formal_Channel_Decl;


   


      function Trace_Image (R : Internal_Entity_Formal_Channel_Decl) return String;


         

      

      type Internal_Entity_Formal_Decl_List is record

               Node : aliased Bare_Formal_Decl_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Formal_Decl_List : constant Internal_Entity_Formal_Decl_List;


      function Create_Internal_Entity_Formal_Decl_List
        (Node : Bare_Formal_Decl_List; Info : Internal_Entity_Info)
         return Internal_Entity_Formal_Decl_List;


   


      function Trace_Image (R : Internal_Entity_Formal_Decl_List) return String;


         

      

      type Internal_Entity_Formal_Function_Decl is record

               Node : aliased Bare_Formal_Function_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Formal_Function_Decl : constant Internal_Entity_Formal_Function_Decl;


      function Create_Internal_Entity_Formal_Function_Decl
        (Node : Bare_Formal_Function_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Formal_Function_Decl;


   


      function Trace_Image (R : Internal_Entity_Formal_Function_Decl) return String;


         

      

      type Internal_Entity_Formal_Private_Type_Decl is record

               Node : aliased Bare_Formal_Private_Type_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Formal_Private_Type_Decl : constant Internal_Entity_Formal_Private_Type_Decl;


      function Create_Internal_Entity_Formal_Private_Type_Decl
        (Node : Bare_Formal_Private_Type_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Formal_Private_Type_Decl;


   


      function Trace_Image (R : Internal_Entity_Formal_Private_Type_Decl) return String;


         

      

      type Internal_Entity_ID is record

               Node : aliased Bare_ID;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_ID : constant Internal_Entity_ID;


      function Create_Internal_Entity_ID
        (Node : Bare_ID; Info : Internal_Entity_Info)
         return Internal_Entity_ID;


   


      function Trace_Image (R : Internal_Entity_ID) return String;


         

      

      type Internal_Entity_Integer_Type_Def is record

               Node : aliased Bare_Integer_Type_Def;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Integer_Type_Def : constant Internal_Entity_Integer_Type_Def;


      function Create_Internal_Entity_Integer_Type_Def
        (Node : Bare_Integer_Type_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Integer_Type_Def;


   


      function Trace_Image (R : Internal_Entity_Integer_Type_Def) return String;


         

      

      type Internal_Entity_Local_Decl is record

               Node : aliased Bare_Local_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Local_Decl : constant Internal_Entity_Local_Decl;


      function Create_Internal_Entity_Local_Decl
        (Node : Bare_Local_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Local_Decl;


   


      function Trace_Image (R : Internal_Entity_Local_Decl) return String;


         

      

      type Internal_Entity_Local_Decl_List is record

               Node : aliased Bare_Local_Decl_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Local_Decl_List : constant Internal_Entity_Local_Decl_List;


      function Create_Internal_Entity_Local_Decl_List
        (Node : Bare_Local_Decl_List; Info : Internal_Entity_Info)
         return Internal_Entity_Local_Decl_List;


   


      function Trace_Image (R : Internal_Entity_Local_Decl_List) return String;


         

      

      type Internal_Entity_Message_Aggregate is record

               Node : aliased Bare_Message_Aggregate;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Message_Aggregate : constant Internal_Entity_Message_Aggregate;


      function Create_Internal_Entity_Message_Aggregate
        (Node : Bare_Message_Aggregate; Info : Internal_Entity_Info)
         return Internal_Entity_Message_Aggregate;


   


      function Trace_Image (R : Internal_Entity_Message_Aggregate) return String;


         

      

      type Internal_Entity_Message_Aggregate_Association is record

               Node : aliased Bare_Message_Aggregate_Association;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Message_Aggregate_Association : constant Internal_Entity_Message_Aggregate_Association;


      function Create_Internal_Entity_Message_Aggregate_Association
        (Node : Bare_Message_Aggregate_Association; Info : Internal_Entity_Info)
         return Internal_Entity_Message_Aggregate_Association;


   


      function Trace_Image (R : Internal_Entity_Message_Aggregate_Association) return String;


         

      

      type Internal_Entity_Message_Aggregate_Association_List is record

               Node : aliased Bare_Message_Aggregate_Association_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Message_Aggregate_Association_List : constant Internal_Entity_Message_Aggregate_Association_List;


      function Create_Internal_Entity_Message_Aggregate_Association_List
        (Node : Bare_Message_Aggregate_Association_List; Info : Internal_Entity_Info)
         return Internal_Entity_Message_Aggregate_Association_List;


   


      function Trace_Image (R : Internal_Entity_Message_Aggregate_Association_List) return String;


         

      

      type Internal_Entity_Message_Aggregate_Associations is record

               Node : aliased Bare_Message_Aggregate_Associations;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Message_Aggregate_Associations : constant Internal_Entity_Message_Aggregate_Associations;


      function Create_Internal_Entity_Message_Aggregate_Associations
        (Node : Bare_Message_Aggregate_Associations; Info : Internal_Entity_Info)
         return Internal_Entity_Message_Aggregate_Associations;


   


      function Trace_Image (R : Internal_Entity_Message_Aggregate_Associations) return String;


         

      

      type Internal_Entity_Message_Aspect_List is record

               Node : aliased Bare_Message_Aspect_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Message_Aspect_List : constant Internal_Entity_Message_Aspect_List;


      function Create_Internal_Entity_Message_Aspect_List
        (Node : Bare_Message_Aspect_List; Info : Internal_Entity_Info)
         return Internal_Entity_Message_Aspect_List;


   


      function Trace_Image (R : Internal_Entity_Message_Aspect_List) return String;


         

      

      type Internal_Entity_Message_Field is record

               Node : aliased Bare_Message_Field;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Message_Field : constant Internal_Entity_Message_Field;


      function Create_Internal_Entity_Message_Field
        (Node : Bare_Message_Field; Info : Internal_Entity_Info)
         return Internal_Entity_Message_Field;


   


      function Trace_Image (R : Internal_Entity_Message_Field) return String;


         

      

      type Internal_Entity_Message_Field_List is record

               Node : aliased Bare_Message_Field_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Message_Field_List : constant Internal_Entity_Message_Field_List;


      function Create_Internal_Entity_Message_Field_List
        (Node : Bare_Message_Field_List; Info : Internal_Entity_Info)
         return Internal_Entity_Message_Field_List;


   


      function Trace_Image (R : Internal_Entity_Message_Field_List) return String;


         

      

      type Internal_Entity_Message_Fields is record

               Node : aliased Bare_Message_Fields;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Message_Fields : constant Internal_Entity_Message_Fields;


      function Create_Internal_Entity_Message_Fields
        (Node : Bare_Message_Fields; Info : Internal_Entity_Info)
         return Internal_Entity_Message_Fields;


   


      function Trace_Image (R : Internal_Entity_Message_Fields) return String;


         

      

      type Internal_Entity_Message_Type_Def is record

               Node : aliased Bare_Message_Type_Def;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Message_Type_Def : constant Internal_Entity_Message_Type_Def;


      function Create_Internal_Entity_Message_Type_Def
        (Node : Bare_Message_Type_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Message_Type_Def;


   


      function Trace_Image (R : Internal_Entity_Message_Type_Def) return String;


         

      

      type Internal_Entity_Modular_Type_Def is record

               Node : aliased Bare_Modular_Type_Def;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Modular_Type_Def : constant Internal_Entity_Modular_Type_Def;


      function Create_Internal_Entity_Modular_Type_Def
        (Node : Bare_Modular_Type_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Modular_Type_Def;


   


      function Trace_Image (R : Internal_Entity_Modular_Type_Def) return String;


         

      

      type Internal_Entity_Named_Enumeration_Def is record

               Node : aliased Bare_Named_Enumeration_Def;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Named_Enumeration_Def : constant Internal_Entity_Named_Enumeration_Def;


      function Create_Internal_Entity_Named_Enumeration_Def
        (Node : Bare_Named_Enumeration_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Named_Enumeration_Def;


   


      function Trace_Image (R : Internal_Entity_Named_Enumeration_Def) return String;


         

      

      type Internal_Entity_Negation is record

               Node : aliased Bare_Negation;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Negation : constant Internal_Entity_Negation;


      function Create_Internal_Entity_Negation
        (Node : Bare_Negation; Info : Internal_Entity_Info)
         return Internal_Entity_Negation;


   


      function Trace_Image (R : Internal_Entity_Negation) return String;


         

      

      type Internal_Entity_NullID is record

               Node : aliased Bare_NullID;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_NullID : constant Internal_Entity_NullID;


      function Create_Internal_Entity_NullID
        (Node : Bare_NullID; Info : Internal_Entity_Info)
         return Internal_Entity_NullID;


   


      function Trace_Image (R : Internal_Entity_NullID) return String;


         

      

      type Internal_Entity_Null_Message_Aggregate is record

               Node : aliased Bare_Null_Message_Aggregate;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Null_Message_Aggregate : constant Internal_Entity_Null_Message_Aggregate;


      function Create_Internal_Entity_Null_Message_Aggregate
        (Node : Bare_Null_Message_Aggregate; Info : Internal_Entity_Info)
         return Internal_Entity_Null_Message_Aggregate;


   


      function Trace_Image (R : Internal_Entity_Null_Message_Aggregate) return String;


         

      

      type Internal_Entity_Null_Message_Field is record

               Node : aliased Bare_Null_Message_Field;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Null_Message_Field : constant Internal_Entity_Null_Message_Field;


      function Create_Internal_Entity_Null_Message_Field
        (Node : Bare_Null_Message_Field; Info : Internal_Entity_Info)
         return Internal_Entity_Null_Message_Field;


   


      function Trace_Image (R : Internal_Entity_Null_Message_Field) return String;


         

      

      type Internal_Entity_Null_Message_Type_Def is record

               Node : aliased Bare_Null_Message_Type_Def;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Null_Message_Type_Def : constant Internal_Entity_Null_Message_Type_Def;


      function Create_Internal_Entity_Null_Message_Type_Def
        (Node : Bare_Null_Message_Type_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Null_Message_Type_Def;


   


      function Trace_Image (R : Internal_Entity_Null_Message_Type_Def) return String;


         

      

      type Internal_Entity_Null_State_Body is record

               Node : aliased Bare_Null_State_Body;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Null_State_Body : constant Internal_Entity_Null_State_Body;


      function Create_Internal_Entity_Null_State_Body
        (Node : Bare_Null_State_Body; Info : Internal_Entity_Info)
         return Internal_Entity_Null_State_Body;


   


      function Trace_Image (R : Internal_Entity_Null_State_Body) return String;


         

      

      type Internal_Entity_Numeric_Literal is record

               Node : aliased Bare_Numeric_Literal;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Numeric_Literal : constant Internal_Entity_Numeric_Literal;


      function Create_Internal_Entity_Numeric_Literal
        (Node : Bare_Numeric_Literal; Info : Internal_Entity_Info)
         return Internal_Entity_Numeric_Literal;


   


      function Trace_Image (R : Internal_Entity_Numeric_Literal) return String;


         

      

      type Internal_Entity_Numeric_Literal_List is record

               Node : aliased Bare_Numeric_Literal_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Numeric_Literal_List : constant Internal_Entity_Numeric_Literal_List;


      function Create_Internal_Entity_Numeric_Literal_List
        (Node : Bare_Numeric_Literal_List; Info : Internal_Entity_Info)
         return Internal_Entity_Numeric_Literal_List;


   


      function Trace_Image (R : Internal_Entity_Numeric_Literal_List) return String;


         

      

      type Internal_Entity_Op is record

               Node : aliased Bare_Op;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Op : constant Internal_Entity_Op;


      function Create_Internal_Entity_Op
        (Node : Bare_Op; Info : Internal_Entity_Info)
         return Internal_Entity_Op;


   


      function Trace_Image (R : Internal_Entity_Op) return String;


         

      

      type Internal_Entity_Op_Add is record

               Node : aliased Bare_Op_Add;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Op_Add : constant Internal_Entity_Op_Add;


      function Create_Internal_Entity_Op_Add
        (Node : Bare_Op_Add; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Add;


   


      function Trace_Image (R : Internal_Entity_Op_Add) return String;


         

      

      type Internal_Entity_Op_And is record

               Node : aliased Bare_Op_And;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Op_And : constant Internal_Entity_Op_And;


      function Create_Internal_Entity_Op_And
        (Node : Bare_Op_And; Info : Internal_Entity_Info)
         return Internal_Entity_Op_And;


   


      function Trace_Image (R : Internal_Entity_Op_And) return String;


         

      

      type Internal_Entity_Op_Div is record

               Node : aliased Bare_Op_Div;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Op_Div : constant Internal_Entity_Op_Div;


      function Create_Internal_Entity_Op_Div
        (Node : Bare_Op_Div; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Div;


   


      function Trace_Image (R : Internal_Entity_Op_Div) return String;


         

      

      type Internal_Entity_Op_Eq is record

               Node : aliased Bare_Op_Eq;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Op_Eq : constant Internal_Entity_Op_Eq;


      function Create_Internal_Entity_Op_Eq
        (Node : Bare_Op_Eq; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Eq;


   


      function Trace_Image (R : Internal_Entity_Op_Eq) return String;


         

      

      type Internal_Entity_Op_Ge is record

               Node : aliased Bare_Op_Ge;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Op_Ge : constant Internal_Entity_Op_Ge;


      function Create_Internal_Entity_Op_Ge
        (Node : Bare_Op_Ge; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Ge;


   


      function Trace_Image (R : Internal_Entity_Op_Ge) return String;


         

      

      type Internal_Entity_Op_Gt is record

               Node : aliased Bare_Op_Gt;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Op_Gt : constant Internal_Entity_Op_Gt;


      function Create_Internal_Entity_Op_Gt
        (Node : Bare_Op_Gt; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Gt;


   


      function Trace_Image (R : Internal_Entity_Op_Gt) return String;


         

      

      type Internal_Entity_Op_In is record

               Node : aliased Bare_Op_In;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Op_In : constant Internal_Entity_Op_In;


      function Create_Internal_Entity_Op_In
        (Node : Bare_Op_In; Info : Internal_Entity_Info)
         return Internal_Entity_Op_In;


   


      function Trace_Image (R : Internal_Entity_Op_In) return String;


         

      

      type Internal_Entity_Op_Le is record

               Node : aliased Bare_Op_Le;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Op_Le : constant Internal_Entity_Op_Le;


      function Create_Internal_Entity_Op_Le
        (Node : Bare_Op_Le; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Le;


   


      function Trace_Image (R : Internal_Entity_Op_Le) return String;


         

      

      type Internal_Entity_Op_Lt is record

               Node : aliased Bare_Op_Lt;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Op_Lt : constant Internal_Entity_Op_Lt;


      function Create_Internal_Entity_Op_Lt
        (Node : Bare_Op_Lt; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Lt;


   


      function Trace_Image (R : Internal_Entity_Op_Lt) return String;


         

      

      type Internal_Entity_Op_Mod is record

               Node : aliased Bare_Op_Mod;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Op_Mod : constant Internal_Entity_Op_Mod;


      function Create_Internal_Entity_Op_Mod
        (Node : Bare_Op_Mod; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Mod;


   


      function Trace_Image (R : Internal_Entity_Op_Mod) return String;


         

      

      type Internal_Entity_Op_Mul is record

               Node : aliased Bare_Op_Mul;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Op_Mul : constant Internal_Entity_Op_Mul;


      function Create_Internal_Entity_Op_Mul
        (Node : Bare_Op_Mul; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Mul;


   


      function Trace_Image (R : Internal_Entity_Op_Mul) return String;


         

      

      type Internal_Entity_Op_Neq is record

               Node : aliased Bare_Op_Neq;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Op_Neq : constant Internal_Entity_Op_Neq;


      function Create_Internal_Entity_Op_Neq
        (Node : Bare_Op_Neq; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Neq;


   


      function Trace_Image (R : Internal_Entity_Op_Neq) return String;


         

      

      type Internal_Entity_Op_Notin is record

               Node : aliased Bare_Op_Notin;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Op_Notin : constant Internal_Entity_Op_Notin;


      function Create_Internal_Entity_Op_Notin
        (Node : Bare_Op_Notin; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Notin;


   


      function Trace_Image (R : Internal_Entity_Op_Notin) return String;


         

      

      type Internal_Entity_Op_Or is record

               Node : aliased Bare_Op_Or;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Op_Or : constant Internal_Entity_Op_Or;


      function Create_Internal_Entity_Op_Or
        (Node : Bare_Op_Or; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Or;


   


      function Trace_Image (R : Internal_Entity_Op_Or) return String;


         

      

      type Internal_Entity_Op_Pow is record

               Node : aliased Bare_Op_Pow;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Op_Pow : constant Internal_Entity_Op_Pow;


      function Create_Internal_Entity_Op_Pow
        (Node : Bare_Op_Pow; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Pow;


   


      function Trace_Image (R : Internal_Entity_Op_Pow) return String;


         

      

      type Internal_Entity_Op_Sub is record

               Node : aliased Bare_Op_Sub;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Op_Sub : constant Internal_Entity_Op_Sub;


      function Create_Internal_Entity_Op_Sub
        (Node : Bare_Op_Sub; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Sub;


   


      function Trace_Image (R : Internal_Entity_Op_Sub) return String;


         

      

      type Internal_Entity_Package_Node is record

               Node : aliased Bare_Package_Node;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Package_Node : constant Internal_Entity_Package_Node;


      function Create_Internal_Entity_Package_Node
        (Node : Bare_Package_Node; Info : Internal_Entity_Info)
         return Internal_Entity_Package_Node;


   


      function Trace_Image (R : Internal_Entity_Package_Node) return String;


         

      

      type Internal_Entity_Parameter is record

               Node : aliased Bare_Parameter;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Parameter : constant Internal_Entity_Parameter;


      function Create_Internal_Entity_Parameter
        (Node : Bare_Parameter; Info : Internal_Entity_Info)
         return Internal_Entity_Parameter;


   


      function Trace_Image (R : Internal_Entity_Parameter) return String;


         

      

      type Internal_Entity_Parameter_List is record

               Node : aliased Bare_Parameter_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Parameter_List : constant Internal_Entity_Parameter_List;


      function Create_Internal_Entity_Parameter_List
        (Node : Bare_Parameter_List; Info : Internal_Entity_Info)
         return Internal_Entity_Parameter_List;


   


      function Trace_Image (R : Internal_Entity_Parameter_List) return String;


         

      

      type Internal_Entity_Parameters is record

               Node : aliased Bare_Parameters;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Parameters : constant Internal_Entity_Parameters;


      function Create_Internal_Entity_Parameters
        (Node : Bare_Parameters; Info : Internal_Entity_Info)
         return Internal_Entity_Parameters;


   


      function Trace_Image (R : Internal_Entity_Parameters) return String;


         

      

      type Internal_Entity_Paren_Expression is record

               Node : aliased Bare_Paren_Expression;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Paren_Expression : constant Internal_Entity_Paren_Expression;


      function Create_Internal_Entity_Paren_Expression
        (Node : Bare_Paren_Expression; Info : Internal_Entity_Info)
         return Internal_Entity_Paren_Expression;


   


      function Trace_Image (R : Internal_Entity_Paren_Expression) return String;


         

      

      type Internal_Entity_Positional_Enumeration_Def is record

               Node : aliased Bare_Positional_Enumeration_Def;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Positional_Enumeration_Def : constant Internal_Entity_Positional_Enumeration_Def;


      function Create_Internal_Entity_Positional_Enumeration_Def
        (Node : Bare_Positional_Enumeration_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Positional_Enumeration_Def;


   


      function Trace_Image (R : Internal_Entity_Positional_Enumeration_Def) return String;


         

      

      type Internal_Entity_Quantified_Expression is record

               Node : aliased Bare_Quantified_Expression;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Quantified_Expression : constant Internal_Entity_Quantified_Expression;


      function Create_Internal_Entity_Quantified_Expression
        (Node : Bare_Quantified_Expression; Info : Internal_Entity_Info)
         return Internal_Entity_Quantified_Expression;


   


      function Trace_Image (R : Internal_Entity_Quantified_Expression) return String;


         

      

      type Internal_Entity_Quantifier is record

               Node : aliased Bare_Quantifier;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Quantifier : constant Internal_Entity_Quantifier;


      function Create_Internal_Entity_Quantifier
        (Node : Bare_Quantifier; Info : Internal_Entity_Info)
         return Internal_Entity_Quantifier;


   


      function Trace_Image (R : Internal_Entity_Quantifier) return String;


         

      

      type Internal_Entity_Quantifier_All is record

               Node : aliased Bare_Quantifier_All;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Quantifier_All : constant Internal_Entity_Quantifier_All;


      function Create_Internal_Entity_Quantifier_All
        (Node : Bare_Quantifier_All; Info : Internal_Entity_Info)
         return Internal_Entity_Quantifier_All;


   


      function Trace_Image (R : Internal_Entity_Quantifier_All) return String;


         

      

      type Internal_Entity_Quantifier_Some is record

               Node : aliased Bare_Quantifier_Some;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Quantifier_Some : constant Internal_Entity_Quantifier_Some;


      function Create_Internal_Entity_Quantifier_Some
        (Node : Bare_Quantifier_Some; Info : Internal_Entity_Info)
         return Internal_Entity_Quantifier_Some;


   


      function Trace_Image (R : Internal_Entity_Quantifier_Some) return String;


         

      

      type Internal_Entity_Range_Type_Def is record

               Node : aliased Bare_Range_Type_Def;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Range_Type_Def : constant Internal_Entity_Range_Type_Def;


      function Create_Internal_Entity_Range_Type_Def
        (Node : Bare_Range_Type_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Range_Type_Def;


   


      function Trace_Image (R : Internal_Entity_Range_Type_Def) return String;


         

      

      type Internal_Entity_Readable is record

               Node : aliased Bare_Readable;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Readable : constant Internal_Entity_Readable;


      function Create_Internal_Entity_Readable
        (Node : Bare_Readable; Info : Internal_Entity_Info)
         return Internal_Entity_Readable;


   


      function Trace_Image (R : Internal_Entity_Readable) return String;


         

      

      type Internal_Entity_Refinement_Decl is record

               Node : aliased Bare_Refinement_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Refinement_Decl : constant Internal_Entity_Refinement_Decl;


      function Create_Internal_Entity_Refinement_Decl
        (Node : Bare_Refinement_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Refinement_Decl;


   


      function Trace_Image (R : Internal_Entity_Refinement_Decl) return String;


         

      

      type Internal_Entity_Renaming_Decl is record

               Node : aliased Bare_Renaming_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Renaming_Decl : constant Internal_Entity_Renaming_Decl;


      function Create_Internal_Entity_Renaming_Decl
        (Node : Bare_Renaming_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Renaming_Decl;


   


      function Trace_Image (R : Internal_Entity_Renaming_Decl) return String;


         

      

      type Internal_Entity_Reset is record

               Node : aliased Bare_Reset;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Reset : constant Internal_Entity_Reset;


      function Create_Internal_Entity_Reset
        (Node : Bare_Reset; Info : Internal_Entity_Info)
         return Internal_Entity_Reset;


   


      function Trace_Image (R : Internal_Entity_Reset) return String;


         

      

      type Internal_Entity_Select_Node is record

               Node : aliased Bare_Select_Node;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Select_Node : constant Internal_Entity_Select_Node;


      function Create_Internal_Entity_Select_Node
        (Node : Bare_Select_Node; Info : Internal_Entity_Info)
         return Internal_Entity_Select_Node;


   


      function Trace_Image (R : Internal_Entity_Select_Node) return String;


         

      

      type Internal_Entity_Sequence_Aggregate is record

               Node : aliased Bare_Sequence_Aggregate;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Sequence_Aggregate : constant Internal_Entity_Sequence_Aggregate;


      function Create_Internal_Entity_Sequence_Aggregate
        (Node : Bare_Sequence_Aggregate; Info : Internal_Entity_Info)
         return Internal_Entity_Sequence_Aggregate;


   


      function Trace_Image (R : Internal_Entity_Sequence_Aggregate) return String;


         

      

      type Internal_Entity_Sequence_Type_Def is record

               Node : aliased Bare_Sequence_Type_Def;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Sequence_Type_Def : constant Internal_Entity_Sequence_Type_Def;


      function Create_Internal_Entity_Sequence_Type_Def
        (Node : Bare_Sequence_Type_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Sequence_Type_Def;


   


      function Trace_Image (R : Internal_Entity_Sequence_Type_Def) return String;


         

      

      type Internal_Entity_Session_Aspects is record

               Node : aliased Bare_Session_Aspects;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Session_Aspects : constant Internal_Entity_Session_Aspects;


      function Create_Internal_Entity_Session_Aspects
        (Node : Bare_Session_Aspects; Info : Internal_Entity_Info)
         return Internal_Entity_Session_Aspects;


   


      function Trace_Image (R : Internal_Entity_Session_Aspects) return String;


         

      

      type Internal_Entity_Session_Decl is record

               Node : aliased Bare_Session_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Session_Decl : constant Internal_Entity_Session_Decl;


      function Create_Internal_Entity_Session_Decl
        (Node : Bare_Session_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Session_Decl;


   


      function Trace_Image (R : Internal_Entity_Session_Decl) return String;


         

      

      type Internal_Entity_Specification is record

               Node : aliased Bare_Specification;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Specification : constant Internal_Entity_Specification;


      function Create_Internal_Entity_Specification
        (Node : Bare_Specification; Info : Internal_Entity_Info)
         return Internal_Entity_Specification;


   


      function Trace_Image (R : Internal_Entity_Specification) return String;


         

      

      type Internal_Entity_State is record

               Node : aliased Bare_State;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_State : constant Internal_Entity_State;


      function Create_Internal_Entity_State
        (Node : Bare_State; Info : Internal_Entity_Info)
         return Internal_Entity_State;


   


      function Trace_Image (R : Internal_Entity_State) return String;


         

      

      type Internal_Entity_State_Body is record

               Node : aliased Bare_State_Body;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_State_Body : constant Internal_Entity_State_Body;


      function Create_Internal_Entity_State_Body
        (Node : Bare_State_Body; Info : Internal_Entity_Info)
         return Internal_Entity_State_Body;


   


      function Trace_Image (R : Internal_Entity_State_Body) return String;


         

      

      type Internal_Entity_State_List is record

               Node : aliased Bare_State_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_State_List : constant Internal_Entity_State_List;


      function Create_Internal_Entity_State_List
        (Node : Bare_State_List; Info : Internal_Entity_Info)
         return Internal_Entity_State_List;


   


      function Trace_Image (R : Internal_Entity_State_List) return String;


         

      

      type Internal_Entity_Statement_List is record

               Node : aliased Bare_Statement_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Statement_List : constant Internal_Entity_Statement_List;


      function Create_Internal_Entity_Statement_List
        (Node : Bare_Statement_List; Info : Internal_Entity_Info)
         return Internal_Entity_Statement_List;


   


      function Trace_Image (R : Internal_Entity_Statement_List) return String;


         

      

      type Internal_Entity_String_Literal is record

               Node : aliased Bare_String_Literal;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_String_Literal : constant Internal_Entity_String_Literal;


      function Create_Internal_Entity_String_Literal
        (Node : Bare_String_Literal; Info : Internal_Entity_Info)
         return Internal_Entity_String_Literal;


   


      function Trace_Image (R : Internal_Entity_String_Literal) return String;


         

      

      type Internal_Entity_Term_Assoc is record

               Node : aliased Bare_Term_Assoc;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Term_Assoc : constant Internal_Entity_Term_Assoc;


      function Create_Internal_Entity_Term_Assoc
        (Node : Bare_Term_Assoc; Info : Internal_Entity_Info)
         return Internal_Entity_Term_Assoc;


   


      function Trace_Image (R : Internal_Entity_Term_Assoc) return String;


         

      

      type Internal_Entity_Term_Assoc_List is record

               Node : aliased Bare_Term_Assoc_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Term_Assoc_List : constant Internal_Entity_Term_Assoc_List;


      function Create_Internal_Entity_Term_Assoc_List
        (Node : Bare_Term_Assoc_List; Info : Internal_Entity_Info)
         return Internal_Entity_Term_Assoc_List;


   


      function Trace_Image (R : Internal_Entity_Term_Assoc_List) return String;


         

      

      type Internal_Entity_Then_Node is record

               Node : aliased Bare_Then_Node;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Then_Node : constant Internal_Entity_Then_Node;


      function Create_Internal_Entity_Then_Node
        (Node : Bare_Then_Node; Info : Internal_Entity_Info)
         return Internal_Entity_Then_Node;


   


      function Trace_Image (R : Internal_Entity_Then_Node) return String;


         

      

      type Internal_Entity_Then_Node_List is record

               Node : aliased Bare_Then_Node_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Then_Node_List : constant Internal_Entity_Then_Node_List;


      function Create_Internal_Entity_Then_Node_List
        (Node : Bare_Then_Node_List; Info : Internal_Entity_Info)
         return Internal_Entity_Then_Node_List;


   


      function Trace_Image (R : Internal_Entity_Then_Node_List) return String;


         

      

      type Internal_Entity_Type_Argument is record

               Node : aliased Bare_Type_Argument;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Type_Argument : constant Internal_Entity_Type_Argument;


      function Create_Internal_Entity_Type_Argument
        (Node : Bare_Type_Argument; Info : Internal_Entity_Info)
         return Internal_Entity_Type_Argument;


   


      function Trace_Image (R : Internal_Entity_Type_Argument) return String;


         

      

      type Internal_Entity_Type_Argument_List is record

               Node : aliased Bare_Type_Argument_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Type_Argument_List : constant Internal_Entity_Type_Argument_List;


      function Create_Internal_Entity_Type_Argument_List
        (Node : Bare_Type_Argument_List; Info : Internal_Entity_Info)
         return Internal_Entity_Type_Argument_List;


   


      function Trace_Image (R : Internal_Entity_Type_Argument_List) return String;


         

      

      type Internal_Entity_Type_Decl is record

               Node : aliased Bare_Type_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Type_Decl : constant Internal_Entity_Type_Decl;


      function Create_Internal_Entity_Type_Decl
        (Node : Bare_Type_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Type_Decl;


   


      function Trace_Image (R : Internal_Entity_Type_Decl) return String;


         

      

      type Internal_Entity_Type_Derivation_Def is record

               Node : aliased Bare_Type_Derivation_Def;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Type_Derivation_Def : constant Internal_Entity_Type_Derivation_Def;


      function Create_Internal_Entity_Type_Derivation_Def
        (Node : Bare_Type_Derivation_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Type_Derivation_Def;


   


      function Trace_Image (R : Internal_Entity_Type_Derivation_Def) return String;


         

      

      type Internal_Entity_UnqualifiedID is record

               Node : aliased Bare_UnqualifiedID;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_UnqualifiedID : constant Internal_Entity_UnqualifiedID;


      function Create_Internal_Entity_UnqualifiedID
        (Node : Bare_UnqualifiedID; Info : Internal_Entity_Info)
         return Internal_Entity_UnqualifiedID;


   


      function Trace_Image (R : Internal_Entity_UnqualifiedID) return String;


         

      

      type Internal_Entity_UnqualifiedID_List is record

               Node : aliased Bare_UnqualifiedID_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_UnqualifiedID_List : constant Internal_Entity_UnqualifiedID_List;


      function Create_Internal_Entity_UnqualifiedID_List
        (Node : Bare_UnqualifiedID_List; Info : Internal_Entity_Info)
         return Internal_Entity_UnqualifiedID_List;


   


      function Trace_Image (R : Internal_Entity_UnqualifiedID_List) return String;


         

      

      type Internal_Entity_Variable is record

               Node : aliased Bare_Variable;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Variable : constant Internal_Entity_Variable;


      function Create_Internal_Entity_Variable
        (Node : Bare_Variable; Info : Internal_Entity_Info)
         return Internal_Entity_Variable;


   


      function Trace_Image (R : Internal_Entity_Variable) return String;


         

      

      type Internal_Entity_Variable_Decl is record

               Node : aliased Bare_Variable_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Variable_Decl : constant Internal_Entity_Variable_Decl;


      function Create_Internal_Entity_Variable_Decl
        (Node : Bare_Variable_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Variable_Decl;


   


      function Trace_Image (R : Internal_Entity_Variable_Decl) return String;


         

      

      type Internal_Entity_Writable is record

               Node : aliased Bare_Writable;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Writable : constant Internal_Entity_Writable;


      function Create_Internal_Entity_Writable
        (Node : Bare_Writable; Info : Internal_Entity_Info)
         return Internal_Entity_Writable;


   


      function Trace_Image (R : Internal_Entity_Writable) return String;


         

      

      type Internal_Env_Assoc is record

               Key : aliased Symbol_Type;
               
               
               Val : aliased Bare_RFLX_Node;
               
               
               Dest_Env : aliased Lexical_Env;
               
               
               Metadata : aliased Internal_Metadata;
               
               
      end record
        with Convention => C;
      No_Env_Assoc : constant Internal_Env_Assoc;

      procedure Inc_Ref (R : Internal_Env_Assoc);
      procedure Dec_Ref (R : in out Internal_Env_Assoc);


      function Equivalent (L, R : Internal_Env_Assoc) return Boolean;

   


      function Trace_Image (R : Internal_Env_Assoc) return String;



   -----------------
   -- Array types --
   -----------------

   --  We implement array types as discriminated records so that binding to C
   --  can be done without copy.

         

   

   type Internal_Bare_RFLX_Node_Array is
      array (Positive range <>) of Bare_RFLX_Node;

   type Bare_RFLX_Node_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Bare_RFLX_Node_Array (1 .. N);
   end record;

   Empty_Bare_RFLX_Node_Array_Record : aliased Bare_RFLX_Node_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Bare_RFLX_Node_Array_Type : constant Bare_RFLX_Node_Array_Access :=
      Empty_Bare_RFLX_Node_Array_Record'Access;


   function Create_Bare_RFLX_Node_Array (Items_Count : Natural) return Bare_RFLX_Node_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Bare_RFLX_Node_Array
     (Items : Internal_Bare_RFLX_Node_Array) return Bare_RFLX_Node_Array_Access;
   --  Create a new array from an existing collection of elements


   function Get
     (T       : Bare_RFLX_Node_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Bare_RFLX_Node;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Bare_RFLX_Node_Array_Access) return Bare_RFLX_Node_Array_Access;

   function Length (T : Bare_RFLX_Node_Array_Access) return Natural;

   procedure Inc_Ref (T : Bare_RFLX_Node_Array_Access);
   procedure Dec_Ref (T : in out Bare_RFLX_Node_Array_Access);

   function Equivalent (L, R : Bare_RFLX_Node_Array_Access) return Boolean;


      function Trace_Image (A : Bare_RFLX_Node_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Bare_RFLX_Node_Array_Record, Bare_RFLX_Node_Array_Access);

         

   


   type Character_Type_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Text_Type (1 .. N);
   end record;

   Empty_Text_Type_Record : aliased Character_Type_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Character_Type_Array_Type : constant Character_Type_Array_Access :=
      Empty_Text_Type_Record'Access;


   function Create_Character_Type_Array (Items_Count : Natural) return Character_Type_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Character_Type_Array
     (Items : Text_Type) return Character_Type_Array_Access;
   --  Create a new array from an existing collection of elements

      function Create_Character_Type_Array
        (Items : Unbounded_Text_Type) return Character_Type_Array_Access;
      --  Create a new character array from an unbounded string. This is not
      --  just for convenience: this function avoids using the secondary stack
      --  to load the string itself, avoiding stack overflows for big strings.

   function Get
     (T       : Character_Type_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Character_Type;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Character_Type_Array_Access) return Character_Type_Array_Access;

   function Length (T : Character_Type_Array_Access) return Natural;

   procedure Inc_Ref (T : Character_Type_Array_Access);
   procedure Dec_Ref (T : in out Character_Type_Array_Access);

   function Equivalent (L, R : Character_Type_Array_Access) return Boolean;


      function Trace_Image (A : Character_Type_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Character_Type_Array_Record, Character_Type_Array_Access);

         

   

   type Internal_Internal_Entity_Array is
      array (Positive range <>) of Internal_Entity;

   type Internal_Entity_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Internal_Entity_Array (1 .. N);
   end record;

   Empty_RFLX_Node_Array_Record : aliased Internal_Entity_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Internal_Entity_Array_Type : constant Internal_Entity_Array_Access :=
      Empty_RFLX_Node_Array_Record'Access;

   function Create_Internal_Entity_Array
     (Items : AST_Envs.Entity_Array) return Internal_Entity_Array_Access;

   function Create_Internal_Entity_Array (Items_Count : Natural) return Internal_Entity_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Internal_Entity_Array
     (Items : Internal_Internal_Entity_Array) return Internal_Entity_Array_Access;
   --  Create a new array from an existing collection of elements


   function Get
     (T       : Internal_Entity_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Entity;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Internal_Entity_Array_Access) return Internal_Entity_Array_Access;

   function Length (T : Internal_Entity_Array_Access) return Natural;

   procedure Inc_Ref (T : Internal_Entity_Array_Access);
   procedure Dec_Ref (T : in out Internal_Entity_Array_Access);

   function Equivalent (L, R : Internal_Entity_Array_Access) return Boolean;


      function Trace_Image (A : Internal_Entity_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Internal_Entity_Array_Record, Internal_Entity_Array_Access);

         

   

   type Internal_Lexical_Env_Array is
      array (Positive range <>) of Lexical_Env;

   type Lexical_Env_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Lexical_Env_Array (1 .. N);
   end record;

   Empty_Lexical_Env_Array_Record : aliased Lexical_Env_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Lexical_Env_Array_Type : constant Lexical_Env_Array_Access :=
      Empty_Lexical_Env_Array_Record'Access;


   function Create_Lexical_Env_Array (Items_Count : Natural) return Lexical_Env_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Lexical_Env_Array
     (Items : Internal_Lexical_Env_Array) return Lexical_Env_Array_Access;
   --  Create a new array from an existing collection of elements


   function Get
     (T       : Lexical_Env_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Lexical_Env;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Lexical_Env_Array_Access) return Lexical_Env_Array_Access;

   function Length (T : Lexical_Env_Array_Access) return Natural;

   procedure Inc_Ref (T : Lexical_Env_Array_Access);
   procedure Dec_Ref (T : in out Lexical_Env_Array_Access);

   function Equivalent (L, R : Lexical_Env_Array_Access) return Boolean;


      function Trace_Image (A : Lexical_Env_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Lexical_Env_Array_Record, Lexical_Env_Array_Access);

         

   

   type Internal_Symbol_Type_Array is
      array (Positive range <>) of Symbol_Type;

   type Symbol_Type_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Symbol_Type_Array (1 .. N);
   end record;

   Empty_Unbounded_Text_Type_Array_Record : aliased Symbol_Type_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Symbol_Type_Array_Type : constant Symbol_Type_Array_Access :=
      Empty_Unbounded_Text_Type_Array_Record'Access;


   function Create_Symbol_Type_Array (Items_Count : Natural) return Symbol_Type_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Symbol_Type_Array
     (Items : Internal_Symbol_Type_Array) return Symbol_Type_Array_Access;
   --  Create a new array from an existing collection of elements


   function Get
     (T       : Symbol_Type_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Symbol_Type;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Symbol_Type_Array_Access) return Symbol_Type_Array_Access;

   function Length (T : Symbol_Type_Array_Access) return Natural;

   procedure Inc_Ref (T : Symbol_Type_Array_Access);
   procedure Dec_Ref (T : in out Symbol_Type_Array_Access);

   function Equivalent (L, R : Symbol_Type_Array_Access) return Boolean;


      function Trace_Image (A : Symbol_Type_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Symbol_Type_Array_Record, Symbol_Type_Array_Access);


   --------------------
   -- Iterator types --
   --------------------

         

   

   type Internal_Bare_RFLX_Node_Iterator is record
      Ref_Count : Integer;
      --  Reference count. The iterator is freed when this drops to zero.
      --  Negative values are interpreted as "always living singleton".

      Safety_Net : Iterator_Safety_Net;
      --  Safety net for the iterator. Used to check that values produced by
      --  the iterator are still valid. Unlike for other types, we put the
      --  safety net in the internal type so that it can be used in all other
      --  APIs (Python, ...).
      --
      --  While other types (except nodes) are "deeply" converted to native
      --  APIs (for instance: internal arrays are turned into native Python
      --  lists, likewise for array items, etc.), iterators are lazy, so the
      --  deep conversion is not possible.

      Elements : Bare_RFLX_Node_Array_Access;
      Index    : Positive;
   end record;

   Empty_Internal_Bare_RFLX_Node_Iterator : aliased Internal_Bare_RFLX_Node_Iterator :=
     (Ref_Count  => -1,
      Safety_Net => No_Iterator_Safety_Net,
      Elements   => No_Bare_RFLX_Node_Array_Type,
      Index      => 1);
   No_Bare_RFLX_Node_Iterator_Type : constant Bare_RFLX_Node_Iterator_Access :=
      Empty_Internal_Bare_RFLX_Node_Iterator'Access;

   function Next
     (T       : Bare_RFLX_Node_Iterator_Access;
      Element : out Bare_RFLX_Node) return Boolean;

   procedure Inc_Ref (T : Bare_RFLX_Node_Iterator_Access);
   procedure Dec_Ref (T : in out Bare_RFLX_Node_Iterator_Access);

      function Trace_Image (A : Bare_RFLX_Node_Iterator_Access) return String;

   procedure Free is new Ada.Unchecked_Deallocation
     (Internal_Bare_RFLX_Node_Iterator, Bare_RFLX_Node_Iterator_Access);

         

   

   type Internal_Internal_Entity_Iterator is record
      Ref_Count : Integer;
      --  Reference count. The iterator is freed when this drops to zero.
      --  Negative values are interpreted as "always living singleton".

      Safety_Net : Iterator_Safety_Net;
      --  Safety net for the iterator. Used to check that values produced by
      --  the iterator are still valid. Unlike for other types, we put the
      --  safety net in the internal type so that it can be used in all other
      --  APIs (Python, ...).
      --
      --  While other types (except nodes) are "deeply" converted to native
      --  APIs (for instance: internal arrays are turned into native Python
      --  lists, likewise for array items, etc.), iterators are lazy, so the
      --  deep conversion is not possible.

      Elements : Internal_Entity_Array_Access;
      Index    : Positive;
   end record;

   Empty_Internal_Internal_Entity_Iterator : aliased Internal_Internal_Entity_Iterator :=
     (Ref_Count  => -1,
      Safety_Net => No_Iterator_Safety_Net,
      Elements   => No_Internal_Entity_Array_Type,
      Index      => 1);
   No_Internal_Entity_Iterator_Type : constant Internal_Entity_Iterator_Access :=
      Empty_Internal_Internal_Entity_Iterator'Access;

   function Next
     (T       : Internal_Entity_Iterator_Access;
      Element : out Internal_Entity) return Boolean;

   procedure Inc_Ref (T : Internal_Entity_Iterator_Access);
   procedure Dec_Ref (T : in out Internal_Entity_Iterator_Access);

      function Trace_Image (A : Internal_Entity_Iterator_Access) return String;

   procedure Free is new Ada.Unchecked_Deallocation
     (Internal_Internal_Entity_Iterator, Internal_Entity_Iterator_Access);


   ------------------------
   -- Named environments --
   ------------------------

   --  The goal of named environments is to provide a sound mechanism to
   --  associate nodes and environments across analysis units: nodes whose
   --  Self_Env comes from another unit ("foreign env"), environments whose
   --  parent comes from another unit (also foreign env), or that contain
   --  symbol/node mappings for nodes coming from other units ("foreign
   --  nodes").
   --
   --  This mechanism comes with the following requirements:
   --
   --  * Ensure that, after unit reparsing, all cross-unit associations are
   --    still valid. For instance, no node's Self_Env can refer to a lexical
   --    environment that has been deallocated.
   --
   --  * Ensure that regardless of the sequence of unit parsing/reparsing that
   --    led to a given set of units (considering only unit filename and source
   --    buffer), the node/env graph (i.e. the result of PLE) is always the
   --    same, i.e. make incremental PLE idempotent.
   --
   --  Note that even though the end goal for named envs is to replace the
   --  previous mechanism (proved to be unsound, as violating the second
   --  requirement), both still coexist during the transition period.
   --
   --  Here is how this mechanism works:
   --
   --  1. Environments can be assigned zero, one or several names (i.e. one or
   --     several symbols). Name(s) assignment happens at environment
   --     construction.
   --
   --  2. As a consequence, multiple environments can be associated to a given
   --     env name. Using a total and deterministic ordering predicate, only
   --     one of them is said to have "precedence": looking up an environment
   --     using that name will return this unique environment.
   --
   --  3. For a given env name, we keep track of all uses of the environment
   --     that is looked up by its name: environment parent link, symbol/node
   --     mapping addition, node's Self_Env assignment. This info is
   --     tracked using the Named_Env_Descriptor record type below, often
   --     abbreviated NED. Note that this tracking happens even when there is
   --     no environment associated to the env name, as we need to do such
   --     updates when an environment gets associated to that env name.
   --
   --  4. Unit reparsing can destroy existing environments and/or create new
   --     ones. This means that, depending on their "ranking" using the
   --     ordering predicate, environments can earn or lose precedence for a
   --     given name.
   --
   --  5. When the precedence changes for a given name, we use the info
   --     collected as per 3. to perform relocation: relevant environment
   --     parent links are updated, symbol/node mappings are removed from the
   --     env that lost precedence and added to the env that earned precedence,
   --     etc.

   --  Tables to populate lexical entries in named envs

   package NED_Assoc_Maps is new Ada.Containers.Hashed_Maps
     (Key_Type        => Symbol_Type,
      Element_Type    => Internal_Map_Node_Vectors.Vector,
      Hash            => Hash,
      Equivalent_Keys => "=",
      "="             => Internal_Map_Node_Vectors."=");
   --  Symbol/lexical env entry mappings for a given named env descriptor.
   --  Symbols are not unique in all mappings, so the lexical env entries are
   --  stored in a vector.

   procedure Add
     (Self : in out NED_Assoc_Maps.Map;
      Key  : Symbol_Type;
      Node : AST_Envs.Internal_Map_Node);
   --  Add a symbol/lexical env entry mapping in Self

   procedure Remove
     (Self : in out NED_Assoc_Maps.Map;
      Key  : Symbol_Type;
      Node : Bare_RFLX_Node);
   --  Remove a symbol/lexical env entry mapping from Self

   --  Global table for named environments

   package Sorted_Env_Maps is new Ada.Containers.Ordered_Maps
     (Key_Type     => Bare_RFLX_Node,
      Element_Type => Lexical_Env);
   --  List of lexical environments, sorted by owning node. This means that the
   --  following must be true for all cursors in such maps::
   --
   --     Key (Cur) = Element (Cur).Env.Node

   package Node_Sets is new Ada.Containers.Hashed_Sets
     (Element_Type        => Bare_RFLX_Node,
      Hash                => Hash,
      Equivalent_Elements => "=");

   type Named_Env_Descriptor is record
      Name : Symbol_Type;
      --  Name corresponding to this descriptor. Useful during debugging.

      Envs : Sorted_Env_Maps.Map;
      --  For each env name, we can have one or several environments
      --  (concurrent definitions). Just like foreign nodes in lexical
      --  environments, we keep them sorted by node to preserve determinism:
      --  given a set of loaded units, we will always have the same set of
      --  name:env associations sorted in the same order and thus always the
      --  same results at lookup time.

      Env_With_Precedence : Lexical_Env;
      --  Named environment that has precedence for this name.
      --
      --  Most of the time, if Envs is empty, this is Empty_Env and otherwise,
      --  shortcut to Envs.First_Element. However, when a change in Envs
      --  invalidates Env_With_Precedence, we reset it to Empty_Env momentarily
      --  during PLE as a way to tag the temprorary inconsistency. Later on, we
      --  recompute it and perform the needed relocations.

      Foreign_Nodes : NED_Assoc_Maps.Map;
      --  This maps symbols to lists of env entries for all the foreign nodes
      --  in Env_With_Precedence.
      --
      --  This set allows efficient relocation of env entries when
      --  Env_With_Precedence changes.

      Foreign_Envs : Sorted_Env_Maps.Map;
      --  This maps the owning node to env mapping for all lexical environments
      --  whose parent must be Env_With_Precedence. Envs are indexed by owning
      --  node for quick lookup during updates.
      --
      --  This set allows efficient env parent link updates when
      --  Env_With_Precedence changes.

      Nodes_With_Foreign_Env : Node_Sets.Set;
      --  Set of nodes whose env (Self_Env) must be Env_With_Precedence.
      --
      --  This set allows efficient Self_Env updates when Env_With_Precedence
      --  changes.

      --  Note that during the updating process of a reparsed unit
      --  (Update_After_Reparse procedure), these data structures become
      --  temporarily inconsistent: Env_With_Precedence can become Empty_Env
      --  even though Envs is not empty.  This is fine, because when it does,
      --  Update_After_Reparse keeps track of it as to be updated
      --  (Named_Envs_Needing_Update map).
   end record;
   type Named_Env_Descriptor_Access is access Named_Env_Descriptor;
   procedure Destroy is new Ada.Unchecked_Deallocation
     (Named_Env_Descriptor, Named_Env_Descriptor_Access);

   package NED_Maps is new Ada.Containers.Hashed_Maps
     (Key_Type        => Symbol_Type,
      Element_Type    => Named_Env_Descriptor_Access,
      Hash            => Hash,
      Equivalent_Keys => "=");
   --  Context-wide table that tracks for all env names the set of lexical envs
   --  that define it.

   type Exiled_Entry_In_NED is record
      Named_Env : Named_Env_Descriptor_Access;
      --  Named env descriptor in which Node is registered

      Key : Symbol_Type;
      --  Key in that Env's internal map that leads to the env descriptor that
      --  contains Node.

      Node : Bare_RFLX_Node;
      --  Exiled node
   end record;

   package Exiled_Entry_In_NED_Vectors is new
      Langkit_Support.Vectors (Exiled_Entry_In_NED);

   type Exiled_Env is record
      Named_Env : Named_Env_Descriptor_Access;
      --  Named env descriptor in which Env is registered

      Env : Lexical_Env;
      --  Exiled environment
   end record;

   package Exiled_Env_Vectors is new Langkit_Support.Vectors (Exiled_Env);

   type Named_Env_Pair is record
      Name : Symbol_Type;
      --  Name on the lexical environment

      Env  : Lexical_Env;
      --  Named lexical environment
   end record;

   package Named_Env_Vectors is new Langkit_Support.Vectors (Named_Env_Pair);

   --  High-level primitives to handle the life cycle of named environment

   function Get_Named_Env_Descriptor
     (Context : Internal_Context;
      Name    : Symbol_Type) return Named_Env_Descriptor_Access;
   --  Return the named env descriptor in Context corresponding to Name. Create
   --  it first, if needed.

   procedure Register_Named_Env
     (Context                   : Internal_Context;
      Name                      : Symbol_Type;
      Env                       : Lexical_Env;
      Named_Envs_Needing_Update : in out NED_Maps.Map);
   --  Register Name as the environment name for Env. If Env takes the
   --  precedence for this name, add Name/its named env descriptor to
   --  Named_Envs_Needing_Update.

   procedure Update_Named_Envs (Named_Envs : NED_Maps.Map);
   --  For each named environment in Named_Envs, update Env_With_Precedence and
   --  do the necessary adjustments: relocate exiled entries, etc.

   -------------------------------
   -- Tree traversal operations --
   -------------------------------

   Kind_To_Node_Children_Count : constant array (RFLX_Node_Kind_Type) of Integer :=
     (RFLX_ID => 2, 
RFLX_NullID => 0, 
RFLX_UnqualifiedID => 0, 
RFLX_Aspect => 2, 
RFLX_Attr_First => 0, 
RFLX_Attr_Has_Data => 0, 
RFLX_Attr_Head => 0, 
RFLX_Attr_Last => 0, 
RFLX_Attr_Opaque => 0, 
RFLX_Attr_Present => 0, 
RFLX_Attr_Size => 0, 
RFLX_Attr_Valid => 0, 
RFLX_Attr_Valid_Checksum => 0, 
RFLX_Attr_Stmt_Append => 0, 
RFLX_Attr_Stmt_Extend => 0, 
RFLX_Attr_Stmt_Read => 0, 
RFLX_Attr_Stmt_Write => 0, 
RFLX_Message_Aggregate_Associations => 1, 
RFLX_Null_Message_Aggregate => 0, 
RFLX_Checksum_Val => 1, 
RFLX_Checksum_Value_Range => 2, 
RFLX_Null_State_Body => 0, 
RFLX_State_Body => 6, 
RFLX_Byte_Order_Type_Highorderfirst => 0, 
RFLX_Byte_Order_Type_Loworderfirst => 0, 
RFLX_Readable => 0, 
RFLX_Writable => 0, 
RFLX_Checksum_Assoc => 2, 
RFLX_Refinement_Decl => 4, 
RFLX_Session_Decl => 6, 
RFLX_Type_Decl => 3, 
RFLX_Description => 1, 
RFLX_Element_Value_Assoc => 2, 
RFLX_Attribute => 2, 
RFLX_Bin_Op => 3, 
RFLX_Binding => 2, 
RFLX_Call => 2, 
RFLX_Comprehension => 4, 
RFLX_Context_Item => 1, 
RFLX_Conversion => 2, 
RFLX_Message_Aggregate => 2, 
RFLX_Negation => 1, 
RFLX_Numeric_Literal => 0, 
RFLX_Paren_Expression => 1, 
RFLX_Quantified_Expression => 4, 
RFLX_Select_Node => 2, 
RFLX_Concatenation => 2, 
RFLX_Sequence_Aggregate => 1, 
RFLX_String_Literal => 0, 
RFLX_Variable => 1, 
RFLX_Formal_Channel_Decl => 2, 
RFLX_Formal_Function_Decl => 3, 
RFLX_Formal_Private_Type_Decl => 1, 
RFLX_Renaming_Decl => 3, 
RFLX_Variable_Decl => 3, 
RFLX_Message_Aggregate_Association => 2, 
RFLX_Byte_Order_Aspect => 1, 
RFLX_Checksum_Aspect => 1, 
RFLX_Message_Field => 6, 
RFLX_Message_Fields => 2, 
RFLX_Null_Message_Field => 1, 
RFLX_Op_Add => 0, 
RFLX_Op_And => 0, 
RFLX_Op_Div => 0, 
RFLX_Op_Eq => 0, 
RFLX_Op_Ge => 0, 
RFLX_Op_Gt => 0, 
RFLX_Op_In => 0, 
RFLX_Op_Le => 0, 
RFLX_Op_Lt => 0, 
RFLX_Op_Mod => 0, 
RFLX_Op_Mul => 0, 
RFLX_Op_Neq => 0, 
RFLX_Op_Notin => 0, 
RFLX_Op_Or => 0, 
RFLX_Op_Pow => 0, 
RFLX_Op_Sub => 0, 
RFLX_Package_Node => 3, 
RFLX_Parameter => 2, 
RFLX_Parameters => 1, 
RFLX_Quantifier_All => 0, 
RFLX_Quantifier_Some => 0, 
RFLX_Aspect_List => -1, 
RFLX_Base_Checksum_Val_List => -1, 
RFLX_Channel_Attribute_List => -1, 
RFLX_Checksum_Assoc_List => -1, 
RFLX_Conditional_Transition_List => -1, 
RFLX_Context_Item_List => -1, 
RFLX_Declaration_List => -1, 
RFLX_Element_Value_Assoc_List => -1, 
RFLX_Expr_List => -1, 
RFLX_Formal_Decl_List => -1, 
RFLX_Local_Decl_List => -1, 
RFLX_Message_Aggregate_Association_List => -1, 
RFLX_Message_Aspect_List => -1, 
RFLX_Message_Field_List => -1, 
RFLX_Numeric_Literal_List => -1, 
RFLX_Parameter_List => -1, 
RFLX_State_List => -1, 
RFLX_Statement_List => -1, 
RFLX_Term_Assoc_List => -1, 
RFLX_Then_Node_List => -1, 
RFLX_Type_Argument_List => -1, 
RFLX_UnqualifiedID_List => -1, 
RFLX_Session_Aspects => 2, 
RFLX_Specification => 2, 
RFLX_State => 3, 
RFLX_Assignment => 2, 
RFLX_Attribute_Statement => 3, 
RFLX_Reset => 2, 
RFLX_Term_Assoc => 2, 
RFLX_Then_Node => 3, 
RFLX_Transition => 2, 
RFLX_Conditional_Transition => 3, 
RFLX_Type_Argument => 2, 
RFLX_Message_Type_Def => 2, 
RFLX_Null_Message_Type_Def => 0, 
RFLX_Named_Enumeration_Def => 1, 
RFLX_Positional_Enumeration_Def => 1, 
RFLX_Enumeration_Type_Def => 2, 
RFLX_Modular_Type_Def => 1, 
RFLX_Range_Type_Def => 3, 
RFLX_Sequence_Type_Def => 1, 
RFLX_Type_Derivation_Def => 1);
   --  For each AST node kind, this array gives the number of AST node children
   --  it has. For AST node lists, this is -1 as this number varies from one
   --  list instance to another.

   function First_Child_Index (Node : Bare_RFLX_Node) return Natural;
   --  Return the index of the first child Node has

   function Last_Child_Index (Node : Bare_RFLX_Node) return Natural;
   --  Return the index of the last child Node has, or 0 if there is no child

   function Children_Count (Node : Bare_RFLX_Node) return Natural;
   --  Return the number of children that Node has

   procedure Get_Child
     (Node            : Bare_RFLX_Node;
      Index           : Positive;
      Index_In_Bounds : out Boolean;
      Result          : out Bare_RFLX_Node);
   --  Return the Index'th child of node, storing it into Result.
   --
   --  Child indexing is 1-based. Store in Index_In_Bounds whether Node had
   --  such a child: if not (i.e. Index is out-of-bounds), the content
   --  of Result is undefined.

   function Child
     (Node  : Bare_RFLX_Node;
      Index : Positive) return Bare_RFLX_Node;
   --  Return the Index'th child of Node, or null if Node has no such child

   function Children
     (Node : Bare_RFLX_Node) return Internal_Bare_RFLX_Node_Array;
   --  Return an array containing all the children of Node.
   --  This is an alternative to the Child/Children_Count pair, useful if you
   --  want the convenience of Ada arrays, and you don't care about the small
   --  performance hit of creating an array.

   function Parents
     (Node      : Bare_RFLX_Node;
      With_Self : Boolean := True)
      return Bare_RFLX_Node_Array_Access;
   --  Return an array that contains the lexical parents, this node included
   --  iff ``with_self`` is True. Nearer parents are first in the list.

   function Parent (Node : Bare_RFLX_Node) return Bare_RFLX_Node;

   function Fetch_Sibling
     (Node   : Bare_RFLX_Node;
      E_Info : Internal_Entity_Info;
      Offset : Integer) return Internal_Entity;
   --  Assuming Node is the Nth child of its parent, return the (N + Offset)'th
   --  child of the same parent, or No_Entity if there is no such sibling.

   function Traverse
     (Node  : Bare_RFLX_Node;
      Visit : access function (Node : Bare_RFLX_Node) return Visit_Status)
      return Visit_Status;
   --  Given the parent node for a subtree, traverse all syntactic nodes of
   --  this tree, calling the given function on each node in prefix order (i.e.
   --  top-down). The order of traversing subtrees follows the order of
   --  declaration of the corresponding attributes in the grammar. The
   --  traversal is controlled as follows by the result returned by Visit:
   --
   --     Into   The traversal continues normally with the syntactic
   --            children of the node just processed.
   --
   --     Over   The children of the node just processed are skipped and
   --            excluded from the traversal, but otherwise processing
   --            continues elsewhere in the tree.
   --
   --     Stop   The entire traversal is immediately abandoned, and the
   --            original call to Traverse returns Stop.

   procedure Traverse
     (Node  : Bare_RFLX_Node;
      Visit : access function (Node : Bare_RFLX_Node)
                               return Visit_Status);
   --  This is the same as Traverse function except that no result is returned
   --  i.e. the Traverse function is called and the result is simply discarded.

   generic
      type Data_Type is private;
      Reset_After_Traversal : Boolean := False;
   function Traverse_With_Data
     (Node  : Bare_RFLX_Node;
      Visit : access function (Node : Bare_RFLX_Node;
                               Data : in out Data_Type)
                               return Visit_Status;
      Data  : in out Data_Type)
      return Visit_Status;
   --  This is the same as the first Traverse function except it accepts an
   --  argument that is passed to all Visit calls.
   --
   --  If Reset_After_Traversal is True, the Data formal is left unchanged when
   --  Traverse_With_Data returns no matter what Visit does. Visit can change
   --  it otherwise.

   ----------------------------------------
   -- Source location-related operations --
   ----------------------------------------

   function Sloc_Range
     (Node : Bare_RFLX_Node) return Source_Location_Range;
   --  Return the source location range corresponding to the set of tokens from
   --  which Node was parsed.

   function Compare
     (Node : Bare_RFLX_Node;
      Sloc : Source_Location) return Relative_Position;
   --  Compare Sloc to the sloc range of Node

   function Lookup
     (Node : Bare_RFLX_Node;
      Sloc : Source_Location) return Bare_RFLX_Node;
   --  Look for the bottom-most AST node whose sloc range contains Sloc. Return
   --  it, or null if no such node was found.

   function Compare
     (Left, Right : Bare_RFLX_Node;
      Relation    : Comparison_Relation) return Boolean;
   --  If Left and Right don't belong to the same analysis units or if one of
   --  them is null, raise a Property_Error. Otherwise, return the comparison
   --  of their starting source location according to Relation.

   -------------------
   -- Debug helpers --
   -------------------

   procedure Print
     (Node        : Bare_RFLX_Node;
      Show_Slocs  : Boolean;
      Line_Prefix : String := "");
   --  Debug helper: print to standard output Node and all its children.
   --  Line_Prefix is prepended to each output line.

   procedure PP_Trivia
     (Node        : Bare_RFLX_Node;
      Line_Prefix : String := "");
   --  Debug helper: print to standard output Node and all its children along
   --  with the trivia associated to them. Line_Prefix is prepended to each
   --  output line.

   procedure Assign_Names_To_Logic_Vars (Node : Bare_RFLX_Node);
   --  Debug helper: Assign names to every logical variable in the root node,
   --  so that we can trace logical variables.

   -------------------------------
   -- Root AST node (internals) --
   -------------------------------

   type Root_Node_Record (Kind : RFLX_Node_Kind_Type) is record
      Parent : Bare_RFLX_Node;
      --  Reference to the parent node, or null if this is the root one

      Unit : Internal_Unit;
      --  Reference to the analysis unit that owns this node

      Token_Start_Index : Token_Index;
      Token_End_Index   : Token_Index;
      --  Reference to the start and end token that constitutes this node. If
      --  this node is a ghost, Token_Start_Index is the token that this AST
      --  node relates to and Token_End_Index is No_Token_Index. Otherwise,
      --  both tokens are inclusive, i.e. they both belong to this node.

      Self_Env : Lexical_Env;
      --  Hold the environment this node defines, or the parent environment
      --  otherwise.

      Last_Attempted_Child : Integer;
      --  0-based index for the last child we tried to parse for this node. -1
      --  if parsing for all children was successful.

      

      
         



         


            case Kind is
                  when RFLX_RFLX_Node_Base_List =>
                     
         

            Count : Natural;
            Nodes : Alloc_AST_List_Array.Element_Array_Access;


         


            case Kind is
                  when RFLX_Parameter_List_Range =>
                     
         



         



            null;
      
                  when RFLX_Message_Aggregate_Association_List_Range =>
                     
         



         



            null;
      
                  when RFLX_Numeric_Literal_List_Range =>
                     
         



         



            null;
      
                  when RFLX_Local_Decl_List_Range =>
                     
         



         



            null;
      
                  when RFLX_Statement_List_Range =>
                     
         



         



            null;
      
                  when RFLX_Conditional_Transition_List_Range =>
                     
         



         



            null;
      
                  when RFLX_Formal_Decl_List_Range =>
                     
         



         



            null;
      
                  when RFLX_State_List_Range =>
                     
         



         



            null;
      
                  when RFLX_Declaration_List_Range =>
                     
         



         



            null;
      
                  when RFLX_UnqualifiedID_List_Range =>
                     
         



         



            null;
      
                  when RFLX_Element_Value_Assoc_List_Range =>
                     
         



         



            null;
      
                  when RFLX_Aspect_List_Range =>
                     
         



         



            null;
      
                  when RFLX_Type_Argument_List_Range =>
                     
         



         



            null;
      
                  when RFLX_Then_Node_List_Range =>
                     
         



         



            null;
      
                  when RFLX_Message_Field_List_Range =>
                     
         



         



            null;
      
                  when RFLX_Base_Checksum_Val_List_Range =>
                     
         



         



            null;
      
                  when RFLX_Checksum_Assoc_List_Range =>
                     
         



         



            null;
      
                  when RFLX_Message_Aspect_List_Range =>
                     
         



         



            null;
      
                  when RFLX_Context_Item_List_Range =>
                     
         



         



            null;
      
                  when RFLX_Channel_Attribute_List_Range =>
                     
         



         



            null;
      
                  when RFLX_Expr_List_Range =>
                     
         



         



            null;
      
                  when RFLX_Term_Assoc_List_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when RFLX_AbstractID =>
                     
         



         


            case Kind is
                  when RFLX_NullID_Range =>
                     
         



         



            null;
      
                  when RFLX_UnqualifiedID_Range =>
                     
         



         



            null;
      
                  when RFLX_ID_Range =>
                     
         


            ID_F_Package : aliased Bare_UnqualifiedID :=
               No_Bare_RFLX_Node;
            ID_F_Name : aliased Bare_UnqualifiedID :=
               No_Bare_RFLX_Node;

         



      
               when others => null;
            end case;

      
                  when RFLX_Parameter_Range =>
                     
         


            Parameter_F_Identifier : aliased Bare_UnqualifiedID :=
               No_Bare_RFLX_Node;
            Parameter_F_Type_Identifier : aliased Bare_ID :=
               No_Bare_RFLX_Node;

         



      
                  when RFLX_Parameters_Range =>
                     
         


            Parameters_F_Parameters : aliased Bare_Parameter_List :=
               No_Bare_RFLX_Node;

         



      
                  when RFLX_Declaration =>
                     
         



         


            case Kind is
                  when RFLX_Type_Decl_Range =>
                     
         


            Type_Decl_F_Identifier : aliased Bare_UnqualifiedID :=
               No_Bare_RFLX_Node;
            Type_Decl_F_Parameters : aliased Bare_Parameters :=
               No_Bare_RFLX_Node;
            Type_Decl_F_Definition : aliased Bare_Type_Def :=
               No_Bare_RFLX_Node;

         



      
                  when RFLX_Refinement_Decl_Range =>
                     
         


            Refinement_Decl_F_Pdu : aliased Bare_ID :=
               No_Bare_RFLX_Node;
            Refinement_Decl_F_Field : aliased Bare_UnqualifiedID :=
               No_Bare_RFLX_Node;
            Refinement_Decl_F_Sdu : aliased Bare_ID :=
               No_Bare_RFLX_Node;
            Refinement_Decl_F_Condition : aliased Bare_Expr :=
               No_Bare_RFLX_Node;

         



      
                  when RFLX_Session_Decl_Range =>
                     
         


            Session_Decl_F_Parameters : aliased Bare_Formal_Decl_List :=
               No_Bare_RFLX_Node;
            Session_Decl_F_Identifier : aliased Bare_UnqualifiedID :=
               No_Bare_RFLX_Node;
            Session_Decl_F_Aspects : aliased Bare_Session_Aspects :=
               No_Bare_RFLX_Node;
            Session_Decl_F_Declarations : aliased Bare_Local_Decl_List :=
               No_Bare_RFLX_Node;
            Session_Decl_F_States : aliased Bare_State_List :=
               No_Bare_RFLX_Node;
            Session_Decl_F_End_Identifier : aliased Bare_UnqualifiedID :=
               No_Bare_RFLX_Node;

         



      
               when others => null;
            end case;

      
                  when RFLX_Type_Def =>
                     
         



         


            case Kind is
                  when RFLX_Integer_Type_Def =>
                     
         



         


            case Kind is
                  when RFLX_Range_Type_Def_Range =>
                     
         


            Range_Type_Def_F_First : aliased Bare_Expr :=
               No_Bare_RFLX_Node;
            Range_Type_Def_F_Last : aliased Bare_Expr :=
               No_Bare_RFLX_Node;
            Range_Type_Def_F_Size : aliased Bare_Aspect :=
               No_Bare_RFLX_Node;

         



      
                  when RFLX_Modular_Type_Def_Range =>
                     
         


            Modular_Type_Def_F_Mod : aliased Bare_Expr :=
               No_Bare_RFLX_Node;

         



      
               when others => null;
            end case;

      
                  when RFLX_Abstract_Message_Type_Def =>
                     
         



         


            case Kind is
                  when RFLX_Null_Message_Type_Def_Range =>
                     
         



         



            null;
      
                  when RFLX_Message_Type_Def_Range =>
                     
         


            Message_Type_Def_F_Message_Fields : aliased Bare_Message_Fields :=
               No_Bare_RFLX_Node;
            Message_Type_Def_F_Aspects : aliased Bare_Message_Aspect_List :=
               No_Bare_RFLX_Node;

         



      
               when others => null;
            end case;

      
                  when RFLX_Type_Derivation_Def_Range =>
                     
         


            Type_Derivation_Def_F_Base : aliased Bare_ID :=
               No_Bare_RFLX_Node;

         



      
                  when RFLX_Sequence_Type_Def_Range =>
                     
         


            Sequence_Type_Def_F_Element_Type : aliased Bare_ID :=
               No_Bare_RFLX_Node;

         



      
                  when RFLX_Enumeration_Def =>
                     
         



         


            case Kind is
                  when RFLX_Positional_Enumeration_Def_Range =>
                     
         


            Positional_Enumeration_Def_F_Elements : aliased Bare_UnqualifiedID_List :=
               No_Bare_RFLX_Node;

         



      
                  when RFLX_Named_Enumeration_Def_Range =>
                     
         


            Named_Enumeration_Def_F_Elements : aliased Bare_Element_Value_Assoc_List :=
               No_Bare_RFLX_Node;

         



      
               when others => null;
            end case;

      
                  when RFLX_Enumeration_Type_Def_Range =>
                     
         


            Enumeration_Type_Def_F_Elements : aliased Bare_Enumeration_Def :=
               No_Bare_RFLX_Node;
            Enumeration_Type_Def_F_Aspects : aliased Bare_Aspect_List :=
               No_Bare_RFLX_Node;

         



      
               when others => null;
            end case;

      
                  when RFLX_Expr =>
                     
         



         


            case Kind is
                  when RFLX_Negation_Range =>
                     
         


            Negation_F_Data : aliased Bare_Expr :=
               No_Bare_RFLX_Node;

         



      
                  when RFLX_Bin_Op_Range =>
                     
         


            Bin_Op_F_Left : aliased Bare_Expr :=
               No_Bare_RFLX_Node;
            Bin_Op_F_Op : aliased Bare_Op :=
               No_Bare_RFLX_Node;
            Bin_Op_F_Right : aliased Bare_Expr :=
               No_Bare_RFLX_Node;

         



      
                  when RFLX_Paren_Expression_Range =>
                     
         


            Paren_Expression_F_Data : aliased Bare_Expr :=
               No_Bare_RFLX_Node;

         



      
                  when RFLX_Message_Aggregate_Range =>
                     
         


            Message_Aggregate_F_Identifier : aliased Bare_ID :=
               No_Bare_RFLX_Node;
            Message_Aggregate_F_Values : aliased Bare_Base_Aggregate :=
               No_Bare_RFLX_Node;

         



      
                  when RFLX_Sequence_Literal =>
                     
         



         


            case Kind is
                  when RFLX_String_Literal_Range =>
                     
         



         



            null;
      
                  when RFLX_Sequence_Aggregate_Range =>
                     
         


            Sequence_Aggregate_F_Values : aliased Bare_Numeric_Literal_List :=
               No_Bare_RFLX_Node;

         



      
                  when RFLX_Concatenation_Range =>
                     
         


            Concatenation_F_Left : aliased Bare_Sequence_Literal :=
               No_Bare_RFLX_Node;
            Concatenation_F_Right : aliased Bare_Sequence_Literal :=
               No_Bare_RFLX_Node;

         



      
               when others => null;
            end case;

      
                  when RFLX_Numeric_Literal_Range =>
                     
         



         



            null;
      
                  when RFLX_Variable_Range =>
                     
         


            Variable_F_Identifier : aliased Bare_ID :=
               No_Bare_RFLX_Node;

         



      
                  when RFLX_Attribute_Range =>
                     
         


            Attribute_F_Expression : aliased Bare_Expr :=
               No_Bare_RFLX_Node;
            Attribute_F_Kind : aliased Bare_Attr :=
               No_Bare_RFLX_Node;

         



      
                  when RFLX_Context_Item_Range =>
                     
         


            Context_Item_F_Item : aliased Bare_UnqualifiedID :=
               No_Bare_RFLX_Node;

         



      
                  when RFLX_Quantified_Expression_Range =>
                     
         


            Quantified_Expression_F_Operation : aliased Bare_Quantifier :=
               No_Bare_RFLX_Node;
            Quantified_Expression_F_Parameter_Identifier : aliased Bare_UnqualifiedID :=
               No_Bare_RFLX_Node;
            Quantified_Expression_F_Iterable : aliased Bare_Expr :=
               No_Bare_RFLX_Node;
            Quantified_Expression_F_Predicate : aliased Bare_Expr :=
               No_Bare_RFLX_Node;

         



      
                  when RFLX_Comprehension_Range =>
                     
         


            Comprehension_F_Iterator : aliased Bare_UnqualifiedID :=
               No_Bare_RFLX_Node;
            Comprehension_F_Sequence : aliased Bare_Expr :=
               No_Bare_RFLX_Node;
            Comprehension_F_Condition : aliased Bare_Expr :=
               No_Bare_RFLX_Node;
            Comprehension_F_Selector : aliased Bare_Expr :=
               No_Bare_RFLX_Node;

         



      
                  when RFLX_Call_Range =>
                     
         


            Call_F_Identifier : aliased Bare_UnqualifiedID :=
               No_Bare_RFLX_Node;
            Call_F_Arguments : aliased Bare_Expr_List :=
               No_Bare_RFLX_Node;

         



      
                  when RFLX_Conversion_Range =>
                     
         


            Conversion_F_Target_Identifier : aliased Bare_ID :=
               No_Bare_RFLX_Node;
            Conversion_F_Argument : aliased Bare_Expr :=
               No_Bare_RFLX_Node;

         



      
                  when RFLX_Binding_Range =>
                     
         


            Binding_F_Expression : aliased Bare_Expr :=
               No_Bare_RFLX_Node;
            Binding_F_Bindings : aliased Bare_Term_Assoc_List :=
               No_Bare_RFLX_Node;

         



      
                  when RFLX_Select_Node_Range =>
                     
         


            Select_Node_F_Expression : aliased Bare_Expr :=
               No_Bare_RFLX_Node;
            Select_Node_F_Selector : aliased Bare_UnqualifiedID :=
               No_Bare_RFLX_Node;

         



      
               when others => null;
            end case;

      
                  when RFLX_Op =>
                     
         



         


            case Kind is
                  when RFLX_Op_Pow_Range =>
                     
         



         



            null;
      
                  when RFLX_Op_Mul_Range =>
                     
         



         



            null;
      
                  when RFLX_Op_Div_Range =>
                     
         



         



            null;
      
                  when RFLX_Op_Add_Range =>
                     
         



         



            null;
      
                  when RFLX_Op_Sub_Range =>
                     
         



         



            null;
      
                  when RFLX_Op_Mod_Range =>
                     
         



         



            null;
      
                  when RFLX_Op_Eq_Range =>
                     
         



         



            null;
      
                  when RFLX_Op_Neq_Range =>
                     
         



         



            null;
      
                  when RFLX_Op_Le_Range =>
                     
         



         



            null;
      
                  when RFLX_Op_Lt_Range =>
                     
         



         



            null;
      
                  when RFLX_Op_Gt_Range =>
                     
         



         



            null;
      
                  when RFLX_Op_Ge_Range =>
                     
         



         



            null;
      
                  when RFLX_Op_And_Range =>
                     
         



         



            null;
      
                  when RFLX_Op_Or_Range =>
                     
         



         



            null;
      
                  when RFLX_Op_In_Range =>
                     
         



         



            null;
      
                  when RFLX_Op_Notin_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when RFLX_Message_Aggregate_Association_Range =>
                     
         


            Message_Aggregate_Association_F_Identifier : aliased Bare_UnqualifiedID :=
               No_Bare_RFLX_Node;
            Message_Aggregate_Association_F_Expression : aliased Bare_Expr :=
               No_Bare_RFLX_Node;

         



      
                  when RFLX_Base_Aggregate =>
                     
         



         


            case Kind is
                  when RFLX_Null_Message_Aggregate_Range =>
                     
         



         



            null;
      
                  when RFLX_Message_Aggregate_Associations_Range =>
                     
         


            Message_Aggregate_Associations_F_Associations : aliased Bare_Message_Aggregate_Association_List :=
               No_Bare_RFLX_Node;

         



      
               when others => null;
            end case;

      
                  when RFLX_Formal_Decl =>
                     
         



         


            case Kind is
                  when RFLX_Formal_Private_Type_Decl_Range =>
                     
         


            Formal_Private_Type_Decl_F_Identifier : aliased Bare_UnqualifiedID :=
               No_Bare_RFLX_Node;

         



      
                  when RFLX_Formal_Function_Decl_Range =>
                     
         


            Formal_Function_Decl_F_Identifier : aliased Bare_UnqualifiedID :=
               No_Bare_RFLX_Node;
            Formal_Function_Decl_F_Parameters : aliased Bare_Parameters :=
               No_Bare_RFLX_Node;
            Formal_Function_Decl_F_Return_Type_Identifier : aliased Bare_ID :=
               No_Bare_RFLX_Node;

         



      
                  when RFLX_Formal_Channel_Decl_Range =>
                     
         


            Formal_Channel_Decl_F_Identifier : aliased Bare_UnqualifiedID :=
               No_Bare_RFLX_Node;
            Formal_Channel_Decl_F_Parameters : aliased Bare_Channel_Attribute_List :=
               No_Bare_RFLX_Node;

         



      
               when others => null;
            end case;

      
                  when RFLX_Session_Aspects_Range =>
                     
         


            Session_Aspects_F_Initial : aliased Bare_UnqualifiedID :=
               No_Bare_RFLX_Node;
            Session_Aspects_F_Final : aliased Bare_UnqualifiedID :=
               No_Bare_RFLX_Node;

         



      
                  when RFLX_Local_Decl =>
                     
         



         


            case Kind is
                  when RFLX_Variable_Decl_Range =>
                     
         


            Variable_Decl_F_Identifier : aliased Bare_UnqualifiedID :=
               No_Bare_RFLX_Node;
            Variable_Decl_F_Type_Identifier : aliased Bare_ID :=
               No_Bare_RFLX_Node;
            Variable_Decl_F_Initializer : aliased Bare_Expr :=
               No_Bare_RFLX_Node;

         



      
                  when RFLX_Renaming_Decl_Range =>
                     
         


            Renaming_Decl_F_Identifier : aliased Bare_UnqualifiedID :=
               No_Bare_RFLX_Node;
            Renaming_Decl_F_Type_Identifier : aliased Bare_ID :=
               No_Bare_RFLX_Node;
            Renaming_Decl_F_Expression : aliased Bare_Expr :=
               No_Bare_RFLX_Node;

         



      
               when others => null;
            end case;

      
                  when RFLX_Base_State_Body =>
                     
         



         


            case Kind is
                  when RFLX_Null_State_Body_Range =>
                     
         



         



            null;
      
                  when RFLX_State_Body_Range =>
                     
         


            State_Body_F_Declarations : aliased Bare_Local_Decl_List :=
               No_Bare_RFLX_Node;
            State_Body_F_Actions : aliased Bare_Statement_List :=
               No_Bare_RFLX_Node;
            State_Body_F_Conditional_Transitions : aliased Bare_Conditional_Transition_List :=
               No_Bare_RFLX_Node;
            State_Body_F_Final_Transition : aliased Bare_Transition :=
               No_Bare_RFLX_Node;
            State_Body_F_Exception_Transition : aliased Bare_Transition :=
               No_Bare_RFLX_Node;
            State_Body_F_End_Identifier : aliased Bare_UnqualifiedID :=
               No_Bare_RFLX_Node;

         



      
               when others => null;
            end case;

      
                  when RFLX_Statement =>
                     
         



         


            case Kind is
                  when RFLX_Assignment_Range =>
                     
         


            Assignment_F_Identifier : aliased Bare_UnqualifiedID :=
               No_Bare_RFLX_Node;
            Assignment_F_Expression : aliased Bare_Expr :=
               No_Bare_RFLX_Node;

         



      
                  when RFLX_Attribute_Statement_Range =>
                     
         


            Attribute_Statement_F_Identifier : aliased Bare_UnqualifiedID :=
               No_Bare_RFLX_Node;
            Attribute_Statement_F_Attr : aliased Bare_Attr_Stmt :=
               No_Bare_RFLX_Node;
            Attribute_Statement_F_Expression : aliased Bare_Expr :=
               No_Bare_RFLX_Node;

         



      
                  when RFLX_Reset_Range =>
                     
         


            Reset_F_Identifier : aliased Bare_UnqualifiedID :=
               No_Bare_RFLX_Node;
            Reset_F_Associations : aliased Bare_Message_Aggregate_Association_List :=
               No_Bare_RFLX_Node;

         



      
               when others => null;
            end case;

      
                  when RFLX_Attr_Stmt =>
                     
         



         


            case Kind is
                  when RFLX_Attr_Stmt_Append_Range =>
                     
         



         



            null;
      
                  when RFLX_Attr_Stmt_Extend_Range =>
                     
         



         



            null;
      
                  when RFLX_Attr_Stmt_Read_Range =>
                     
         



         



            null;
      
                  when RFLX_Attr_Stmt_Write_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when RFLX_Description_Range =>
                     
         


            Description_F_Content : aliased Bare_String_Literal :=
               No_Bare_RFLX_Node;

         



      
                  when RFLX_Transition_Range =>
                     
         


            Transition_F_Target : aliased Bare_UnqualifiedID :=
               No_Bare_RFLX_Node;
            Transition_F_Description : aliased Bare_Description :=
               No_Bare_RFLX_Node;

         


            case Kind is
                  when RFLX_Conditional_Transition_Range =>
                     
         


            Conditional_Transition_F_Condition : aliased Bare_Expr :=
               No_Bare_RFLX_Node;

         



      
               when others => null;
            end case;

      
                  when RFLX_State_Range =>
                     
         


            State_F_Identifier : aliased Bare_UnqualifiedID :=
               No_Bare_RFLX_Node;
            State_F_Description : aliased Bare_Description :=
               No_Bare_RFLX_Node;
            State_F_Body : aliased Bare_Base_State_Body :=
               No_Bare_RFLX_Node;

         



      
                  when RFLX_Package_Node_Range =>
                     
         


            Package_Node_F_Identifier : aliased Bare_UnqualifiedID :=
               No_Bare_RFLX_Node;
            Package_Node_F_Declarations : aliased Bare_Declaration_List :=
               No_Bare_RFLX_Node;
            Package_Node_F_End_Identifier : aliased Bare_UnqualifiedID :=
               No_Bare_RFLX_Node;

         



      
                  when RFLX_Aspect_Range =>
                     
         


            Aspect_F_Identifier : aliased Bare_UnqualifiedID :=
               No_Bare_RFLX_Node;
            Aspect_F_Value : aliased Bare_Expr :=
               No_Bare_RFLX_Node;

         



      
                  when RFLX_Element_Value_Assoc_Range =>
                     
         


            Element_Value_Assoc_F_Identifier : aliased Bare_UnqualifiedID :=
               No_Bare_RFLX_Node;
            Element_Value_Assoc_F_Literal : aliased Bare_Numeric_Literal :=
               No_Bare_RFLX_Node;

         



      
                  when RFLX_Then_Node_Range =>
                     
         


            Then_Node_F_Target : aliased Bare_AbstractID :=
               No_Bare_RFLX_Node;
            Then_Node_F_Aspects : aliased Bare_Aspect_List :=
               No_Bare_RFLX_Node;
            Then_Node_F_Condition : aliased Bare_Expr :=
               No_Bare_RFLX_Node;

         



      
                  when RFLX_Type_Argument_Range =>
                     
         


            Type_Argument_F_Identifier : aliased Bare_UnqualifiedID :=
               No_Bare_RFLX_Node;
            Type_Argument_F_Expression : aliased Bare_Expr :=
               No_Bare_RFLX_Node;

         



      
                  when RFLX_Null_Message_Field_Range =>
                     
         


            Null_Message_Field_F_Then : aliased Bare_Then_Node :=
               No_Bare_RFLX_Node;

         



      
                  when RFLX_Message_Field_Range =>
                     
         


            Message_Field_F_Identifier : aliased Bare_UnqualifiedID :=
               No_Bare_RFLX_Node;
            Message_Field_F_Type_Identifier : aliased Bare_ID :=
               No_Bare_RFLX_Node;
            Message_Field_F_Type_Arguments : aliased Bare_Type_Argument_List :=
               No_Bare_RFLX_Node;
            Message_Field_F_Aspects : aliased Bare_Aspect_List :=
               No_Bare_RFLX_Node;
            Message_Field_F_Condition : aliased Bare_Expr :=
               No_Bare_RFLX_Node;
            Message_Field_F_Thens : aliased Bare_Then_Node_List :=
               No_Bare_RFLX_Node;

         



      
                  when RFLX_Message_Fields_Range =>
                     
         


            Message_Fields_F_Initial_Field : aliased Bare_Null_Message_Field :=
               No_Bare_RFLX_Node;
            Message_Fields_F_Fields : aliased Bare_Message_Field_List :=
               No_Bare_RFLX_Node;

         



      
                  when RFLX_Base_Checksum_Val =>
                     
         



         


            case Kind is
                  when RFLX_Checksum_Val_Range =>
                     
         


            Checksum_Val_F_Data : aliased Bare_Expr :=
               No_Bare_RFLX_Node;

         



      
                  when RFLX_Checksum_Value_Range_Range =>
                     
         


            Checksum_Value_Range_F_First : aliased Bare_Expr :=
               No_Bare_RFLX_Node;
            Checksum_Value_Range_F_Last : aliased Bare_Expr :=
               No_Bare_RFLX_Node;

         



      
               when others => null;
            end case;

      
                  when RFLX_Checksum_Assoc_Range =>
                     
         


            Checksum_Assoc_F_Identifier : aliased Bare_UnqualifiedID :=
               No_Bare_RFLX_Node;
            Checksum_Assoc_F_Covered_Fields : aliased Bare_Base_Checksum_Val_List :=
               No_Bare_RFLX_Node;

         



      
                  when RFLX_Message_Aspect =>
                     
         



         


            case Kind is
                  when RFLX_Checksum_Aspect_Range =>
                     
         


            Checksum_Aspect_F_Associations : aliased Bare_Checksum_Assoc_List :=
               No_Bare_RFLX_Node;

         



      
                  when RFLX_Byte_Order_Aspect_Range =>
                     
         


            Byte_Order_Aspect_F_Byte_Order : aliased Bare_Byte_Order_Type :=
               No_Bare_RFLX_Node;

         



      
               when others => null;
            end case;

      
                  when RFLX_Byte_Order_Type =>
                     
         



         


            case Kind is
                  when RFLX_Byte_Order_Type_Highorderfirst_Range =>
                     
         



         



            null;
      
                  when RFLX_Byte_Order_Type_Loworderfirst_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when RFLX_Attr =>
                     
         



         


            case Kind is
                  when RFLX_Attr_First_Range =>
                     
         



         



            null;
      
                  when RFLX_Attr_Size_Range =>
                     
         



         



            null;
      
                  when RFLX_Attr_Last_Range =>
                     
         



         



            null;
      
                  when RFLX_Attr_Valid_Checksum_Range =>
                     
         



         



            null;
      
                  when RFLX_Attr_Has_Data_Range =>
                     
         



         



            null;
      
                  when RFLX_Attr_Head_Range =>
                     
         



         



            null;
      
                  when RFLX_Attr_Opaque_Range =>
                     
         



         



            null;
      
                  when RFLX_Attr_Present_Range =>
                     
         



         



            null;
      
                  when RFLX_Attr_Valid_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when RFLX_Specification_Range =>
                     
         


            Specification_F_Context_Clause : aliased Bare_Context_Item_List :=
               No_Bare_RFLX_Node;
            Specification_F_Package_Declaration : aliased Bare_Package_Node :=
               No_Bare_RFLX_Node;

         



      
                  when RFLX_Channel_Attribute =>
                     
         



         


            case Kind is
                  when RFLX_Readable_Range =>
                     
         



         



            null;
      
                  when RFLX_Writable_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when RFLX_Quantifier =>
                     
         



         


            case Kind is
                  when RFLX_Quantifier_All_Range =>
                     
         



         



            null;
      
                  when RFLX_Quantifier_Some_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when RFLX_Term_Assoc_Range =>
                     
         


            Term_Assoc_F_Identifier : aliased Bare_UnqualifiedID :=
               No_Bare_RFLX_Node;
            Term_Assoc_F_Expression : aliased Bare_Expr :=
               No_Bare_RFLX_Node;

         



      
               when others => null;
            end case;

      
   end record;

   procedure Initialize
     (Self              : Bare_RFLX_Node;
      Kind              : RFLX_Node_Kind_Type;
      Unit              : Internal_Unit;
      Token_Start_Index : Token_Index;
      Token_End_Index   : Token_Index;
      Parent            : Bare_RFLX_Node := null;
      Self_Env          : Lexical_Env := AST_Envs.Empty_Env);
   --  Helper for parsers, to initialize a freshly allocated node

   type PLE_Unit_State is record
      Named_Envs_Needing_Update : NED_Maps.Map;
      --  Set of named env entries whose Env_With_Precedence needs to be
      --  updated.
   end record;
   --  State of PLE on a specific unit

   type PLE_Unit_State_Access is access all PLE_Unit_State;

   type PLE_Node_State is record
      Unit_State : PLE_Unit_State_Access;
      --  State of PLE on the unit that owns this node

      Current_Env : Lexical_Env;
      --  Current environment when processing the node: initially inheritted
      --  from the Current_Env of the parent node (or Root_Scope on the root
      --  node), SetInitialEnv actions can change this.
      --
      --  Other environment actions such as AddEnv or AddToEnv can use this.

      Current_NED : Named_Env_Descriptor_Access;
      --  If the current environment was looked up by name, reference to the
      --  named environment descriptor. Null otherwise.
   end record;
   --  State of PLE on a specific node

   procedure Use_Direct_Env (State : in out PLE_Node_State; Env : Lexical_Env);
   --  Change State so that the current environment is Env, and record that it
   --  was *not* looked up by name.

   procedure Use_Named_Env
     (State   : in out PLE_Node_State;
      Context : Internal_Context;
      Name    : Symbol_Type);
   --  Change State so that the current environment comes from the named
   --  environment looked up with Name.

   procedure Set_Initial_Env
     (Self     : Bare_RFLX_Node;
      State    : in out PLE_Node_State;
      Name     : Symbol_Type;
      Resolver : Lexical_Env_Resolver);
   --  Helper for Populate_Lexical_Env: fetch the initial environment for Self
   --  and update State accordingly.
   --
   --  Name is for the requested named environment, or null if none is
   --  requested.
   --
   --  If Name is null or an empty array, use Resolver to fetch the initial
   --  environment, or use the current environment if there is no resolver.

   procedure Add_To_Env
     (Self              : Bare_RFLX_Node;
      State             : PLE_Node_State;
      Key               : Symbol_Type;
      Value             : Bare_RFLX_Node;
      MD                : Internal_Metadata;
      Resolver          : Entity_Resolver;
      Dest_Env_Name     : Symbol_Type;
      Dest_Env_Fallback : Lexical_Env;
      DSL_Location      : String);
   --  Helper for Populate_Lexical_Env: insert the Key/Value/MD/Resolver entry
   --  in the appropriate lexical env.
   --
   --  The destination environment is:
   --
   --  * If Dest_Env_Name is not null, this is the corresponding named
   --    environment.
   --
   --  * Otherwise, use Dest_Env_Fallback if is not the empty environment.
   --
   --  * Finally, use State's current environment.
   --
   --  If the destination environment is foreign and not fetched from its name
   --  while DSL_Location is not empty, raise a Property_Error.

   procedure Ref_Env
     (Self                : Bare_RFLX_Node;
      Dest_Env            : Lexical_Env;
      Ref_Env_Nodes       : in out Bare_RFLX_Node_Array_Access;
      Resolver            : Lexical_Env_Resolver;
      Kind                : Ref_Kind;
      Cats                : Ref_Categories;
      Shed_Rebindings     : Boolean);
   --  Helper for Populate_Lexical_Env: add referenced environments to
   --  Dest_Env. Calling this takes an ownership share for Ref_Env_Nodes.

   procedure Add_Env
     (Self              : Bare_RFLX_Node;
      State             : in out PLE_Node_State;
      No_Parent         : Boolean;
      Transitive_Parent : Boolean;
      Resolver          : Lexical_Env_Resolver;
      Names             : in out Symbol_Type_Array_Access);
   --  Helper for Populate_Lexical_Env: create a new environment for Self, and
   --  update State accordingly.
   --
   --  State/No_Parent/Resolver all participate to the computation of the
   --  parent for this new environment. Transitive_Parent is directly forwarded
   --  to the lexical environment constructor.
   --
   --  If Names is not null, this also registers the new environment as a named
   --  env for all the given names. For PLE code brevity, Add_Env takes care of
   --  freeing Names before returning.

   procedure Pre_Env_Actions
     (Self            : Bare_RFLX_Node;
      State           : in out PLE_Node_State;
      Add_To_Env_Only : Boolean := False);
   --  Internal procedure that will execute all necessary lexical env actions
   --  for Node. This is meant to be called by Populate_Lexical_Env, and not by
   --  the user.

   procedure Post_Env_Actions
     (Self : Bare_RFLX_Node; State : in out PLE_Node_State);
   --  Internal procedure that will execute all post add to env actions for
   --  Node. This is meant to be called by Populate_Lexical_Env.

   function Get_Symbol (Node : Bare_RFLX_Node) return Symbol_Type
      with Pre => Node = null or else Is_Token_Node (Node);
   --  Assuming Node is a token node, return the corresponding symbol for the
   --  token it contains.

   function Image (Self : Symbol_Type) return Character_Type_Array_Access;
   --  Transform a Symbol into an internal String

   function Text (Node : Bare_RFLX_Node) return Text_Type;
   --  Retun the fragment of text from which Node was parsed

   ------------------------------
   -- Root AST node properties --
   ------------------------------


   -----------------------
   -- Generic list type --
   -----------------------


   function Length (Node : Bare_RFLX_Node_Base_List) return Natural;

   function Children
     (Node : Bare_RFLX_Node) return Bare_RFLX_Node_Array_Access;
   --  Return an array containing all the children of Node.
   --  This is an alternative to the Child/Children_Count pair, useful if you
   --  want the convenience of ada arrays, and you don't care about the small
   --  performance hit of creating an array.

   function Item
     (Node  : Bare_RFLX_Node_Base_List;
      Index : Positive) return Bare_RFLX_Node renames Child;

   function Get
     (Node    : Bare_RFLX_Node_Base_List;
      Index   : Integer;
      Or_Null : Boolean := False) return Bare_RFLX_Node;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based.

   procedure Free_User_Fields (Node : Bare_RFLX_Node);
   --  Free resources associated to user fields in ``Node``

   procedure Set_Parents (Node, Parent : Bare_RFLX_Node);
   --  Set Node.Parent to Parent, and initialize recursively the parent of all
   --  child nodes.

   procedure Destroy (Node : Bare_RFLX_Node);
   --  Free the resources allocated to this node and all its children

   --------------------------------------
   -- Environments handling (internal) --
   --------------------------------------

   function Create_Static_Lexical_Env
     (Parent            : Env_Getter;
      Node              : Bare_RFLX_Node;
      Transitive_Parent : Boolean := False) return Lexical_Env;
   --  Wrapper around AST_Envs.Create_Lexical_Env. Create the environment and,
   --  if Node is not null, register the result for destruction in Node's
   --  analysis unit.

   function Get (A : AST_Envs.Entity_Array; Index : Integer) return Entity;
   --  Simple getter that raises Property_Error on out-of-bound accesses.
   --  Useful for code generation.

   function Group
     (Envs   : Lexical_Env_Array_Access;
      Env_Md : Internal_Metadata := No_Metadata) return Lexical_Env;
   --  Convenience wrapper for uniform types handling in code generation

   package Bare_RFLX_Node_Vectors is
      new Langkit_Support.Vectors (Bare_RFLX_Node);

   function Is_Visible_From
     (Referenced_Env, Base_Env : Lexical_Env) return Boolean;
   --  Return whether the unit that Referenced_Env belongs to is visible from
   --  the unit that Base_Env belongs to. If at least one of these two lexical
   --  environments does not belong to a particular analysis unit, this raises
   --  a Property_Error.

   function Populate_Lexical_Env (Node : Bare_RFLX_Node) return Boolean;
   --  Populate the lexical environment for node and all its children. Return
   --  whether a Property_Error error occurred in the process.

   -----------------------------------
   -- Lexical utilities (internals) --
   -----------------------------------

   function Token
     (Node  : Bare_RFLX_Node;
      Index : Token_Index) return Token_Reference;
   --  Helper for properties. This is used to turn token indexes as stored in
   --  AST nodes into Token_Reference values.

   function Stored_Token
     (Node  : Bare_RFLX_Node;
      Token : Token_Reference) return Token_Index;
   --  Helper for properties. This is used to turn a Token_Reference value into
   --  a Token_Index value that can be stored as a field in Node. This raises a
   --  Property_Error if Node and Token don't belong to the same analysis unit
   --  or if Token is actually a Trivia.

   type Bare_Child_Record (Kind : Child_Or_Trivia := Child) is record
      case Kind is
         when Child =>
            Node : Bare_RFLX_Node;
         when Trivia =>
            Trivia : Token_Reference;
      end case;
   end record;
   --  Variant that holds either an node or a token

   type Bare_Children_Array is array (Positive range <>) of Bare_Child_Record;

   function Children_And_Trivia
     (Node : Bare_RFLX_Node) return Bare_Children_Array;
   --  Implementation for Analysis.Children_And_Trivia

      

   



         



 function Node_Env
   
  (Node : Bare_RFLX_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   ;
--  For nodes that introduce a new environment, return the parent lexical
--  environment. Return the "inherited" environment otherwise.

         



 function Children_Env
   
  (Node : Bare_RFLX_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   ;
--  For nodes that introduce a new environment, return it. Return the
--  "inherited" environment otherwise.

         



 function Parent
   
  (Node : Bare_RFLX_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity
   ;
--  Return the lexical parent for this node. Return null for the root AST node
--  or for AST nodes for which no one has a reference to the parent.

         



 function Parents
   
  (Node : Bare_RFLX_Node
      ; With_Self : Boolean
         := True
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Array_Access
   ;
--  Return an array that contains the lexical parents, this node included iff
--  ``with_self`` is True. Nearer parents are first in the list.

         



 function Children
   
  (Node : Bare_RFLX_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Array_Access
   ;
--  Return an array that contains the direct lexical children.

         



 function Token_Start
   
  (Node : Bare_RFLX_Node
  )

   return Token_Reference
   ;
--  Return the first token used to parse this node.

         



 function Token_End
   
  (Node : Bare_RFLX_Node
  )

   return Token_Reference
   ;
--  Return the last token used to parse this node.

         



 function Child_Index
   
  (Node : Bare_RFLX_Node
  )

   return Integer
   ;
--  Return the 0-based index for Node in its parent's children.

         



 function Previous_Sibling
   
  (Node : Bare_RFLX_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity
   ;
--  Return the node's previous sibling, if there is one.

         



 function Next_Sibling
   
  (Node : Bare_RFLX_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity
   ;
--  Return the node's next sibling, if there is one.

         



 function Unit
   
  (Node : Bare_RFLX_Node
  )

   return Internal_Unit
   ;
--  Return the analysis unit owning this node.

         



 function Is_Ghost
   
  (Node : Bare_RFLX_Node
  )

   return Boolean
   ;
--  Return whether the node is a ghost.
--
--  Unlike regular nodes, ghost nodes cover no token in the input source: they
--  are logically located instead between two tokens. The "token_first" of all
--  ghost nodes is the token right after this logical position, while they have
--  no "token_last".

         



 function Text
   
  (Node : Bare_RFLX_Node
  )

   return Character_Type_Array_Access
   ;
--  Return the text corresponding to this node. Private property (for internal
--  DSL use).

         



 function Full_Sloc_Image
   
  (Node : Bare_RFLX_Node
  )

   return Character_Type_Array_Access
   ;
--  Return a string containing the filename + the sloc in GNU conformant
--  format. Useful to create diagnostics from a node.


   




      

   




   




      

   

      
      procedure Initialize_Fields_For_ID
        (Self : Bare_ID
         ; ID_F_Package : Bare_UnqualifiedID
         ; ID_F_Name : Bare_UnqualifiedID
        );

      
   function ID_F_Package
     (Node : Bare_ID) return Bare_UnqualifiedID;

      
   function ID_F_Name
     (Node : Bare_ID) return Bare_UnqualifiedID;



   




      

   




   




      

   




   




      

   

      
      procedure Initialize_Fields_For_Aspect
        (Self : Bare_Aspect
         ; Aspect_F_Identifier : Bare_UnqualifiedID
         ; Aspect_F_Value : Bare_Expr
        );

      
   function Aspect_F_Identifier
     (Node : Bare_Aspect) return Bare_UnqualifiedID;

      
   function Aspect_F_Value
     (Node : Bare_Aspect) return Bare_Expr;



   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   

      
      procedure Initialize_Fields_For_Message_Aggregate_Associations
        (Self : Bare_Message_Aggregate_Associations
         ; Message_Aggregate_Associations_F_Associations : Bare_Message_Aggregate_Association_List
        );

      
   function Message_Aggregate_Associations_F_Associations
     (Node : Bare_Message_Aggregate_Associations) return Bare_Message_Aggregate_Association_List;



   




      

   




   




      

   




   




      

   

      
      procedure Initialize_Fields_For_Checksum_Val
        (Self : Bare_Checksum_Val
         ; Checksum_Val_F_Data : Bare_Expr
        );

      
   function Checksum_Val_F_Data
     (Node : Bare_Checksum_Val) return Bare_Expr;



   




      

   

      
      procedure Initialize_Fields_For_Checksum_Value_Range
        (Self : Bare_Checksum_Value_Range
         ; Checksum_Value_Range_F_First : Bare_Expr
         ; Checksum_Value_Range_F_Last : Bare_Expr
        );

      
   function Checksum_Value_Range_F_First
     (Node : Bare_Checksum_Value_Range) return Bare_Expr;

      
   function Checksum_Value_Range_F_Last
     (Node : Bare_Checksum_Value_Range) return Bare_Expr;



   




      

   




   




      

   




   




      

   

      
      procedure Initialize_Fields_For_State_Body
        (Self : Bare_State_Body
         ; State_Body_F_Declarations : Bare_Local_Decl_List
         ; State_Body_F_Actions : Bare_Statement_List
         ; State_Body_F_Conditional_Transitions : Bare_Conditional_Transition_List
         ; State_Body_F_Final_Transition : Bare_Transition
         ; State_Body_F_Exception_Transition : Bare_Transition
         ; State_Body_F_End_Identifier : Bare_UnqualifiedID
        );

      
   function State_Body_F_Declarations
     (Node : Bare_State_Body) return Bare_Local_Decl_List;

      
   function State_Body_F_Actions
     (Node : Bare_State_Body) return Bare_Statement_List;

      
   function State_Body_F_Conditional_Transitions
     (Node : Bare_State_Body) return Bare_Conditional_Transition_List;

      
   function State_Body_F_Final_Transition
     (Node : Bare_State_Body) return Bare_Transition;

      
   function State_Body_F_Exception_Transition
     (Node : Bare_State_Body) return Bare_Transition;

      
   function State_Body_F_End_Identifier
     (Node : Bare_State_Body) return Bare_UnqualifiedID;



   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   

      
      procedure Initialize_Fields_For_Checksum_Assoc
        (Self : Bare_Checksum_Assoc
         ; Checksum_Assoc_F_Identifier : Bare_UnqualifiedID
         ; Checksum_Assoc_F_Covered_Fields : Bare_Base_Checksum_Val_List
        );

      
   function Checksum_Assoc_F_Identifier
     (Node : Bare_Checksum_Assoc) return Bare_UnqualifiedID;

      
   function Checksum_Assoc_F_Covered_Fields
     (Node : Bare_Checksum_Assoc) return Bare_Base_Checksum_Val_List;



   




      

   




   




      

   

      
      procedure Initialize_Fields_For_Refinement_Decl
        (Self : Bare_Refinement_Decl
         ; Refinement_Decl_F_Pdu : Bare_ID
         ; Refinement_Decl_F_Field : Bare_UnqualifiedID
         ; Refinement_Decl_F_Sdu : Bare_ID
         ; Refinement_Decl_F_Condition : Bare_Expr
        );

      
   function Refinement_Decl_F_Pdu
     (Node : Bare_Refinement_Decl) return Bare_ID;

      
   function Refinement_Decl_F_Field
     (Node : Bare_Refinement_Decl) return Bare_UnqualifiedID;

      
   function Refinement_Decl_F_Sdu
     (Node : Bare_Refinement_Decl) return Bare_ID;

      
   function Refinement_Decl_F_Condition
     (Node : Bare_Refinement_Decl) return Bare_Expr;



   




      

   

      
      procedure Initialize_Fields_For_Session_Decl
        (Self : Bare_Session_Decl
         ; Session_Decl_F_Parameters : Bare_Formal_Decl_List
         ; Session_Decl_F_Identifier : Bare_UnqualifiedID
         ; Session_Decl_F_Aspects : Bare_Session_Aspects
         ; Session_Decl_F_Declarations : Bare_Local_Decl_List
         ; Session_Decl_F_States : Bare_State_List
         ; Session_Decl_F_End_Identifier : Bare_UnqualifiedID
        );

      
   function Session_Decl_F_Parameters
     (Node : Bare_Session_Decl) return Bare_Formal_Decl_List;

      
   function Session_Decl_F_Identifier
     (Node : Bare_Session_Decl) return Bare_UnqualifiedID;

      
   function Session_Decl_F_Aspects
     (Node : Bare_Session_Decl) return Bare_Session_Aspects;

      
   function Session_Decl_F_Declarations
     (Node : Bare_Session_Decl) return Bare_Local_Decl_List;

      
   function Session_Decl_F_States
     (Node : Bare_Session_Decl) return Bare_State_List;

      
   function Session_Decl_F_End_Identifier
     (Node : Bare_Session_Decl) return Bare_UnqualifiedID;



   




      

   

      
      procedure Initialize_Fields_For_Type_Decl
        (Self : Bare_Type_Decl
         ; Type_Decl_F_Identifier : Bare_UnqualifiedID
         ; Type_Decl_F_Parameters : Bare_Parameters
         ; Type_Decl_F_Definition : Bare_Type_Def
        );

      
   function Type_Decl_F_Identifier
     (Node : Bare_Type_Decl) return Bare_UnqualifiedID;

      
   function Type_Decl_F_Parameters
     (Node : Bare_Type_Decl) return Bare_Parameters;

      
   function Type_Decl_F_Definition
     (Node : Bare_Type_Decl) return Bare_Type_Def;



   




      

   

      
      procedure Initialize_Fields_For_Description
        (Self : Bare_Description
         ; Description_F_Content : Bare_String_Literal
        );

      
   function Description_F_Content
     (Node : Bare_Description) return Bare_String_Literal;



   




      

   

      
      procedure Initialize_Fields_For_Element_Value_Assoc
        (Self : Bare_Element_Value_Assoc
         ; Element_Value_Assoc_F_Identifier : Bare_UnqualifiedID
         ; Element_Value_Assoc_F_Literal : Bare_Numeric_Literal
        );

      
   function Element_Value_Assoc_F_Identifier
     (Node : Bare_Element_Value_Assoc) return Bare_UnqualifiedID;

      
   function Element_Value_Assoc_F_Literal
     (Node : Bare_Element_Value_Assoc) return Bare_Numeric_Literal;



   




      

   




   




      

   

      
      procedure Initialize_Fields_For_Attribute
        (Self : Bare_Attribute
         ; Attribute_F_Expression : Bare_Expr
         ; Attribute_F_Kind : Bare_Attr
        );

      
   function Attribute_F_Expression
     (Node : Bare_Attribute) return Bare_Expr;

      
   function Attribute_F_Kind
     (Node : Bare_Attribute) return Bare_Attr;



   




      

   

      
      procedure Initialize_Fields_For_Bin_Op
        (Self : Bare_Bin_Op
         ; Bin_Op_F_Left : Bare_Expr
         ; Bin_Op_F_Op : Bare_Op
         ; Bin_Op_F_Right : Bare_Expr
        );

      
   function Bin_Op_F_Left
     (Node : Bare_Bin_Op) return Bare_Expr;

      
   function Bin_Op_F_Op
     (Node : Bare_Bin_Op) return Bare_Op;

      
   function Bin_Op_F_Right
     (Node : Bare_Bin_Op) return Bare_Expr;



   




      

   

      
      procedure Initialize_Fields_For_Binding
        (Self : Bare_Binding
         ; Binding_F_Expression : Bare_Expr
         ; Binding_F_Bindings : Bare_Term_Assoc_List
        );

      
   function Binding_F_Expression
     (Node : Bare_Binding) return Bare_Expr;

      
   function Binding_F_Bindings
     (Node : Bare_Binding) return Bare_Term_Assoc_List;



   




      

   

      
      procedure Initialize_Fields_For_Call
        (Self : Bare_Call
         ; Call_F_Identifier : Bare_UnqualifiedID
         ; Call_F_Arguments : Bare_Expr_List
        );

      
   function Call_F_Identifier
     (Node : Bare_Call) return Bare_UnqualifiedID;

      
   function Call_F_Arguments
     (Node : Bare_Call) return Bare_Expr_List;



   




      

   

      
      procedure Initialize_Fields_For_Comprehension
        (Self : Bare_Comprehension
         ; Comprehension_F_Iterator : Bare_UnqualifiedID
         ; Comprehension_F_Sequence : Bare_Expr
         ; Comprehension_F_Condition : Bare_Expr
         ; Comprehension_F_Selector : Bare_Expr
        );

      
   function Comprehension_F_Iterator
     (Node : Bare_Comprehension) return Bare_UnqualifiedID;

      
   function Comprehension_F_Sequence
     (Node : Bare_Comprehension) return Bare_Expr;

      
   function Comprehension_F_Condition
     (Node : Bare_Comprehension) return Bare_Expr;

      
   function Comprehension_F_Selector
     (Node : Bare_Comprehension) return Bare_Expr;



   




      

   

      
      procedure Initialize_Fields_For_Context_Item
        (Self : Bare_Context_Item
         ; Context_Item_F_Item : Bare_UnqualifiedID
        );

      
   function Context_Item_F_Item
     (Node : Bare_Context_Item) return Bare_UnqualifiedID;



   




      

   

      
      procedure Initialize_Fields_For_Conversion
        (Self : Bare_Conversion
         ; Conversion_F_Target_Identifier : Bare_ID
         ; Conversion_F_Argument : Bare_Expr
        );

      
   function Conversion_F_Target_Identifier
     (Node : Bare_Conversion) return Bare_ID;

      
   function Conversion_F_Argument
     (Node : Bare_Conversion) return Bare_Expr;



   




      

   

      
      procedure Initialize_Fields_For_Message_Aggregate
        (Self : Bare_Message_Aggregate
         ; Message_Aggregate_F_Identifier : Bare_ID
         ; Message_Aggregate_F_Values : Bare_Base_Aggregate
        );

      
   function Message_Aggregate_F_Identifier
     (Node : Bare_Message_Aggregate) return Bare_ID;

      
   function Message_Aggregate_F_Values
     (Node : Bare_Message_Aggregate) return Bare_Base_Aggregate;



   




      

   

      
      procedure Initialize_Fields_For_Negation
        (Self : Bare_Negation
         ; Negation_F_Data : Bare_Expr
        );

      
   function Negation_F_Data
     (Node : Bare_Negation) return Bare_Expr;



   




      

   




   




      

   

      
      procedure Initialize_Fields_For_Paren_Expression
        (Self : Bare_Paren_Expression
         ; Paren_Expression_F_Data : Bare_Expr
        );

      
   function Paren_Expression_F_Data
     (Node : Bare_Paren_Expression) return Bare_Expr;



   




      

   

      
      procedure Initialize_Fields_For_Quantified_Expression
        (Self : Bare_Quantified_Expression
         ; Quantified_Expression_F_Operation : Bare_Quantifier
         ; Quantified_Expression_F_Parameter_Identifier : Bare_UnqualifiedID
         ; Quantified_Expression_F_Iterable : Bare_Expr
         ; Quantified_Expression_F_Predicate : Bare_Expr
        );

      
   function Quantified_Expression_F_Operation
     (Node : Bare_Quantified_Expression) return Bare_Quantifier;

      
   function Quantified_Expression_F_Parameter_Identifier
     (Node : Bare_Quantified_Expression) return Bare_UnqualifiedID;

      
   function Quantified_Expression_F_Iterable
     (Node : Bare_Quantified_Expression) return Bare_Expr;

      
   function Quantified_Expression_F_Predicate
     (Node : Bare_Quantified_Expression) return Bare_Expr;



   




      

   

      
      procedure Initialize_Fields_For_Select_Node
        (Self : Bare_Select_Node
         ; Select_Node_F_Expression : Bare_Expr
         ; Select_Node_F_Selector : Bare_UnqualifiedID
        );

      
   function Select_Node_F_Expression
     (Node : Bare_Select_Node) return Bare_Expr;

      
   function Select_Node_F_Selector
     (Node : Bare_Select_Node) return Bare_UnqualifiedID;



   




      

   




   




      

   

      
      procedure Initialize_Fields_For_Concatenation
        (Self : Bare_Concatenation
         ; Concatenation_F_Left : Bare_Sequence_Literal
         ; Concatenation_F_Right : Bare_Sequence_Literal
        );

      
   function Concatenation_F_Left
     (Node : Bare_Concatenation) return Bare_Sequence_Literal;

      
   function Concatenation_F_Right
     (Node : Bare_Concatenation) return Bare_Sequence_Literal;



   




      

   

      
      procedure Initialize_Fields_For_Sequence_Aggregate
        (Self : Bare_Sequence_Aggregate
         ; Sequence_Aggregate_F_Values : Bare_Numeric_Literal_List
        );

      
   function Sequence_Aggregate_F_Values
     (Node : Bare_Sequence_Aggregate) return Bare_Numeric_Literal_List;



   




      

   




   




      

   

      
      procedure Initialize_Fields_For_Variable
        (Self : Bare_Variable
         ; Variable_F_Identifier : Bare_ID
        );

      
   function Variable_F_Identifier
     (Node : Bare_Variable) return Bare_ID;



   




      

   




   




      

   

      
      procedure Initialize_Fields_For_Formal_Channel_Decl
        (Self : Bare_Formal_Channel_Decl
         ; Formal_Channel_Decl_F_Identifier : Bare_UnqualifiedID
         ; Formal_Channel_Decl_F_Parameters : Bare_Channel_Attribute_List
        );

      
   function Formal_Channel_Decl_F_Identifier
     (Node : Bare_Formal_Channel_Decl) return Bare_UnqualifiedID;

      
   function Formal_Channel_Decl_F_Parameters
     (Node : Bare_Formal_Channel_Decl) return Bare_Channel_Attribute_List;



   




      

   

      
      procedure Initialize_Fields_For_Formal_Function_Decl
        (Self : Bare_Formal_Function_Decl
         ; Formal_Function_Decl_F_Identifier : Bare_UnqualifiedID
         ; Formal_Function_Decl_F_Parameters : Bare_Parameters
         ; Formal_Function_Decl_F_Return_Type_Identifier : Bare_ID
        );

      
   function Formal_Function_Decl_F_Identifier
     (Node : Bare_Formal_Function_Decl) return Bare_UnqualifiedID;

      
   function Formal_Function_Decl_F_Parameters
     (Node : Bare_Formal_Function_Decl) return Bare_Parameters;

      
   function Formal_Function_Decl_F_Return_Type_Identifier
     (Node : Bare_Formal_Function_Decl) return Bare_ID;



   




      

   

      
      procedure Initialize_Fields_For_Formal_Private_Type_Decl
        (Self : Bare_Formal_Private_Type_Decl
         ; Formal_Private_Type_Decl_F_Identifier : Bare_UnqualifiedID
        );

      
   function Formal_Private_Type_Decl_F_Identifier
     (Node : Bare_Formal_Private_Type_Decl) return Bare_UnqualifiedID;



   




      

   




   




      

   

      
      procedure Initialize_Fields_For_Renaming_Decl
        (Self : Bare_Renaming_Decl
         ; Renaming_Decl_F_Identifier : Bare_UnqualifiedID
         ; Renaming_Decl_F_Type_Identifier : Bare_ID
         ; Renaming_Decl_F_Expression : Bare_Expr
        );

      
   function Renaming_Decl_F_Identifier
     (Node : Bare_Renaming_Decl) return Bare_UnqualifiedID;

      
   function Renaming_Decl_F_Type_Identifier
     (Node : Bare_Renaming_Decl) return Bare_ID;

      
   function Renaming_Decl_F_Expression
     (Node : Bare_Renaming_Decl) return Bare_Expr;



   




      

   

      
      procedure Initialize_Fields_For_Variable_Decl
        (Self : Bare_Variable_Decl
         ; Variable_Decl_F_Identifier : Bare_UnqualifiedID
         ; Variable_Decl_F_Type_Identifier : Bare_ID
         ; Variable_Decl_F_Initializer : Bare_Expr
        );

      
   function Variable_Decl_F_Identifier
     (Node : Bare_Variable_Decl) return Bare_UnqualifiedID;

      
   function Variable_Decl_F_Type_Identifier
     (Node : Bare_Variable_Decl) return Bare_ID;

      
   function Variable_Decl_F_Initializer
     (Node : Bare_Variable_Decl) return Bare_Expr;



   




      

   

      
      procedure Initialize_Fields_For_Message_Aggregate_Association
        (Self : Bare_Message_Aggregate_Association
         ; Message_Aggregate_Association_F_Identifier : Bare_UnqualifiedID
         ; Message_Aggregate_Association_F_Expression : Bare_Expr
        );

      
   function Message_Aggregate_Association_F_Identifier
     (Node : Bare_Message_Aggregate_Association) return Bare_UnqualifiedID;

      
   function Message_Aggregate_Association_F_Expression
     (Node : Bare_Message_Aggregate_Association) return Bare_Expr;



   




      

   




   




      

   

      
      procedure Initialize_Fields_For_Byte_Order_Aspect
        (Self : Bare_Byte_Order_Aspect
         ; Byte_Order_Aspect_F_Byte_Order : Bare_Byte_Order_Type
        );

      
   function Byte_Order_Aspect_F_Byte_Order
     (Node : Bare_Byte_Order_Aspect) return Bare_Byte_Order_Type;



   




      

   

      
      procedure Initialize_Fields_For_Checksum_Aspect
        (Self : Bare_Checksum_Aspect
         ; Checksum_Aspect_F_Associations : Bare_Checksum_Assoc_List
        );

      
   function Checksum_Aspect_F_Associations
     (Node : Bare_Checksum_Aspect) return Bare_Checksum_Assoc_List;



   




      

   

      
      procedure Initialize_Fields_For_Message_Field
        (Self : Bare_Message_Field
         ; Message_Field_F_Identifier : Bare_UnqualifiedID
         ; Message_Field_F_Type_Identifier : Bare_ID
         ; Message_Field_F_Type_Arguments : Bare_Type_Argument_List
         ; Message_Field_F_Aspects : Bare_Aspect_List
         ; Message_Field_F_Condition : Bare_Expr
         ; Message_Field_F_Thens : Bare_Then_Node_List
        );

      
   function Message_Field_F_Identifier
     (Node : Bare_Message_Field) return Bare_UnqualifiedID;

      
   function Message_Field_F_Type_Identifier
     (Node : Bare_Message_Field) return Bare_ID;

      
   function Message_Field_F_Type_Arguments
     (Node : Bare_Message_Field) return Bare_Type_Argument_List;

      
   function Message_Field_F_Aspects
     (Node : Bare_Message_Field) return Bare_Aspect_List;

      
   function Message_Field_F_Condition
     (Node : Bare_Message_Field) return Bare_Expr;

      
   function Message_Field_F_Thens
     (Node : Bare_Message_Field) return Bare_Then_Node_List;



   




      

   

      
      procedure Initialize_Fields_For_Message_Fields
        (Self : Bare_Message_Fields
         ; Message_Fields_F_Initial_Field : Bare_Null_Message_Field
         ; Message_Fields_F_Fields : Bare_Message_Field_List
        );

      
   function Message_Fields_F_Initial_Field
     (Node : Bare_Message_Fields) return Bare_Null_Message_Field;

      
   function Message_Fields_F_Fields
     (Node : Bare_Message_Fields) return Bare_Message_Field_List;



   




      

   

      
      procedure Initialize_Fields_For_Null_Message_Field
        (Self : Bare_Null_Message_Field
         ; Null_Message_Field_F_Then : Bare_Then_Node
        );

      
   function Null_Message_Field_F_Then
     (Node : Bare_Null_Message_Field) return Bare_Then_Node;



   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   

      
      procedure Initialize_Fields_For_Package_Node
        (Self : Bare_Package_Node
         ; Package_Node_F_Identifier : Bare_UnqualifiedID
         ; Package_Node_F_Declarations : Bare_Declaration_List
         ; Package_Node_F_End_Identifier : Bare_UnqualifiedID
        );

      
   function Package_Node_F_Identifier
     (Node : Bare_Package_Node) return Bare_UnqualifiedID;

      
   function Package_Node_F_Declarations
     (Node : Bare_Package_Node) return Bare_Declaration_List;

      
   function Package_Node_F_End_Identifier
     (Node : Bare_Package_Node) return Bare_UnqualifiedID;



   




      

   

      
      procedure Initialize_Fields_For_Parameter
        (Self : Bare_Parameter
         ; Parameter_F_Identifier : Bare_UnqualifiedID
         ; Parameter_F_Type_Identifier : Bare_ID
        );

      
   function Parameter_F_Identifier
     (Node : Bare_Parameter) return Bare_UnqualifiedID;

      
   function Parameter_F_Type_Identifier
     (Node : Bare_Parameter) return Bare_ID;



   




      

   

      
      procedure Initialize_Fields_For_Parameters
        (Self : Bare_Parameters
         ; Parameters_F_Parameters : Bare_Parameter_List
        );

      
   function Parameters_F_Parameters
     (Node : Bare_Parameters) return Bare_Parameter_List;



   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   

      
      procedure Initialize_Fields_For_Session_Aspects
        (Self : Bare_Session_Aspects
         ; Session_Aspects_F_Initial : Bare_UnqualifiedID
         ; Session_Aspects_F_Final : Bare_UnqualifiedID
        );

      
   function Session_Aspects_F_Initial
     (Node : Bare_Session_Aspects) return Bare_UnqualifiedID;

      
   function Session_Aspects_F_Final
     (Node : Bare_Session_Aspects) return Bare_UnqualifiedID;



   




      

   

      
      procedure Initialize_Fields_For_Specification
        (Self : Bare_Specification
         ; Specification_F_Context_Clause : Bare_Context_Item_List
         ; Specification_F_Package_Declaration : Bare_Package_Node
        );

      
   function Specification_F_Context_Clause
     (Node : Bare_Specification) return Bare_Context_Item_List;

      
   function Specification_F_Package_Declaration
     (Node : Bare_Specification) return Bare_Package_Node;



   




      

   

      
      procedure Initialize_Fields_For_State
        (Self : Bare_State
         ; State_F_Identifier : Bare_UnqualifiedID
         ; State_F_Description : Bare_Description
         ; State_F_Body : Bare_Base_State_Body
        );

      
   function State_F_Identifier
     (Node : Bare_State) return Bare_UnqualifiedID;

      
   function State_F_Description
     (Node : Bare_State) return Bare_Description;

      
   function State_F_Body
     (Node : Bare_State) return Bare_Base_State_Body;



   




      

   




   




      

   

      
      procedure Initialize_Fields_For_Assignment
        (Self : Bare_Assignment
         ; Assignment_F_Identifier : Bare_UnqualifiedID
         ; Assignment_F_Expression : Bare_Expr
        );

      
   function Assignment_F_Identifier
     (Node : Bare_Assignment) return Bare_UnqualifiedID;

      
   function Assignment_F_Expression
     (Node : Bare_Assignment) return Bare_Expr;



   




      

   

      
      procedure Initialize_Fields_For_Attribute_Statement
        (Self : Bare_Attribute_Statement
         ; Attribute_Statement_F_Identifier : Bare_UnqualifiedID
         ; Attribute_Statement_F_Attr : Bare_Attr_Stmt
         ; Attribute_Statement_F_Expression : Bare_Expr
        );

      
   function Attribute_Statement_F_Identifier
     (Node : Bare_Attribute_Statement) return Bare_UnqualifiedID;

      
   function Attribute_Statement_F_Attr
     (Node : Bare_Attribute_Statement) return Bare_Attr_Stmt;

      
   function Attribute_Statement_F_Expression
     (Node : Bare_Attribute_Statement) return Bare_Expr;



   




      

   

      
      procedure Initialize_Fields_For_Reset
        (Self : Bare_Reset
         ; Reset_F_Identifier : Bare_UnqualifiedID
         ; Reset_F_Associations : Bare_Message_Aggregate_Association_List
        );

      
   function Reset_F_Identifier
     (Node : Bare_Reset) return Bare_UnqualifiedID;

      
   function Reset_F_Associations
     (Node : Bare_Reset) return Bare_Message_Aggregate_Association_List;



   




      

   

      
      procedure Initialize_Fields_For_Term_Assoc
        (Self : Bare_Term_Assoc
         ; Term_Assoc_F_Identifier : Bare_UnqualifiedID
         ; Term_Assoc_F_Expression : Bare_Expr
        );

      
   function Term_Assoc_F_Identifier
     (Node : Bare_Term_Assoc) return Bare_UnqualifiedID;

      
   function Term_Assoc_F_Expression
     (Node : Bare_Term_Assoc) return Bare_Expr;



   




      

   

      
      procedure Initialize_Fields_For_Then_Node
        (Self : Bare_Then_Node
         ; Then_Node_F_Target : Bare_AbstractID
         ; Then_Node_F_Aspects : Bare_Aspect_List
         ; Then_Node_F_Condition : Bare_Expr
        );

      
   function Then_Node_F_Target
     (Node : Bare_Then_Node) return Bare_AbstractID;

      
   function Then_Node_F_Aspects
     (Node : Bare_Then_Node) return Bare_Aspect_List;

      
   function Then_Node_F_Condition
     (Node : Bare_Then_Node) return Bare_Expr;



   




      

   

      
      procedure Initialize_Fields_For_Transition
        (Self : Bare_Transition
         ; Transition_F_Target : Bare_UnqualifiedID
         ; Transition_F_Description : Bare_Description
        );

      
   function Transition_F_Target
     (Node : Bare_Transition) return Bare_UnqualifiedID;

      
   function Transition_F_Description
     (Node : Bare_Transition) return Bare_Description;



   




      

   

      
      procedure Initialize_Fields_For_Conditional_Transition
        (Self : Bare_Conditional_Transition
         ; Transition_F_Target : Bare_UnqualifiedID
         ; Transition_F_Description : Bare_Description
         ; Conditional_Transition_F_Condition : Bare_Expr
        );

      
   function Conditional_Transition_F_Condition
     (Node : Bare_Conditional_Transition) return Bare_Expr;



   




      

   

      
      procedure Initialize_Fields_For_Type_Argument
        (Self : Bare_Type_Argument
         ; Type_Argument_F_Identifier : Bare_UnqualifiedID
         ; Type_Argument_F_Expression : Bare_Expr
        );

      
   function Type_Argument_F_Identifier
     (Node : Bare_Type_Argument) return Bare_UnqualifiedID;

      
   function Type_Argument_F_Expression
     (Node : Bare_Type_Argument) return Bare_Expr;



   




      

   




   




      

   




   




      

   

      
      procedure Initialize_Fields_For_Message_Type_Def
        (Self : Bare_Message_Type_Def
         ; Message_Type_Def_F_Message_Fields : Bare_Message_Fields
         ; Message_Type_Def_F_Aspects : Bare_Message_Aspect_List
        );

      
   function Message_Type_Def_F_Message_Fields
     (Node : Bare_Message_Type_Def) return Bare_Message_Fields;

      
   function Message_Type_Def_F_Aspects
     (Node : Bare_Message_Type_Def) return Bare_Message_Aspect_List;



   




      

   




   




      

   




   




      

   

      
      procedure Initialize_Fields_For_Named_Enumeration_Def
        (Self : Bare_Named_Enumeration_Def
         ; Named_Enumeration_Def_F_Elements : Bare_Element_Value_Assoc_List
        );

      
   function Named_Enumeration_Def_F_Elements
     (Node : Bare_Named_Enumeration_Def) return Bare_Element_Value_Assoc_List;



   




      

   

      
      procedure Initialize_Fields_For_Positional_Enumeration_Def
        (Self : Bare_Positional_Enumeration_Def
         ; Positional_Enumeration_Def_F_Elements : Bare_UnqualifiedID_List
        );

      
   function Positional_Enumeration_Def_F_Elements
     (Node : Bare_Positional_Enumeration_Def) return Bare_UnqualifiedID_List;



   




      

   

      
      procedure Initialize_Fields_For_Enumeration_Type_Def
        (Self : Bare_Enumeration_Type_Def
         ; Enumeration_Type_Def_F_Elements : Bare_Enumeration_Def
         ; Enumeration_Type_Def_F_Aspects : Bare_Aspect_List
        );

      
   function Enumeration_Type_Def_F_Elements
     (Node : Bare_Enumeration_Type_Def) return Bare_Enumeration_Def;

      
   function Enumeration_Type_Def_F_Aspects
     (Node : Bare_Enumeration_Type_Def) return Bare_Aspect_List;



   




      

   




   




      

   

      
      procedure Initialize_Fields_For_Modular_Type_Def
        (Self : Bare_Modular_Type_Def
         ; Modular_Type_Def_F_Mod : Bare_Expr
        );

      
   function Modular_Type_Def_F_Mod
     (Node : Bare_Modular_Type_Def) return Bare_Expr;



   




      

   

      
      procedure Initialize_Fields_For_Range_Type_Def
        (Self : Bare_Range_Type_Def
         ; Range_Type_Def_F_First : Bare_Expr
         ; Range_Type_Def_F_Last : Bare_Expr
         ; Range_Type_Def_F_Size : Bare_Aspect
        );

      
   function Range_Type_Def_F_First
     (Node : Bare_Range_Type_Def) return Bare_Expr;

      
   function Range_Type_Def_F_Last
     (Node : Bare_Range_Type_Def) return Bare_Expr;

      
   function Range_Type_Def_F_Size
     (Node : Bare_Range_Type_Def) return Bare_Aspect;



   




      

   

      
      procedure Initialize_Fields_For_Sequence_Type_Def
        (Self : Bare_Sequence_Type_Def
         ; Sequence_Type_Def_F_Element_Type : Bare_ID
        );

      
   function Sequence_Type_Def_F_Element_Type
     (Node : Bare_Sequence_Type_Def) return Bare_ID;



   




      

   

      
      procedure Initialize_Fields_For_Type_Derivation_Def
        (Self : Bare_Type_Derivation_Def
         ; Type_Derivation_Def_F_Base : Bare_ID
        );

      
   function Type_Derivation_Def_F_Base
     (Node : Bare_Type_Derivation_Def) return Bare_ID;



   





   function "<" (Left, Right : Internal_Unit) return Boolean;

   type Exiled_Entry is record
      Env  : Lexical_Env;
      Key  : Symbol_Type;
      Node : Bare_RFLX_Node;
   end record;
   --  Tuple of values passed to AST_Envs.Add. Used in the lexical
   --  environment rerooting machinery: see Remove_Exiled_Entries and
   --  Reroot_Foreign_Nodes.

   package Exiled_Entry_Vectors is new Langkit_Support.Vectors (Exiled_Entry);

   type Foreign_Node_Entry is record
      Node : Bare_RFLX_Node;
      --  The foreign node that has been added to an analysis unit's lexical
      --  environment.

      Unit : Internal_Unit;
      --  Analysis unit that owns Node
   end record;

   package Foreign_Node_Entry_Vectors is new Langkit_Support.Vectors
     (Foreign_Node_Entry);

   procedure Register_Destroyable
     (Unit : Internal_Unit; Node : Bare_RFLX_Node);
   --  Register Node to be destroyed when Unit is deallocated/reparsed

   procedure Register_Destroyable
     (Unit : Internal_Unit; Env : AST_Envs.Lexical_Env_Access);
   --  Register Env to be destroyed when Unit is deallocated/reparsed


   -----------------------------
   -- Miscellanous operations --
   -----------------------------

   type Destroy_Procedure is access procedure (Object : System.Address);

   type Destroyable_Type is record
      Object  : System.Address;
      --  Object to destroy

      Destroy : Destroy_Procedure;
      --  Procedure to destroy Object
   end record;
   --  Simple holder to associate an object to destroy and the procedure to
   --  perform the destruction.

   package Destroyable_Vectors is new Langkit_Support.Vectors
     (Destroyable_Type);

   package Analysis_Unit_Sets is new Langkit_Support.Cheap_Sets
     (Internal_Unit, null);

   package Units_Maps is new Ada.Containers.Hashed_Maps
     (Key_Type        => GNATCOLL.VFS.Virtual_File,
      Element_Type    => Internal_Unit,
      Hash            => GNATCOLL.VFS.Full_Name_Hash,
      Equivalent_Keys => GNATCOLL.VFS."=");

   function Token_Data (Unit : Internal_Unit) return Token_Data_Handler_Access;

   function Lookup_Symbol
     (Context : Internal_Context; Symbol : Text_Type) return Symbol_Type;
   --  Return the given symbol text as a symbol for this context. Raise an
   --  Invalid_Symbol_Error if it is invalid.

   function Create_Special_Unit
     (Context             : Internal_Context;
      Normalized_Filename : GNATCOLL.VFS.Virtual_File;
      Charset             : String;
      Rule                : Grammar_Rule) return Internal_Unit;
   --  Create a new special analysis unit, i.e. a unit that is not registered
   --  in Context's unit map.

   function Templates_Unit (Context : Internal_Context) return Internal_Unit;
   --  Return the analysis unit to be used to parse tree rewriting templates.
   --  This creates it if it does not exists yet.

   procedure Set_Rule (Unit : Internal_Unit; Rule : Grammar_Rule);

   package Virtual_File_Maps is new Ada.Containers.Hashed_Maps
     (Key_Type        => Unbounded_String,
      Element_Type    => GNATCOLL.VFS.Virtual_File,
      Equivalent_Keys => "=",
      "="             => GNATCOLL.VFS."=",
      Hash            => Ada.Strings.Unbounded.Hash);

   function Normalized_Unit_Filename
     (Context : Internal_Context; Filename : String)
      return GNATCOLL.VFS.Virtual_File;
   --  Try to return a canonical filename. This is used to have an
   --  as-unique-as-possible analysis unit identifier.

   ------------------------------------
   -- File reader internal interface --
   ------------------------------------

   type Internal_File_Reader is limited interface;
   type Internal_File_Reader_Access is access all Internal_File_Reader'Class;

   procedure Inc_Ref (Self : in out Internal_File_Reader) is abstract;
   --  Create an ownership share for this file reader.

   function Dec_Ref (Self : in out Internal_File_Reader) return Boolean
   is abstract;
   --  Release an ownership share for this file reader. This destroys the file
   --  reader if there are no shares left.
   --
   --  Return whether there are no ownership shares left.

   procedure Read
     (Self        : Internal_File_Reader;
      Filename    : String;
      Charset     : String;
      Read_BOM    : Boolean;
      Contents    : out Decoded_File_Contents;
      Diagnostics : in out Diagnostics_Vectors.Vector) is abstract;
   --  Read the content of the source at the given filename, decoding it using
   --  the given charset and decoding the byte order mark if ``Read_BOM`` is
   --  true.
   --
   --  If there is an error during this process, append an error message to
   --  Diagnostics. In that case, Contents is considered uninitialized.
   --
   --  Otherwise, allocate a Text_Type buffer, fill it and initialize Contents
   --  to refer to it.

   procedure Dec_Ref (File_Reader : in out Internal_File_Reader_Access);
   --  Call Dec_Ref on File_Reader.all and, if the ref-count reaches 0,
   --  dealloacte it.

   --------------------------------------
   -- Unit provider internal interface --
   --------------------------------------

   type Internal_Unit_Provider is limited interface;
   type Internal_Unit_Provider_Access is
      access all Internal_Unit_Provider'Class;

   procedure Inc_Ref (Provider : in out Internal_Unit_Provider) is abstract;
   --  Create an ownership share for this unit provider.

   function Dec_Ref (Provider : in out Internal_Unit_Provider) return Boolean
   is abstract;
   --  Release an ownership share for this unit provider. This destroys the
   --  unit provider if there are no shares left.
   --
   --  Return whether there are no ownership shares left.

   function Get_Unit_Filename
     (Provider : Internal_Unit_Provider;
      Name     : Text_Type;
      Kind     : Analysis_Unit_Kind) return String is abstract;
   --  Return the filename corresponding to the given unit name/unit kind.
   --  Raise a ``Property_Error`` if the given unit name is not valid.

   function Get_Unit
     (Provider    : Internal_Unit_Provider;
      Context     : Internal_Context;
      Name        : Text_Type;
      Kind        : Analysis_Unit_Kind;
      Charset     : String := "";
      Reparse     : Boolean := False) return Internal_Unit is abstract;
   --  Fetch and return the analysis unit referenced by the given unit name.
   --  Raise a ``Property_Error`` if the given unit name is not valid.

   procedure Dec_Ref (Provider : in out Internal_Unit_Provider_Access);

   type Analysis_Context_Type is limited record
      --  Start of ABI area. In order to perform fast checks from foreign
      --  languages, we maintain minimal ABI for analysis context: this allows
      --  us in language bindings to directly peek in this record rather than
      --  rely on (slow) calls to getters.

      Serial_Number : Version_Number;
      --  Serial number that is incremented each time this context allocation
      --  is re-used.

      --  End of ABI area

      Ref_Count : Natural;

      Units : Units_Maps.Map;
      --  Collection of analysis units loaded in this context

      Filenames : Virtual_File_Maps.Map;
      --  Cache for GNATCOLL.VFS.Virtual_File we create for String filenames.
      --  Re-using older Virtual_File values is useful as this reduces the need
      --  to normalize paths, which is a costly operation.

      Symbols : Symbol_Table;
      --  Symbol table used in this whole context

      Charset : Unbounded_String;
      --  Default charset to use in analysis units

      Tab_Stop : aliased Positive;
      --  Tab stop for the lexer to correctly interpret ASCII.HT input
      --  characters.

      With_Trivia : Boolean;
      --  Whether Trivia nodes were parsed and included in analysis units

      Root_Scope : Lexical_Env;
      --  The lexical scope that is shared amongst every compilation unit. Used
      --  to resolve cross file references.

      Named_Envs : NED_Maps.Map;
      --  Map env names to the corresponding named environment descriptors

      File_Reader : Internal_File_Reader_Access;
      --  Object to override the reading and decoding of source files

      Unit_Provider : Internal_Unit_Provider_Access;
      --  Object to translate unit names to file names

      Parser : Parser_Type;
      --  Main parser type. TODO: If we want to parse in several tasks, we'll
      --  replace that by an array of parsers.

      Discard_Errors_In_Populate_Lexical_Env : Boolean;
      --  See the eponym procedure

      In_Populate_Lexical_Env : Boolean;
      --  Flag to tell whether we are running the Populate_Lexical_Env pass.
      --  When it's on, we must not use the memoization map as the hash of
      --  lexical environment changes when their content changes.

      Logic_Resolution_Timeout : Natural;
      --  If zero, inefficient. Otherwise, designates the maximal number of
      --  steps allowed in the resolution of logic equations before
      --  interrupting the resolution because of timeout. See the
      --  Set_Logic_Resolution_Timeout procedure.

      Cache_Version : Natural;
      --  Version number used to invalidate memoization caches in a lazy
      --  fashion. If an analysis unit's version number is strictly inferior to
      --  this, its memoization map should be cleared.

      Reparse_Cache_Version : Natural;
      --  Version number used to invalidate referenced envs caches. It is
      --  incremented only when a unit is reparsed in the context.

      Rewriting_Handle : Rewriting_Handle_Pointer :=
         No_Rewriting_Handle_Pointer;
      --  Rewriting handle for this context's current rewriting session.
      --  No_Rewriting_Handle_Pointer if there is no such session currently.

      Templates_Unit : Internal_Unit := No_Analysis_Unit;
      --  Special analysis unit used only as a containing unit to parse
      --  templates in the context of tree rewriting.

      Released : Boolean;
      --  Whether this context has been released and thus is available in
      --  Context_Pool.

      Current_Call_Depth : Natural := 0;
      --  Number of recursive calls currently running. This counter is
      --  used as a mitigation against infinite recursions. The calls
      --  considered here include:
      --
      --  * parsing functions;
      --  * properties calls.

      Call_Depth_High_Water_Mark : Natural := 0;
      --  Maximum number of recursive calls seen in this context so far

      Max_Call_Depth : Natural := 0;
      --  Maximum number of recursive calls allowed

      Available_Rebindings : Env_Rebindings_Vectors.Vector;
      --  List of allocated-but-unused Env_Rebinding_Type records.
      --
      --  Each rebinding we allocate for an analysis context is deallocated
      --  only when the whole context is released, so when this list is not
      --  empty, we pick one of its element instead of allocating another
      --  rebinding (see the Acquire_Rebindings and Release_Rebindings
      --  subprograms).
      --
      --  Thanks to this mechanism, we have a very simple way to implement
      --  rebindings validity checking for nodes: once we have established that
      --  the node reference is valid regarding its context, we know that the
      --  rebindings pointer is valid, and thus we can just check the rebinding
      --  version number.
   end record;

   package Node_To_Named_Env_Maps is new Ada.Containers.Hashed_Maps
     (Key_Type        => Bare_RFLX_Node,
      Element_Type    => Named_Env_Descriptor_Access,
      Hash            => Hash,
      Equivalent_Keys => "=");

   type Analysis_Unit_Type is limited record
      --  Start of ABI area. In order to perform fast checks from foreign
      --  languages, we maintain minimal ABI for analysis context: this allows
      --  us in language bindings to directly peek in this record rather than
      --  rely on (slow) calls to getters.

      Unit_Version : Version_Number := 0;
      --  Version for this particular unit. This will be incremented every time
      --  a reparse occurs.

      --  End of ABI area

      Context : Internal_Context;
      --  The owning context for this analysis unit

      AST_Root : Bare_RFLX_Node;

      Filename : GNATCOLL.VFS.Virtual_File;
      --  The originating name for this analysis unit. This should be set even
      --  if the analysis unit was parsed from a buffer.

      Charset : Unbounded_String;
      --  The parsing charset for this analysis unit, as a string. If the
      --  charset used actually came from a byte order mark, this is
      --  nevertheless set to the one the user requested.

      TDH : aliased Token_Data_Handler;
      --  The token data handler that handles all token data during parsing and
      --  owns it afterwards.

      Diagnostics : Diagnostics_Vectors.Vector;
      --  The list of diagnostics produced for this analysis unit

      Rule : Grammar_Rule;
      --  The grammar rule used to parse this unit

      AST_Mem_Pool : Bump_Ptr_Pool;
      --  This memory pool shall only be used for AST parsing. Stored here
      --  because it is more convenient, but one shall not allocate from it.

      Destroyables : Destroyable_Vectors.Vector;
      --  Collection of objects to destroy when destroying the analysis unit

      Referenced_Units : Analysis_Unit_Sets.Set;
      --  Units that are referenced from this one. Useful for
      --  visibility/computation of the reference graph.

      Is_Env_Populated : Boolean;
      --  Whether Populate_Lexical_Env was called on this unit. Used not to
      --  populate multiple times the same unit and hence avoid infinite
      --  populate recursions for circular dependencies.

      Exiled_Entries : Exiled_Entry_Vectors.Vector;
      --  Lexical env population for this unit may have added AST nodes it owns
      --  to the lexical environments that belong to other units ("exiled"
      --  entries). For each of these AST nodes, this vector contains an entry
      --  that records the target environment, the AST node and the
      --  corresponding symbol.

      Foreign_Nodes : Foreign_Node_Entry_Vectors.Vector;
      --  This unit owns a set of lexical environments. This vector contains
      --  the list of AST nodes that were added to these environments and that
      --  come from other units.

      Exiled_Entries_In_NED : Exiled_Entry_In_NED_Vectors.Vector;
      --  Like Exiled_Entries, but for symbol/node associations exclusively
      --  handled by the named environments mechanism.
      --
      --  This list allows efficient removal of these entries from
      --  Named_Env_Descriptor.Foreign_Nodes components when unloading this
      --  unit.

      Exiled_Envs : Exiled_Env_Vectors.Vector;
      --  List of lexical environments created in this unit and whose parent is
      --  a named environment.
      --
      --  This list allows efficient removal for these envs from
      --  Named_Env_Descriptor.Foreign_Envs components when unloading this
      --  unit.

      Named_Envs : Named_Env_Vectors.Vector;
      --  List of named environment created in this unit.
      --
      --  This list allows efficient removal for these envs from the
      --  Named_Env_Descriptor.Envs components when unloading this unit.

      Nodes_With_Foreign_Env : Node_To_Named_Env_Maps.Map;
      --  Mapping from a node to its Self_Env's named env descriptor, for each
      --  node in this unit whose Self_Env is a named environment.
      --
      --  This mapping allows efficient removal for these nodes from the
      --  Named_Env_Descriptor.Nodes_With_Foreign_Env components when unloading
      --  this unit.

      Rebindings : aliased Env_Rebindings_Vectors.Vector;
      --  List of rebindings for which Old_Env and/or New_Env belong to this
      --  unit. When this unit gets destroyed or reparsed, these rebindings
      --  need to be destroyed too (see Destroy_Rebindings).


      Cache_Version : Natural := 0;
      --  See the eponym field in Analysis_Context_Type

      

   end record;

   procedure Free is new Ada.Unchecked_Deallocation
     (Analysis_Context_Type, Internal_Context);

   procedure Free is new Ada.Unchecked_Deallocation
     (Analysis_Unit_Type, Internal_Unit);

   type Reparsed_Unit is record
      TDH          : Token_Data_Handler;
      Diagnostics  : Diagnostics_Vectors.Vector;
      AST_Mem_Pool : Bump_Ptr_Pool;
      AST_Root     : Bare_RFLX_Node;
   end record;
   --  Holder for fields affected by an analysis unit reparse. This makes it
   --  possible to separate the "reparsing" and the "replace" steps.

   procedure Destroy (Reparsed : in out Reparsed_Unit);
   --  Free all resources in Reparsed

   function Basename (Filename : String) return String;
   --  Return the base filename for String

   ----------------------------------------------------
   -- Implementation for analysis context primitives --
   ----------------------------------------------------

   function Create_Context
     (Charset        : String;
      File_Reader    : Internal_File_Reader_Access;
      Unit_Provider  : Internal_Unit_Provider_Access;
      With_Trivia    : Boolean;
      Tab_Stop       : Positive;
      Max_Call_Depth : Natural := 1000)
      return Internal_Context;
   --  Implementation for Analysis.Create_Context

   function Create_Unit
     (Context             : Internal_Context;
      Normalized_Filename : GNATCOLL.VFS.Virtual_File;
      Charset             : String;
      Rule                : Grammar_Rule) return Internal_Unit
      with Pre => not Has_Unit (Context, +Normalized_Filename.Full_Name);
   --  Create a new analysis unit and register it in Context

   function Get_Unit
     (Context           : Internal_Context;
      Filename, Charset : String;
      Reparse           : Boolean;
      Input             : Internal_Lexer_Input;
      Rule              : Grammar_Rule) return Internal_Unit;
   --  Helper for Get_From_File and Get_From_Buffer. Return the resulting
   --  analysis unit.

   function Has_Unit
     (Context       : Internal_Context;
      Unit_Filename : String) return Boolean;
   --  Implementation for Analysis.Has_Unit

   function Get_From_File
     (Context  : Internal_Context;
      Filename : String;
      Charset  : String;
      Reparse  : Boolean;
      Rule     : Grammar_Rule) return Internal_Unit;
   --  Implementation for Analysis.Get_From_File

   function Get_From_Buffer
     (Context  : Internal_Context;
      Filename : String;
      Charset  : String;
      Buffer   : String;
      Rule     : Grammar_Rule) return Internal_Unit;
   --  Implementation for Analysis.Get_From_Buffer

   function Get_With_Error
     (Context  : Internal_Context;
      Filename : String;
      Error    : Text_Type;
      Charset  : String;
      Rule     : Grammar_Rule) return Internal_Unit;
   --  Implementation for Analysis.Get_With_Error


   function Unit_Provider
     (Context : Internal_Context) return Internal_Unit_Provider_Access;
   --  Implementation for Analysis.Unit_Provider

   function Hash (Context : Internal_Context) return Hash_Type;
   --  Implementation for Analysis.Hash

   function Has_With_Trivia (Context : Internal_Context) return Boolean;
   --  Implementation for Analysis.Has_With_Trivia

   procedure Discard_Errors_In_Populate_Lexical_Env
     (Context : Internal_Context; Discard : Boolean);
   --  Implementation for Analysis.Discard_Errors_In_Populate_Lexical_Env

   procedure Set_Logic_Resolution_Timeout
     (Context : Internal_Context; Timeout : Natural);
   --  Implementation for Analysis.Set_Logic_Resolution_Timeout

   function Has_Rewriting_Handle (Context : Internal_Context) return Boolean;
   --  Implementation for Analysis.Has_Rewriting_Handle

   procedure Inc_Ref (Context : Internal_Context);
   --  Increment the ref-count of Context. This does nothing if Context is
   --  null.

   procedure Dec_Ref (Context : in out Internal_Context);
   --  Decrement the ref-count of Context, destroying it if the ref-count
   --  reaches zero. This does nothing if Context is null.

   procedure Destroy (Context : in out Internal_Context)
      with Pre => not Has_Rewriting_Handle (Context);
   --  Free all resources allocated for Context

   -------------------------------------------------
   -- Implementation for analysis unit primitives --
   -------------------------------------------------

   function Context (Unit : Internal_Unit) return Internal_Context;
   --  Implementation for Analysis.Context

   function Hash (Unit : Internal_Unit) return Hash_Type;
   --  Implementation for Analysis.Hash

   procedure Reparse (Unit : Internal_Unit; Charset : String);
   --  Implementation for Analysis.Reparse

   procedure Reparse
     (Unit : Internal_Unit; Charset : String; Buffer  : String);
   --  Implementation for Analysis.Reparse

   procedure Populate_Lexical_Env (Unit : Internal_Unit);
   --  Implementation for Analysis.Populate_Lexical_Env

   function Get_Filename (Unit : Internal_Unit) return String;
   --  Implementation for Analysis.Get_Filename

   function Get_Charset (Unit : Internal_Unit) return String;
   --  Implementation for Analysis.Get_Charset

   function Has_Diagnostics (Unit : Internal_Unit) return Boolean;
   --  Implementation for Analysis.Has_Diagnostics

   function Diagnostics (Unit : Internal_Unit) return Diagnostics_Array;
   --  Implementation for Analysis.Diagnostics

   function Format_GNU_Diagnostic
     (Unit : Internal_Unit; D : Diagnostic) return String;
   --  Implementation for Analysis.Format_GNU_Diagnostic

   function Root (Unit : Internal_Unit) return Bare_RFLX_Node;
   --  Implementation for Analysis.Root

   function First_Token (Unit : Internal_Unit) return Token_Reference;
   --  Implementation for Analysis.First_Token

   function Last_Token (Unit : Internal_Unit) return Token_Reference;
   --  Implementation for Analysis.Last_Token

   function Token_Count (Unit : Internal_Unit) return Natural;
   --  Implementation for Analysis.Token_Count

   function Trivia_Count (Unit : Internal_Unit) return Natural;
   --  Implementation for Analysis.Trivia_Count

   function Text (Unit : Internal_Unit) return Text_Type;
   --  Implementation for Analysis.Text

   function Lookup_Token
     (Unit : Internal_Unit; Sloc : Source_Location) return Token_Reference;
   --  Implementation for Analysis.Lookup_Token

   procedure Dump_Lexical_Env (Unit : Internal_Unit);
   --  Implementation for Analysis.Dump_Lexical_Env

   procedure Print (Unit : Internal_Unit; Show_Slocs : Boolean);
   --  Implementation for Analysis.Print

   procedure PP_Trivia (Unit : Internal_Unit);
   --  Implementation for Analysis.PP_Trivia

   procedure Destroy (Unit : in out Internal_Unit);
   --  TODO???

   function Basename (Unit : Internal_Unit) return String;
   --  Return the base filename for Unit

   procedure Invalidate_Caches
     (Context : Internal_Context; Invalidate_Envs : Boolean);
   --  Invalidate memoization caches. If Invalidate_Envs is true, also
   --  invalidate referenced envs caches.

   procedure Reset_Caches (Unit : Internal_Unit);
   --  Destroy Unit's memoization cache. This resets Unit's version number to
   --  Unit.Context.Cache_Version.

   procedure Reference_Unit (From, Referenced : Internal_Unit);
   --  Set the Referenced unit as being referenced from the From unit. This is
   --  useful for visibility purposes, and is mainly meant to be used in the
   --  env hooks.

   function Get_Line
     (Unit : Internal_Unit; Line_Number : Positive) return Text_Type;
   --  Return the line of text at line number ``Line_Number``

   function Is_Referenced_From
     (Self, Unit : Internal_Unit) return Boolean;

   procedure Do_Parsing
     (Unit   : Internal_Unit;
      Input  : Internal_Lexer_Input;
      Result : out Reparsed_Unit);
   --  Parse text for Unit using Input and store the result in Result. This
   --  leaves Unit unchanged.

   procedure Update_After_Reparse
     (Unit : Internal_Unit; Reparsed : in out Reparsed_Unit);
   --  Update Unit's AST from Reparsed and update stale lexical environment
   --  data after the reparsing of Unit.

   procedure Destroy_Unit_Destroyables (Unit : Internal_Unit);
   --  Destroy all destroyables objects in Unit and clear this list in Unit

   procedure Remove_Exiled_Entries (Unit : Internal_Unit);
   --  Remove lexical environment entries referencing nodes in Unit from
   --  lexical environments Unit does not own. Remove foreign node entries in
   --  foreign units that correspond to these exiled entries. Clear
   --  Unit.Exiled_Entries afterwards.

   procedure Remove_Named_Envs
     (Unit                      : Internal_Unit;
      Named_Envs_Needing_Update : in out NED_Maps.Map);
   --  Remove envs that belong to Unit from all relevant NEDs, and keep track
   --  in Named_Env_Needing_Update of the env names whose env with precedence
   --  must change because of this.

   procedure Extract_Foreign_Nodes
     (Unit          : Internal_Unit;
      Foreign_Nodes : in out Bare_RFLX_Node_Vectors.Vector);
   --  Collect in Foreign_Nodes all foreign nodes in Unit's lexical
   --  environments (i.e. lexical env entries that refer to nodes which belongs
   --  to other analysis units). Remove the exiled entries in foreign units
   --  that correspond to these foreign nodes. Clear Unit.Foreign_Nodes
   --  afterwards.

   procedure Reroot_Foreign_Node (Node : Bare_RFLX_Node);
   --  Re-create the lexical env entry for Node. This is to be used in
   --  Flush_Populate_Lexical_Env_Queue, after reparsing removed the target
   --  lexical environment.

   procedure Destroy_Rebindings
     (Rebindings : access Env_Rebindings_Vectors.Vector);
   --  Destroy all rebindings in Rebindings, plus their child rebindings. Note
   --  that children can belong to various analysis units, so this takes care
   --  of removing the destroyed rebindings from each concerned analysis unit's
   --  Rebindings vector.
   --
   --  This require an access parameter in order to avoid aliasing issues in
   --  the body.

   function Get_Rewriting_Handle
     (Context : Internal_Context) return Rewriting_Handle_Pointer;
   --  Return the Rewriting_Handle component of Context

   procedure Set_Rewriting_Handle
     (Context : Internal_Context; Handle : Rewriting_Handle_Pointer);
   --  Set the Rewriting_Handle component of Context

   type Node_Safety_Net is record
      Context        : Internal_Context;
      Context_Serial : Version_Number;
      --  Analysis context and serial number at the time this safety net was
      --  produced.

      Unit         : Internal_Unit;
      Unit_Version : Version_Number;
      --  Analysis unit and unit version at the time this safety net was
      --  produced.

      Rebindings_Version : Version_Number;
      --  Version of the associated rebinding at the time this safety net was
      --  procuded.
   end record;
   --  Information to embed in public APIs, used to check before accessing data
   --  that the said-data is still valid.

   No_Node_Safety_Net : constant Node_Safety_Net := (null, 0, null, 0, 0);

   function String_To_Symbol
     (Context : Internal_Context; S : Character_Type_Array_Access) return Symbol_Type;
   --  Convert S into the corresponding symbol, raising a Property_Error if
   --  symbol canonicalization fails. If S is empty, just return null.

   function Solve_Wrapper
     (R            : Relation;
      Context_Node : Bare_RFLX_Node) return Boolean;
   --  Wrapper for Langkit_Support.Adalog.Solve; will handle setting the debug
   --  strings in the equation if in debug mode.

   generic
      type T (<>) is limited private;
      type T_Access is access all T;
      with procedure Destroy (Object : in out T_Access);
   procedure Register_Destroyable_Gen
     (Unit : Internal_Unit; Object : T_Access);
   --  Generic procedure to register an object so that it is automatically
   --  destroyed when Unit is destroyed.

private
   --  We only have a private part to defer the initialization of struct
   --  constants. This allows us to circumvent circularity problems between
   --  arrays and structs.

         

         

         
      


      No_Entity_AbstractID : constant Internal_Entity_AbstractID :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Type_Def : constant Internal_Entity_Type_Def :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Abstract_Message_Type_Def : constant Internal_Entity_Abstract_Message_Type_Def :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Aspect : constant Internal_Entity_Aspect :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_RFLX_Node_Base_List : constant Internal_Entity_RFLX_Node_Base_List :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Aspect_List : constant Internal_Entity_Aspect_List :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Statement : constant Internal_Entity_Statement :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Assignment : constant Internal_Entity_Assignment :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Attr : constant Internal_Entity_Attr :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Attr_First : constant Internal_Entity_Attr_First :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Attr_Has_Data : constant Internal_Entity_Attr_Has_Data :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Attr_Head : constant Internal_Entity_Attr_Head :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Attr_Last : constant Internal_Entity_Attr_Last :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Attr_Opaque : constant Internal_Entity_Attr_Opaque :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Attr_Present : constant Internal_Entity_Attr_Present :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Attr_Size : constant Internal_Entity_Attr_Size :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Attr_Stmt : constant Internal_Entity_Attr_Stmt :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Attr_Stmt_Append : constant Internal_Entity_Attr_Stmt_Append :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Attr_Stmt_Extend : constant Internal_Entity_Attr_Stmt_Extend :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Attr_Stmt_Read : constant Internal_Entity_Attr_Stmt_Read :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Attr_Stmt_Write : constant Internal_Entity_Attr_Stmt_Write :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Attr_Valid : constant Internal_Entity_Attr_Valid :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Attr_Valid_Checksum : constant Internal_Entity_Attr_Valid_Checksum :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Expr : constant Internal_Entity_Expr :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Attribute : constant Internal_Entity_Attribute :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Attribute_Statement : constant Internal_Entity_Attribute_Statement :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Base_Aggregate : constant Internal_Entity_Base_Aggregate :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Base_Checksum_Val : constant Internal_Entity_Base_Checksum_Val :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Base_Checksum_Val_List : constant Internal_Entity_Base_Checksum_Val_List :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Base_State_Body : constant Internal_Entity_Base_State_Body :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Bin_Op : constant Internal_Entity_Bin_Op :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Binding : constant Internal_Entity_Binding :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Message_Aspect : constant Internal_Entity_Message_Aspect :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Byte_Order_Aspect : constant Internal_Entity_Byte_Order_Aspect :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Byte_Order_Type : constant Internal_Entity_Byte_Order_Type :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Byte_Order_Type_Highorderfirst : constant Internal_Entity_Byte_Order_Type_Highorderfirst :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Byte_Order_Type_Loworderfirst : constant Internal_Entity_Byte_Order_Type_Loworderfirst :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Call : constant Internal_Entity_Call :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Channel_Attribute : constant Internal_Entity_Channel_Attribute :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Channel_Attribute_List : constant Internal_Entity_Channel_Attribute_List :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Checksum_Aspect : constant Internal_Entity_Checksum_Aspect :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Checksum_Assoc : constant Internal_Entity_Checksum_Assoc :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Checksum_Assoc_List : constant Internal_Entity_Checksum_Assoc_List :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Checksum_Val : constant Internal_Entity_Checksum_Val :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Checksum_Value_Range : constant Internal_Entity_Checksum_Value_Range :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Comprehension : constant Internal_Entity_Comprehension :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Sequence_Literal : constant Internal_Entity_Sequence_Literal :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Concatenation : constant Internal_Entity_Concatenation :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Transition : constant Internal_Entity_Transition :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Conditional_Transition : constant Internal_Entity_Conditional_Transition :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Conditional_Transition_List : constant Internal_Entity_Conditional_Transition_List :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Context_Item : constant Internal_Entity_Context_Item :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Context_Item_List : constant Internal_Entity_Context_Item_List :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Conversion : constant Internal_Entity_Conversion :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Declaration : constant Internal_Entity_Declaration :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Declaration_List : constant Internal_Entity_Declaration_List :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Description : constant Internal_Entity_Description :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Element_Value_Assoc : constant Internal_Entity_Element_Value_Assoc :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Element_Value_Assoc_List : constant Internal_Entity_Element_Value_Assoc_List :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Enumeration_Def : constant Internal_Entity_Enumeration_Def :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Enumeration_Type_Def : constant Internal_Entity_Enumeration_Type_Def :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Expr_List : constant Internal_Entity_Expr_List :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Formal_Decl : constant Internal_Entity_Formal_Decl :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Formal_Channel_Decl : constant Internal_Entity_Formal_Channel_Decl :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Formal_Decl_List : constant Internal_Entity_Formal_Decl_List :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Formal_Function_Decl : constant Internal_Entity_Formal_Function_Decl :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Formal_Private_Type_Decl : constant Internal_Entity_Formal_Private_Type_Decl :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_ID : constant Internal_Entity_ID :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Integer_Type_Def : constant Internal_Entity_Integer_Type_Def :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Local_Decl : constant Internal_Entity_Local_Decl :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Local_Decl_List : constant Internal_Entity_Local_Decl_List :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Message_Aggregate : constant Internal_Entity_Message_Aggregate :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Message_Aggregate_Association : constant Internal_Entity_Message_Aggregate_Association :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Message_Aggregate_Association_List : constant Internal_Entity_Message_Aggregate_Association_List :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Message_Aggregate_Associations : constant Internal_Entity_Message_Aggregate_Associations :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Message_Aspect_List : constant Internal_Entity_Message_Aspect_List :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Message_Field : constant Internal_Entity_Message_Field :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Message_Field_List : constant Internal_Entity_Message_Field_List :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Message_Fields : constant Internal_Entity_Message_Fields :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Message_Type_Def : constant Internal_Entity_Message_Type_Def :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Modular_Type_Def : constant Internal_Entity_Modular_Type_Def :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Named_Enumeration_Def : constant Internal_Entity_Named_Enumeration_Def :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Negation : constant Internal_Entity_Negation :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_NullID : constant Internal_Entity_NullID :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Null_Message_Aggregate : constant Internal_Entity_Null_Message_Aggregate :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Null_Message_Field : constant Internal_Entity_Null_Message_Field :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Null_Message_Type_Def : constant Internal_Entity_Null_Message_Type_Def :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Null_State_Body : constant Internal_Entity_Null_State_Body :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Numeric_Literal : constant Internal_Entity_Numeric_Literal :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Numeric_Literal_List : constant Internal_Entity_Numeric_Literal_List :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Op : constant Internal_Entity_Op :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Op_Add : constant Internal_Entity_Op_Add :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Op_And : constant Internal_Entity_Op_And :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Op_Div : constant Internal_Entity_Op_Div :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Op_Eq : constant Internal_Entity_Op_Eq :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Op_Ge : constant Internal_Entity_Op_Ge :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Op_Gt : constant Internal_Entity_Op_Gt :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Op_In : constant Internal_Entity_Op_In :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Op_Le : constant Internal_Entity_Op_Le :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Op_Lt : constant Internal_Entity_Op_Lt :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Op_Mod : constant Internal_Entity_Op_Mod :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Op_Mul : constant Internal_Entity_Op_Mul :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Op_Neq : constant Internal_Entity_Op_Neq :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Op_Notin : constant Internal_Entity_Op_Notin :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Op_Or : constant Internal_Entity_Op_Or :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Op_Pow : constant Internal_Entity_Op_Pow :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Op_Sub : constant Internal_Entity_Op_Sub :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Package_Node : constant Internal_Entity_Package_Node :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Parameter : constant Internal_Entity_Parameter :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Parameter_List : constant Internal_Entity_Parameter_List :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Parameters : constant Internal_Entity_Parameters :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Paren_Expression : constant Internal_Entity_Paren_Expression :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Positional_Enumeration_Def : constant Internal_Entity_Positional_Enumeration_Def :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Quantified_Expression : constant Internal_Entity_Quantified_Expression :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Quantifier : constant Internal_Entity_Quantifier :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Quantifier_All : constant Internal_Entity_Quantifier_All :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Quantifier_Some : constant Internal_Entity_Quantifier_Some :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Range_Type_Def : constant Internal_Entity_Range_Type_Def :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Readable : constant Internal_Entity_Readable :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Refinement_Decl : constant Internal_Entity_Refinement_Decl :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Renaming_Decl : constant Internal_Entity_Renaming_Decl :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Reset : constant Internal_Entity_Reset :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Select_Node : constant Internal_Entity_Select_Node :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Sequence_Aggregate : constant Internal_Entity_Sequence_Aggregate :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Sequence_Type_Def : constant Internal_Entity_Sequence_Type_Def :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Session_Aspects : constant Internal_Entity_Session_Aspects :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Session_Decl : constant Internal_Entity_Session_Decl :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Specification : constant Internal_Entity_Specification :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_State : constant Internal_Entity_State :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_State_Body : constant Internal_Entity_State_Body :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_State_List : constant Internal_Entity_State_List :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Statement_List : constant Internal_Entity_Statement_List :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_String_Literal : constant Internal_Entity_String_Literal :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Term_Assoc : constant Internal_Entity_Term_Assoc :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Term_Assoc_List : constant Internal_Entity_Term_Assoc_List :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Then_Node : constant Internal_Entity_Then_Node :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Then_Node_List : constant Internal_Entity_Then_Node_List :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Type_Argument : constant Internal_Entity_Type_Argument :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Type_Argument_List : constant Internal_Entity_Type_Argument_List :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Type_Decl : constant Internal_Entity_Type_Decl :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Type_Derivation_Def : constant Internal_Entity_Type_Derivation_Def :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_UnqualifiedID : constant Internal_Entity_UnqualifiedID :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_UnqualifiedID_List : constant Internal_Entity_UnqualifiedID_List :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Variable : constant Internal_Entity_Variable :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Variable_Decl : constant Internal_Entity_Variable_Decl :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Entity_Writable : constant Internal_Entity_Writable :=
      (
               Node => No_Bare_RFLX_Node, 
               Info => No_Entity_Info
      );

         
      


      No_Env_Assoc : constant Internal_Env_Assoc :=
      (
               Key => null, 
               Val => No_Bare_RFLX_Node, 
               Dest_Env => Empty_Env, 
               Metadata => No_Metadata
      );


end Librflxlang.Implementation;
