/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.sdef;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Relation;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.BooleanHelper;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.sdef.SDEFmethods;
import net.sf.mpxj.writer.AbstractProjectWriter;

public final class SDEFWriter
extends AbstractProjectWriter {
    private ProjectFile m_projectFile;
    private EventManager m_eventManager;
    private PrintStream m_writer;
    private StringBuilder m_buffer;
    private Format m_formatter = new SimpleDateFormat("ddMMMyy");
    private double m_minutesPerDay;
    private double m_minutesPerWeek;
    private double m_daysPerMonth;
    private static final int MAX_EXCEPTIONS_PER_RECORD = 15;

    @Override
    public void write(ProjectFile projectFile, OutputStream out) throws IOException {
        this.m_projectFile = projectFile;
        this.m_eventManager = projectFile.getEventManager();
        this.m_writer = new PrintStream(out);
        this.m_buffer = new StringBuilder();
        try {
            this.write();
        }
        finally {
            this.m_writer = null;
            this.m_projectFile = null;
            this.m_buffer = null;
        }
    }

    private void write() throws IOException {
        this.writeFileCreationRecord();
        this.writeProjectProperties(this.m_projectFile.getProjectProperties());
        this.writeCalendars(this.m_projectFile.getCalendars());
        this.writeExceptions(this.m_projectFile.getCalendars());
        this.writeTasks(this.m_projectFile.getTasks());
        this.writePredecessors(this.m_projectFile.getTasks());
        this.writeProgress(this.m_projectFile.getTasks());
        this.m_writer.println("END");
    }

    private void writeFileCreationRecord() throws IOException {
        this.m_writer.println("VOLM  1");
    }

    private void writeProjectProperties(ProjectProperties record) throws IOException {
        this.m_minutesPerDay = record.getMinutesPerDay().doubleValue();
        this.m_minutesPerWeek = record.getMinutesPerWeek().doubleValue();
        this.m_daysPerMonth = record.getDaysPerMonth().doubleValue();
        Date dataDate = record.getStatusDate() == null ? this.m_projectFile.getProjectProperties().getCurrentDate() : record.getStatusDate();
        Date startDate = record.getStartDate() == null ? this.m_projectFile.getStartDate() : record.getStartDate();
        Date finishDate = record.getFinishDate() == null ? this.m_projectFile.getFinishDate() : record.getFinishDate();
        this.m_buffer.setLength(0);
        this.m_buffer.append("PROJ ");
        this.m_buffer.append(this.formatDate(dataDate) + " ");
        this.m_buffer.append(SDEFmethods.lset(record.getManager(), 4) + " ");
        this.m_buffer.append(SDEFmethods.lset(record.getProjectTitle(), 48) + " ");
        this.m_buffer.append(SDEFmethods.lset(record.getSubject(), 36) + " ");
        this.m_buffer.append("P ");
        this.m_buffer.append(SDEFmethods.lset(record.getKeywords(), 7));
        this.m_buffer.append(this.formatDate(startDate) + " ");
        this.m_buffer.append(this.formatDate(finishDate));
        this.m_writer.println(this.m_buffer);
    }

    private void writeCalendars(List<ProjectCalendar> records) {
        for (ProjectCalendar record : records) {
            this.m_buffer.setLength(0);
            this.m_buffer.append("CLDR ");
            this.m_buffer.append(SDEFmethods.lset(record.getUniqueID().toString(), 2));
            String workDays = SDEFmethods.workDays(record);
            this.m_buffer.append(SDEFmethods.lset(workDays, 8));
            this.m_buffer.append(SDEFmethods.lset(record.getName(), 30));
            this.m_writer.println(this.m_buffer);
        }
    }

    private void writeExceptions(List<ProjectCalendar> records) throws IOException {
        for (ProjectCalendar record : records) {
            if (!record.getCalendarExceptions().isEmpty()) {
                ArrayList<String> formattedExceptions = new ArrayList<String>();
                String recordPrefix = "HOLI " + SDEFmethods.lset(record.getUniqueID().toString(), 2);
                for (ProjectCalendarException ex : record.getCalendarExceptions()) {
                    this.generateCalendarExceptions(record, ex, formattedExceptions);
                }
                int startIndex = 0;
                while (startIndex < formattedExceptions.size()) {
                    int endIndex = startIndex + 15 <= formattedExceptions.size() ? startIndex + 15 : formattedExceptions.size();
                    this.m_writer.print(recordPrefix);
                    this.m_writer.println(formattedExceptions.subList(startIndex, endIndex).stream().collect(Collectors.joining(" ")));
                    startIndex = endIndex;
                }
            }
            this.m_eventManager.fireCalendarWrittenEvent(record);
        }
    }

    private void generateCalendarExceptions(ProjectCalendar parentCalendar, ProjectCalendarException record, List<String> formattedExceptions) {
        Calendar stepDay = DateHelper.popCalendar(record.getFromDate());
        Calendar lastDay = DateHelper.popCalendar(record.getToDate());
        while (stepDay.compareTo(lastDay) <= 0) {
            formattedExceptions.add(this.formatDate(stepDay.getTime()));
            stepDay.add(5, 1);
        }
        DateHelper.pushCalendar(stepDay);
        DateHelper.pushCalendar(lastDay);
    }

    private void writeTask(Task record) throws IOException {
        this.m_buffer.setLength(0);
        if (!record.getSummary()) {
            String formattedConstraintDate;
            String conType;
            this.m_buffer.append("ACTV ");
            this.m_buffer.append(this.getActivityID(record) + " ");
            this.m_buffer.append(SDEFmethods.lset(record.getName(), 30) + " ");
            Duration dd = record.getDuration();
            if (dd == null) {
                dd = Duration.getInstance(0, TimeUnit.DAYS);
            }
            double duration = dd.getDuration();
            if (dd.getUnits() != TimeUnit.DAYS) {
                dd = Duration.convertUnits(duration, dd.getUnits(), TimeUnit.DAYS, this.m_minutesPerDay, this.m_minutesPerWeek, this.m_daysPerMonth);
            }
            Double days = dd.getDuration() + 0.5;
            Integer est = days.intValue();
            this.m_buffer.append(SDEFmethods.rset(est.toString(), 3) + " ");
            Date conDate = record.getConstraintDate();
            if (conDate == null) {
                conType = "   ";
                formattedConstraintDate = "       ";
            } else {
                formattedConstraintDate = this.m_formatter.format(conDate).toUpperCase();
                switch (record.getConstraintType()) {
                    case AS_LATE_AS_POSSIBLE: 
                    case MUST_FINISH_ON: 
                    case FINISH_NO_EARLIER_THAN: 
                    case FINISH_NO_LATER_THAN: {
                        conType = "LF ";
                        break;
                    }
                    default: {
                        conType = "ES ";
                    }
                }
            }
            this.m_buffer.append(formattedConstraintDate + " ");
            this.m_buffer.append(conType);
            if (record.getCalendar() == null) {
                this.m_buffer.append("1 ");
            } else {
                this.m_buffer.append(SDEFmethods.lset(record.getCalendar().getUniqueID().toString(), 1) + " ");
            }
            this.m_buffer.append(BooleanHelper.getBoolean(record.getHammockCode()) ? "Y " : "  ");
            this.m_buffer.append(SDEFmethods.rset(this.formatNumber(record.getWorkersPerDay()), 3) + " ");
            this.m_buffer.append(SDEFmethods.lset(record.getResponsibilityCode(), 4) + " ");
            this.m_buffer.append(SDEFmethods.lset(record.getWorkAreaCode(), 4) + " ");
            this.m_buffer.append(SDEFmethods.lset(record.getModOrClaimNumber(), 6) + " ");
            this.m_buffer.append(SDEFmethods.lset(record.getBidItem(), 6) + " ");
            this.m_buffer.append(SDEFmethods.lset(record.getPhaseOfWork(), 2) + " ");
            this.m_buffer.append(SDEFmethods.lset(record.getCategoryOfWork(), 1) + " ");
            this.m_buffer.append(SDEFmethods.lset(record.getFeatureOfWork(), 30));
            this.m_writer.println(this.m_buffer.toString());
            this.m_eventManager.fireTaskWrittenEvent(record);
        }
    }

    private void writeTasks(List<Task> tasks) throws IOException {
        for (Task task : tasks) {
            this.writeTask(task);
        }
    }

    private void writePredecessors(List<Task> tasks) {
        for (Task task : tasks) {
            this.writeTaskPredecessors(task);
        }
    }

    private void writeTaskPredecessors(Task record) {
        this.m_buffer.setLength(0);
        if (!record.getSummary() && !record.getPredecessors().isEmpty()) {
            List<Relation> predecessors = record.getPredecessors();
            for (Relation pred : predecessors) {
                this.m_buffer.setLength(0);
                this.m_buffer.append("PRED ");
                this.m_buffer.append(this.getActivityID(pred.getSourceTask()) + " ");
                this.m_buffer.append(this.getActivityID(pred.getTargetTask()) + " ");
                String type = "C";
                if (!pred.getType().toString().equals("FS")) {
                    type = pred.getType().toString().substring(0, 1);
                }
                this.m_buffer.append(type + " ");
                Duration dd = pred.getLag();
                double duration = dd.getDuration();
                duration = duration < 0.0 ? (duration -= 0.5) : (duration += 0.5);
                if (dd.getUnits() != TimeUnit.DAYS) {
                    dd = Duration.convertUnits(duration, dd.getUnits(), TimeUnit.DAYS, this.m_minutesPerDay, this.m_minutesPerWeek, this.m_daysPerMonth);
                }
                Double days = dd.getDuration();
                Integer est = days.intValue();
                this.m_buffer.append(SDEFmethods.rset(est.toString(), 4));
                this.m_writer.println(this.m_buffer.toString());
            }
        }
    }

    private void writePROG(Task record) {
        this.m_buffer.setLength(0);
        if (!record.getSummary()) {
            String floatValue;
            int floatSign;
            this.m_buffer.append("PROG ");
            this.m_buffer.append(this.getActivityID(record) + " ");
            Date temp = record.getActualStart();
            if (temp == null) {
                this.m_buffer.append("        ");
            } else {
                this.m_buffer.append(this.m_formatter.format(record.getActualStart()).toUpperCase() + " ");
            }
            temp = record.getActualFinish();
            if (temp == null) {
                this.m_buffer.append("        ");
            } else {
                this.m_buffer.append(this.m_formatter.format(record.getActualFinish()).toUpperCase() + " ");
            }
            Duration dd = record.getRemainingDuration() == null ? Duration.getInstance(0, TimeUnit.DAYS) : record.getRemainingDuration();
            double duration = dd.getDuration();
            if (dd.getUnits() != TimeUnit.DAYS) {
                dd = Duration.convertUnits(duration, dd.getUnits(), TimeUnit.DAYS, this.m_minutesPerDay, this.m_minutesPerWeek, this.m_daysPerMonth);
            }
            Double days = dd.getDuration() + 0.5;
            Integer est = days.intValue();
            this.m_buffer.append(SDEFmethods.rset(est.toString(), 3) + " ");
            DecimalFormat twoDec = new DecimalFormat("#0.00");
            this.m_buffer.append(SDEFmethods.rset(twoDec.format(NumberHelper.getDouble(record.getCost())), 12) + " ");
            this.m_buffer.append(SDEFmethods.rset(twoDec.format(NumberHelper.getDouble(record.getActualCost())), 12) + " ");
            this.m_buffer.append(SDEFmethods.rset(twoDec.format(NumberHelper.getDouble(record.getStoredMaterial())), 12) + " ");
            this.m_buffer.append(this.formatDate(record.getEarlyStart()) + " ");
            this.m_buffer.append(this.formatDate(record.getEarlyFinish()) + " ");
            this.m_buffer.append(this.formatDate(record.getLateStart()) + " ");
            this.m_buffer.append(this.formatDate(record.getLateFinish()) + " ");
            if (record.getActualFinish() == null) {
                dd = record.getTotalSlack();
                duration = dd.getDuration();
                if (dd.getUnits() != TimeUnit.DAYS) {
                    dd = Duration.convertUnits(duration, dd.getUnits(), TimeUnit.DAYS, this.m_minutesPerDay, this.m_minutesPerWeek, this.m_daysPerMonth);
                }
                floatSign = (est = Integer.valueOf((days = Double.valueOf(dd.getDuration() + 0.5)).intValue())) >= 0 ? 43 : 45;
                est = Math.abs(days.intValue());
                floatValue = est.toString();
            } else {
                floatSign = 32;
                floatValue = "";
            }
            this.m_buffer.append((char)floatSign + " ");
            this.m_buffer.append(SDEFmethods.rset(floatValue, 3));
            this.m_writer.println(this.m_buffer.toString());
            this.m_eventManager.fireTaskWrittenEvent(record);
        }
    }

    private void writeProgress(List<Task> tasks) {
        for (Task task : tasks) {
            this.writePROG(task);
        }
    }

    private String formatDate(Date date) {
        String result = date == null ? "       " : this.m_formatter.format(date).toUpperCase();
        return result;
    }

    private String formatNumber(Number value) {
        String result = value == null ? "" : value.toString();
        return result;
    }

    private String getActivityID(Task task) {
        String activityID = task.getActivityID();
        activityID = activityID == null ? SDEFmethods.rset(String.valueOf(NumberHelper.getInt(task.getUniqueID())), 10) : SDEFmethods.lset(activityID, 10);
        return activityID;
    }
}

