/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.projectcommander;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.projectcommander.Block;
import net.sf.mpxj.projectcommander.DatatypeConverter;
import net.sf.mpxj.projectcommander.ProjectCommanderData;
import net.sf.mpxj.reader.AbstractProjectStreamReader;

public final class ProjectCommanderReader
extends AbstractProjectStreamReader {
    private ProjectFile m_projectFile;
    private EventManager m_eventManager;
    private ProjectCommanderData m_data;
    private Map<Task, Block> m_taskMap;
    private Map<Integer, Integer> m_childTaskCounts;
    private Map<Task, Integer> m_extraBarCounts;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final Day[] DAYS = new Day[]{Day.SATURDAY, Day.SUNDAY, Day.MONDAY, Day.TUESDAY, Day.WEDNESDAY, Day.THURSDAY, Day.FRIDAY};

    @Override
    public ProjectFile read(InputStream is) throws MPXJException {
        try {
            this.m_projectFile = new ProjectFile();
            this.m_projectFile.getProjectProperties().setFileApplication("Project Commander");
            this.m_projectFile.getProjectProperties().setFileType("PC");
            ProjectConfig config = this.m_projectFile.getProjectConfig();
            config.setAutoTaskUniqueID(false);
            config.setAutoResourceUniqueID(false);
            this.m_eventManager = this.m_projectFile.getEventManager();
            this.m_taskMap = new TreeMap<Task, Block>();
            this.m_childTaskCounts = new TreeMap<Integer, Integer>();
            this.m_extraBarCounts = new HashMap<Task, Integer>();
            this.m_data = new ProjectCommanderData();
            this.m_data.process(is);
            this.readCalendars();
            this.readResources();
            this.readTasks();
            this.readRelationships();
            ProjectFile projectFile = this.m_projectFile;
            return projectFile;
        }
        catch (IOException ex) {
            throw new MPXJException("Error reading file", ex);
        }
        finally {
            this.m_eventManager = null;
            this.m_taskMap = null;
            this.m_childTaskCounts = null;
            this.m_extraBarCounts = null;
            this.m_data = null;
        }
    }

    @Override
    public List<ProjectFile> readAll(InputStream inputStream) throws MPXJException {
        return Arrays.asList(this.read(inputStream));
    }

    private void readCalendars() {
        this.m_data.getBlocks().stream().filter(block -> "CCalendar".equals(block.getName())).forEach(block -> this.readCalendar((Block)block));
    }

    private void readTasks() {
        this.m_data.getBlocks().stream().filter(block -> "CTask".equals(block.getName())).forEach(block -> this.readTask((Block)block));
        this.updateStructure();
        this.updateDates();
    }

    private void readResources() {
        this.m_data.getBlocks().stream().filter(block -> "CResource".equals(block.getName())).forEach(block -> this.readResource((Block)block));
        this.updateResourceUniqueIDValues();
    }

    private void readRelationships() {
        for (Map.Entry<Task, Block> entry : this.m_taskMap.entrySet()) {
            entry.getValue().getChildBlocks().stream().filter(x -> "CLink".equals(x.getName())).forEach(x -> this.readRelationships((Task)entry.getKey(), (Block)x));
        }
    }

    private ProjectCalendar readCalendar(Block block) {
        ProjectCalendar calendar;
        byte[] data = block.getData();
        String name = DatatypeConverter.getString(data, 0, null);
        if (name == null || name.trim().isEmpty()) {
            calendar = null;
        } else {
            int offset = 1 + name.length();
            calendar = this.m_projectFile.addCalendar();
            calendar.setName(name);
            int workingDays = DatatypeConverter.getByte(data, offset);
            calendar.setWorkingDay(Day.SATURDAY, (workingDays & 0x40) != 0);
            calendar.setWorkingDay(Day.SUNDAY, (workingDays & 0x20) != 0);
            calendar.setWorkingDay(Day.MONDAY, (workingDays & 0x10) != 0);
            calendar.setWorkingDay(Day.TUESDAY, (workingDays & 8) != 0);
            calendar.setWorkingDay(Day.WEDNESDAY, (workingDays & 4) != 0);
            calendar.setWorkingDay(Day.THURSDAY, (workingDays & 2) != 0);
            calendar.setWorkingDay(Day.FRIDAY, (workingDays & 1) != 0);
            HashMap<Day, List<DateRange>> ranges = new HashMap<Day, List<DateRange>>();
            ranges.put(Day.SATURDAY, this.readCalendarHours(data, (offset += 28) + 0));
            ranges.put(Day.SUNDAY, this.readCalendarHours(data, offset + 16));
            ranges.put(Day.MONDAY, this.readCalendarHours(data, offset + 32));
            ranges.put(Day.TUESDAY, this.readCalendarHours(data, offset + 48));
            ranges.put(Day.WEDNESDAY, this.readCalendarHours(data, offset + 64));
            ranges.put(Day.THURSDAY, this.readCalendarHours(data, offset + 80));
            ranges.put(Day.FRIDAY, this.readCalendarHours(data, offset + 96));
            for (Day day : DAYS) {
                if (!calendar.isWorkingDay(day)) continue;
                ProjectCalendarHours hours = calendar.addCalendarHours(day);
                ((List)ranges.get(day)).stream().forEach(range -> hours.addRange((DateRange)range));
            }
            block.getChildBlocks().stream().filter(x -> "CDayFlag".equals(x.getName())).forEach(x -> this.readCalendarException(calendar, ranges, x.getData()));
            this.m_eventManager.fireCalendarReadEvent(calendar);
        }
        return calendar;
    }

    private List<DateRange> readCalendarHours(byte[] data, int offset) {
        ArrayList<DateRange> ranges = new ArrayList<DateRange>();
        this.addRange(ranges, DatatypeConverter.getInt(data, offset), DatatypeConverter.getInt(data, offset + 4));
        this.addRange(ranges, DatatypeConverter.getInt(data, offset + 8), DatatypeConverter.getInt(data, offset + 12));
        return ranges;
    }

    private void addRange(List<DateRange> ranges, int startMinutes, int endMinutes) {
        if (startMinutes != endMinutes) {
            Date start = DateHelper.getTimeFromMinutesPastMidnight(startMinutes);
            Date end = DateHelper.getTimeFromMinutesPastMidnight(endMinutes);
            ranges.add(new DateRange(start, end));
        }
    }

    private void readCalendarException(ProjectCalendar calendar, Map<Day, List<DateRange>> ranges, byte[] data) {
        long timestampInDays = DatatypeConverter.getShort(data, 2, 0);
        if (timestampInDays > 255L) {
            long timestampInMilliseconds = timestampInDays * 24L * 60L * 60L * 1000L;
            Date exceptionDate = DateHelper.getTimestampFromLong(timestampInMilliseconds);
            Calendar cal = DateHelper.popCalendar();
            cal.setTime(exceptionDate);
            Day day = Day.getInstance(cal.get(7));
            DateHelper.pushCalendar(cal);
            ProjectCalendarException ex = calendar.addCalendarException(exceptionDate, exceptionDate);
            if (!calendar.isWorkingDay(day)) {
                ranges.get(day).stream().forEach(range -> ex.addRange((DateRange)range));
            }
        }
    }

    private void readTask(Block block) {
        int offset;
        byte[] cTaskData = block.getData();
        String name = DatatypeConverter.getString(cTaskData, offset = 0, null);
        if (name == null) {
            return;
        }
        Block[] baselines = (Block[])this.getChildBlocks(block, "CBaselineData").toArray(Block[]::new);
        if (baselines.length == 0) {
            this.readSummaryTask(block, name);
        } else {
            this.readChildTasks(block, name, baselines[0]);
        }
    }

    private void readSummaryTask(Block block, String name) {
        byte[] cTaskData = block.getData();
        int offset = name.length() + 1;
        Task task = this.m_projectFile.addTask();
        task.setName(name);
        int childTaskCount = DatatypeConverter.getShort(cTaskData, offset + 405, 0);
        if (childTaskCount != 0) {
            this.m_childTaskCounts.put(task.getID(), DatatypeConverter.getShort(cTaskData, offset + 405, 0));
        }
        task.setStartSlack(Duration.getInstance(0, TimeUnit.DAYS));
        task.setFinishSlack(Duration.getInstance(0, TimeUnit.DAYS));
        task.setCritical(false);
        this.m_eventManager.fireTaskReadEvent(task);
    }

    private void readChildTasks(Block block, String name, Block baseline) {
        Block cUsageTask = this.getChildBlock(block, "CUsageTask");
        byte[] cUsageTaskBaselineData = this.getByteArray(cUsageTask, "CBaselineData");
        Resource resource = this.readChildTaskResource(cUsageTask);
        List tasks = this.getChildBlocks(baseline, "CBar").map(bar -> this.readChildTask(name, (Block)bar, cUsageTaskBaselineData, resource)).collect(Collectors.toList());
        if (tasks.size() > 1) {
            this.m_extraBarCounts.put((Task)tasks.get(0), tasks.size() - 1);
        }
    }

    private Resource readChildTaskResource(Block cUsageTask) {
        Resource result;
        if (cUsageTask == null) {
            result = null;
        } else {
            Integer resourceUniqueID = DatatypeConverter.getShort(cUsageTask.getData(), 9);
            result = this.m_projectFile.getResourceByUniqueID(resourceUniqueID);
        }
        return result;
    }

    private Task readChildTask(String name, Block bar, byte[] cUsageTaskBaselineData, Resource resource) {
        Task task = this.m_projectFile.addTask();
        this.m_taskMap.put(task, bar);
        task.setName(name);
        byte[] cBarData = bar.getData();
        int uniqueID = DatatypeConverter.getShort(cBarData, 23, 0);
        task.setUniqueID(uniqueID);
        if (cBarData[0] == 2) {
            ProjectCalendar calendar = this.m_projectFile.getDefaultCalendar();
            task.setDuration(Duration.getInstance(0, TimeUnit.DAYS));
            task.setMilestone(true);
            Date startDate = DatatypeConverter.getTimestamp(cBarData, 7);
            task.setStart(DateHelper.setTime(startDate, calendar.getStartTime(startDate)));
            task.setFinish(calendar.getDate(task.getStart(), task.getDuration(), false));
        } else if (cUsageTaskBaselineData.length != 0) {
            Duration durationInHours = null;
            int potentialDuration = DatatypeConverter.getInt(cBarData, 97, 0);
            durationInHours = potentialDuration != 0 && (potentialDuration & 0xFF000000) == 0 ? DatatypeConverter.getDuration(cBarData, 97) : ((potentialDuration = DatatypeConverter.getInt(cUsageTaskBaselineData, 433, 0)) != 0 && (potentialDuration & 0xFF000000) == 0 ? DatatypeConverter.getDuration(cUsageTaskBaselineData, 433) : Duration.getInstance(0, TimeUnit.HOURS));
            task.setDuration(durationInHours.convertUnits(TimeUnit.DAYS, this.m_projectFile.getProjectProperties()));
            task.setWork(durationInHours);
            ProjectCalendar calendar = this.m_projectFile.getDefaultCalendar();
            Date startDate = DatatypeConverter.getTimestamp(cBarData, 5);
            task.setStart(DateHelper.setTime(startDate, calendar.getStartTime(startDate)));
            task.setFinish(calendar.getDate(task.getStart(), task.getDuration(), false));
            if (resource != null) {
                ResourceAssignment assignment = task.addResourceAssignment(resource);
                assignment.setWork(durationInHours);
                assignment.setRemainingWork(durationInHours);
            }
        }
        task.setStartSlack(Duration.getInstance(0, TimeUnit.DAYS));
        task.setFinishSlack(Duration.getInstance(0, TimeUnit.DAYS));
        task.setCritical(false);
        this.m_eventManager.fireTaskReadEvent(task);
        return task;
    }

    private byte[] getByteArray(Block block, String name) {
        Block childBlock = this.getChildBlock(block, name);
        return childBlock == null ? EMPTY_BYTE_ARRAY : childBlock.getData();
    }

    private Block getChildBlock(Block block, String name) {
        Block result = block == null ? null : (Block)this.getChildBlocks(block, name).findFirst().orElse(null);
        return result;
    }

    private Stream<Block> getChildBlocks(Block block, String name) {
        Stream<Block> result = block == null ? null : block.getChildBlocks().stream().filter(x -> name.equals(x.getName()));
        return result;
    }

    private void readRelationships(Task task, Block block) {
        byte[] data = block.getData();
        int successorTaskUniqueID = DatatypeConverter.getShort(data, 0);
        Task successor = this.m_projectFile.getTaskByUniqueID(successorTaskUniqueID);
        if (successor == null || task.isSucessor(successor) || task.isPredecessor(successor) || data.length == 14) {
            return;
        }
        Duration lag = DatatypeConverter.getDuration(data, 6);
        RelationType type = DatatypeConverter.getRelationType(data, 2);
        successor.addPredecessor(task, type, lag);
    }

    private void updateStructure() {
        int maxUniqueID = this.m_projectFile.getChildTasks().stream().mapToInt(task -> NumberHelper.getInt(task.getUniqueID())).max().orElse(0);
        int uniqueID = ((maxUniqueID + 1000) / 1000 + 1) * 1000;
        for (Map.Entry<Integer, Integer> entry : this.m_childTaskCounts.entrySet()) {
            Task task2 = this.m_projectFile.getTaskByID(entry.getKey());
            task2.setUniqueID(uniqueID++);
            int startID = task2.getID() + 1;
            int offset = entry.getValue();
            for (int id = startID; id < startID + offset; ++id) {
                Task childTask = this.m_projectFile.getTaskByID(id);
                if (childTask == null) continue;
                childTask.setOutlineLevel(NumberHelper.getInt(childTask.getOutlineLevel()) + 1);
                offset += NumberHelper.getInt(this.m_extraBarCounts.get(childTask));
            }
        }
        this.m_projectFile.getTasks().updateStructure();
    }

    private void readResource(Block block) {
        ProjectCalendar calendar;
        Block calendarBlock;
        byte[] data = block.getData();
        Resource resource = this.m_projectFile.addResource();
        resource.setName(DatatypeConverter.getString(data, 0));
        Block resourceTask = this.getChildBlock(block, "CResourceTask");
        if (resourceTask != null) {
            resource.setUniqueID(DatatypeConverter.getShort(resourceTask.getData(), 9));
        }
        if ((calendarBlock = this.getChildBlock(block, "CCalendar")) != null && (calendar = this.readCalendar(calendarBlock)) != null) {
            calendar.setResource(resource);
        }
        this.m_eventManager.fireResourceReadEvent(resource);
    }

    private void updateDates() {
        for (Task task : this.m_projectFile.getChildTasks()) {
            this.updateDates(task);
        }
    }

    private void updateDates(Task parentTask) {
        if (parentTask.hasChildTasks()) {
            Date plannedStartDate = parentTask.getStart();
            Date plannedFinishDate = parentTask.getFinish();
            for (Task task : parentTask.getChildTasks()) {
                this.updateDates(task);
                plannedStartDate = DateHelper.min(plannedStartDate, task.getStart());
                plannedFinishDate = DateHelper.max(plannedFinishDate, task.getFinish());
            }
            parentTask.setStart(plannedStartDate);
            parentTask.setFinish(plannedFinishDate);
        }
    }

    private void updateResourceUniqueIDValues() {
        int maxUniqueID = this.m_projectFile.getResources().stream().mapToInt(task -> NumberHelper.getInt(task.getUniqueID())).max().getAsInt();
        int uniqueID = ((maxUniqueID + 1000) / 1000 + 1) * 1000;
        for (Resource resource : this.m_projectFile.getResources()) {
            if (resource.getUniqueID() != null) continue;
            resource.setUniqueID(uniqueID++);
        }
    }
}

