/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera.suretrak;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.sf.mpxj.primavera.common.ByteColumn;
import net.sf.mpxj.primavera.common.ColumnDefinition;
import net.sf.mpxj.primavera.common.IntColumn;
import net.sf.mpxj.primavera.common.ShortColumn;
import net.sf.mpxj.primavera.common.StringColumn;
import net.sf.mpxj.primavera.common.Table;
import net.sf.mpxj.primavera.common.TableDefinition;
import net.sf.mpxj.primavera.suretrak.AnnualColumn;
import net.sf.mpxj.primavera.suretrak.DateInDaysColumn;
import net.sf.mpxj.primavera.suretrak.DateInHoursColumn;
import net.sf.mpxj.primavera.suretrak.DurationColumn;
import net.sf.mpxj.primavera.suretrak.PercentColumn;
import net.sf.mpxj.primavera.suretrak.RawColumn;
import net.sf.mpxj.primavera.suretrak.RelationTypeColumn;
import net.sf.mpxj.primavera.suretrak.TableReader;

class DatabaseReader {
    private static final ColumnDefinition[] ACT_COLUMNS = new ColumnDefinition[]{new StringColumn("ACTIVITY_ID", 1, 10), new StringColumn("NAME", 11, 48), new StringColumn("DEPARTMENT", 59, 5), new StringColumn("MANAGER", 64, 8), new StringColumn("SECTION", 72, 4), new StringColumn("MAIL", 76, 8), new StringColumn("WBS", 123, 48), new PercentColumn("PERCENT_COMPLETE", 192), new DurationColumn("ORIGINAL_DURATION", 198), new DurationColumn("REMAINING_DURATION", 200), new DateInHoursColumn("EARLY_START", 202), new DateInHoursColumn("EARLY_FINISH", 206), new DateInHoursColumn("LATE_START", 210), new DateInHoursColumn("LATE_FINISH", 214), new DateInHoursColumn("ACTUAL_START", 234), new DateInHoursColumn("ACTUAL_FINISH", 238), new DateInHoursColumn("TARGET_START", 242), new DateInHoursColumn("TARGET_FINISH,", 246)};
    private static final ColumnDefinition[] CAL_COLUMNS = new ColumnDefinition[]{new ShortColumn("CALENDAR_ID", 1), new StringColumn("NAME", 3, 16), new IntColumn("SUNDAY_HOURS", 19), new IntColumn("MONDAY_HOURS", 23), new IntColumn("TUESDAY_HOURS", 27), new IntColumn("WEDNESDAY_HOURS", 31), new IntColumn("THURSDAY_HOURS", 35), new IntColumn("FRIDAY_HOURS", 39), new IntColumn("SATURDAY_HOURS", 43)};
    private static final ColumnDefinition[] DIR_COLUMNS = new ColumnDefinition[0];
    private static final ColumnDefinition[] FLT_COLUMNS = new ColumnDefinition[0];
    private static final ColumnDefinition[] HOL_COLUMNS = new ColumnDefinition[]{new ShortColumn("CALENDAR_ID", 1), new DateInDaysColumn("DATE", 3), new AnnualColumn("ANNUAL", 3)};
    private static final ColumnDefinition[] REL_COLUMNS = new ColumnDefinition[]{new StringColumn("PREDECESSOR_ACTIVITY_ID", 1, 10), new StringColumn("SUCCESSOR_ACTIVITY_ID", 11, 10), new RelationTypeColumn("TYPE", 21), new DurationColumn("LAG", 22)};
    private static final ColumnDefinition[] RES_COLUMNS = new ColumnDefinition[]{new StringColumn("ACTIVITY_ID", 1, 10), new StringColumn("RESOURCE_ID", 11, 8)};
    private static final ColumnDefinition[] RLB_COLUMNS = new ColumnDefinition[]{new StringColumn("CODE", 1, 8), new StringColumn("NAME", 9, 40), new ShortColumn("BASE_CALENDAR_ID", 99), new ShortColumn("CALENDAR_ID", 101)};
    private static final ColumnDefinition[] TTL_COLUMNS = new ColumnDefinition[]{new RawColumn("DATA", 0, 100), new StringColumn("TEXT1", 1, 48), new StringColumn("TEXT2", 49, 48), new ByteColumn("DEFINITION_ID", 97), new ShortColumn("ORDER", 98)};
    private static final Map<String, TableDefinition> TABLE_DEFINITIONS = new HashMap<String, TableDefinition>();

    DatabaseReader() {
    }

    public Map<String, Table> process(File directory, String prefix) throws IOException {
        String filePrefix = prefix.toUpperCase();
        HashMap<String, Table> tables = new HashMap<String, Table>();
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                int typeIndex;
                String type;
                TableDefinition definition;
                String name = file.getName().toUpperCase();
                if (!name.startsWith(filePrefix) || (definition = TABLE_DEFINITIONS.get(type = name.substring((typeIndex = name.lastIndexOf(46)) + 1, name.length()))) == null) continue;
                Table table = new Table();
                TableReader reader = new TableReader(definition);
                reader.read(file, table);
                tables.put(type, table);
            }
        }
        return tables;
    }

    static {
        TABLE_DEFINITIONS.put("ACT", new TableDefinition(0, 298, ACT_COLUMNS));
        TABLE_DEFINITIONS.put("CAL", new TableDefinition(0, 47, "CALENDAR_ID", null, CAL_COLUMNS));
        TABLE_DEFINITIONS.put("DIR", new TableDefinition(0, 565, DIR_COLUMNS));
        TABLE_DEFINITIONS.put("FLT", new TableDefinition(0, 137, FLT_COLUMNS));
        TABLE_DEFINITIONS.put("HOL", new TableDefinition(0, 11, HOL_COLUMNS));
        TABLE_DEFINITIONS.put("REL", new TableDefinition(0, 26, REL_COLUMNS));
        TABLE_DEFINITIONS.put("RES", new TableDefinition(0, 118, RES_COLUMNS));
        TABLE_DEFINITIONS.put("RLB", new TableDefinition(0, 111, RLB_COLUMNS));
        TABLE_DEFINITIONS.put("TTL", new TableDefinition(0, 100, TTL_COLUMNS));
    }
}

