/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.ActivityType;
import net.sf.mpxj.Availability;
import net.sf.mpxj.AvailabilityTable;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.CostAccount;
import net.sf.mpxj.CostRateTable;
import net.sf.mpxj.CostRateTableEntry;
import net.sf.mpxj.CriticalActivityType;
import net.sf.mpxj.CurrencySymbolPosition;
import net.sf.mpxj.CustomField;
import net.sf.mpxj.DataType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ExpenseCategory;
import net.sf.mpxj.ExpenseItem;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.FieldTypeClass;
import net.sf.mpxj.HtmlNotes;
import net.sf.mpxj.Notes;
import net.sf.mpxj.ParentNotes;
import net.sf.mpxj.PercentCompleteType;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.StructuredNotes;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.BooleanHelper;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.FieldTypeHelper;
import net.sf.mpxj.common.HtmlHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.primavera.DatatypeConverter;
import net.sf.mpxj.primavera.ObjectSequence;
import net.sf.mpxj.primavera.PrimaveraPMObjectSequences;
import net.sf.mpxj.primavera.UserFieldDataType;
import net.sf.mpxj.primavera.schema.APIBusinessObjects;
import net.sf.mpxj.primavera.schema.ActivityExpenseType;
import net.sf.mpxj.primavera.schema.ActivityNoteType;
import net.sf.mpxj.primavera.schema.BaselineProjectType;
import net.sf.mpxj.primavera.schema.CalendarType;
import net.sf.mpxj.primavera.schema.CostAccountType;
import net.sf.mpxj.primavera.schema.CurrencyType;
import net.sf.mpxj.primavera.schema.ExpenseCategoryType;
import net.sf.mpxj.primavera.schema.NotebookTopicType;
import net.sf.mpxj.primavera.schema.ObjectFactory;
import net.sf.mpxj.primavera.schema.ProjectNoteType;
import net.sf.mpxj.primavera.schema.ProjectType;
import net.sf.mpxj.primavera.schema.RelationshipType;
import net.sf.mpxj.primavera.schema.ResourceAssignmentType;
import net.sf.mpxj.primavera.schema.ResourceRateType;
import net.sf.mpxj.primavera.schema.UDFAssignmentType;
import net.sf.mpxj.primavera.schema.UDFTypeType;
import net.sf.mpxj.primavera.schema.WBSType;
import net.sf.mpxj.primavera.schema.WorkTimeType;

final class PrimaveraPMProjectWriter {
    private static final Integer NOTEBOOK_TOPIC_OBJECT_ID = 1;
    private static final String DEFAULT_PROJECT_ID = "PROJECT";
    private static final String RESOURCE_ID_PREFIX = "RESOURCE-";
    private static final String DEFAULT_WBS_CODE = "WBS";
    private static final Integer DEFAULT_CURRENCY_ID = 1;
    private static final String[] DAY_NAMES = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    private static final Map<RelationType, String> RELATION_TYPE_MAP = new HashMap<RelationType, String>();
    private static final Map<TaskType, String> DURATION_TYPE_MAP;
    private static final Map<ConstraintType, String> CONSTRAINT_TYPE_MAP;
    private static final Map<AccrueType, String> ACCRUE_TYPE_MAP;
    private static final Map<PercentCompleteType, String> PERCENT_COMPLETE_TYPE;
    private static final Map<ActivityType, String> ACTIVITY_TYPE_MAP;
    private static final Map<CriticalActivityType, String> CRITICAL_ACTIVITY_MAP;
    private final ProjectFile m_projectFile;
    private final APIBusinessObjects m_apibo;
    private final Integer m_projectObjectID;
    private final PrimaveraPMObjectSequences m_sequences;
    private ObjectFactory m_factory;
    private List<WBSType> m_wbs;
    private List<net.sf.mpxj.primavera.schema.ActivityType> m_activities;
    private List<ResourceAssignmentType> m_assignments;
    private List<RelationshipType> m_relationships;
    private List<ActivityExpenseType> m_expenses;
    private List<ProjectNoteType> m_projectNotes;
    private List<ActivityNoteType> m_activityNotes;
    private List<UDFAssignmentType> m_udf;
    private ObjectSequence m_wbsSequence;
    private List<CustomField> m_sortedCustomFieldsList;
    private Map<Integer, String> m_topics;
    private boolean m_activityTypePopulated;

    public PrimaveraPMProjectWriter(APIBusinessObjects apibo, ProjectFile projectFile, Integer projectObjectID, PrimaveraPMObjectSequences sequences) {
        this.m_projectFile = projectFile;
        this.m_apibo = apibo;
        this.m_projectObjectID = projectObjectID;
        this.m_sequences = sequences;
    }

    public void writeProject() {
        this.write(false);
    }

    public void writeBaseline() {
        this.write(true);
    }

    private void write(boolean baseline) {
        try {
            this.m_factory = new ObjectFactory();
            this.m_topics = new HashMap<Integer, String>();
            this.m_activityTypePopulated = this.m_projectFile.getTasks().getPopulatedFields().contains(TaskField.ACTIVITY_TYPE);
            this.m_wbsSequence = new ObjectSequence(0);
            if (baseline) {
                BaselineProjectType project = this.m_factory.createBaselineProjectType();
                this.m_apibo.getBaselineProject().add(project);
                this.m_wbs = project.getWBS();
                this.m_activities = project.getActivity();
                this.m_assignments = project.getResourceAssignment();
                this.m_relationships = project.getRelationship();
                this.m_expenses = project.getActivityExpense();
                this.m_projectNotes = project.getProjectNote();
                this.m_activityNotes = project.getActivityNote();
                this.m_udf = project.getUDF();
                this.writeProjectProperties(project);
                this.populateSortedCustomFieldsList();
                this.writeTasks();
                this.writeAssignments();
                this.writeExpenseItems();
            } else {
                ProjectType project = this.m_factory.createProjectType();
                this.m_apibo.getProject().add(project);
                this.m_wbs = project.getWBS();
                this.m_activities = project.getActivity();
                this.m_assignments = project.getResourceAssignment();
                this.m_relationships = project.getRelationship();
                this.m_expenses = project.getActivityExpense();
                this.m_projectNotes = project.getProjectNote();
                this.m_activityNotes = project.getActivityNote();
                this.m_udf = project.getUDF();
                this.writeProjectProperties(project);
                this.populateSortedCustomFieldsList();
                this.writeUDF();
                this.writeCurrency();
                this.writeUserFieldDefinitions();
                this.writeExpenseCategories();
                this.writeCostAccounts();
                this.writeCalendars();
                this.writeResources();
                this.writeResourceRates();
                this.writeTasks();
                this.writeAssignments();
                this.writeExpenseItems();
                this.writeTopics();
            }
        }
        finally {
            this.m_factory = null;
            this.m_wbsSequence = null;
            this.m_sortedCustomFieldsList = null;
            this.m_topics = null;
        }
    }

    private void writeUDF() {
        this.m_udf.addAll(this.writeUDFType(FieldTypeClass.PROJECT, this.m_projectFile.getProjectProperties()));
    }

    private void writeCurrency() {
        ProjectProperties props = this.m_projectFile.getProjectProperties();
        CurrencyType currency = this.m_factory.createCurrencyType();
        this.m_apibo.getCurrency().add(currency);
        String positiveSymbol = this.getCurrencyFormat(props.getSymbolPosition());
        String negativeSymbol = "(" + positiveSymbol + ")";
        currency.setDecimalPlaces(props.getCurrencyDigits());
        currency.setDecimalSymbol(this.getSymbolName(props.getDecimalSeparator()));
        currency.setDigitGroupingSymbol(this.getSymbolName(props.getThousandsSeparator()));
        currency.setExchangeRate(1.0);
        currency.setId("CUR");
        currency.setName("Default Currency");
        currency.setNegativeSymbol(negativeSymbol);
        currency.setObjectId(DEFAULT_CURRENCY_ID);
        currency.setPositiveSymbol(positiveSymbol);
        currency.setSymbol(props.getCurrencySymbol());
    }

    private String getSymbolName(char c) {
        String result = null;
        switch (c) {
            case ',': {
                result = "Comma";
                break;
            }
            case '.': {
                result = "Period";
            }
        }
        return result;
    }

    private String getCurrencyFormat(CurrencySymbolPosition position) {
        String result;
        switch (position) {
            case AFTER: {
                result = "1.1#";
                break;
            }
            case AFTER_WITH_SPACE: {
                result = "1.1 #";
                break;
            }
            case BEFORE_WITH_SPACE: {
                result = "# 1.1";
                break;
            }
            default: {
                result = "#1.1";
            }
        }
        return result;
    }

    private void writeUserFieldDefinitions() {
        for (CustomField cf : this.m_sortedCustomFieldsList) {
            UDFTypeType udf = this.m_factory.createUDFTypeType();
            udf.setObjectId(FieldTypeHelper.getFieldID(cf.getFieldType()));
            udf.setDataType(UserFieldDataType.inferUserFieldDataType(cf.getFieldType().getDataType()));
            udf.setSubjectArea(UserFieldDataType.inferUserFieldSubjectArea(cf.getFieldType()));
            udf.setTitle(cf.getAlias());
            this.m_apibo.getUDFType().add(udf);
        }
    }

    private void writeExpenseCategories() {
        List<ExpenseCategoryType> expenseCategories = this.m_apibo.getExpenseCategory();
        for (ExpenseCategory category : this.m_projectFile.getExpenseCategories()) {
            ExpenseCategoryType ect = this.m_factory.createExpenseCategoryType();
            ect.setObjectId(category.getUniqueID());
            ect.setName(category.getName());
            ect.setSequenceNumber(category.getSequence());
            expenseCategories.add(ect);
        }
    }

    private void writeCostAccounts() {
        List<CostAccountType> costAccounts = this.m_apibo.getCostAccount();
        for (CostAccount account : this.m_projectFile.getCostAccounts()) {
            CostAccountType cat = this.m_factory.createCostAccountType();
            cat.setObjectId(account.getUniqueID());
            cat.setId(account.getID());
            cat.setName(account.getName());
            cat.setDescription(account.getDescription());
            cat.setSequenceNumber(account.getSequence());
            if (account.getParent() != null) {
                cat.setParentObjectId(account.getParent().getUniqueID());
            }
            costAccounts.add(cat);
        }
    }

    private void writeProjectProperties(ProjectType project) {
        ProjectProperties mpxj = this.m_projectFile.getProjectProperties();
        String projectID = mpxj.getProjectID() == null ? DEFAULT_PROJECT_ID : mpxj.getProjectID();
        project.setActivityDefaultActivityType("Task Dependent");
        project.setActivityDefaultCalendarObjectId(this.getCalendarUniqueID(this.m_projectFile.getDefaultCalendar()));
        project.setActivityDefaultDurationType("Fixed Duration and Units");
        project.setActivityDefaultPercentCompleteType("Duration");
        project.setActivityDefaultPricePerUnit(NumberHelper.DOUBLE_ZERO);
        project.setActivityIdBasedOnSelectedActivity(Boolean.TRUE);
        project.setActivityIdIncrement(10);
        project.setActivityIdPrefix("A");
        project.setActivityIdSuffix(1000);
        project.setActivityPercentCompleteBasedOnActivitySteps(Boolean.FALSE);
        project.setAddActualToRemaining(Boolean.FALSE);
        project.setAllowNegativeActualUnitsFlag(Boolean.FALSE);
        project.setAssignmentDefaultDrivingFlag(Boolean.TRUE);
        project.setAssignmentDefaultRateType("Price / Unit");
        project.setCheckOutStatus(Boolean.FALSE);
        project.setCostQuantityRecalculateFlag(Boolean.FALSE);
        project.setCreateDate(mpxj.getCreationDate());
        project.setCriticalActivityFloatLimit(NumberHelper.DOUBLE_ZERO);
        project.setCriticalActivityPathType(CRITICAL_ACTIVITY_MAP.get((Object)mpxj.getCriticalActivityType()));
        project.setCurrentBaselineProjectObjectId(mpxj.getBaselineProjectUniqueID());
        project.setDataDate(this.m_projectFile.getProjectProperties().getStatusDate());
        project.setDefaultPriceTimeUnits("Hour");
        project.setDiscountApplicationPeriod("Month");
        project.setEarnedValueComputeType("Activity Percent Complete");
        project.setEarnedValueETCComputeType("ETC = Remaining Cost for Activity");
        project.setEarnedValueETCUserValue(0.88);
        project.setEarnedValueUserPercent(0.06);
        project.setEnableSummarization(Boolean.TRUE);
        project.setFiscalYearStartMonth(1);
        project.setFinishDate(mpxj.getFinishDate());
        project.setGUID(DatatypeConverter.printUUID(mpxj.getGUID()));
        project.setId(projectID);
        project.setLastUpdateDate(mpxj.getLastSaved());
        project.setLevelingPriority(10);
        project.setLinkActualToActualThisPeriod(Boolean.TRUE);
        project.setLinkPercentCompleteWithActual(Boolean.TRUE);
        project.setLinkPlannedAndAtCompletionFlag(Boolean.TRUE);
        project.setName(mpxj.getName() == null ? projectID : mpxj.getName());
        project.setObjectId(this.m_projectObjectID);
        project.setPlannedStartDate(mpxj.getStartDate());
        project.setPrimaryResourcesCanMarkActivitiesAsCompleted(Boolean.TRUE);
        project.setResetPlannedToRemainingFlag(Boolean.FALSE);
        project.setResourceCanBeAssignedToSameActivityMoreThanOnce(Boolean.TRUE);
        project.setResourcesCanAssignThemselvesToActivities(Boolean.TRUE);
        project.setResourcesCanEditAssignmentPercentComplete(Boolean.FALSE);
        project.setResourcesCanMarkAssignmentAsCompleted(Boolean.FALSE);
        project.setResourcesCanViewInactiveActivities(Boolean.FALSE);
        project.setRiskLevel("Medium");
        project.setStartDate(mpxj.getStartDate());
        project.setStatus("Active");
        project.setStrategicPriority(500);
        project.setSummarizeToWBSLevel(2);
        project.setSummaryLevel("Assignment Level");
        project.setUseProjectBaselineForEarnedValue(Boolean.TRUE);
        project.setWBSCodeSeparator(".");
    }

    private void writeProjectProperties(BaselineProjectType project) {
        ProjectProperties mpxj = this.m_projectFile.getProjectProperties();
        String projectID = mpxj.getProjectID() == null ? DEFAULT_PROJECT_ID : mpxj.getProjectID();
        project.setActivityDefaultActivityType("Task Dependent");
        project.setActivityDefaultCalendarObjectId(this.getCalendarUniqueID(this.m_projectFile.getDefaultCalendar()));
        project.setActivityDefaultDurationType("Fixed Duration and Units");
        project.setActivityDefaultPercentCompleteType("Duration");
        project.setActivityDefaultPricePerUnit(NumberHelper.DOUBLE_ZERO);
        project.setActivityIdBasedOnSelectedActivity(Boolean.TRUE);
        project.setActivityIdIncrement(10);
        project.setActivityIdPrefix("A");
        project.setActivityIdSuffix(1000);
        project.setActivityPercentCompleteBasedOnActivitySteps(Boolean.FALSE);
        project.setAddActualToRemaining(Boolean.FALSE);
        project.setAssignmentDefaultDrivingFlag(Boolean.TRUE);
        project.setAssignmentDefaultRateType("Price / Unit");
        project.setCheckOutStatus(Boolean.FALSE);
        project.setCostQuantityRecalculateFlag(Boolean.FALSE);
        project.setCreateDate(mpxj.getCreationDate());
        project.setCriticalActivityFloatLimit(NumberHelper.DOUBLE_ZERO);
        project.setCriticalActivityPathType("Critical Float");
        project.setDataDate(this.m_projectFile.getProjectProperties().getStatusDate());
        project.setDefaultPriceTimeUnits("Hour");
        project.setDiscountApplicationPeriod("Month");
        project.setEnableSummarization(Boolean.TRUE);
        project.setFiscalYearStartMonth(1);
        project.setFinishDate(mpxj.getFinishDate());
        project.setGUID(DatatypeConverter.printUUID(mpxj.getGUID()));
        project.setId(projectID);
        project.setLastUpdateDate(mpxj.getLastSaved());
        project.setLevelingPriority(10);
        project.setLinkActualToActualThisPeriod(Boolean.TRUE);
        project.setLinkPercentCompleteWithActual(Boolean.TRUE);
        project.setLinkPlannedAndAtCompletionFlag(Boolean.TRUE);
        project.setName(mpxj.getName() == null ? projectID : mpxj.getName());
        project.setObjectId(this.m_projectObjectID);
        project.setPlannedStartDate(mpxj.getStartDate());
        project.setPrimaryResourcesCanMarkActivitiesAsCompleted(Boolean.TRUE);
        project.setResetPlannedToRemainingFlag(Boolean.FALSE);
        project.setResourceCanBeAssignedToSameActivityMoreThanOnce(Boolean.TRUE);
        project.setResourcesCanAssignThemselvesToActivities(Boolean.TRUE);
        project.setResourcesCanEditAssignmentPercentComplete(Boolean.FALSE);
        project.setRiskLevel("Medium");
        project.setStartDate(mpxj.getStartDate());
        project.setStatus("Active");
        project.setStrategicPriority(500);
        project.setSummarizeToWBSLevel(2);
        project.setWBSCodeSeparator(".");
    }

    private void writeCalendars() {
        for (ProjectCalendar calendar : this.m_projectFile.getCalendars()) {
            this.writeCalendar(calendar);
        }
    }

    private void writeCalendar(ProjectCalendar mpxj) {
        CalendarType xml = this.m_factory.createCalendarType();
        this.m_apibo.getCalendar().add(xml);
        String type = mpxj.getResource() == null ? "Global" : "Resource";
        xml.setBaseCalendarObjectId(this.getCalendarUniqueID(mpxj.getParent()));
        xml.setIsDefault(mpxj == this.m_projectFile.getDefaultCalendar());
        xml.setIsPersonal(mpxj.getResource() == null ? Boolean.FALSE : Boolean.TRUE);
        xml.setName(mpxj.getName());
        xml.setObjectId(mpxj.getUniqueID());
        xml.setType(type);
        xml.setHoursPerDay((double)mpxj.getMinutesPerDay() / 60.0);
        xml.setHoursPerWeek((double)mpxj.getMinutesPerWeek() / 60.0);
        xml.setHoursPerMonth((double)mpxj.getMinutesPerMonth() / 60.0);
        xml.setHoursPerYear((double)mpxj.getMinutesPerYear() / 60.0);
        CalendarType.StandardWorkWeek xmlStandardWorkWeek = this.m_factory.createCalendarTypeStandardWorkWeek();
        xml.setStandardWorkWeek(xmlStandardWorkWeek);
        for (Day day : EnumSet.allOf(Day.class)) {
            CalendarType.StandardWorkWeek.StandardWorkHours xmlHours = this.m_factory.createCalendarTypeStandardWorkWeekStandardWorkHours();
            xmlStandardWorkWeek.getStandardWorkHours().add(xmlHours);
            xmlHours.setDayOfWeek(this.getDayName(day));
            for (DateRange range : mpxj.getHours(day)) {
                WorkTimeType xmlWorkTime = this.m_factory.createWorkTimeType();
                xmlHours.getWorkTime().add(xmlWorkTime);
                xmlWorkTime.setStart(range.getStart());
                xmlWorkTime.setFinish(this.getEndTime(range.getEnd()));
            }
        }
        CalendarType.HolidayOrExceptions xmlExceptions = this.m_factory.createCalendarTypeHolidayOrExceptions();
        xml.setHolidayOrExceptions(xmlExceptions);
        if (!mpxj.getCalendarExceptions().isEmpty()) {
            Calendar calendar = DateHelper.popCalendar();
            for (ProjectCalendarException mpxjException : mpxj.getCalendarExceptions()) {
                calendar.setTime(mpxjException.getFromDate());
                while (calendar.getTimeInMillis() < mpxjException.getToDate().getTime()) {
                    CalendarType.HolidayOrExceptions.HolidayOrException xmlException = this.m_factory.createCalendarTypeHolidayOrExceptionsHolidayOrException();
                    xmlExceptions.getHolidayOrException().add(xmlException);
                    xmlException.setDate(calendar.getTime());
                    for (DateRange range : mpxjException) {
                        WorkTimeType xmlHours = this.m_factory.createWorkTimeType();
                        xmlException.getWorkTime().add(xmlHours);
                        xmlHours.setStart(range.getStart());
                        if (range.getEnd() == null) continue;
                        xmlHours.setFinish(this.getEndTime(range.getEnd()));
                    }
                    calendar.add(6, 1);
                }
            }
            DateHelper.pushCalendar(calendar);
        }
    }

    private void writeResources() {
        for (Resource resource : this.m_projectFile.getResources()) {
            if (resource.getUniqueID() == 0) continue;
            this.writeResource(resource);
        }
    }

    private void writeResource(Resource mpxj) {
        net.sf.mpxj.primavera.schema.ResourceType xml = this.m_factory.createResourceType();
        this.m_apibo.getResource().add(xml);
        xml.setAutoComputeActuals(Boolean.TRUE);
        xml.setCalculateCostFromUnits(Boolean.TRUE);
        xml.setCalendarObjectId(this.getCalendarUniqueID(mpxj.getResourceCalendar()));
        xml.setCurrencyObjectId(DEFAULT_CURRENCY_ID);
        xml.setDefaultUnitsPerTime(1.0);
        xml.setEmailAddress(mpxj.getEmailAddress());
        xml.setEmployeeId(mpxj.getCode());
        xml.setGUID(DatatypeConverter.printUUID(mpxj.getGUID()));
        xml.setId(this.getResourceID(mpxj));
        xml.setIsActive(Boolean.TRUE);
        xml.setMaxUnitsPerTime(this.getPercentage(mpxj.getMaxUnits()));
        xml.setName(mpxj.getName());
        xml.setObjectId(mpxj.getUniqueID());
        xml.setParentObjectId(mpxj.getParentID());
        xml.setResourceNotes(this.getResourceNotes(mpxj.getNotesObject()));
        xml.setResourceType(this.getResourceType(mpxj));
        xml.getUDF().addAll(this.writeUDFType(FieldTypeClass.RESOURCE, mpxj));
    }

    private String getResourceNotes(Notes notes) {
        String result = notes == null || notes.isEmpty() ? "" : (notes instanceof HtmlNotes ? ((HtmlNotes)notes).getHtml() : HtmlHelper.getHtmlFromPlainText(notes.toString()));
        return result;
    }

    private void writeTasks() {
        Map<Task, Integer> wbsSequence = this.m_projectFile.getTasks().stream().filter(t -> t.getSummary() || this.m_activityTypePopulated && t.getActivityType() == null).collect(Collectors.toMap(t -> t, t -> this.m_wbsSequence.getNext()));
        ArrayList<Task> tasks = new ArrayList<Task>(this.m_projectFile.getTasks());
        Collections.sort(tasks, (t1, t2) -> NumberHelper.compare(t1.getUniqueID(), t2.getUniqueID()));
        tasks.forEach(t -> this.writeTask((Task)t, (Integer)wbsSequence.get(t)));
    }

    private void writeTask(Task task, Integer wbsSequence) {
        if (!task.getNull()) {
            if (wbsSequence != null) {
                this.writeWBS(task, wbsSequence);
            } else {
                this.writeActivity(task);
            }
        }
    }

    private void writeWBS(Task mpxj, Integer sequence) {
        if (mpxj.getUniqueID() != 0) {
            WBSType xml = this.m_factory.createWBSType();
            this.m_wbs.add(xml);
            Task parentTask = mpxj.getParentTask();
            Integer parentObjectID = parentTask == null ? null : parentTask.getUniqueID();
            xml.setCode(this.getWbsCode(mpxj));
            xml.setGUID(DatatypeConverter.printUUID(mpxj.getGUID()));
            xml.setName(mpxj.getName());
            xml.setObjectId(mpxj.getUniqueID());
            xml.setParentObjectId(parentObjectID);
            xml.setProjectObjectId(this.m_projectObjectID);
            xml.setSequenceNumber(sequence);
            xml.setStatus("Active");
            this.writeWbsNote(mpxj);
        }
    }

    private String getWbsCode(Task task) {
        String code = task.getWBS();
        if (code == null || code.length() == 0) {
            code = DEFAULT_WBS_CODE;
        } else {
            String prefix = null;
            if (task.getParentTask() == null && this.m_projectFile.getProjectProperties().getProjectID() != null) {
                prefix = this.m_projectFile.getProjectProperties().getProjectID() + ".";
            } else if (task.getParentTask() != null) {
                prefix = task.getParentTask().getWBS() + ".";
            }
            if (prefix != null && code.startsWith(prefix)) {
                code = code.substring(prefix.length());
            }
        }
        return code;
    }

    private void writeActivity(Task mpxj) {
        net.sf.mpxj.primavera.schema.ActivityType xml = this.m_factory.createActivityType();
        this.m_activities.add(xml);
        Task parentTask = mpxj.getParentTask();
        Integer parentObjectID = parentTask == null ? null : parentTask.getUniqueID();
        Date plannedStart = mpxj.getPlannedStart() == null ? mpxj.getStart() : mpxj.getPlannedStart();
        Date plannedFinish = mpxj.getPlannedFinish() == null ? mpxj.getFinish() : mpxj.getPlannedFinish();
        xml.setActualStartDate(mpxj.getActualStart());
        xml.setActualDuration(this.getDuration(mpxj.getActualDuration()));
        xml.setActualFinishDate(mpxj.getActualFinish());
        xml.setAtCompletionDuration(this.getDuration(mpxj.getDuration()));
        xml.setCalendarObjectId(this.getCalendarUniqueID(mpxj.getCalendar()));
        xml.setDurationPercentComplete(this.getPercentage(mpxj.getPercentageComplete()));
        xml.setDurationType(DURATION_TYPE_MAP.get(mpxj.getType()));
        xml.setFinishDate(mpxj.getFinish());
        xml.setGUID(DatatypeConverter.printUUID(mpxj.getGUID()));
        xml.setId(mpxj.getActivityID() == null ? mpxj.getWBS() : mpxj.getActivityID());
        xml.setName(mpxj.getName());
        xml.setObjectId(mpxj.getUniqueID());
        xml.setPercentCompleteType(this.getPercentCompleteType(mpxj.getPercentCompleteType()));
        xml.setPercentComplete(this.getPercentComplete(mpxj));
        xml.setPhysicalPercentComplete(this.getPercentage(mpxj.getPhysicalPercentComplete()));
        xml.setPrimaryConstraintType(CONSTRAINT_TYPE_MAP.get(mpxj.getConstraintType()));
        xml.setPrimaryConstraintDate(mpxj.getConstraintDate());
        xml.setPrimaryResourceObjectId(mpxj.getPrimaryResourceID());
        xml.setPlannedDuration(this.getDuration(mpxj.getPlannedDuration() == null ? mpxj.getDuration() : mpxj.getPlannedDuration()));
        xml.setPlannedFinishDate(plannedFinish);
        xml.setPlannedStartDate(plannedStart);
        xml.setProjectObjectId(this.m_projectObjectID);
        xml.setRemainingDuration(this.getDuration(mpxj.getRemainingDuration()));
        xml.setRemainingEarlyFinishDate(mpxj.getRemainingEarlyFinish());
        xml.setRemainingEarlyStartDate(mpxj.getRemainingEarlyStart());
        xml.setRemainingLateFinishDate(mpxj.getRemainingLateFinish());
        xml.setRemainingLateStartDate(mpxj.getRemainingLateStart());
        xml.setRemainingLaborCost(NumberHelper.DOUBLE_ZERO);
        xml.setRemainingLaborUnits(NumberHelper.DOUBLE_ZERO);
        xml.setRemainingNonLaborCost(NumberHelper.DOUBLE_ZERO);
        xml.setRemainingNonLaborUnits(NumberHelper.DOUBLE_ZERO);
        if (mpxj.getSuspendDate() != null) {
            xml.setResumeDate(mpxj.getResume());
        }
        xml.setStartDate(mpxj.getStart());
        xml.setStatus(this.getActivityStatus(mpxj));
        xml.setSuspendDate(mpxj.getSuspendDate());
        xml.setType(this.getTaskType(mpxj));
        xml.setUnitsPercentComplete(this.getPercentage(mpxj.getPercentageWorkComplete()));
        xml.setWBSObjectId(parentObjectID);
        xml.getUDF().addAll(this.writeUDFType(FieldTypeClass.TASK, mpxj));
        this.writeActivityNote(mpxj);
        this.writePredecessors(mpxj);
    }

    private String getTaskType(Task task) {
        return task.getActivityType() == null ? "Resource Dependent" : ACTIVITY_TYPE_MAP.get((Object)task.getActivityType());
    }

    private void writeAssignments() {
        ArrayList assignments = new ArrayList();
        this.m_projectFile.getTasks().forEach(t -> assignments.addAll(t.getResourceAssignments()));
        for (ResourceAssignment assignment : assignments) {
            Task task;
            Resource resource = assignment.getResource();
            if (resource == null || (task = assignment.getTask()) == null || task.getUniqueID() == 0 || task.getSummary()) continue;
            this.writeAssignment(assignment);
        }
    }

    private void writeAssignment(ResourceAssignment mpxj) {
        ResourceAssignmentType xml = this.m_factory.createResourceAssignmentType();
        this.m_assignments.add(xml);
        Task task = mpxj.getTask();
        Task parentTask = task.getParentTask();
        Integer parentTaskUniqueID = parentTask == null ? null : parentTask.getUniqueID();
        xml.setActivityObjectId(mpxj.getTaskUniqueID());
        xml.setActualCost(this.getDouble(mpxj.getActualCost()));
        xml.setActualFinishDate(mpxj.getActualFinish());
        xml.setActualOvertimeCost(this.getDouble(mpxj.getActualOvertimeCost()));
        xml.setActualOvertimeUnits(this.getDuration(mpxj.getActualOvertimeWork()));
        xml.setActualRegularUnits(this.getDuration(mpxj.getActualWork()));
        xml.setActualStartDate(mpxj.getActualStart());
        xml.setActualUnits(this.getDuration(mpxj.getActualWork()));
        xml.setAtCompletionCost(NumberHelper.sumAsDouble(mpxj.getActualCost(), mpxj.getRemainingCost()));
        xml.setAtCompletionUnits(this.getDuration(Duration.add(mpxj.getActualWork(), mpxj.getRemainingWork(), this.m_projectFile.getProjectProperties())));
        xml.setFinishDate(mpxj.getFinish());
        xml.setGUID(DatatypeConverter.printUUID(mpxj.getGUID()));
        xml.setObjectId(mpxj.getUniqueID());
        xml.setPlannedCost(this.getDouble(mpxj.getPlannedCost()));
        xml.setPlannedFinishDate(mpxj.getPlannedFinish());
        xml.setPlannedStartDate(mpxj.getPlannedStart());
        xml.setPlannedUnits(this.getDuration(mpxj.getPlannedWork()));
        xml.setPlannedUnitsPerTime(this.getPercentage(mpxj.getUnits()));
        xml.setProjectObjectId(this.m_projectObjectID);
        xml.setRateSource("Resource");
        xml.setRemainingCost(this.getDouble(mpxj.getRemainingCost()));
        xml.setRemainingDuration(this.getDuration(mpxj.getRemainingWork()));
        xml.setRemainingUnits(this.getDuration(mpxj.getRemainingWork()));
        xml.setRemainingUnitsPerTime(this.getPercentage(mpxj.getUnits()));
        xml.setResourceObjectId(mpxj.getResourceUniqueID());
        xml.setStartDate(mpxj.getStart());
        xml.setWBSObjectId(parentTaskUniqueID);
        xml.getUDF().addAll(this.writeUDFType(FieldTypeClass.ASSIGNMENT, mpxj));
    }

    private void writePredecessors(Task task) {
        List<Relation> relations = task.getPredecessors();
        for (Relation mpxj : relations) {
            RelationshipType xml = this.m_factory.createRelationshipType();
            this.m_relationships.add(xml);
            xml.setLag(this.getDuration(mpxj.getLag()));
            xml.setObjectId(this.m_sequences.getRelationshipObjectID());
            xml.setPredecessorActivityObjectId(mpxj.getTargetTask().getUniqueID());
            xml.setSuccessorActivityObjectId(mpxj.getSourceTask().getUniqueID());
            xml.setPredecessorProjectObjectId(this.m_projectObjectID);
            xml.setSuccessorProjectObjectId(this.m_projectObjectID);
            xml.setType(RELATION_TYPE_MAP.get(mpxj.getType()));
        }
    }

    private void writeExpenseItems() {
        ArrayList<Task> tasks = new ArrayList<Task>(this.m_projectFile.getTasks());
        Collections.sort(tasks, (t1, t2) -> NumberHelper.compare(t1.getUniqueID(), t2.getUniqueID()));
        tasks.forEach(t -> this.writeExpenseItems((Task)t));
    }

    private void writeExpenseItems(Task task) {
        List<ExpenseItem> items = task.getExpenseItems();
        if (items != null && !items.isEmpty()) {
            ArrayList<ExpenseItem> expenseItems = new ArrayList<ExpenseItem>(items);
            expenseItems.sort((i1, i2) -> NumberHelper.compare(i1.getUniqueID(), i2.getUniqueID()));
            Integer parentObjectID = task.getParentTask() == null ? null : task.getParentTask().getUniqueID();
            for (ExpenseItem item : expenseItems) {
                ActivityExpenseType expense = this.m_factory.createActivityExpenseType();
                this.m_expenses.add(expense);
                expense.setAccrualType(ACCRUE_TYPE_MAP.get(item.getAccrueType()));
                expense.setActivityObjectId(task.getUniqueID());
                expense.setActualCost(item.getActualCost());
                expense.setActualUnits(item.getActualUnits());
                expense.setAutoComputeActuals(item.getAutoComputeActuals());
                if (item.getAccount() != null) {
                    expense.setCostAccountObjectId(item.getAccount().getUniqueID());
                }
                expense.setDocumentNumber(item.getDocumentNumber());
                if (item.getCategory() != null) {
                    expense.setExpenseCategoryObjectId(item.getCategory().getUniqueID());
                }
                expense.setExpenseDescription(item.getDescription());
                expense.setExpenseItem(item.getName());
                expense.setObjectId(item.getUniqueID());
                expense.setPlannedCost(item.getPlannedCost());
                expense.setPlannedUnits(item.getPlannedUnits());
                expense.setPricePerUnit(item.getPricePerUnit());
                expense.setProjectObjectId(this.m_projectObjectID);
                expense.setRemainingCost(item.getRemainingCost());
                expense.setRemainingUnits(item.getRemainingUnits());
                expense.setUnitOfMeasure(item.getUnitOfMeasure());
                expense.setVendor(item.getVendor());
                expense.setWBSObjectId(parentObjectID);
            }
        }
    }

    private void writeResourceRates() {
        this.m_projectFile.getResources().forEach(r -> this.writeResourceRates((Resource)r));
    }

    private void writeResourceRates(Resource resource) {
        CostRateTable table = resource.getCostRateTable(0);
        AvailabilityTable availabilityTable = resource.getAvailability();
        if (table != null) {
            for (CostRateTableEntry entry : table) {
                if (!this.costRateTableWriteRequired(entry)) continue;
                Availability availability = availabilityTable.getEntryByDate(entry.getStartDate());
                Double maxUnits = availability == null ? Double.valueOf(1.0) : Double.valueOf(availability.getUnits().doubleValue() / 100.0);
                ResourceRateType rate = this.m_factory.createResourceRateType();
                this.m_apibo.getResourceRate().add(rate);
                rate.setEffectiveDate(entry.getStartDate());
                rate.setMaxUnitsPerTime(maxUnits);
                rate.setObjectId(this.m_sequences.getRateObjectID());
                rate.setPricePerUnit(entry.getStandardRate().getAmount());
                rate.setResourceObjectId(resource.getUniqueID());
            }
        }
    }

    private boolean costRateTableWriteRequired(CostRateTableEntry entry) {
        boolean fromDate = DateHelper.compare(entry.getStartDate(), DateHelper.START_DATE_NA) > 0;
        boolean toDate = DateHelper.compare(entry.getEndDate(), DateHelper.END_DATE_NA) > 0;
        boolean overtimeRate = entry.getOvertimeRate() != null && entry.getOvertimeRate().getAmount() != 0.0;
        boolean standardRate = entry.getStandardRate() != null && entry.getStandardRate().getAmount() != 0.0;
        return fromDate || toDate || overtimeRate || standardRate;
    }

    private void writeTopics() {
        int sequenceNumber = 1;
        for (Map.Entry<Integer, String> entry : this.m_topics.entrySet()) {
            NotebookTopicType topic = this.m_factory.createNotebookTopicType();
            this.m_apibo.getNotebookTopic().add(topic);
            topic.setAvailableForActivity(Boolean.TRUE);
            topic.setAvailableForWBS(Boolean.TRUE);
            topic.setName(entry.getValue());
            topic.setObjectId(entry.getKey());
            topic.setSequenceNumber(sequenceNumber++);
        }
    }

    private void writeWbsNote(Task task) {
        String notes = task.getNotes();
        if (notes.isEmpty()) {
            return;
        }
        if (this.notesAreNativeFormat(task.getNotesObject())) {
            this.writeNativeWbsNote(task);
        } else {
            this.writeDefaultWbsNote(task);
        }
    }

    private void writeDefaultWbsNote(Task task) {
        ProjectNoteType xml = this.m_factory.createProjectNoteType();
        this.m_projectNotes.add(xml);
        this.m_topics.put(NOTEBOOK_TOPIC_OBJECT_ID, "Notes");
        xml.setNote(HtmlHelper.getHtmlFromPlainText(task.getNotes()));
        xml.setNotebookTopicObjectId(NOTEBOOK_TOPIC_OBJECT_ID);
        xml.setObjectId(this.m_sequences.getWbsNoteObjectID());
        xml.setProjectObjectId(this.m_projectObjectID);
        xml.setWBSObjectId(task.getUniqueID());
    }

    private void writeNativeWbsNote(Task task) {
        for (Notes note : ((ParentNotes)task.getNotesObject()).getChildNotes()) {
            StructuredNotes structuredNotes = (StructuredNotes)note;
            HtmlNotes htmlNotes = (HtmlNotes)structuredNotes.getNotes();
            ProjectNoteType xml = this.m_factory.createProjectNoteType();
            this.m_projectNotes.add(xml);
            this.m_topics.put(structuredNotes.getTopicID(), structuredNotes.getTopicName());
            xml.setNote(htmlNotes.getHtml());
            xml.setNotebookTopicObjectId(structuredNotes.getTopicID());
            xml.setObjectId(this.m_sequences.getWbsNoteObjectID());
            xml.setProjectObjectId(this.m_projectObjectID);
            xml.setWBSObjectId(task.getUniqueID());
        }
    }

    private void writeActivityNote(Task task) {
        String notes = task.getNotes();
        if (notes.isEmpty()) {
            return;
        }
        if (this.notesAreNativeFormat(task.getNotesObject())) {
            this.writeNativeActivityNote(task);
        } else {
            this.writeDefaultActivityNote(task);
        }
    }

    private void writeDefaultActivityNote(Task task) {
        ActivityNoteType xml = this.m_factory.createActivityNoteType();
        this.m_activityNotes.add(xml);
        this.m_topics.put(NOTEBOOK_TOPIC_OBJECT_ID, "Notes");
        xml.setNote(HtmlHelper.getHtmlFromPlainText(task.getNotes()));
        xml.setNotebookTopicObjectId(NOTEBOOK_TOPIC_OBJECT_ID);
        xml.setObjectId(this.m_sequences.getActivityNoteObjectID());
        xml.setProjectObjectId(this.m_projectObjectID);
        xml.setActivityObjectId(task.getUniqueID());
    }

    private void writeNativeActivityNote(Task task) {
        for (Notes note : ((ParentNotes)task.getNotesObject()).getChildNotes()) {
            StructuredNotes structuredNotes = (StructuredNotes)note;
            HtmlNotes htmlNotes = (HtmlNotes)structuredNotes.getNotes();
            ActivityNoteType xml = this.m_factory.createActivityNoteType();
            this.m_activityNotes.add(xml);
            this.m_topics.put(structuredNotes.getTopicID(), structuredNotes.getTopicName());
            xml.setNote(htmlNotes.getHtml());
            xml.setNotebookTopicObjectId(structuredNotes.getTopicID());
            xml.setObjectId(this.m_sequences.getActivityNoteObjectID());
            xml.setProjectObjectId(this.m_projectObjectID);
            xml.setActivityObjectId(task.getUniqueID());
        }
    }

    private boolean notesAreNativeFormat(Notes notes) {
        return notes instanceof ParentNotes && ((ParentNotes)notes).getChildNotes().stream().allMatch(n -> n instanceof StructuredNotes && ((StructuredNotes)n).getNotes() instanceof HtmlNotes);
    }

    private List<UDFAssignmentType> writeUDFType(FieldTypeClass type, FieldContainer mpxj) {
        ArrayList<UDFAssignmentType> out = new ArrayList<UDFAssignmentType>();
        for (CustomField cf : this.m_sortedCustomFieldsList) {
            Object value;
            FieldType fieldType = cf.getFieldType();
            if (type != fieldType.getFieldTypeClass() || !FieldTypeHelper.valueIsNotDefault(fieldType, value = mpxj.getCachedValue(fieldType))) continue;
            UDFAssignmentType udf = this.m_factory.createUDFAssignmentType();
            udf.setTypeObjectId(FieldTypeHelper.getFieldID(fieldType));
            this.setUserFieldValue(udf, fieldType.getDataType(), value);
            out.add(udf);
        }
        return out;
    }

    private void setUserFieldValue(UDFAssignmentType udf, DataType dataType, Object value) {
        switch (dataType) {
            case DURATION: {
                udf.setTextValue(((Duration)value).toString());
                break;
            }
            case CURRENCY: {
                if (!(value instanceof Double)) {
                    value = ((Number)value).doubleValue();
                }
                udf.setCostValue((Double)value);
                break;
            }
            case BINARY: {
                udf.setTextValue("");
                break;
            }
            case STRING: {
                udf.setTextValue((String)value);
                break;
            }
            case DATE: {
                udf.setStartDateValue((Date)value);
                break;
            }
            case NUMERIC: {
                if (!(value instanceof Double)) {
                    value = ((Number)value).doubleValue();
                }
                udf.setDoubleValue((Double)value);
                break;
            }
            case BOOLEAN: {
                udf.setIntegerValue(BooleanHelper.getBoolean((Boolean)value) ? Integer.valueOf(1) : Integer.valueOf(0));
                break;
            }
            case INTEGER: 
            case SHORT: {
                udf.setIntegerValue(NumberHelper.getInteger((Number)value));
                break;
            }
            default: {
                throw new RuntimeException("Unconvertible data type: " + dataType);
            }
        }
    }

    private Double getDuration(Duration duration) {
        Double result;
        if (duration == null) {
            result = null;
        } else {
            if (duration.getUnits() != TimeUnit.HOURS) {
                duration = duration.convertUnits(TimeUnit.HOURS, this.m_projectFile.getProjectProperties());
            }
            result = duration.getDuration();
        }
        return result;
    }

    private String getDayName(Day day) {
        return DAY_NAMES[day.getValue() - 1];
    }

    private String getResourceType(Resource resource) {
        String result;
        ResourceType type = resource.getType();
        if (type == null) {
            type = ResourceType.WORK;
        }
        switch (type) {
            case MATERIAL: {
                result = "Material";
                break;
            }
            case COST: {
                result = "Nonlabor";
                break;
            }
            default: {
                result = "Labor";
            }
        }
        return result;
    }

    private Double getPercentage(Number number) {
        Double result = null;
        if (number != null) {
            result = number.doubleValue() / 100.0;
        }
        return result;
    }

    private String getPercentCompleteType(PercentCompleteType value) {
        return PERCENT_COMPLETE_TYPE.get((Object)(value == null ? PercentCompleteType.DURATION : value));
    }

    private Double getPercentComplete(Task task) {
        Number result;
        PercentCompleteType type = task.getPercentCompleteType();
        if (type == null) {
            type = PercentCompleteType.DURATION;
        }
        switch (type) {
            case PHYSICAL: {
                result = task.getPhysicalPercentComplete();
                break;
            }
            case UNITS: {
                result = task.getPercentageWorkComplete();
                break;
            }
            default: {
                result = task.getPercentageComplete();
            }
        }
        return this.getPercentage(result);
    }

    private Double getDouble(Number number) {
        Double result = null;
        if (number != null) {
            result = number.doubleValue();
        }
        return result;
    }

    private Date getEndTime(Date date) {
        return new Date(date.getTime() - 60000L);
    }

    private Integer getCalendarUniqueID(ProjectCalendar calendar) {
        return calendar == null ? null : calendar.getUniqueID();
    }

    private String getActivityStatus(Task mpxj) {
        String result = mpxj.getActualStart() == null ? "Not Started" : (mpxj.getActualFinish() == null ? "In Progress" : "Completed");
        return result;
    }

    private String getResourceID(Resource resource) {
        String result = resource.getResourceID();
        if (result == null) {
            result = RESOURCE_ID_PREFIX + resource.getUniqueID();
        }
        return result;
    }

    private void populateSortedCustomFieldsList() {
        this.m_sortedCustomFieldsList = new ArrayList<CustomField>();
        for (CustomField field : this.m_projectFile.getCustomFields()) {
            FieldType fieldType = field.getFieldType();
            if (fieldType == null || fieldType.getDataType() == null) continue;
            this.m_sortedCustomFieldsList.add(field);
        }
        Collections.sort(this.m_sortedCustomFieldsList, new Comparator<CustomField>(){

            @Override
            public int compare(CustomField customField1, CustomField customField2) {
                FieldType o1 = customField1.getFieldType();
                FieldType o2 = customField2.getFieldType();
                String name1 = o1.getClass().getSimpleName() + "." + o1.getName() + " " + customField1.getAlias();
                String name2 = o2.getClass().getSimpleName() + "." + o2.getName() + " " + customField2.getAlias();
                return name1.compareTo(name2);
            }
        });
    }

    ProjectFile getProjectFile() {
        return this.m_projectFile;
    }

    static {
        RELATION_TYPE_MAP.put(RelationType.FINISH_START, "Finish to Start");
        RELATION_TYPE_MAP.put(RelationType.FINISH_FINISH, "Finish to Finish");
        RELATION_TYPE_MAP.put(RelationType.START_START, "Start to Start");
        RELATION_TYPE_MAP.put(RelationType.START_FINISH, "Start to Finish");
        DURATION_TYPE_MAP = new HashMap<TaskType, String>();
        DURATION_TYPE_MAP.put(TaskType.FIXED_DURATION, "Fixed Duration and Units/Time");
        DURATION_TYPE_MAP.put(TaskType.FIXED_UNITS, "Fixed Units");
        DURATION_TYPE_MAP.put(TaskType.FIXED_WORK, "Fixed Duration and Units");
        CONSTRAINT_TYPE_MAP = new HashMap<ConstraintType, String>();
        CONSTRAINT_TYPE_MAP.put(ConstraintType.START_ON, "Start On");
        CONSTRAINT_TYPE_MAP.put(ConstraintType.START_NO_LATER_THAN, "Start On or Before");
        CONSTRAINT_TYPE_MAP.put(ConstraintType.START_NO_EARLIER_THAN, "Start On or After");
        CONSTRAINT_TYPE_MAP.put(ConstraintType.FINISH_ON, "Finish On");
        CONSTRAINT_TYPE_MAP.put(ConstraintType.FINISH_NO_LATER_THAN, "Finish On or Before");
        CONSTRAINT_TYPE_MAP.put(ConstraintType.FINISH_NO_EARLIER_THAN, "Finish On or After");
        CONSTRAINT_TYPE_MAP.put(ConstraintType.AS_LATE_AS_POSSIBLE, "As Late As Possible");
        CONSTRAINT_TYPE_MAP.put(ConstraintType.MUST_START_ON, "Mandatory Start");
        CONSTRAINT_TYPE_MAP.put(ConstraintType.MUST_FINISH_ON, "Mandatory Finish");
        ACCRUE_TYPE_MAP = new HashMap<AccrueType, String>();
        ACCRUE_TYPE_MAP.put(AccrueType.PRORATED, "Uniform Over Activity");
        ACCRUE_TYPE_MAP.put(AccrueType.END, "End of Activity");
        ACCRUE_TYPE_MAP.put(AccrueType.START, "Start of Activity");
        PERCENT_COMPLETE_TYPE = new HashMap<PercentCompleteType, String>();
        PERCENT_COMPLETE_TYPE.put(PercentCompleteType.PHYSICAL, "Physical");
        PERCENT_COMPLETE_TYPE.put(PercentCompleteType.DURATION, "Duration");
        PERCENT_COMPLETE_TYPE.put(PercentCompleteType.UNITS, "Units");
        PERCENT_COMPLETE_TYPE.put(PercentCompleteType.SCOPE, "Scope");
        ACTIVITY_TYPE_MAP = new HashMap<ActivityType, String>();
        ACTIVITY_TYPE_MAP.put(ActivityType.TASK_DEPENDENT, "Task Dependent");
        ACTIVITY_TYPE_MAP.put(ActivityType.RESOURCE_DEPENDENT, "Resource Dependent");
        ACTIVITY_TYPE_MAP.put(ActivityType.LEVEL_OF_EFFORT, "Level of Effort");
        ACTIVITY_TYPE_MAP.put(ActivityType.START_MILESTONE, "Start Milestone");
        ACTIVITY_TYPE_MAP.put(ActivityType.FINISH_MILESTONE, "Finish Milestone");
        ACTIVITY_TYPE_MAP.put(ActivityType.WBS_SUMMARY, "WBS Summary");
        CRITICAL_ACTIVITY_MAP = new HashMap<CriticalActivityType, String>();
        CRITICAL_ACTIVITY_MAP.put(CriticalActivityType.TOTAL_FLOAT, "Critical Float");
        CRITICAL_ACTIVITY_MAP.put(CriticalActivityType.LONGEST_PATH, "Longest Path");
    }
}

