/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.ActivityCode;
import net.sf.mpxj.ActivityCodeContainer;
import net.sf.mpxj.ActivityCodeValue;
import net.sf.mpxj.ActivityStatus;
import net.sf.mpxj.ActivityType;
import net.sf.mpxj.AssignmentField;
import net.sf.mpxj.Availability;
import net.sf.mpxj.ChildTaskContainer;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.CostAccount;
import net.sf.mpxj.CostAccountContainer;
import net.sf.mpxj.CostRateTable;
import net.sf.mpxj.CostRateTableEntry;
import net.sf.mpxj.CriticalActivityType;
import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.ExpenseCategory;
import net.sf.mpxj.ExpenseCategoryContainer;
import net.sf.mpxj.ExpenseItem;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.FieldTypeClass;
import net.sf.mpxj.HtmlNotes;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.Notes;
import net.sf.mpxj.ParentNotes;
import net.sf.mpxj.PercentCompleteType;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Rate;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.StructuredNotes;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.BooleanHelper;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.common.UnmarshalHelper;
import net.sf.mpxj.primavera.ActivitySorter;
import net.sf.mpxj.primavera.DatatypeConverter;
import net.sf.mpxj.primavera.ExternalRelation;
import net.sf.mpxj.primavera.NamespaceFilter;
import net.sf.mpxj.primavera.PrimaveraInputStreamReader;
import net.sf.mpxj.primavera.UserFieldCounters;
import net.sf.mpxj.primavera.UserFieldDataType;
import net.sf.mpxj.primavera.WbsRowComparatorPMXML;
import net.sf.mpxj.primavera.schema.APIBusinessObjects;
import net.sf.mpxj.primavera.schema.ActivityCodeType;
import net.sf.mpxj.primavera.schema.ActivityCodeTypeType;
import net.sf.mpxj.primavera.schema.ActivityExpenseType;
import net.sf.mpxj.primavera.schema.ActivityNoteType;
import net.sf.mpxj.primavera.schema.BaselineProjectType;
import net.sf.mpxj.primavera.schema.CalendarType;
import net.sf.mpxj.primavera.schema.CodeAssignmentType;
import net.sf.mpxj.primavera.schema.CurrencyType;
import net.sf.mpxj.primavera.schema.GlobalPreferencesType;
import net.sf.mpxj.primavera.schema.ProjectNoteType;
import net.sf.mpxj.primavera.schema.ProjectType;
import net.sf.mpxj.primavera.schema.RelationshipType;
import net.sf.mpxj.primavera.schema.ResourceAssignmentType;
import net.sf.mpxj.primavera.schema.ResourceRateType;
import net.sf.mpxj.primavera.schema.ScheduleOptionsType;
import net.sf.mpxj.primavera.schema.UDFAssignmentType;
import net.sf.mpxj.primavera.schema.UDFTypeType;
import net.sf.mpxj.primavera.schema.WBSType;
import net.sf.mpxj.primavera.schema.WorkTimeType;
import net.sf.mpxj.reader.AbstractProjectStreamReader;
import org.apache.poi.util.ReplacingInputStream;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class PrimaveraPMFileReader
extends AbstractProjectStreamReader {
    private static JAXBContext CONTEXT;
    private static JAXBException CONTEXT_EXCEPTION;
    private Integer m_projectID;
    private ProjectFile m_projectFile;
    private EventManager m_eventManager;
    private Map<Integer, Integer> m_clashMap;
    private Map<Integer, ActivityCodeValue> m_activityCodeMap;
    private UserFieldCounters m_taskUdfCounters;
    private UserFieldCounters m_resourceUdfCounters;
    private UserFieldCounters m_assignmentUdfCounters;
    private Map<Integer, FieldType> m_fieldTypeMap;
    private List<ExternalRelation> m_externalRelations;
    private boolean m_linkCrossProjectRelations;
    private Map<Integer, String> m_notebookTopics;
    private static final Map<String, ResourceType> RESOURCE_TYPE_MAP;
    private static final Map<String, ConstraintType> CONSTRAINT_TYPE_MAP;
    private static final Map<String, Priority> PRIORITY_MAP;
    private static final Map<String, RelationType> RELATION_TYPE_MAP;
    private static final Map<String, Day> DAY_MAP;
    private static final Map<String, Boolean> MILESTONE_MAP;
    private static final Map<String, FieldTypeClass> FIELD_TYPE_MAP;
    private static final Map<String, AccrueType> ACCRUE_TYPE_MAP;
    private static final Map<String, TaskType> DURATION_TYPE_MAP;
    private static final Map<String, PercentCompleteType> PERCENT_COMPLETE_TYPE;
    private static final Map<String, ActivityStatus> STATUS_MAP;
    private static final Map<String, ActivityType> ACTIVITY_TYPE_MAP;
    private static final Map<String, CriticalActivityType> CRITICAL_ACTIVITY_MAP;
    private static final WbsRowComparatorPMXML WBS_ROW_COMPARATOR;
    private static final Pattern ENCODING_PATTERN;

    public void setProjectID(int projectID) {
        this.m_projectID = projectID;
    }

    @Deprecated
    public boolean getWbsIsFullPath() {
        return false;
    }

    @Deprecated
    public void setWbsIsFullPath(boolean wbsIsFullPath) {
    }

    public boolean getLinkCrossProjectRelations() {
        return this.m_linkCrossProjectRelations;
    }

    public void setLinkCrossProjectRelations(boolean linkCrossProjectRelations) {
        this.m_linkCrossProjectRelations = linkCrossProjectRelations;
    }

    public Map<Integer, String> listProjects(InputStream is) throws MPXJException {
        APIBusinessObjects apibo = this.processFile(is);
        List<ProjectType> projects = apibo.getProject();
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        projects.forEach(p -> result.put(p.getObjectId(), p.getName()));
        return result;
    }

    @Override
    public ProjectFile read(InputStream is) throws MPXJException {
        ProjectFile project = null;
        List<ProjectFile> projects = this.readAll(is);
        if (!projects.isEmpty()) {
            project = this.m_projectID == null ? projects.get(0) : (ProjectFile)projects.stream().filter(p -> this.m_projectID.equals(p.getProjectProperties().getUniqueID())).findFirst().orElse(null);
        }
        return project;
    }

    @Override
    public List<ProjectFile> readAll(InputStream is) throws MPXJException {
        APIBusinessObjects apibo = this.processFile(is);
        List<ProjectType> projects = apibo.getProject();
        List<BaselineProjectType> baselineProjects = apibo.getBaselineProject();
        ArrayList<ProjectFile> result = new ArrayList<ProjectFile>(projects.size() + baselineProjects.size());
        this.m_externalRelations = new ArrayList<ExternalRelation>();
        projects.forEach(project -> result.add(this.read(apibo, project)));
        baselineProjects.forEach(project -> result.add(this.read(apibo, project)));
        result.sort((o1, o2) -> Boolean.compare(o2.getProjectProperties().getExportFlag(), o1.getProjectProperties().getExportFlag()));
        this.linkCrossProjectRelations(result);
        this.populateBaselines(result);
        this.m_externalRelations = null;
        return result;
    }

    private void linkCrossProjectRelations(List<ProjectFile> projects) {
        if (this.m_linkCrossProjectRelations) {
            for (ExternalRelation externalRelation : this.m_externalRelations) {
                Task predecessor;
                Task successor;
                Task externalTask = this.findTaskInProjects(projects, externalRelation.externalTaskUniqueID());
                if (externalTask == null) continue;
                if (externalRelation.getPredecessor()) {
                    successor = externalRelation.getTargetTask();
                    predecessor = externalTask;
                } else {
                    successor = externalTask;
                    predecessor = externalRelation.getTargetTask();
                }
                Relation relation = successor.addPredecessor(predecessor, externalRelation.getType(), externalRelation.getLag());
                relation.setUniqueID(externalRelation.getUniqueID());
            }
        }
    }

    private void populateBaselines(List<ProjectFile> projects) {
        Map<Integer, ProjectFile> map = projects.stream().collect(Collectors.toMap(p -> p.getProjectProperties().getUniqueID(), p -> p));
        for (ProjectFile project : projects) {
            ProjectFile baseline = map.get(project.getProjectProperties().getBaselineProjectUniqueID());
            if (baseline == null) continue;
            project.setBaseline(baseline, t -> t.getCanonicalActivityID());
        }
    }

    private Task findTaskInProjects(List<ProjectFile> projects, Integer uniqueID) {
        ProjectFile proj;
        Task result = null;
        Iterator<ProjectFile> iterator = projects.iterator();
        while (iterator.hasNext() && (result = (proj = iterator.next()).getTaskByUniqueID(uniqueID)) == null) {
        }
        return result;
    }

    private APIBusinessObjects processFile(InputStream stream) throws MPXJException {
        try {
            if (CONTEXT == null) {
                throw CONTEXT_EXCEPTION;
            }
            return (APIBusinessObjects)UnmarshalHelper.unmarshal(CONTEXT, this.configureInputSource(stream), new NamespaceFilter(), false);
        }
        catch (ParserConfigurationException ex) {
            throw new MPXJException("Failed to parse file", ex);
        }
        catch (JAXBException ex) {
            throw new MPXJException("Failed to parse file", (Exception)((Object)ex));
        }
        catch (SAXException ex) {
            throw new MPXJException("Failed to parse file", ex);
        }
        catch (IOException ex) {
            throw new MPXJException("Failed to parse file", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectFile read(APIBusinessObjects apibo, Object projectObject) {
        try {
            List<ActivityExpenseType> activityExpenseType;
            List<ResourceAssignmentType> assignments;
            List<RelationshipType> relationships;
            List<ActivityNoteType> activityNotes;
            List<net.sf.mpxj.primavera.schema.ActivityType> activities;
            List<ProjectNoteType> projectNotes;
            List<WBSType> wbs;
            List<CalendarType> calendars;
            List<ActivityCodeType> activityCodes;
            List<ActivityCodeTypeType> activityCodeTypes;
            Object project;
            this.m_clashMap = new HashMap<Integer, Integer>();
            this.m_activityCodeMap = new HashMap<Integer, ActivityCodeValue>();
            this.m_taskUdfCounters = new UserFieldCounters();
            this.m_resourceUdfCounters = new UserFieldCounters();
            this.m_assignmentUdfCounters = new UserFieldCounters();
            this.m_fieldTypeMap = new HashMap<Integer, FieldType>();
            this.m_notebookTopics = new HashMap<Integer, String>();
            this.m_projectFile = new ProjectFile();
            this.m_eventManager = this.m_projectFile.getEventManager();
            ProjectConfig config = this.m_projectFile.getProjectConfig();
            config.setAutoTaskUniqueID(false);
            config.setAutoResourceUniqueID(false);
            config.setAutoCalendarUniqueID(false);
            config.setAutoAssignmentUniqueID(false);
            config.setAutoWBS(false);
            this.m_projectFile.getProjectProperties().setFileApplication("Primavera");
            this.m_projectFile.getProjectProperties().setFileType("PMXML");
            this.addListenersToProject(this.m_projectFile);
            if (projectObject instanceof ProjectType) {
                project = (ProjectType)projectObject;
                this.processProjectProperties((ProjectType)project);
                activityCodeTypes = ((ProjectType)project).getActivityCodeType();
                activityCodes = ((ProjectType)project).getActivityCode();
                calendars = ((ProjectType)project).getCalendar();
                wbs = ((ProjectType)project).getWBS();
                projectNotes = ((ProjectType)project).getProjectNote();
                activities = ((ProjectType)project).getActivity();
                activityNotes = ((ProjectType)project).getActivityNote();
                relationships = ((ProjectType)project).getRelationship();
                assignments = ((ProjectType)project).getResourceAssignment();
                activityExpenseType = ((ProjectType)project).getActivityExpense();
            } else {
                project = (BaselineProjectType)projectObject;
                this.processProjectProperties((BaselineProjectType)project);
                activityCodeTypes = ((BaselineProjectType)project).getActivityCodeType();
                activityCodes = ((BaselineProjectType)project).getActivityCode();
                calendars = ((BaselineProjectType)project).getCalendar();
                wbs = ((BaselineProjectType)project).getWBS();
                projectNotes = ((BaselineProjectType)project).getProjectNote();
                activities = ((BaselineProjectType)project).getActivity();
                activityNotes = ((BaselineProjectType)project).getActivityNote();
                relationships = ((BaselineProjectType)project).getRelationship();
                assignments = ((BaselineProjectType)project).getResourceAssignment();
                activityExpenseType = ((BaselineProjectType)project).getActivityExpense();
            }
            this.processGlobalProperties(apibo);
            this.processProjectUDFs(apibo);
            this.processExpenseCategories(apibo);
            this.processCostAccounts(apibo);
            this.processNotebookTopics(apibo);
            this.processActivityCodes(apibo, activityCodeTypes, activityCodes);
            this.processCalendars(apibo, calendars);
            this.processResources(apibo);
            this.processTasks(wbs, this.getWbsNotes(projectNotes), activities, this.getActivityNotes(activityNotes));
            this.processPredecessors(relationships);
            this.processAssignments(assignments);
            this.processExpenseItems(activityExpenseType);
            this.processResourceRates(apibo);
            this.rollupValues();
            this.m_projectFile.updateStructure();
            config.updateUniqueCounters();
            ProjectFile projectFile = this.m_projectFile;
            return projectFile;
        }
        finally {
            this.m_projectFile = null;
            this.m_clashMap = null;
            this.m_activityCodeMap = null;
            this.m_taskUdfCounters = null;
            this.m_resourceUdfCounters = null;
            this.m_assignmentUdfCounters = null;
            this.m_fieldTypeMap = null;
            this.m_notebookTopics = null;
        }
    }

    private InputSource configureInputSource(InputStream stream) throws IOException {
        int bufferSize = 512;
        BufferedInputStream bis = new BufferedInputStream(stream);
        bis.mark(bufferSize);
        byte[] buffer = new byte[bufferSize];
        bis.read(buffer);
        bis.reset();
        ReplacingInputStream ris = new ReplacingInputStream((InputStream)bis, "&lt;/HTML&gt;&#0;", "&lt;/HTML&gt;");
        Matcher matcher = ENCODING_PATTERN.matcher(new String(buffer));
        InputSource result = matcher.find() ? new InputSource(new PrimaveraInputStreamReader((InputStream)ris, matcher.group(1))) : new InputSource((InputStream)ris);
        return result;
    }

    private void processProjectUDFs(APIBusinessObjects apibo) {
        for (UDFTypeType udf : apibo.getUDFType()) {
            this.processUDF(udf);
        }
    }

    private void processUDF(UDFTypeType udf) {
        String name;
        UserFieldDataType dataType;
        FieldType field;
        FieldTypeClass fieldType = FIELD_TYPE_MAP.get(udf.getSubjectArea());
        if (fieldType != null && (field = this.addUserDefinedField(fieldType, dataType = UserFieldDataType.getInstanceFromXmlName(udf.getDataType()), name = udf.getTitle())) != null) {
            this.m_fieldTypeMap.put(udf.getObjectId(), field);
        }
    }

    private FieldType addUserDefinedField(FieldTypeClass fieldType, UserFieldDataType dataType, String name) {
        FieldType field = null;
        CustomFieldContainer container = this.m_projectFile.getCustomFields();
        try {
            switch (fieldType) {
                case TASK: {
                    while (container.getCustomField(field = (FieldType)this.m_taskUdfCounters.nextField(TaskField.class, dataType)).getAlias() != null) {
                    }
                    container.getCustomField(field).setAlias(name);
                    break;
                }
                case RESOURCE: {
                    while (container.getCustomField(field = (FieldType)this.m_resourceUdfCounters.nextField(ResourceField.class, dataType)).getAlias() != null) {
                    }
                    container.getCustomField(field).setAlias(name);
                    break;
                }
                case ASSIGNMENT: {
                    while (container.getCustomField(field = (FieldType)this.m_assignmentUdfCounters.nextField(AssignmentField.class, dataType)).getAlias() != null) {
                    }
                    container.getCustomField(field).setAlias(name);
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return field;
    }

    private void processGlobalProperties(APIBusinessObjects apibo) {
        List<GlobalPreferencesType> list = apibo.getGlobalPreferences();
        if (!list.isEmpty()) {
            GlobalPreferencesType prefs = list.get(0);
            ProjectProperties properties = this.m_projectFile.getProjectProperties();
            properties.setCreationDate(prefs.getCreateDate());
            properties.setLastSaved(prefs.getLastUpdateDate());
            properties.setMinutesPerDay((int)(NumberHelper.getDouble(prefs.getHoursPerDay()) * 60.0));
            properties.setMinutesPerWeek((int)(NumberHelper.getDouble(prefs.getHoursPerWeek()) * 60.0));
            properties.setWeekStartDay(Day.getInstance(NumberHelper.getInt(prefs.getStartDayOfWeek())));
            List<CurrencyType> currencyList = apibo.getCurrency();
            for (CurrencyType currency : currencyList) {
                if (!currency.getObjectId().equals(prefs.getBaseCurrencyObjectId())) continue;
                properties.setCurrencySymbol(currency.getSymbol());
                break;
            }
        }
    }

    private void processProjectProperties(ProjectType project) {
        ProjectProperties properties = this.m_projectFile.getProjectProperties();
        properties.setBaselineProjectUniqueID(project.getCurrentBaselineProjectObjectId());
        properties.setCreationDate(project.getCreateDate());
        properties.setCriticalActivityType(CRITICAL_ACTIVITY_MAP.getOrDefault(project.getCriticalActivityPathType(), CriticalActivityType.TOTAL_FLOAT));
        properties.setFinishDate(project.getFinishDate());
        properties.setGUID(DatatypeConverter.parseUUID(project.getGUID()));
        properties.setName(project.getName());
        properties.setStartDate(project.getPlannedStartDate());
        properties.setStatusDate(project.getDataDate());
        properties.setProjectID(project.getId());
        properties.setUniqueID(project.getObjectId());
        properties.setExportFlag(!BooleanHelper.getBoolean(project.isExternal()));
        this.processScheduleOptions(project.getScheduleOptions());
    }

    private void processProjectProperties(BaselineProjectType project) {
        ProjectProperties properties = this.m_projectFile.getProjectProperties();
        properties.setCreationDate(project.getCreateDate());
        properties.setFinishDate(project.getFinishDate());
        properties.setGUID(DatatypeConverter.parseUUID(project.getGUID()));
        properties.setName(project.getName());
        properties.setStartDate(project.getPlannedStartDate());
        properties.setStatusDate(project.getDataDate());
        properties.setProjectID(project.getId());
        properties.setUniqueID(project.getObjectId());
        properties.setExportFlag(false);
    }

    private void processActivityCodes(APIBusinessObjects apibo, List<ActivityCodeTypeType> activityCodeTypes, List<ActivityCodeType> activityCodes) {
        ActivityCodeContainer container = this.m_projectFile.getActivityCodes();
        HashMap<Integer, ActivityCode> map = new HashMap<Integer, ActivityCode>();
        ArrayList<ActivityCodeTypeType> types = new ArrayList<ActivityCodeTypeType>();
        types.addAll(apibo.getActivityCodeType());
        types.addAll(activityCodeTypes);
        for (ActivityCodeTypeType type : types) {
            ActivityCode code = new ActivityCode(type.getObjectId(), type.getName());
            container.add(code);
            map.put(code.getUniqueID(), code);
        }
        ArrayList<ActivityCodeType> typeValues = new ArrayList<ActivityCodeType>();
        typeValues.addAll(apibo.getActivityCode());
        typeValues.addAll(activityCodes);
        for (ActivityCodeType typeValue : typeValues) {
            ActivityCode code = (ActivityCode)map.get(typeValue.getCodeTypeObjectId());
            if (code == null) continue;
            ActivityCodeValue value = code.addValue(typeValue.getObjectId(), typeValue.getCodeValue(), typeValue.getDescription());
            this.m_activityCodeMap.put(value.getUniqueID(), value);
        }
        for (ActivityCodeType typeValue : typeValues) {
            ActivityCodeValue child = this.m_activityCodeMap.get(typeValue.getObjectId());
            ActivityCodeValue parent = this.m_activityCodeMap.get(typeValue.getParentObjectId());
            if (parent == null || child == null) continue;
            child.setParent(parent);
        }
    }

    private void processExpenseCategories(APIBusinessObjects apibo) {
        ExpenseCategoryContainer container = this.m_projectFile.getExpenseCategories();
        apibo.getExpenseCategory().forEach(c -> container.add(new ExpenseCategory(c.getObjectId(), c.getName(), c.getSequenceNumber())));
    }

    private void processCostAccounts(APIBusinessObjects apibo) {
        CostAccountContainer container = this.m_projectFile.getCostAccounts();
        apibo.getCostAccount().forEach(c -> container.add(new CostAccount(c.getObjectId(), c.getId(), c.getName(), c.getDescription(), c.getSequenceNumber())));
        apibo.getCostAccount().forEach(c -> ((CostAccount)container.getByUniqueID(c.getObjectId())).setParent((CostAccount)container.getByUniqueID(c.getParentObjectId())));
    }

    private void processExpenseItems(List<ActivityExpenseType> expenseItems) {
        for (ActivityExpenseType item : expenseItems) {
            Task task = this.m_projectFile.getTaskByUniqueID(item.getActivityObjectId());
            if (task == null) continue;
            List<ExpenseItem> items = task.getExpenseItems();
            if (items == null) {
                items = new ArrayList<ExpenseItem>();
                task.setExpenseItems(items);
            }
            ExpenseItem ei = new ExpenseItem(task);
            items.add(ei);
            ei.setAccount((CostAccount)this.m_projectFile.getCostAccounts().getByUniqueID(item.getCostAccountObjectId()));
            ei.setAccrueType(ACCRUE_TYPE_MAP.get(item.getAccrualType()));
            ei.setActualCost(item.getActualCost());
            ei.setActualUnits(item.getActualUnits());
            ei.setAtCompletionUnits(item.getAtCompletionUnits());
            ei.setAutoComputeActuals(BooleanHelper.getBoolean(item.isAutoComputeActuals()));
            ei.setCategory((ExpenseCategory)this.m_projectFile.getExpenseCategories().getByUniqueID(item.getExpenseCategoryObjectId()));
            ei.setDescription(item.getExpenseDescription());
            ei.setDocumentNumber(item.getDocumentNumber());
            ei.setName(item.getExpenseItem());
            ei.setPlannedCost(item.getPlannedCost());
            ei.setPlannedUnits(item.getPlannedUnits());
            ei.setPricePerUnit(item.getPricePerUnit());
            ei.setRemainingCost(item.getRemainingCost());
            ei.setRemainingUnits(item.getRemainingUnits());
            ei.setUniqueID(item.getObjectId());
            ei.setUnitOfMeasure(item.getUnitOfMeasure());
            ei.setVendor(item.getVendor());
            ei.setAtCompletionCost(NumberHelper.sumAsDouble(item.getActualCost(), item.getRemainingCost()));
            task.setPlannedCost(NumberHelper.sumAsDouble(task.getPlannedCost(), ei.getPlannedCost()));
            task.setActualCost(NumberHelper.sumAsDouble(task.getActualCost(), ei.getActualCost()));
            task.setRemainingCost(NumberHelper.sumAsDouble(task.getRemainingCost(), ei.getRemainingCost()));
            task.setCost(NumberHelper.sumAsDouble(task.getCost(), ei.getAtCompletionCost()));
        }
    }

    private void processCalendars(APIBusinessObjects apibo, List<CalendarType> projectCalendars) {
        ArrayList<CalendarType> calendars = new ArrayList<CalendarType>(apibo.getCalendar());
        calendars.addAll(projectCalendars);
        HashMap<ProjectCalendar, Integer> baseCalendarMap = new HashMap<ProjectCalendar, Integer>();
        for (CalendarType calendarType : calendars) {
            ProjectCalendar calendar = this.processCalendar(calendarType);
            Integer baseCalendarID = calendarType.getBaseCalendarObjectId();
            if (baseCalendarID == null) continue;
            baseCalendarMap.put(calendar, baseCalendarID);
        }
        for (Map.Entry entry : baseCalendarMap.entrySet()) {
            ProjectCalendar baseCalendar = this.m_projectFile.getCalendarByUniqueID((Integer)entry.getValue());
            if (baseCalendar == null) continue;
            ((ProjectCalendar)entry.getKey()).setParent(baseCalendar);
        }
        ProjectConfig config = this.m_projectFile.getProjectConfig();
        config.updateCalendarUniqueCounter();
        config.setAutoCalendarUniqueID(true);
    }

    private ProjectCalendar processCalendar(CalendarType row) {
        CalendarType.HolidayOrExceptions hoe;
        ProjectCalendar calendar = this.m_projectFile.addCalendar();
        Integer id = row.getObjectId();
        calendar.setName(row.getName());
        calendar.setUniqueID(id);
        if (BooleanHelper.getBoolean(row.isIsDefault())) {
            this.m_projectFile.setDefaultCalendar(calendar);
        }
        calendar.setMinutesPerDay((int)(NumberHelper.getDouble(row.getHoursPerDay()) * 60.0));
        calendar.setMinutesPerWeek((int)(NumberHelper.getDouble(row.getHoursPerWeek()) * 60.0));
        calendar.setMinutesPerMonth((int)(NumberHelper.getDouble(row.getHoursPerMonth()) * 60.0));
        calendar.setMinutesPerYear((int)(NumberHelper.getDouble(row.getHoursPerYear()) * 60.0));
        CalendarType.StandardWorkWeek stdWorkWeek = row.getStandardWorkWeek();
        if (stdWorkWeek != null) {
            for (CalendarType.StandardWorkWeek.StandardWorkHours hours : stdWorkWeek.getStandardWorkHours()) {
                Day day = DAY_MAP.get(hours.getDayOfWeek());
                List<WorkTimeType> workTime = hours.getWorkTime();
                if (workTime.isEmpty() || workTime.get(0) == null) {
                    calendar.setWorkingDay(day, false);
                    continue;
                }
                calendar.setWorkingDay(day, true);
                ProjectCalendarHours calendarHours = calendar.addCalendarHours(day);
                for (WorkTimeType work : workTime) {
                    if (work == null) continue;
                    calendarHours.addRange(new DateRange(work.getStart(), this.getEndTime(work.getFinish())));
                }
            }
        }
        if ((hoe = row.getHolidayOrExceptions()) != null) {
            for (CalendarType.HolidayOrExceptions.HolidayOrException ex : hoe.getHolidayOrException()) {
                Date startDate = DateHelper.getDayStartDate(ex.getDate());
                Date endDate = DateHelper.getDayEndDate(ex.getDate());
                ProjectCalendarException pce = calendar.addCalendarException(startDate, endDate);
                List<WorkTimeType> workTime = ex.getWorkTime();
                for (WorkTimeType work : workTime) {
                    if (work == null || work.getStart() == null || work.getFinish() == null) continue;
                    pce.addRange(new DateRange(work.getStart(), this.getEndTime(work.getFinish())));
                }
            }
        }
        return calendar;
    }

    private void processResources(APIBusinessObjects apibo) {
        List<net.sf.mpxj.primavera.schema.ResourceType> resources = apibo.getResource();
        for (net.sf.mpxj.primavera.schema.ResourceType xml : resources) {
            Resource resource = this.m_projectFile.addResource();
            resource.setUniqueID(xml.getObjectId());
            resource.setName(xml.getName());
            resource.setCode(xml.getEmployeeId());
            resource.setEmailAddress(xml.getEmailAddress());
            resource.setGUID(DatatypeConverter.parseUUID(xml.getGUID()));
            resource.setNotesObject(this.getNotes(xml.getResourceNotes()));
            resource.setCreationDate(xml.getCreateDate());
            resource.setType(RESOURCE_TYPE_MAP.get(xml.getResourceType()));
            resource.setMaxUnits(this.reversePercentage(xml.getMaxUnitsPerTime()));
            resource.setParentID(xml.getParentObjectId());
            resource.setResourceID(xml.getId());
            this.setCalendar(resource, xml.getCalendarObjectId());
            this.readUDFTypes(resource, xml.getUDF());
            this.m_eventManager.fireResourceReadEvent(resource);
        }
    }

    private void setCalendar(Resource resource, Integer calendarID) {
        ProjectCalendar calendar;
        if (calendarID != null && (calendar = this.m_projectFile.getCalendarByUniqueID(calendarID)) != null) {
            if (calendar.isDerived()) {
                if (calendar.getResource() == null) {
                    resource.setResourceCalendar(calendar);
                } else {
                    ProjectCalendar copy = this.m_projectFile.addCalendar();
                    copy.copy(calendar);
                    resource.setResourceCalendar(copy);
                }
            } else {
                ProjectCalendar resourceCalendar = this.m_projectFile.addCalendar();
                resourceCalendar.setParent(calendar);
                resourceCalendar.setWorkingDay(Day.MONDAY, DayType.DEFAULT);
                resourceCalendar.setWorkingDay(Day.TUESDAY, DayType.DEFAULT);
                resourceCalendar.setWorkingDay(Day.WEDNESDAY, DayType.DEFAULT);
                resourceCalendar.setWorkingDay(Day.THURSDAY, DayType.DEFAULT);
                resourceCalendar.setWorkingDay(Day.FRIDAY, DayType.DEFAULT);
                resourceCalendar.setWorkingDay(Day.SATURDAY, DayType.DEFAULT);
                resourceCalendar.setWorkingDay(Day.SUNDAY, DayType.DEFAULT);
                resource.setResourceCalendar(resourceCalendar);
            }
        }
    }

    private Notes getNotes(String text) {
        HtmlNotes notes = this.getHtmlNote(text);
        return notes == null || notes.isEmpty() ? null : notes;
    }

    private void processTasks(List<WBSType> wbs, Map<Integer, Notes> wbsNotes, List<net.sf.mpxj.primavera.schema.ActivityType> activities, Map<Integer, Notes> activityNotes) {
        String activityID;
        Task task;
        HashSet<Integer> uniqueIDs = new HashSet<Integer>();
        HashSet<Task> wbsTasks = new HashSet<Task>();
        boolean baselineFromCurrentProject = this.m_projectFile.getProjectProperties().getBaselineProjectUniqueID() == null;
        Collections.sort(wbs, WBS_ROW_COMPARATOR);
        for (WBSType row : wbs) {
            task = this.m_projectFile.addTask();
            Integer uniqueID = row.getObjectId();
            uniqueIDs.add(uniqueID);
            wbsTasks.add(task);
            task.setUniqueID(uniqueID);
            task.setGUID(DatatypeConverter.parseUUID(row.getGUID()));
            task.setName(row.getName());
            task.setSummary(true);
            task.setStart(row.getAnticipatedStartDate());
            task.setFinish(row.getAnticipatedFinishDate());
            task.setWBS(row.getCode());
            task.setNotesObject(wbsNotes.get(uniqueID));
            task.setCritical(false);
        }
        this.m_projectFile.getChildTasks().clear();
        for (WBSType row : wbs) {
            task = this.m_projectFile.getTaskByUniqueID(row.getObjectId());
            Task parentTask = this.m_projectFile.getTaskByUniqueID(row.getParentObjectId());
            if (parentTask == null) {
                this.m_projectFile.getChildTasks().add(task);
                continue;
            }
            this.m_projectFile.getChildTasks().remove(task);
            parentTask.getChildTasks().add(task);
        }
        String prefix = this.m_projectFile.getProjectProperties().getProjectID();
        if (prefix != null && this.m_projectFile.getChildTasks().size() == 1 && (activityID = this.m_projectFile.getChildTasks().get(0).getWBS()) != null && activityID.equals(prefix)) {
            prefix = "";
        }
        this.populateWBS(prefix, this.m_projectFile);
        int nextID = 1;
        this.m_clashMap.clear();
        boolean forceCriticalToFalse = this.m_projectFile.getProjectProperties().getCriticalActivityType() == CriticalActivityType.LONGEST_PATH;
        for (net.sf.mpxj.primavera.schema.ActivityType row : activities) {
            Integer uniqueID = row.getObjectId();
            Notes notes = activityNotes.get(uniqueID);
            if (uniqueIDs.contains(uniqueID)) {
                while (uniqueIDs.contains(nextID)) {
                    ++nextID;
                }
                Integer newUniqueID = nextID;
                this.m_clashMap.put(uniqueID, newUniqueID);
                uniqueID = newUniqueID;
            }
            uniqueIDs.add(uniqueID);
            Integer parentTaskID = row.getWBSObjectId();
            Task parentTask = this.m_projectFile.getTaskByUniqueID(parentTaskID);
            Task task2 = parentTask == null ? this.m_projectFile.addTask() : parentTask.addTask();
            task2.setUniqueID(uniqueID);
            task2.setGUID(DatatypeConverter.parseUUID(row.getGUID()));
            task2.setName(row.getName());
            task2.setNotesObject(notes);
            task2.setPercentCompleteType(PERCENT_COMPLETE_TYPE.get(row.getPercentCompleteType()));
            task2.setPercentageComplete(this.reversePercentage(row.getDurationPercentComplete()));
            task2.setPhysicalPercentComplete(this.reversePercentage(row.getPhysicalPercentComplete()));
            task2.setPercentageWorkComplete(this.reversePercentage(row.getUnitsPercentComplete()));
            task2.setActualWork(this.addDurations(row.getActualLaborUnits(), row.getActualNonLaborUnits()));
            task2.setPlannedWork(this.addDurations(row.getPlannedLaborUnits(), row.getPlannedNonLaborUnits()));
            task2.setRemainingWork(this.addDurations(row.getRemainingLaborUnits(), row.getRemainingNonLaborUnits()));
            task2.setWork(this.addDurations(row.getAtCompletionLaborUnits(), row.getAtCompletionNonLaborUnits()));
            task2.setPlannedDuration(this.getDuration(row.getPlannedDuration()));
            task2.setActualDuration(this.getDuration(row.getActualDuration()));
            task2.setRemainingDuration(this.getDuration(row.getRemainingDuration()));
            task2.setDuration(this.getDuration(row.getAtCompletionDuration()));
            task2.setConstraintDate(row.getPrimaryConstraintDate());
            task2.setConstraintType(CONSTRAINT_TYPE_MAP.get(row.getPrimaryConstraintType()));
            task2.setSecondaryConstraintDate(row.getSecondaryConstraintDate());
            task2.setSecondaryConstraintType(CONSTRAINT_TYPE_MAP.get(row.getSecondaryConstraintType()));
            task2.setActualStart(row.getActualStartDate());
            task2.setActualFinish(row.getActualFinishDate());
            task2.setPlannedStart(row.getPlannedStartDate());
            task2.setPlannedFinish(row.getPlannedFinishDate());
            task2.setRemainingEarlyStart(row.getRemainingEarlyStartDate());
            task2.setRemainingEarlyFinish(row.getRemainingEarlyFinishDate());
            task2.setRemainingLateStart(row.getRemainingLateStartDate());
            task2.setRemainingLateFinish(row.getRemainingLateFinishDate());
            task2.setPriority(PRIORITY_MAP.get(row.getLevelingPriority()));
            task2.setCreateDate(row.getCreateDate());
            task2.setActivityID(row.getId());
            task2.setActivityType(ACTIVITY_TYPE_MAP.get(row.getType()));
            task2.setActivityStatus(STATUS_MAP.get(row.getStatus()));
            task2.setPrimaryResourceID(row.getPrimaryResourceObjectId());
            task2.setSuspendDate(row.getSuspendDate());
            task2.setResume(row.getResumeDate());
            task2.setType(DURATION_TYPE_MAP.get(row.getDurationType()));
            task2.setMilestone(BooleanHelper.getBoolean(MILESTONE_MAP.get(row.getType())));
            task2.disableEvents();
            task2.setEarlyStart(task2.getRemainingEarlyStart());
            task2.setEarlyFinish(task2.getRemainingEarlyFinish());
            task2.setLateStart(task2.getRemainingLateStart());
            task2.setLateFinish(task2.getRemainingLateFinish());
            task2.getCritical();
            task2.setEarlyStart(null);
            task2.setEarlyFinish(null);
            task2.setLateStart(null);
            task2.setLateFinish(null);
            task2.enableEvents();
            if (parentTask != null) {
                task2.setWBS(parentTask.getWBS());
            }
            Integer calId = row.getCalendarObjectId();
            ProjectCalendar cal = this.m_projectFile.getCalendarByUniqueID(calId);
            task2.setCalendar(cal);
            task2.setStart(row.getStartDate());
            task2.setFinish(row.getFinishDate());
            this.populateField(task2, TaskField.START, TaskField.START, TaskField.ACTUAL_START, TaskField.REMAINING_EARLY_START, TaskField.PLANNED_START);
            this.populateField(task2, TaskField.FINISH, TaskField.FINISH, TaskField.ACTUAL_FINISH, TaskField.REMAINING_EARLY_FINISH);
            if (task2.getFinish() == null) {
                Duration duration = task2.getRemainingDuration();
                if (duration != null && duration.getDuration() == 0.0) {
                    duration = null;
                }
                if (task2.getActualStart() == null || duration == null) {
                    task2.setFinish(task2.getPlannedFinish());
                } else {
                    Date nextWorkStart;
                    ProjectCalendar calendar = task2.getEffectiveCalendar();
                    Date finish = calendar.getDate(task2.getPlannedStart(), duration, false);
                    if (DateHelper.compare(finish, nextWorkStart = calendar.getNextWorkStart(finish)) == 0) {
                        finish = calendar.getPreviousWorkFinish(finish);
                    }
                    task2.setFinish(finish);
                }
            }
            this.readUDFTypes(task2, row.getUDF());
            this.readActivityCodes(task2, row.getCode());
            if (forceCriticalToFalse) {
                task2.setCritical(false);
            }
            if (baselineFromCurrentProject) {
                this.populateBaselineFromCurrentProject(task2);
            }
            this.m_eventManager.fireTaskReadEvent(task2);
        }
        new ActivitySorter(wbsTasks).sort(this.m_projectFile);
        this.updateStructure();
    }

    private void populateBaselineFromCurrentProject(Task task) {
        task.setBaselineCost(task.getPlannedCost());
        task.setBaselineDuration(task.getPlannedDuration());
        task.setBaselineFinish(task.getPlannedFinish());
        task.setBaselineStart(task.getPlannedStart());
        task.setBaselineWork(task.getPlannedWork());
    }

    private void populateWBS(String prefix, ChildTaskContainer container) {
        for (Task task : container.getChildTasks()) {
            String wbs = prefix.isEmpty() ? task.getWBS() : prefix + "." + task.getWBS();
            task.setWBS(wbs);
            task.setActivityID(wbs);
            this.populateWBS(wbs, task);
        }
    }

    private Duration addDurations(Number ... values) {
        return this.getDuration(NumberHelper.sumAsDouble(values));
    }

    private void rollupDates(Task parentTask) {
        if (parentTask.hasChildTasks()) {
            int finished = 0;
            Date startDate = parentTask.getStart();
            Date finishDate = parentTask.getFinish();
            Date plannedStartDate = parentTask.getPlannedStart();
            Date plannedFinishDate = parentTask.getPlannedFinish();
            Date actualStartDate = parentTask.getActualStart();
            Date actualFinishDate = parentTask.getActualFinish();
            Date earlyStartDate = parentTask.getEarlyStart();
            Date earlyFinishDate = parentTask.getEarlyFinish();
            Date lateStartDate = parentTask.getLateStart();
            Date lateFinishDate = parentTask.getLateFinish();
            Date baselineStartDate = parentTask.getBaselineStart();
            Date baselineFinishDate = parentTask.getBaselineFinish();
            Date remainingEarlyStartDate = parentTask.getRemainingEarlyStart();
            Date remainingEarlyFinishDate = parentTask.getRemainingEarlyFinish();
            Date remainingLateStartDate = parentTask.getRemainingLateStart();
            Date remainingLateFinishDate = parentTask.getRemainingLateFinish();
            boolean critical = false;
            for (Task task : parentTask.getChildTasks()) {
                this.rollupDates(task);
                startDate = DateHelper.min(startDate, task.getStart());
                finishDate = DateHelper.max(finishDate, task.getFinish());
                plannedStartDate = DateHelper.min(plannedStartDate, task.getPlannedStart());
                plannedFinishDate = DateHelper.max(plannedFinishDate, task.getPlannedFinish());
                actualStartDate = DateHelper.min(actualStartDate, task.getActualStart());
                actualFinishDate = DateHelper.max(actualFinishDate, task.getActualFinish());
                earlyStartDate = DateHelper.min(earlyStartDate, task.getEarlyStart());
                earlyFinishDate = DateHelper.max(earlyFinishDate, task.getEarlyFinish());
                remainingEarlyStartDate = DateHelper.min(remainingEarlyStartDate, task.getRemainingEarlyStart());
                remainingEarlyFinishDate = DateHelper.max(remainingEarlyFinishDate, task.getRemainingEarlyFinish());
                lateStartDate = DateHelper.min(lateStartDate, task.getLateStart());
                lateFinishDate = DateHelper.max(lateFinishDate, task.getLateFinish());
                remainingLateStartDate = DateHelper.min(remainingLateStartDate, task.getRemainingLateStart());
                remainingLateFinishDate = DateHelper.max(remainingLateFinishDate, task.getRemainingLateFinish());
                baselineStartDate = DateHelper.min(baselineStartDate, task.getBaselineStart());
                baselineFinishDate = DateHelper.max(baselineFinishDate, task.getBaselineFinish());
                if (task.getActualFinish() != null) {
                    ++finished;
                }
                critical = critical || task.getCritical();
            }
            parentTask.setStart(startDate);
            parentTask.setFinish(finishDate);
            parentTask.setPlannedStart(plannedStartDate);
            parentTask.setPlannedFinish(plannedFinishDate);
            parentTask.setActualStart(actualStartDate);
            parentTask.setEarlyStart(earlyStartDate);
            parentTask.setEarlyFinish(earlyFinishDate);
            parentTask.setRemainingEarlyStart(remainingEarlyStartDate);
            parentTask.setRemainingEarlyFinish(remainingEarlyFinishDate);
            parentTask.setLateStart(lateStartDate);
            parentTask.setLateFinish(lateFinishDate);
            parentTask.setRemainingLateStart(remainingLateStartDate);
            parentTask.setRemainingLateFinish(remainingLateFinishDate);
            parentTask.setBaselineStart(baselineStartDate);
            parentTask.setBaselineFinish(baselineFinishDate);
            if (finished == parentTask.getChildTasks().size()) {
                parentTask.setActualFinish(actualFinishDate);
            }
            Duration plannedDuration = null;
            if (plannedStartDate != null && plannedFinishDate != null) {
                plannedDuration = this.m_projectFile.getDefaultCalendar().getWork(plannedStartDate, plannedFinishDate, TimeUnit.HOURS);
                parentTask.setPlannedDuration(plannedDuration);
            }
            Duration actualDuration = null;
            Duration remainingDuration = null;
            if (parentTask.getActualFinish() == null) {
                Date taskFinishDate;
                Date taskStartDate = parentTask.getRemainingEarlyStart();
                if (taskStartDate == null && (taskStartDate = parentTask.getEarlyStart()) == null) {
                    taskStartDate = plannedStartDate;
                }
                if ((taskFinishDate = parentTask.getRemainingEarlyFinish()) == null && (taskFinishDate = parentTask.getEarlyFinish()) == null) {
                    taskFinishDate = plannedFinishDate;
                }
                if (taskStartDate != null) {
                    if (parentTask.getActualStart() != null) {
                        actualDuration = this.m_projectFile.getDefaultCalendar().getWork(parentTask.getActualStart(), taskStartDate, TimeUnit.HOURS);
                    }
                    if (taskFinishDate != null) {
                        remainingDuration = this.m_projectFile.getDefaultCalendar().getWork(taskStartDate, taskFinishDate, TimeUnit.HOURS);
                    }
                }
            } else {
                actualDuration = this.m_projectFile.getDefaultCalendar().getWork(parentTask.getActualStart(), parentTask.getActualFinish(), TimeUnit.HOURS);
                remainingDuration = Duration.getInstance(0, TimeUnit.HOURS);
            }
            if (actualDuration != null && actualDuration.getDuration() < 0.0) {
                actualDuration = null;
            }
            if (remainingDuration != null && remainingDuration.getDuration() < 0.0) {
                remainingDuration = null;
            }
            parentTask.setActualDuration(actualDuration);
            parentTask.setRemainingDuration(remainingDuration);
            parentTask.setDuration(Duration.add(actualDuration, remainingDuration, this.m_projectFile.getProjectProperties()));
            if (plannedDuration != null && remainingDuration != null && plannedDuration.getDuration() != 0.0) {
                double durationPercentComplete = (plannedDuration.getDuration() - remainingDuration.getDuration()) / plannedDuration.getDuration() * 100.0;
                if (durationPercentComplete < 0.0) {
                    durationPercentComplete = 0.0;
                } else if (durationPercentComplete > 100.0) {
                    durationPercentComplete = 100.0;
                }
                parentTask.setPercentageComplete(durationPercentComplete);
                parentTask.setPercentCompleteType(PercentCompleteType.DURATION);
            }
            parentTask.getStartSlack();
            parentTask.getFinishSlack();
            parentTask.setCritical(critical);
        }
    }

    private void populateField(FieldContainer container, FieldType target, FieldType ... types) {
        for (FieldType type : types) {
            Object value = container.getCachedValue(type);
            if (value == null) continue;
            container.set(target, value);
            break;
        }
    }

    private void updateStructure() {
        int id = 1;
        Integer outlineLevel = 1;
        for (Task task : this.m_projectFile.getChildTasks()) {
            id = this.updateStructure(id, task, outlineLevel);
        }
    }

    private int updateStructure(int id, Task task, Integer outlineLevel) {
        task.setID(id++);
        task.setOutlineLevel(outlineLevel);
        outlineLevel = outlineLevel + 1;
        for (Task childTask : task.getChildTasks()) {
            id = this.updateStructure(id, childTask, outlineLevel);
        }
        return id;
    }

    private void processPredecessors(List<RelationshipType> relationships) {
        for (RelationshipType row : relationships) {
            Object relation;
            Integer predecessorID = row.getPredecessorActivityObjectId();
            Integer successorID = row.getSuccessorActivityObjectId();
            Task successorTask = this.m_projectFile.getTaskByUniqueID(this.mapTaskID(successorID));
            Task predecessorTask = this.m_projectFile.getTaskByUniqueID(this.mapTaskID(predecessorID));
            RelationType type = RELATION_TYPE_MAP.get(row.getType());
            Duration lag = this.getDuration(row.getLag());
            if (successorTask != null && predecessorTask != null) {
                relation = successorTask.addPredecessor(predecessorTask, type, lag);
                ((Relation)relation).setUniqueID(row.getObjectId());
                this.m_eventManager.fireRelationReadEvent((Relation)relation);
                continue;
            }
            if (successorTask != null && predecessorTask == null) {
                relation = new ExternalRelation(predecessorID, successorTask, type, lag, true);
                this.m_externalRelations.add((ExternalRelation)relation);
                ((ExternalRelation)relation).setUniqueID(row.getObjectId());
                continue;
            }
            if (successorTask != null || predecessorTask == null) continue;
            relation = new ExternalRelation(successorID, predecessorTask, type, lag, false);
            this.m_externalRelations.add((ExternalRelation)relation);
            ((ExternalRelation)relation).setUniqueID(row.getObjectId());
        }
    }

    private void processAssignments(List<ResourceAssignmentType> assignments) {
        for (ResourceAssignmentType row : assignments) {
            Task task = this.m_projectFile.getTaskByUniqueID(this.mapTaskID(row.getActivityObjectId()));
            Resource resource = this.m_projectFile.getResourceByUniqueID(row.getResourceObjectId());
            if (task == null || resource == null) continue;
            ResourceAssignment assignment = task.addResourceAssignment(resource);
            assignment.setUniqueID(row.getObjectId());
            assignment.setRemainingWork(this.getDuration(row.getRemainingUnits()));
            assignment.setPlannedWork(this.getDuration(row.getPlannedUnits()));
            assignment.setActualWork(this.getDuration(row.getActualUnits()));
            assignment.setRemainingCost(row.getRemainingCost());
            assignment.setPlannedCost(row.getPlannedCost());
            assignment.setActualCost(row.getActualCost());
            assignment.setActualStart(row.getActualStartDate());
            assignment.setActualFinish(row.getActualFinishDate());
            assignment.setPlannedStart(row.getPlannedStartDate());
            assignment.setPlannedFinish(row.getPlannedFinishDate());
            assignment.setGUID(DatatypeConverter.parseUUID(row.getGUID()));
            assignment.setActualOvertimeCost(row.getActualOvertimeCost());
            assignment.setActualOvertimeWork(this.getDuration(row.getActualOvertimeUnits()));
            this.populateField(assignment, AssignmentField.START, AssignmentField.ACTUAL_START, AssignmentField.PLANNED_START);
            this.populateField(assignment, AssignmentField.FINISH, AssignmentField.ACTUAL_FINISH, AssignmentField.PLANNED_FINISH);
            Duration remainingWork = assignment.getRemainingWork();
            Duration actualWork = assignment.getActualWork();
            Duration totalWork = Duration.add(actualWork, remainingWork, this.m_projectFile.getProjectProperties());
            assignment.setWork(totalWork);
            Number remainingCost = assignment.getRemainingCost();
            Number actualCost = assignment.getActualCost();
            Double atCompletionCost = NumberHelper.sumAsDouble(actualCost, remainingCost);
            assignment.setCost(atCompletionCost);
            task.setPlannedCost(NumberHelper.sumAsDouble(task.getPlannedCost(), assignment.getPlannedCost()));
            task.setActualCost(NumberHelper.sumAsDouble(task.getActualCost(), actualCost));
            task.setRemainingCost(NumberHelper.sumAsDouble(task.getRemainingCost(), remainingCost));
            task.setCost(NumberHelper.sumAsDouble(task.getCost(), atCompletionCost));
            double units = resource.getType() == ResourceType.MATERIAL ? (totalWork == null ? 0.0 : totalWork.getDuration() * 100.0) : NumberHelper.getDouble(row.getPlannedUnitsPerTime()) * 100.0;
            assignment.setUnits(NumberHelper.getDouble(units));
            this.readUDFTypes(assignment, row.getUDF());
            this.m_eventManager.fireAssignmentReadEvent(assignment);
        }
    }

    private void processResourceRates(APIBusinessObjects apibo) {
        ArrayList<ResourceRateType> rates = new ArrayList<ResourceRateType>(apibo.getResourceRate());
        Collections.sort(rates, new Comparator<ResourceRateType>(){

            @Override
            public int compare(ResourceRateType r1, ResourceRateType r2) {
                Integer id2;
                Integer id1 = r1.getResourceObjectId();
                int cmp = NumberHelper.compare(id1, id2 = r2.getResourceObjectId());
                if (cmp != 0) {
                    return cmp;
                }
                Date d1 = r1.getEffectiveDate();
                Date d2 = r2.getEffectiveDate();
                return DateHelper.compare(d1, d2);
            }
        });
        for (int i = 0; i < rates.size(); ++i) {
            CostRateTable costRateTable;
            Resource resource;
            ResourceRateType row = (ResourceRateType)rates.get(i);
            Integer resourceID = row.getResourceObjectId();
            Rate standardRate = new Rate(row.getPricePerUnit(), TimeUnit.HOURS);
            TimeUnit standardRateFormat = TimeUnit.HOURS;
            Rate overtimeRate = new Rate(0.0, TimeUnit.HOURS);
            TimeUnit overtimeRateFormat = TimeUnit.HOURS;
            Double costPerUse = NumberHelper.getDouble(0.0);
            Double maxUnits = NumberHelper.getDouble(NumberHelper.getDouble(row.getMaxUnitsPerTime()) * 100.0);
            Date startDate = row.getEffectiveDate();
            Date endDate = DateHelper.END_DATE_NA;
            if (i + 1 < rates.size()) {
                ResourceRateType nextRow = (ResourceRateType)rates.get(i + 1);
                int nextResourceID = NumberHelper.getInt(nextRow.getResourceObjectId());
                if (resourceID == nextResourceID) {
                    Calendar cal = DateHelper.popCalendar(nextRow.getEffectiveDate());
                    cal.add(12, -1);
                    endDate = cal.getTime();
                    DateHelper.pushCalendar(cal);
                }
            }
            if ((resource = this.m_projectFile.getResourceByUniqueID(resourceID)) == null) continue;
            if (startDate == null || startDate.getTime() < DateHelper.START_DATE_NA.getTime()) {
                startDate = DateHelper.START_DATE_NA;
            }
            if (endDate == null || endDate.getTime() > DateHelper.END_DATE_NA.getTime()) {
                endDate = DateHelper.END_DATE_NA;
            }
            if ((costRateTable = resource.getCostRateTable(0)) == null) {
                costRateTable = new CostRateTable();
                resource.setCostRateTable(0, costRateTable);
            }
            CostRateTableEntry entry = new CostRateTableEntry(standardRate, standardRateFormat, overtimeRate, overtimeRateFormat, costPerUse, startDate, endDate);
            costRateTable.add(entry);
            resource.getAvailability().add(new Availability(startDate, endDate, maxUnits));
        }
    }

    private void processNotebookTopics(APIBusinessObjects apibo) {
        apibo.getNotebookTopic().forEach(t -> this.m_notebookTopics.put(t.getObjectId(), t.getName()));
    }

    private Map<Integer, Notes> getWbsNotes(List<ProjectNoteType> notes) {
        Map<Integer, Map<Integer, List<String>>> map = notes.stream().filter(n -> n.getWBSObjectId() != null).collect(Collectors.groupingBy(ProjectNoteType::getWBSObjectId, Collectors.groupingBy(ProjectNoteType::getNotebookTopicObjectId, Collectors.mapping(ProjectNoteType::getNote, Collectors.toList()))));
        return this.getNotes(map);
    }

    private Map<Integer, Notes> getActivityNotes(List<ActivityNoteType> notes) {
        Map<Integer, Map<Integer, List<String>>> map = notes.stream().filter(n -> n.getActivityObjectId() != null).collect(Collectors.groupingBy(ActivityNoteType::getActivityObjectId, Collectors.groupingBy(ActivityNoteType::getNotebookTopicObjectId, Collectors.mapping(ActivityNoteType::getNote, Collectors.toList()))));
        return this.getNotes(map);
    }

    private Map<Integer, Notes> getNotes(Map<Integer, Map<Integer, List<String>>> map) {
        HashMap<Integer, Notes> result = new HashMap<Integer, Notes>();
        for (Map.Entry<Integer, Map<Integer, List<String>>> entry : map.entrySet()) {
            ArrayList<Notes> list = new ArrayList<Notes>();
            for (Map.Entry<Integer, List<String>> topicEntry : entry.getValue().entrySet()) {
                topicEntry.getValue().stream().map(s -> this.getHtmlNote((String)s)).filter(n -> n != null && !n.isEmpty()).forEach(n -> list.add(new StructuredNotes((Integer)topicEntry.getKey(), this.m_notebookTopics.get(topicEntry.getKey()), (Notes)n)));
            }
            result.put(entry.getKey(), new ParentNotes(list));
        }
        return result;
    }

    private HtmlNotes getHtmlNote(String text) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        String html = text.replaceAll("[\\uFEFF\\uFFFE\\x00]", "");
        return new HtmlNotes(html);
    }

    private Duration getDuration(Double duration) {
        Duration result = null;
        if (duration != null) {
            result = Duration.getInstance(NumberHelper.getDouble(duration), TimeUnit.HOURS);
        }
        return result;
    }

    private Date getEndTime(Date date) {
        return new Date(date.getTime() + 60000L);
    }

    private Number reversePercentage(Double n) {
        return n == null ? null : NumberHelper.getDouble(n * 100.0);
    }

    private void readUDFTypes(FieldContainer mpxj, List<UDFAssignmentType> udfs) {
        for (UDFAssignmentType udf : udfs) {
            FieldType fieldType = this.m_fieldTypeMap.get(udf.getTypeObjectId());
            if (fieldType == null) continue;
            mpxj.set(fieldType, this.getUdfValue(udf));
        }
    }

    private Object getUdfValue(UDFAssignmentType udf) {
        if (udf.getCostValue() != null) {
            return udf.getCostValue();
        }
        if (udf.getDoubleValue() != null) {
            return udf.getDoubleValue();
        }
        if (udf.getFinishDateValue() != null) {
            return udf.getFinishDateValue();
        }
        if (udf.getIndicatorValue() != null) {
            return udf.getIndicatorValue();
        }
        if (udf.getIntegerValue() != null) {
            return udf.getIntegerValue();
        }
        if (udf.getStartDateValue() != null) {
            return udf.getStartDateValue();
        }
        if (udf.getTextValue() != null) {
            return udf.getTextValue();
        }
        return null;
    }

    private void readActivityCodes(Task task, List<CodeAssignmentType> codes) {
        for (CodeAssignmentType assignment : codes) {
            ActivityCodeValue code = this.m_activityCodeMap.get(assignment.getValueObjectId());
            if (code == null) continue;
            task.addActivityCode(code);
        }
    }

    private void processScheduleOptions(List<ScheduleOptionsType> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        ScheduleOptionsType options = list.get(0);
        TreeMap<String, Object> customProperties = new TreeMap<String, Object>();
        customProperties.put("ConsiderAssignmentsInOtherProjects", options.isIncludeExternalResAss());
        customProperties.put("ConsiderAssignmentsInOtherProjectsWithPriorityEqualHigherThan", options.getExternalProjectPriorityLimit());
        customProperties.put("PreserveScheduledEarlyAndLateDates", options.isPreserveScheduledEarlyAndLateDates());
        customProperties.put("LevelAllResources", options.isLevelAllResources());
        customProperties.put("LevelResourcesOnlyWithinActivityTotalFloat", options.isLevelWithinFloat());
        customProperties.put("PreserveMinimumFloatWhenLeveling", options.getMinFloatToPreserve());
        customProperties.put("MaxPercentToOverallocateResources", options.getOverAllocationPercentage());
        customProperties.put("LevelingPriorities", options.getPriorityList());
        customProperties.put("MakeOpenEndedActivitiesCritical", options.isMakeOpenEndedActivitiesCritical());
        customProperties.put("UseExpectedFinishDates", options.isUseExpectedFinishDates());
        customProperties.put("ComputeStartToStartLagFromEarlyStart", options.isStartToStartLagCalculationType());
        customProperties.put("CalculateFloatBasedOnFishDateOfEachProject", options.isCalculateFloatBasedOnFinishDate());
        customProperties.put("ComputeTotalFloatAs", options.getComputeTotalFloatType());
        customProperties.put("CalendarForSchedulingRelationshipLag", options.getRelationshipLagCalendar());
        customProperties.put("CalculateMultipleFloatPaths", options.isMultipleFloatPathsEnabled());
        customProperties.put("CalculateMultiplePathsUsingTotalFloat", options.isMultipleFloatPathsUseTotalFloat());
        customProperties.put("DisplayMultipleFloatPathsEndingWithActivity", options.getMultipleFloatPathsEndingActivityObjectId());
        customProperties.put("NumberofPathsToCalculate", options.getMaximumMultipleFloatPaths());
        this.m_projectFile.getProjectProperties().setCustomProperties(customProperties);
    }

    private void rollupValues() {
        this.m_projectFile.getChildTasks().forEach(t -> this.rollupDates((Task)t));
        this.m_projectFile.getChildTasks().forEach(t -> this.rollupWork((Task)t));
        this.m_projectFile.getChildTasks().forEach(t -> this.rollupCosts((Task)t));
        if (this.m_projectFile.getProjectProperties().getBaselineProjectUniqueID() == null) {
            this.m_projectFile.getTasks().stream().filter(t -> t.getSummary()).forEach(t -> this.populateBaselineFromCurrentProject((Task)t));
        }
    }

    private void rollupCosts(Task parentTask) {
        if (parentTask.hasChildTasks()) {
            double plannedCost = 0.0;
            double actualCost = 0.0;
            double remainingCost = 0.0;
            double cost = 0.0;
            for (Task child : parentTask.getChildTasks()) {
                this.rollupCosts(child);
                plannedCost += NumberHelper.getDouble(child.getPlannedCost());
                actualCost += NumberHelper.getDouble(child.getActualCost());
                remainingCost += NumberHelper.getDouble(child.getRemainingCost());
                cost += NumberHelper.getDouble(child.getCost());
            }
            parentTask.setPlannedCost(NumberHelper.getDouble(plannedCost));
            parentTask.setActualCost(NumberHelper.getDouble(actualCost));
            parentTask.setRemainingCost(NumberHelper.getDouble(remainingCost));
            parentTask.setCost(NumberHelper.getDouble(cost));
        }
    }

    private void rollupWork(Task parentTask) {
        if (parentTask.hasChildTasks()) {
            ProjectProperties properties = this.m_projectFile.getProjectProperties();
            Duration actualWork = null;
            Duration plannedWork = null;
            Duration remainingWork = null;
            Duration work = null;
            for (Task task : parentTask.getChildTasks()) {
                this.rollupWork(task);
                actualWork = Duration.add(actualWork, task.getActualWork(), properties);
                plannedWork = Duration.add(plannedWork, task.getPlannedWork(), properties);
                remainingWork = Duration.add(remainingWork, task.getRemainingWork(), properties);
                work = Duration.add(work, task.getWork(), properties);
            }
            parentTask.setActualWork(actualWork);
            parentTask.setPlannedWork(plannedWork);
            parentTask.setRemainingWork(remainingWork);
            parentTask.setWork(work);
        }
    }

    private Integer mapTaskID(Integer id) {
        Integer mappedID = this.m_clashMap.get(id);
        if (mappedID == null) {
            mappedID = id;
        }
        return mappedID;
    }

    static {
        try {
            System.setProperty("com.sun.xml.bind.v2.runtime.JAXBContextImpl.fastBoot", "true");
            CONTEXT = JAXBContext.newInstance((String)"net.sf.mpxj.primavera.schema", (ClassLoader)PrimaveraPMFileReader.class.getClassLoader());
        }
        catch (JAXBException ex) {
            CONTEXT_EXCEPTION = ex;
            CONTEXT = null;
        }
        RESOURCE_TYPE_MAP = new HashMap<String, ResourceType>();
        RESOURCE_TYPE_MAP.put(null, ResourceType.WORK);
        RESOURCE_TYPE_MAP.put("Labor", ResourceType.WORK);
        RESOURCE_TYPE_MAP.put("Material", ResourceType.MATERIAL);
        RESOURCE_TYPE_MAP.put("Nonlabor", ResourceType.COST);
        CONSTRAINT_TYPE_MAP = new HashMap<String, ConstraintType>();
        CONSTRAINT_TYPE_MAP.put("Start On", ConstraintType.START_ON);
        CONSTRAINT_TYPE_MAP.put("Start On or Before", ConstraintType.START_NO_LATER_THAN);
        CONSTRAINT_TYPE_MAP.put("Start On or After", ConstraintType.START_NO_EARLIER_THAN);
        CONSTRAINT_TYPE_MAP.put("Finish On", ConstraintType.FINISH_ON);
        CONSTRAINT_TYPE_MAP.put("Finish On or Before", ConstraintType.FINISH_NO_LATER_THAN);
        CONSTRAINT_TYPE_MAP.put("Finish On or After", ConstraintType.FINISH_NO_EARLIER_THAN);
        CONSTRAINT_TYPE_MAP.put("As Late As Possible", ConstraintType.AS_LATE_AS_POSSIBLE);
        CONSTRAINT_TYPE_MAP.put("Mandatory Start", ConstraintType.MUST_START_ON);
        CONSTRAINT_TYPE_MAP.put("Mandatory Finish", ConstraintType.MUST_FINISH_ON);
        PRIORITY_MAP = new HashMap<String, Priority>();
        PRIORITY_MAP.put("Top", Priority.getInstance(900));
        PRIORITY_MAP.put("High", Priority.getInstance(600));
        PRIORITY_MAP.put("Normal", Priority.getInstance(500));
        PRIORITY_MAP.put("Low", Priority.getInstance(400));
        PRIORITY_MAP.put("Lowest", Priority.getInstance(100));
        RELATION_TYPE_MAP = new HashMap<String, RelationType>();
        RELATION_TYPE_MAP.put("Finish to Start", RelationType.FINISH_START);
        RELATION_TYPE_MAP.put("Finish to Finish", RelationType.FINISH_FINISH);
        RELATION_TYPE_MAP.put("Start to Start", RelationType.START_START);
        RELATION_TYPE_MAP.put("Start to Finish", RelationType.START_FINISH);
        DAY_MAP = new HashMap<String, Day>();
        DAY_MAP.put("Monday", Day.MONDAY);
        DAY_MAP.put("Tuesday", Day.TUESDAY);
        DAY_MAP.put("Wednesday", Day.WEDNESDAY);
        DAY_MAP.put("Thursday", Day.THURSDAY);
        DAY_MAP.put("Friday", Day.FRIDAY);
        DAY_MAP.put("Saturday", Day.SATURDAY);
        DAY_MAP.put("Sunday", Day.SUNDAY);
        DAY_MAP.put("1", Day.SUNDAY);
        DAY_MAP.put("2", Day.MONDAY);
        DAY_MAP.put("3", Day.TUESDAY);
        DAY_MAP.put("4", Day.WEDNESDAY);
        DAY_MAP.put("5", Day.THURSDAY);
        DAY_MAP.put("6", Day.FRIDAY);
        DAY_MAP.put("7", Day.SATURDAY);
        MILESTONE_MAP = new HashMap<String, Boolean>();
        MILESTONE_MAP.put("Task Dependent", Boolean.FALSE);
        MILESTONE_MAP.put("Resource Dependent", Boolean.FALSE);
        MILESTONE_MAP.put("Level of Effort", Boolean.FALSE);
        MILESTONE_MAP.put("Start Milestone", Boolean.TRUE);
        MILESTONE_MAP.put("Finish Milestone", Boolean.TRUE);
        MILESTONE_MAP.put("WBS Summary", Boolean.FALSE);
        FIELD_TYPE_MAP = new HashMap<String, FieldTypeClass>();
        FIELD_TYPE_MAP.put("Activity", FieldTypeClass.TASK);
        FIELD_TYPE_MAP.put("WBS", FieldTypeClass.TASK);
        FIELD_TYPE_MAP.put("Resource", FieldTypeClass.RESOURCE);
        FIELD_TYPE_MAP.put("Resource Assignment", FieldTypeClass.ASSIGNMENT);
        ACCRUE_TYPE_MAP = new HashMap<String, AccrueType>();
        ACCRUE_TYPE_MAP.put("Uniform Over Activity", AccrueType.PRORATED);
        ACCRUE_TYPE_MAP.put("End of Activity", AccrueType.END);
        ACCRUE_TYPE_MAP.put("Start of Activity", AccrueType.START);
        DURATION_TYPE_MAP = new HashMap<String, TaskType>();
        DURATION_TYPE_MAP.put("Fixed Units/Time", TaskType.FIXED_UNITS);
        DURATION_TYPE_MAP.put("Fixed Duration and Units/Time", TaskType.FIXED_DURATION);
        DURATION_TYPE_MAP.put("Fixed Units", TaskType.FIXED_UNITS);
        DURATION_TYPE_MAP.put("Fixed Duration and Units", TaskType.FIXED_WORK);
        PERCENT_COMPLETE_TYPE = new HashMap<String, PercentCompleteType>();
        PERCENT_COMPLETE_TYPE.put("Physical", PercentCompleteType.PHYSICAL);
        PERCENT_COMPLETE_TYPE.put("Duration", PercentCompleteType.DURATION);
        PERCENT_COMPLETE_TYPE.put("Units", PercentCompleteType.UNITS);
        PERCENT_COMPLETE_TYPE.put("Scope", PercentCompleteType.SCOPE);
        STATUS_MAP = new HashMap<String, ActivityStatus>();
        STATUS_MAP.put("Not Started", ActivityStatus.NOT_STARTED);
        STATUS_MAP.put("In Progress", ActivityStatus.IN_PROGRESS);
        STATUS_MAP.put("Completed", ActivityStatus.COMPLETED);
        ACTIVITY_TYPE_MAP = new HashMap<String, ActivityType>();
        ACTIVITY_TYPE_MAP.put("Task Dependent", ActivityType.TASK_DEPENDENT);
        ACTIVITY_TYPE_MAP.put("Resource Dependent", ActivityType.RESOURCE_DEPENDENT);
        ACTIVITY_TYPE_MAP.put("Level of Effort", ActivityType.LEVEL_OF_EFFORT);
        ACTIVITY_TYPE_MAP.put("Start Milestone", ActivityType.START_MILESTONE);
        ACTIVITY_TYPE_MAP.put("Finish Milestone", ActivityType.FINISH_MILESTONE);
        ACTIVITY_TYPE_MAP.put("WBS Summary", ActivityType.WBS_SUMMARY);
        CRITICAL_ACTIVITY_MAP = new HashMap<String, CriticalActivityType>();
        CRITICAL_ACTIVITY_MAP.put("Critical Float", CriticalActivityType.TOTAL_FLOAT);
        CRITICAL_ACTIVITY_MAP.put("Longest Path", CriticalActivityType.LONGEST_PATH);
        WBS_ROW_COMPARATOR = new WbsRowComparatorPMXML();
        ENCODING_PATTERN = Pattern.compile(".*<\\?xml.*encoding=\"([^\"]+)\".*\\?>.*", 32);
    }
}

