/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.common.AutoCloseableHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.primavera.PrimaveraDatabaseReader;
import net.sf.mpxj.reader.AbstractProjectFileReader;
import org.sqlite.JDBC;

public final class PrimaveraDatabaseFileReader
extends AbstractProjectFileReader {
    private Integer m_projectID;

    public Map<Integer, String> listProjects(File file) throws MPXJException {
        Connection connection = null;
        try {
            connection = this.getDatabaseConnection(file);
            PrimaveraDatabaseReader reader = new PrimaveraDatabaseReader();
            reader.setConnection(connection);
            Map<Integer, String> map = reader.listProjects();
            return map;
        }
        catch (SQLException ex) {
            throw new MPXJException("Failed to create connection", ex);
        }
        finally {
            AutoCloseableHelper.closeQuietly(connection);
        }
    }

    public void setProjectID(int projectID) {
        this.m_projectID = projectID;
    }

    @Override
    public ProjectFile read(File file) throws MPXJException {
        Connection connection = null;
        try {
            connection = this.getDatabaseConnection(file);
            PrimaveraDatabaseReader reader = new PrimaveraDatabaseReader();
            reader.setConnection(connection);
            reader.setProjectID(NumberHelper.getInt(this.m_projectID));
            this.addListenersToReader(reader);
            ProjectFile projectFile = reader.read();
            return projectFile;
        }
        catch (SQLException ex) {
            throw new MPXJException("Failed to create connection", ex);
        }
        finally {
            AutoCloseableHelper.closeQuietly(connection);
        }
    }

    @Override
    public List<ProjectFile> readAll(File file) throws MPXJException {
        Connection connection = null;
        try {
            connection = this.getDatabaseConnection(file);
            PrimaveraDatabaseReader reader = new PrimaveraDatabaseReader();
            reader.setConnection(connection);
            this.addListenersToReader(reader);
            List<ProjectFile> list = reader.readAll();
            return list;
        }
        catch (SQLException ex) {
            throw new MPXJException("Failed to create connection", ex);
        }
        finally {
            AutoCloseableHelper.closeQuietly(connection);
        }
    }

    private Connection getDatabaseConnection(File file) throws SQLException {
        String url = "jdbc:sqlite:" + file.getAbsolutePath();
        Properties props = new Properties();
        props.setProperty("date_string_format", "yyyy-MM-dd HH:mm:ss");
        return JDBC.createConnection((String)url, (Properties)props);
    }
}

