/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.sf.mpxj.ChildTaskContainer;
import net.sf.mpxj.Task;

class ActivitySorter {
    final Set<Task> m_wbsTasks;

    public ActivitySorter(Set<Task> wbsTasks) {
        this.m_wbsTasks = wbsTasks;
    }

    public void sort(ChildTaskContainer container) {
        List<Task> tasks = container.getChildTasks();
        if (!tasks.isEmpty()) {
            tasks.stream().forEach(task -> this.sort((ChildTaskContainer)task));
            Collections.sort(tasks, new Comparator<Task>(){

                @Override
                public int compare(Task t1, Task t2) {
                    boolean t1IsWbs = ActivitySorter.this.m_wbsTasks.contains(t1);
                    boolean t2IsWbs = ActivitySorter.this.m_wbsTasks.contains(t2);
                    if (t1IsWbs && t2IsWbs) {
                        return t1.getID().compareTo(t2.getID());
                    }
                    if (!t1IsWbs && !t2IsWbs) {
                        String activityID1 = t1.getActivityID();
                        String activityID2 = t2.getActivityID();
                        if (activityID1 == null || activityID2 == null) {
                            return activityID1 == null && activityID2 == null ? 0 : (activityID1 == null ? 1 : -1);
                        }
                        return activityID1.compareTo(activityID2);
                    }
                    return t1IsWbs ? 1 : -1;
                }
            });
        }
    }
}

