/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mspdi;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.AssignmentField;
import net.sf.mpxj.Availability;
import net.sf.mpxj.CostRateTable;
import net.sf.mpxj.CostRateTableEntry;
import net.sf.mpxj.CustomField;
import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.CustomFieldLookupTable;
import net.sf.mpxj.CustomFieldValueDataType;
import net.sf.mpxj.CustomFieldValueMask;
import net.sf.mpxj.DataType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectCalendarWeek;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.RecurringData;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.ScheduleFrom;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TaskMode;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.TimephasedWork;
import net.sf.mpxj.common.AssignmentFieldLists;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.FieldTypeHelper;
import net.sf.mpxj.common.MPPAssignmentField;
import net.sf.mpxj.common.MPPResourceField;
import net.sf.mpxj.common.MPPTaskField;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.common.ProjectFieldLists;
import net.sf.mpxj.common.ResourceFieldLists;
import net.sf.mpxj.common.TaskFieldLists;
import net.sf.mpxj.mpp.CustomFieldValueItem;
import net.sf.mpxj.mspdi.DatatypeConverter;
import net.sf.mpxj.mspdi.SaveVersion;
import net.sf.mpxj.mspdi.schema.ObjectFactory;
import net.sf.mpxj.mspdi.schema.Project;
import net.sf.mpxj.mspdi.schema.TimephasedDataType;
import net.sf.mpxj.writer.AbstractProjectWriter;

public final class MSPDIWriter
extends AbstractProjectWriter {
    private static JAXBContext CONTEXT;
    private static JAXBException CONTEXT_EXCEPTION;
    private static final int[] DAY_MASKS;
    private ObjectFactory m_factory;
    private ProjectFile m_projectFile;
    private EventManager m_eventManager;
    private Set<FieldType> m_extendedAttributesInUse;
    private Map<FieldType, Map<String, CustomFieldValueItem>> m_customFieldValueItems;
    private boolean m_compatibleOutput = true;
    private boolean m_splitTimephasedAsDays = true;
    private boolean m_writeTimphasedData;
    private SaveVersion m_saveVersion = SaveVersion.Project2016;
    private static final BigInteger BIGINTEGER_ZERO;
    private static final Integer NULL_RESOURCE_ID;
    private static final BigInteger NULL_CALENDAR_ID;
    private static final Set<FieldType> ENTERPRISE_CUSTOM_FIELDS;

    public void setMicrosoftProjectCompatibleOutput(boolean flag) {
        this.m_compatibleOutput = flag;
    }

    public boolean getMicrosoftProjectCompatibleOutput() {
        return this.m_compatibleOutput;
    }

    public void setSplitTimephasedAsDays(boolean flag) {
        this.m_splitTimephasedAsDays = flag;
    }

    public boolean getSplitTimephasedAsDays() {
        return this.m_splitTimephasedAsDays;
    }

    public void setWriteTimephasedData(boolean value) {
        this.m_writeTimphasedData = value;
    }

    public boolean getWriteTimephasedData() {
        return this.m_writeTimphasedData;
    }

    public void setSaveVersion(SaveVersion version) {
        this.m_saveVersion = version;
    }

    public SaveVersion getSaveVersion() {
        return this.m_saveVersion;
    }

    @Override
    public void write(ProjectFile projectFile, OutputStream stream) throws IOException {
        try {
            if (CONTEXT == null) {
                throw CONTEXT_EXCEPTION;
            }
            this.m_projectFile = projectFile;
            this.m_projectFile.validateUniqueIDsForMicrosoftProject();
            this.m_eventManager = this.m_projectFile.getEventManager();
            DatatypeConverter.setParentFile(this.m_projectFile);
            Marshaller marshaller = CONTEXT.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            this.m_extendedAttributesInUse = new HashSet<FieldType>();
            this.m_customFieldValueItems = new HashMap<FieldType, Map<String, CustomFieldValueItem>>();
            this.m_factory = new ObjectFactory();
            Project project = this.m_factory.createProject();
            this.writeProjectProperties(project);
            this.writeCalendars(project);
            this.writeResources(project);
            this.writeTasks(project);
            this.writeAssignments(project);
            this.writeOutlineCodes(project);
            this.writeProjectExtendedAttributes(project);
            marshaller.marshal((Object)project, stream);
        }
        catch (JAXBException ex) {
            throw new IOException(ex.toString());
        }
        finally {
            this.m_projectFile = null;
            this.m_factory = null;
            this.m_extendedAttributesInUse = null;
            this.m_customFieldValueItems = null;
        }
    }

    private void writeProjectProperties(Project project) {
        ProjectProperties properties = this.m_projectFile.getProjectProperties();
        project.setActualsInSync(properties.getActualsInSync());
        project.setAdminProject(properties.getAdminProject());
        project.setAuthor(properties.getAuthor());
        project.setAutoAddNewResourcesAndTasks(properties.getAutoAddNewResourcesAndTasks());
        project.setAutolink(properties.getAutolink());
        project.setBaselineForEarnedValue(NumberHelper.getBigInteger(properties.getBaselineForEarnedValue()));
        project.setCalendarUID(this.m_projectFile.getDefaultCalendar() == null ? BigInteger.ONE : NumberHelper.getBigInteger(this.m_projectFile.getDefaultCalendar().getUniqueID()));
        project.setCategory(properties.getCategory());
        project.setCompany(properties.getCompany());
        project.setCreationDate(properties.getCreationDate());
        project.setCriticalSlackLimit(NumberHelper.getBigInteger(properties.getCriticalSlackLimit()));
        project.setCurrencyCode(properties.getCurrencyCode());
        project.setCurrencyDigits(BigInteger.valueOf(properties.getCurrencyDigits().intValue()));
        project.setCurrencySymbol(properties.getCurrencySymbol());
        project.setCurrencySymbolPosition(properties.getSymbolPosition());
        project.setCurrentDate(properties.getCurrentDate());
        project.setDaysPerMonth(NumberHelper.getBigInteger(properties.getDaysPerMonth()));
        project.setDefaultFinishTime(properties.getDefaultEndTime());
        project.setDefaultFixedCostAccrual(properties.getDefaultFixedCostAccrual());
        project.setDefaultOvertimeRate(DatatypeConverter.printRate(properties.getDefaultOvertimeRate()));
        project.setDefaultStandardRate(DatatypeConverter.printRate(properties.getDefaultStandardRate()));
        project.setDefaultStartTime(properties.getDefaultStartTime());
        project.setDefaultTaskEVMethod(DatatypeConverter.printEarnedValueMethod(properties.getDefaultTaskEarnedValueMethod()));
        project.setDefaultTaskType(properties.getDefaultTaskType());
        project.setDurationFormat(DatatypeConverter.printDurationTimeUnits(properties.getDefaultDurationUnits(), false));
        project.setEarnedValueMethod(DatatypeConverter.printEarnedValueMethod(properties.getEarnedValueMethod()));
        project.setEditableActualCosts(properties.getEditableActualCosts());
        project.setExtendedCreationDate(properties.getExtendedCreationDate());
        project.setFinishDate(properties.getFinishDate());
        project.setFiscalYearStart(properties.getFiscalYearStart());
        project.setFYStartDate(NumberHelper.getBigInteger(properties.getFiscalYearStartMonth()));
        project.setGUID(properties.getGUID());
        project.setHonorConstraints(properties.getHonorConstraints());
        project.setInsertedProjectsLikeSummary(properties.getInsertedProjectsLikeSummary());
        project.setLastSaved(properties.getLastSaved());
        project.setManager(properties.getManager());
        project.setMicrosoftProjectServerURL(properties.getMicrosoftProjectServerURL());
        project.setMinutesPerDay(NumberHelper.getBigInteger(properties.getMinutesPerDay()));
        project.setMinutesPerWeek(NumberHelper.getBigInteger(properties.getMinutesPerWeek()));
        project.setMoveCompletedEndsBack(properties.getMoveCompletedEndsBack());
        project.setMoveCompletedEndsForward(properties.getMoveCompletedEndsForward());
        project.setMoveRemainingStartsBack(properties.getMoveRemainingStartsBack());
        project.setMoveRemainingStartsForward(properties.getMoveRemainingStartsForward());
        project.setMultipleCriticalPaths(properties.getMultipleCriticalPaths());
        project.setName(properties.getName());
        project.setNewTasksEffortDriven(properties.getNewTasksEffortDriven());
        project.setNewTasksEstimated(properties.getNewTasksEstimated());
        project.setNewTaskStartDate(properties.getNewTaskStartIsProjectStart() ? BigInteger.ZERO : BigInteger.ONE);
        project.setNewTasksAreManual(properties.getNewTasksAreManual());
        project.setProjectExternallyEdited(properties.getProjectExternallyEdited());
        project.setRemoveFileProperties(properties.getRemoveFileProperties());
        project.setRevision(NumberHelper.getBigInteger(properties.getRevision()));
        project.setSaveVersion(BigInteger.valueOf(this.m_saveVersion.getValue()));
        project.setScheduleFromStart(properties.getScheduleFrom() == ScheduleFrom.START);
        project.setSplitsInProgressTasks(properties.getSplitInProgressTasks());
        project.setSpreadActualCost(properties.getSpreadActualCost());
        project.setSpreadPercentComplete(properties.getSpreadPercentComplete());
        project.setStartDate(properties.getStartDate());
        project.setStatusDate(properties.getStatusDate());
        project.setSubject(properties.getSubject());
        project.setTaskUpdatesResource(properties.getUpdatingTaskStatusUpdatesResourceStatus());
        project.setTitle(properties.getProjectTitle());
        project.setWeekStartDay(DatatypeConverter.printDay(properties.getWeekStartDay()));
        project.setWorkFormat(DatatypeConverter.printWorkUnits(properties.getDefaultWorkUnits()));
    }

    private void writeProjectExtendedAttributes(Project project) {
        Project.ExtendedAttributes attributes = this.m_factory.createProjectExtendedAttributes();
        project.setExtendedAttributes(attributes);
        List<Project.ExtendedAttributes.ExtendedAttribute> list = attributes.getExtendedAttribute();
        HashSet<FieldType> customFields = new HashSet<FieldType>();
        for (CustomField customField : this.m_projectFile.getCustomFields()) {
            FieldType fieldType = customField.getFieldType();
            if (fieldType == null) continue;
            customFields.add(fieldType);
        }
        customFields.addAll(this.m_extendedAttributesInUse);
        customFields.removeAll(ENTERPRISE_CUSTOM_FIELDS);
        ArrayList<FieldType> customFieldsList = new ArrayList<FieldType>();
        customFieldsList.addAll(customFields);
        final CustomFieldContainer customFieldContainer = this.m_projectFile.getCustomFields();
        Collections.sort(customFieldsList, new Comparator<FieldType>(){

            @Override
            public int compare(FieldType o1, FieldType o2) {
                CustomField customField1 = customFieldContainer.getCustomField(o1);
                CustomField customField2 = customFieldContainer.getCustomField(o2);
                String name1 = o1.getClass().getSimpleName() + "." + o1.getName() + " " + customField1.getAlias();
                String name2 = o2.getClass().getSimpleName() + "." + o2.getName() + " " + customField2.getAlias();
                return name1.compareTo(name2);
            }
        });
        for (FieldType fieldType : customFieldsList) {
            Project.ExtendedAttributes.ExtendedAttribute attribute = this.m_factory.createProjectExtendedAttributesExtendedAttribute();
            list.add(attribute);
            attribute.setFieldID(String.valueOf(FieldTypeHelper.getFieldID(fieldType)));
            attribute.setFieldName(fieldType.getName());
            CustomField customField = customFieldContainer.getCustomField(fieldType);
            attribute.setAlias(customField.getAlias());
            attribute.setLtuid(customField.getLookupTable().getGUID());
        }
    }

    private void writeOutlineCodes(Project project) {
        Project.OutlineCodes outlineCodes = null;
        ArrayList<CustomField> allCustomFields = new ArrayList<CustomField>();
        for (CustomField field : this.m_projectFile.getCustomFields()) {
            allCustomFields.add(field);
        }
        Collections.sort(allCustomFields, new Comparator<CustomField>(){

            @Override
            public int compare(CustomField customField1, CustomField customField2) {
                FieldType o1 = customField1.getFieldType();
                FieldType o2 = customField2.getFieldType();
                String className1 = o1 == null ? "Unknown" : o1.getClass().getSimpleName();
                String className2 = o2 == null ? "Unknown" : o2.getClass().getSimpleName();
                String fieldName1 = o1 == null ? "Unknown" : o1.getName();
                String fieldName2 = o2 == null ? "Unknown" : o2.getName();
                String name1 = className1 + "." + fieldName1 + " " + customField1.getAlias();
                String name2 = className2 + "." + fieldName2 + " " + customField2.getAlias();
                return name1.compareTo(name2);
            }
        });
        for (CustomField field : allCustomFields) {
            if (field.getLookupTable().isEmpty()) continue;
            if (outlineCodes == null) {
                outlineCodes = this.m_factory.createProjectOutlineCodes();
                project.setOutlineCodes(outlineCodes);
            }
            Project.OutlineCodes.OutlineCode outlineCode = this.m_factory.createProjectOutlineCodesOutlineCode();
            outlineCodes.getOutlineCode().add(outlineCode);
            this.writeOutlineCode(outlineCode, field);
        }
    }

    private void writeOutlineCode(Project.OutlineCodes.OutlineCode outlineCode, CustomField field) {
        CustomFieldLookupTable table = field.getLookupTable();
        outlineCode.setFieldID(String.valueOf(FieldTypeHelper.getFieldID(field.getFieldType())));
        outlineCode.setGuid(table.getGUID());
        outlineCode.setEnterprise(table.getEnterprise());
        outlineCode.setShowIndent(table.getShowIndent());
        outlineCode.setResourceSubstitutionEnabled(table.getResourceSubstitutionEnabled());
        outlineCode.setLeafOnly(table.getLeafOnly());
        outlineCode.setAllLevelsRequired(table.getAllLevelsRequired());
        outlineCode.setOnlyTableValuesAllowed(table.getOnlyTableValuesAllowed());
        outlineCode.setMasks(this.m_factory.createProjectOutlineCodesOutlineCodeMasks());
        if (field.getMasks().isEmpty()) {
            Object type = ((CustomFieldValueItem)table.get(0)).getType();
            if (type == null) {
                type = CustomFieldValueDataType.TEXT;
            }
            CustomFieldValueMask item = new CustomFieldValueMask(0, 1, ".", (CustomFieldValueDataType)type);
            this.writeMask(outlineCode, item);
        } else {
            for (CustomFieldValueMask item : field.getMasks()) {
                this.writeMask(outlineCode, item);
            }
        }
        Project.OutlineCodes.OutlineCode.Values values = this.m_factory.createProjectOutlineCodesOutlineCodeValues();
        outlineCode.setValues(values);
        for (CustomFieldValueItem item : table) {
            Project.OutlineCodes.OutlineCode.Values.Value value = this.m_factory.createProjectOutlineCodesOutlineCodeValuesValue();
            values.getValue().add(value);
            this.writeOutlineCodeValue(value, item);
        }
    }

    private void writeOutlineCodeValue(Project.OutlineCodes.OutlineCode.Values.Value value, CustomFieldValueItem item) {
        CustomFieldValueDataType type = item.getType();
        if (type == null) {
            type = CustomFieldValueDataType.TEXT;
        }
        value.setDescription(item.getDescription());
        value.setFieldGUID(item.getGUID());
        value.setIsCollapsed(item.getCollapsed());
        value.setParentValueID(NumberHelper.getBigInteger(item.getParent()));
        value.setType(BigInteger.valueOf(type.getValue()));
        value.setValueID(NumberHelper.getBigInteger(item.getUniqueID()));
        value.setValue(DatatypeConverter.printOutlineCodeValue(item.getValue(), type.getDataType()));
    }

    private void writeMask(Project.OutlineCodes.OutlineCode outlineCode, CustomFieldValueMask item) {
        Project.OutlineCodes.OutlineCode.Masks.Mask mask = this.m_factory.createProjectOutlineCodesOutlineCodeMasksMask();
        outlineCode.getMasks().getMask().add(mask);
        mask.setLength(BigInteger.valueOf(item.getLength()));
        mask.setLevel(BigInteger.valueOf(item.getLevel()));
        mask.setSeparator(item.getSeparator());
        mask.setType(BigInteger.valueOf(item.getType().getMaskValue()));
    }

    private void writeCalendars(Project project) {
        Project.Calendars calendars = this.m_factory.createProjectCalendars();
        project.setCalendars(calendars);
        List<Project.Calendars.Calendar> calendar = calendars.getCalendar();
        for (ProjectCalendar cal : this.m_projectFile.getCalendars()) {
            calendar.add(this.writeCalendar(cal));
        }
    }

    private Project.Calendars.Calendar writeCalendar(ProjectCalendar bc) {
        Project.Calendars.Calendar calendar = this.m_factory.createProjectCalendarsCalendar();
        calendar.setUID(NumberHelper.getBigInteger(bc.getUniqueID()));
        calendar.setIsBaseCalendar(!bc.isDerived());
        ProjectCalendar base = bc.getParent();
        calendar.setBaseCalendarUID(base == null ? NULL_CALENDAR_ID : NumberHelper.getBigInteger(base.getUniqueID()));
        calendar.setName(bc.getName());
        Project.Calendars.Calendar.WeekDays days = this.m_factory.createProjectCalendarsCalendarWeekDays();
        List<Project.Calendars.Calendar.WeekDays.WeekDay> dayList = days.getWeekDay();
        for (int loop = 1; loop < 8; ++loop) {
            DayType workingFlag = bc.getWorkingDay(Day.getInstance(loop));
            if (workingFlag == DayType.DEFAULT) continue;
            Project.Calendars.Calendar.WeekDays.WeekDay day = this.m_factory.createProjectCalendarsCalendarWeekDaysWeekDay();
            dayList.add(day);
            day.setDayType(BigInteger.valueOf(loop));
            day.setDayWorking(workingFlag == DayType.WORKING);
            if (workingFlag != DayType.WORKING) continue;
            Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes times = this.m_factory.createProjectCalendarsCalendarWeekDaysWeekDayWorkingTimes();
            day.setWorkingTimes(times);
            List<Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes.WorkingTime> timesList = times.getWorkingTime();
            ProjectCalendarHours bch = bc.getCalendarHours(Day.getInstance(loop));
            if (bch == null) continue;
            for (DateRange range : bch) {
                if (range == null) continue;
                Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes.WorkingTime time = this.m_factory.createProjectCalendarsCalendarWeekDaysWeekDayWorkingTimesWorkingTime();
                timesList.add(time);
                time.setFromTime(range.getStart());
                time.setToTime(range.getEnd());
            }
        }
        ArrayList<ProjectCalendarException> exceptions = new ArrayList<ProjectCalendarException>(bc.getCalendarExceptions());
        if (!exceptions.isEmpty()) {
            Collections.sort(exceptions);
            this.writeExceptions(calendar, dayList, exceptions);
        }
        if (!dayList.isEmpty()) {
            calendar.setWeekDays(days);
        }
        this.writeWorkWeeks(calendar, bc);
        this.m_eventManager.fireCalendarWrittenEvent(bc);
        return calendar;
    }

    private void writeExceptions(Project.Calendars.Calendar calendar, List<Project.Calendars.Calendar.WeekDays.WeekDay> dayList, List<ProjectCalendarException> exceptions) {
        this.writeExceptions9(dayList, exceptions);
        if (this.m_saveVersion.getValue() > SaveVersion.Project2003.getValue()) {
            this.writeExceptions12(calendar, exceptions);
        }
    }

    private void writeExceptions9(List<Project.Calendars.Calendar.WeekDays.WeekDay> dayList, List<ProjectCalendarException> exceptions) {
        for (ProjectCalendarException exception : exceptions) {
            boolean working = exception.getWorking();
            Project.Calendars.Calendar.WeekDays.WeekDay day = this.m_factory.createProjectCalendarsCalendarWeekDaysWeekDay();
            dayList.add(day);
            day.setDayType(BIGINTEGER_ZERO);
            day.setDayWorking(working);
            Project.Calendars.Calendar.WeekDays.WeekDay.TimePeriod period = this.m_factory.createProjectCalendarsCalendarWeekDaysWeekDayTimePeriod();
            day.setTimePeriod(period);
            period.setFromDate(exception.getFromDate());
            period.setToDate(exception.getToDate());
            if (!working) continue;
            Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes times = this.m_factory.createProjectCalendarsCalendarWeekDaysWeekDayWorkingTimes();
            day.setWorkingTimes(times);
            List<Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes.WorkingTime> timesList = times.getWorkingTime();
            for (DateRange range : exception) {
                Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes.WorkingTime time = this.m_factory.createProjectCalendarsCalendarWeekDaysWeekDayWorkingTimesWorkingTime();
                timesList.add(time);
                time.setFromTime(range.getStart());
                time.setToTime(range.getEnd());
            }
        }
    }

    private void writeExceptions12(Project.Calendars.Calendar calendar, List<ProjectCalendarException> exceptions) {
        Project.Calendars.Calendar.Exceptions ce = this.m_factory.createProjectCalendarsCalendarExceptions();
        calendar.setExceptions(ce);
        List<Project.Calendars.Calendar.Exceptions.Exception> el = ce.getException();
        for (ProjectCalendarException exception : exceptions) {
            Project.Calendars.Calendar.Exceptions.Exception ex = this.m_factory.createProjectCalendarsCalendarExceptionsException();
            el.add(ex);
            ex.setName(exception.getName());
            boolean working = exception.getWorking();
            ex.setDayWorking(working);
            if (exception.getRecurring() == null) {
                ex.setEnteredByOccurrences(Boolean.FALSE);
                ex.setOccurrences(BigInteger.ONE);
                ex.setType(BigInteger.ONE);
            } else {
                this.populateRecurringException(exception, ex);
            }
            Project.Calendars.Calendar.Exceptions.Exception.TimePeriod period = this.m_factory.createProjectCalendarsCalendarExceptionsExceptionTimePeriod();
            ex.setTimePeriod(period);
            period.setFromDate(exception.getFromDate());
            period.setToDate(exception.getToDate());
            if (!working) continue;
            Project.Calendars.Calendar.Exceptions.Exception.WorkingTimes times = this.m_factory.createProjectCalendarsCalendarExceptionsExceptionWorkingTimes();
            ex.setWorkingTimes(times);
            List<Project.Calendars.Calendar.Exceptions.Exception.WorkingTimes.WorkingTime> timesList = times.getWorkingTime();
            for (DateRange range : exception) {
                Project.Calendars.Calendar.Exceptions.Exception.WorkingTimes.WorkingTime time = this.m_factory.createProjectCalendarsCalendarExceptionsExceptionWorkingTimesWorkingTime();
                timesList.add(time);
                time.setFromTime(range.getStart());
                time.setToTime(range.getEnd());
            }
        }
    }

    private void populateRecurringException(ProjectCalendarException mpxjException, Project.Calendars.Calendar.Exceptions.Exception xmlException) {
        RecurringData data = mpxjException.getRecurring();
        xmlException.setEnteredByOccurrences(Boolean.TRUE);
        xmlException.setOccurrences(NumberHelper.getBigInteger(data.getOccurrences()));
        switch (data.getRecurrenceType()) {
            case DAILY: {
                xmlException.setType(BigInteger.valueOf(7L));
                xmlException.setPeriod(NumberHelper.getBigInteger(data.getFrequency()));
                break;
            }
            case WEEKLY: {
                xmlException.setType(BigInteger.valueOf(6L));
                xmlException.setPeriod(NumberHelper.getBigInteger(data.getFrequency()));
                xmlException.setDaysOfWeek(this.getDaysOfTheWeek(data));
                break;
            }
            case MONTHLY: {
                xmlException.setPeriod(NumberHelper.getBigInteger(data.getFrequency()));
                if (data.getRelative()) {
                    xmlException.setType(BigInteger.valueOf(5L));
                    xmlException.setMonthItem(BigInteger.valueOf(data.getDayOfWeek().getValue() + 2));
                    xmlException.setMonthPosition(BigInteger.valueOf(NumberHelper.getInt(data.getDayNumber()) - 1));
                    break;
                }
                xmlException.setType(BigInteger.valueOf(4L));
                xmlException.setMonthDay(NumberHelper.getBigInteger(data.getDayNumber()));
                break;
            }
            case YEARLY: {
                xmlException.setMonth(BigInteger.valueOf(NumberHelper.getInt(data.getMonthNumber()) - 1));
                if (data.getRelative()) {
                    xmlException.setType(BigInteger.valueOf(3L));
                    xmlException.setMonthItem(BigInteger.valueOf(data.getDayOfWeek().getValue() + 2));
                    xmlException.setMonthPosition(BigInteger.valueOf(NumberHelper.getInt(data.getDayNumber()) - 1));
                    break;
                }
                xmlException.setType(BigInteger.valueOf(2L));
                xmlException.setMonthDay(NumberHelper.getBigInteger(data.getDayNumber()));
            }
        }
    }

    private BigInteger getDaysOfTheWeek(RecurringData data) {
        int value = 0;
        for (Day day : Day.values()) {
            if (!data.getWeeklyDay(day)) continue;
            value |= DAY_MASKS[day.getValue()];
        }
        return BigInteger.valueOf(value);
    }

    private void writeWorkWeeks(Project.Calendars.Calendar xmlCalendar, ProjectCalendar mpxjCalendar) {
        List<ProjectCalendarWeek> weeks = mpxjCalendar.getWorkWeeks();
        if (!weeks.isEmpty()) {
            Project.Calendars.Calendar.WorkWeeks xmlWorkWeeks = this.m_factory.createProjectCalendarsCalendarWorkWeeks();
            xmlCalendar.setWorkWeeks(xmlWorkWeeks);
            List<Project.Calendars.Calendar.WorkWeeks.WorkWeek> xmlWorkWeekList = xmlWorkWeeks.getWorkWeek();
            for (ProjectCalendarWeek week : weeks) {
                Project.Calendars.Calendar.WorkWeeks.WorkWeek xmlWeek = this.m_factory.createProjectCalendarsCalendarWorkWeeksWorkWeek();
                xmlWorkWeekList.add(xmlWeek);
                xmlWeek.setName(week.getName());
                Project.Calendars.Calendar.WorkWeeks.WorkWeek.TimePeriod xmlTimePeriod = this.m_factory.createProjectCalendarsCalendarWorkWeeksWorkWeekTimePeriod();
                xmlWeek.setTimePeriod(xmlTimePeriod);
                xmlTimePeriod.setFromDate(week.getDateRange().getStart());
                xmlTimePeriod.setToDate(week.getDateRange().getEnd());
                Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays xmlWeekDays = this.m_factory.createProjectCalendarsCalendarWorkWeeksWorkWeekWeekDays();
                xmlWeek.setWeekDays(xmlWeekDays);
                List<Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays.WeekDay> dayList = xmlWeekDays.getWeekDay();
                for (int loop = 1; loop < 8; ++loop) {
                    DayType workingFlag = week.getWorkingDay(Day.getInstance(loop));
                    if (workingFlag == DayType.DEFAULT) continue;
                    Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays.WeekDay day = this.m_factory.createProjectCalendarsCalendarWorkWeeksWorkWeekWeekDaysWeekDay();
                    dayList.add(day);
                    day.setDayType(BigInteger.valueOf(loop));
                    day.setDayWorking(workingFlag == DayType.WORKING);
                    if (workingFlag != DayType.WORKING) continue;
                    Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays.WeekDay.WorkingTimes times = this.m_factory.createProjectCalendarsCalendarWorkWeeksWorkWeekWeekDaysWeekDayWorkingTimes();
                    day.setWorkingTimes(times);
                    List<Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays.WeekDay.WorkingTimes.WorkingTime> timesList = times.getWorkingTime();
                    ProjectCalendarHours bch = week.getCalendarHours(Day.getInstance(loop));
                    if (bch == null) continue;
                    for (DateRange range : bch) {
                        if (range == null) continue;
                        Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays.WeekDay.WorkingTimes.WorkingTime time = this.m_factory.createProjectCalendarsCalendarWorkWeeksWorkWeekWeekDaysWeekDayWorkingTimesWorkingTime();
                        timesList.add(time);
                        time.setFromTime(range.getStart());
                        time.setToTime(range.getEnd());
                    }
                }
            }
        }
    }

    private void writeResources(Project project) {
        Project.Resources resources = this.m_factory.createProjectResources();
        project.setResources(resources);
        List<Project.Resources.Resource> list = resources.getResource();
        for (Resource resource : this.m_projectFile.getResources()) {
            list.add(this.writeResource(resource));
        }
    }

    private Project.Resources.Resource writeResource(Resource mpx) {
        Project.Resources.Resource xml = this.m_factory.createProjectResourcesResource();
        ProjectCalendar cal = mpx.getResourceCalendar();
        if (cal != null) {
            xml.setCalendarUID(NumberHelper.getBigInteger(cal.getUniqueID()));
        }
        xml.setAccrueAt(mpx.getAccrueAt());
        xml.setActiveDirectoryGUID(mpx.getActiveDirectoryGUID());
        xml.setActualCost(DatatypeConverter.printCurrency(mpx.getActualCost()));
        xml.setActualOvertimeCost(DatatypeConverter.printCurrency(mpx.getActualOvertimeCost()));
        xml.setActualOvertimeWork(DatatypeConverter.printDuration(this, mpx.getActualOvertimeWork()));
        xml.setActualOvertimeWorkProtected(DatatypeConverter.printDuration(this, mpx.getActualOvertimeWorkProtected()));
        xml.setActualWork(DatatypeConverter.printDuration(this, mpx.getActualWork()));
        xml.setActualWorkProtected(DatatypeConverter.printDuration(this, mpx.getActualWorkProtected()));
        xml.setACWP(DatatypeConverter.printCurrency(mpx.getACWP()));
        xml.setAvailableFrom(mpx.getAvailableFrom());
        xml.setAvailableTo(mpx.getAvailableTo());
        xml.setBCWS(DatatypeConverter.printCurrency(mpx.getBCWS()));
        xml.setBCWP(DatatypeConverter.printCurrency(mpx.getBCWP()));
        xml.setBookingType(mpx.getBookingType());
        xml.setIsBudget(mpx.getBudget());
        xml.setCanLevel(mpx.getCanLevel());
        xml.setCode(mpx.getCode());
        xml.setCost(DatatypeConverter.printCurrency(mpx.getCost()));
        xml.setCostPerUse(DatatypeConverter.printCurrency(mpx.getCostPerUse()));
        xml.setCostVariance(DatatypeConverter.printCurrency(mpx.getCostVariance()));
        xml.setCreationDate(mpx.getCreationDate());
        xml.setCV(DatatypeConverter.printCurrency(mpx.getCV()));
        xml.setEmailAddress(mpx.getEmailAddress());
        xml.setFinish(mpx.getFinish());
        xml.setGroup(mpx.getGroup());
        xml.setGUID(mpx.getGUID());
        xml.setHyperlink(mpx.getHyperlink());
        xml.setHyperlinkAddress(mpx.getHyperlinkAddress());
        xml.setHyperlinkSubAddress(mpx.getHyperlinkSubAddress());
        xml.setID(NumberHelper.getBigInteger(mpx.getID()));
        xml.setInitials(mpx.getInitials());
        xml.setIsEnterprise(mpx.getEnterprise());
        xml.setIsGeneric(mpx.getGeneric());
        xml.setIsInactive(!mpx.getActive());
        xml.setIsNull(mpx.getNull());
        xml.setMaterialLabel(mpx.getMaterialLabel());
        xml.setMaxUnits(DatatypeConverter.printUnits(mpx.getMaxUnits()));
        xml.setName(mpx.getName());
        if (!mpx.getNotes().isEmpty()) {
            xml.setNotes(mpx.getNotes());
        }
        xml.setNTAccount(mpx.getNtAccount());
        xml.setOverAllocated(mpx.getOverAllocated());
        xml.setOvertimeCost(DatatypeConverter.printCurrency(mpx.getOvertimeCost()));
        xml.setOvertimeRate(DatatypeConverter.printRate(mpx.getOvertimeRate()));
        xml.setOvertimeRateFormat(DatatypeConverter.printTimeUnit(mpx.getOvertimeRateUnits()));
        xml.setOvertimeWork(DatatypeConverter.printDuration(this, mpx.getOvertimeWork()));
        xml.setPeakUnits(DatatypeConverter.printUnits(mpx.getPeakUnits()));
        xml.setPercentWorkComplete(NumberHelper.getBigInteger(mpx.getPercentWorkComplete()));
        xml.setPhonetics(mpx.getPhonetics());
        xml.setRegularWork(DatatypeConverter.printDuration(this, mpx.getRegularWork()));
        xml.setRemainingCost(DatatypeConverter.printCurrency(mpx.getRemainingCost()));
        xml.setRemainingOvertimeCost(DatatypeConverter.printCurrency(mpx.getRemainingOvertimeCost()));
        xml.setRemainingOvertimeWork(DatatypeConverter.printDuration(this, mpx.getRemainingOvertimeWork()));
        xml.setRemainingWork(DatatypeConverter.printDuration(this, mpx.getRemainingWork()));
        xml.setStandardRate(DatatypeConverter.printRate(mpx.getStandardRate()));
        xml.setStandardRateFormat(DatatypeConverter.printTimeUnit(mpx.getStandardRateUnits()));
        xml.setStart(mpx.getStart());
        xml.setSV(DatatypeConverter.printCurrency(mpx.getSV()));
        xml.setUID(mpx.getUniqueID());
        xml.setWork(DatatypeConverter.printDuration(this, mpx.getWork()));
        xml.setWorkGroup(mpx.getWorkGroup());
        xml.setWorkVariance(DatatypeConverter.printDurationInDecimalThousandthsOfMinutes(mpx.getWorkVariance()));
        if (mpx.getType() == ResourceType.COST) {
            xml.setType(ResourceType.MATERIAL);
            xml.setIsCostResource(Boolean.TRUE);
        } else {
            xml.setType(mpx.getType());
        }
        this.writeResourceExtendedAttributes(xml, mpx);
        this.writeResourceOutlineCodes(xml, mpx);
        this.writeResourceBaselines(xml, mpx);
        this.writeCostRateTables(xml, mpx);
        this.writeAvailability(xml, mpx);
        return xml;
    }

    private void writeResourceBaselines(Project.Resources.Resource xmlResource, Resource mpxjResource) {
        Duration work;
        Project.Resources.Resource.Baseline baseline = this.m_factory.createProjectResourcesResourceBaseline();
        boolean populated = false;
        Number cost = mpxjResource.getBaselineCost();
        if (cost != null && cost.intValue() != 0) {
            populated = true;
            baseline.setCost(DatatypeConverter.printCurrency(cost));
        }
        if ((work = mpxjResource.getBaselineWork()) != null && work.getDuration() != 0.0) {
            populated = true;
            baseline.setWork(DatatypeConverter.printDuration(this, work));
        }
        if (populated) {
            xmlResource.getBaseline().add(baseline);
            baseline.setNumber(BigInteger.ZERO);
        }
        for (int loop = 1; loop <= 10; ++loop) {
            baseline = this.m_factory.createProjectResourcesResourceBaseline();
            populated = false;
            cost = mpxjResource.getBaselineCost(loop);
            if (cost != null && cost.intValue() != 0) {
                populated = true;
                baseline.setCost(DatatypeConverter.printCurrency(cost));
            }
            if ((work = mpxjResource.getBaselineWork(loop)) != null && work.getDuration() != 0.0) {
                populated = true;
                baseline.setWork(DatatypeConverter.printDuration(this, work));
            }
            if (!populated) continue;
            xmlResource.getBaseline().add(baseline);
            baseline.setNumber(BigInteger.valueOf(loop));
        }
    }

    private void writeResourceExtendedAttributes(Project.Resources.Resource xml, Resource mpx) {
        List<Project.Resources.Resource.ExtendedAttribute> extendedAttributes = xml.getExtendedAttribute();
        for (ResourceField mpxFieldID : ResourceFieldLists.EXTENDED_FIELDS) {
            Object value = mpx.getCachedValue(mpxFieldID);
            if (!FieldTypeHelper.valueIsNotDefault(mpxFieldID, value)) continue;
            this.m_extendedAttributesInUse.add(mpxFieldID);
            Integer xmlFieldID = MPPResourceField.getID(mpxFieldID) | 0xC400000;
            String formattedValue = DatatypeConverter.printExtendedAttribute(this, value, mpxFieldID.getDataType());
            Project.Resources.Resource.ExtendedAttribute attrib = this.m_factory.createProjectResourcesResourceExtendedAttribute();
            extendedAttributes.add(attrib);
            attrib.setFieldID(xmlFieldID.toString());
            attrib.setValue(formattedValue);
            attrib.setDurationFormat(this.printExtendedAttributeDurationFormat(value));
            this.setValueGUID(attrib, (FieldType)mpxFieldID, formattedValue);
        }
    }

    private void setValueGUID(Project.Resources.Resource.ExtendedAttribute attrib, FieldType fieldType, String formattedValue) {
        CustomFieldValueItem valueItem = this.getValueItem(fieldType, formattedValue);
        if (valueItem != null) {
            attrib.setValueGUID(valueItem.getGUID());
        }
    }

    private void writeResourceOutlineCodes(Project.Resources.Resource xml, Resource mpx) {
        List<Project.Resources.Resource.OutlineCode> outlineCodes = xml.getOutlineCode();
        for (ResourceField mpxFieldID : ResourceFieldLists.CUSTOM_OUTLINE_CODE) {
            Object value = mpx.getCachedValue(mpxFieldID);
            if (!FieldTypeHelper.valueIsNotDefault(mpxFieldID, value)) continue;
            this.m_extendedAttributesInUse.add(mpxFieldID);
            Integer xmlFieldID = MPPResourceField.getID(mpxFieldID) | 0xC400000;
            String formattedValue = DatatypeConverter.printExtendedAttribute(this, value, mpxFieldID.getDataType());
            Project.Resources.Resource.OutlineCode attrib = this.m_factory.createProjectResourcesResourceOutlineCode();
            outlineCodes.add(attrib);
            attrib.setFieldID(xmlFieldID.toString());
            this.setValueID(attrib, (FieldType)mpxFieldID, formattedValue);
        }
    }

    private void setValueID(Project.Resources.Resource.OutlineCode attrib, FieldType fieldType, String formattedValue) {
        CustomFieldValueItem valueItem = this.getValueItem(fieldType, formattedValue);
        if (valueItem != null) {
            attrib.setValueID(NumberHelper.getBigInteger(valueItem.getUniqueID()));
        }
    }

    private void writeCostRateTables(Project.Resources.Resource xml, Resource mpx) {
        List<Project.Resources.Resource.Rates.Rate> ratesList = null;
        for (int tableIndex = 0; tableIndex < 5; ++tableIndex) {
            CostRateTable table = mpx.getCostRateTable(tableIndex);
            if (table == null) continue;
            for (CostRateTableEntry entry : table) {
                if (!this.costRateTableWriteRequired(entry)) continue;
                if (ratesList == null) {
                    Project.Resources.Resource.Rates rates = this.m_factory.createProjectResourcesResourceRates();
                    xml.setRates(rates);
                    ratesList = rates.getRate();
                }
                Project.Resources.Resource.Rates.Rate rate = this.m_factory.createProjectResourcesResourceRatesRate();
                ratesList.add(rate);
                rate.setCostPerUse(DatatypeConverter.printCurrencyMandatory(entry.getCostPerUse()));
                rate.setOvertimeRate(DatatypeConverter.printRateMandatory(entry.getOvertimeRate()));
                rate.setOvertimeRateFormat(DatatypeConverter.printTimeUnit(entry.getOvertimeRateFormat()));
                rate.setRatesFrom(entry.getStartDate());
                rate.setRatesTo(entry.getEndDate());
                rate.setRateTable(BigInteger.valueOf(tableIndex));
                rate.setStandardRate(DatatypeConverter.printRateMandatory(entry.getStandardRate()));
                rate.setStandardRateFormat(DatatypeConverter.printTimeUnit(entry.getStandardRateFormat()));
            }
        }
    }

    private boolean costRateTableWriteRequired(CostRateTableEntry entry) {
        boolean fromDate = DateHelper.compare(entry.getStartDate(), DateHelper.START_DATE_NA) > 0;
        boolean toDate = DateHelper.compare(entry.getEndDate(), DateHelper.END_DATE_NA) > 0;
        boolean costPerUse = NumberHelper.getDouble(entry.getCostPerUse()) != 0.0;
        boolean overtimeRate = entry.getOvertimeRate() != null && entry.getOvertimeRate().getAmount() != 0.0;
        boolean standardRate = entry.getStandardRate() != null && entry.getStandardRate().getAmount() != 0.0;
        return fromDate || toDate || costPerUse || overtimeRate || standardRate;
    }

    private void writeAvailability(Project.Resources.Resource xml, Resource mpx) {
        Project.Resources.Resource.AvailabilityPeriods periods = this.m_factory.createProjectResourcesResourceAvailabilityPeriods();
        xml.setAvailabilityPeriods(periods);
        List<Project.Resources.Resource.AvailabilityPeriods.AvailabilityPeriod> list = periods.getAvailabilityPeriod();
        for (Availability availability : mpx.getAvailability()) {
            Project.Resources.Resource.AvailabilityPeriods.AvailabilityPeriod period = this.m_factory.createProjectResourcesResourceAvailabilityPeriodsAvailabilityPeriod();
            list.add(period);
            DateRange range = availability.getRange();
            period.setAvailableFrom(range.getStart());
            period.setAvailableTo(range.getEnd());
            period.setAvailableUnits(DatatypeConverter.printUnits(availability.getUnits()));
        }
    }

    private void writeTasks(Project project) {
        Project.Tasks tasks = this.m_factory.createProjectTasks();
        project.setTasks(tasks);
        List<Project.Tasks.Task> list = tasks.getTask();
        for (Task task : this.m_projectFile.getTasks()) {
            list.add(this.writeTask(task));
        }
    }

    private Project.Tasks.Task writeTask(Task mpx) {
        Project.Tasks.Task xml = this.m_factory.createProjectTasksTask();
        xml.setActive(mpx.getActive());
        xml.setActualCost(DatatypeConverter.printCurrency(mpx.getActualCost()));
        xml.setActualDuration(DatatypeConverter.printDuration(this, mpx.getActualDuration()));
        xml.setActualFinish(mpx.getActualFinish());
        xml.setActualOvertimeCost(DatatypeConverter.printCurrency(mpx.getActualOvertimeCost()));
        xml.setActualOvertimeWork(DatatypeConverter.printDuration(this, mpx.getActualOvertimeWork()));
        xml.setActualOvertimeWorkProtected(DatatypeConverter.printDuration(this, mpx.getActualOvertimeWorkProtected()));
        xml.setActualStart(mpx.getActualStart());
        xml.setActualWork(DatatypeConverter.printDuration(this, mpx.getActualWork()));
        xml.setActualWorkProtected(DatatypeConverter.printDuration(this, mpx.getActualWorkProtected()));
        xml.setACWP(DatatypeConverter.printCurrency(mpx.getACWP()));
        xml.setBCWP(DatatypeConverter.printCurrency(mpx.getBCWP()));
        xml.setBCWS(DatatypeConverter.printCurrency(mpx.getBCWS()));
        xml.setCalendarUID(this.getTaskCalendarID(mpx));
        xml.setConstraintDate(mpx.getConstraintDate());
        xml.setConstraintType(DatatypeConverter.printConstraintType(mpx.getConstraintType()));
        xml.setContact(mpx.getContact());
        xml.setCost(DatatypeConverter.printCurrency(mpx.getCost()));
        xml.setCreateDate(mpx.getCreateDate());
        xml.setCritical(mpx.getCritical());
        xml.setCV(DatatypeConverter.printCurrency(mpx.getCV()));
        xml.setDeadline(mpx.getDeadline());
        xml.setDuration(DatatypeConverter.printDurationMandatory(this, mpx.getDuration()));
        xml.setDurationText(mpx.getDurationText());
        xml.setDurationFormat(DatatypeConverter.printDurationTimeUnits(mpx.getDuration(), mpx.getEstimated()));
        xml.setEarlyFinish(mpx.getEarlyFinish());
        xml.setEarlyStart(mpx.getEarlyStart());
        xml.setEarnedValueMethod(DatatypeConverter.printEarnedValueMethod(mpx.getEarnedValueMethod()));
        xml.setEffortDriven(mpx.getEffortDriven());
        xml.setEstimated(mpx.getEstimated());
        xml.setExternalTask(mpx.getExternalTask());
        xml.setExternalTaskProject(mpx.getProject());
        xml.setFinish(mpx.getFinish());
        xml.setFinishSlack(DatatypeConverter.printDurationInIntegerTenthsOfMinutes(mpx.getFinishSlack()));
        xml.setFinishText(mpx.getFinishText());
        xml.setFinishVariance(DatatypeConverter.printDurationInIntegerThousandthsOfMinutes(mpx.getFinishVariance()));
        xml.setFixedCost(DatatypeConverter.printCurrency(mpx.getFixedCost()));
        AccrueType fixedCostAccrual = mpx.getFixedCostAccrual();
        if (fixedCostAccrual == null) {
            fixedCostAccrual = AccrueType.PRORATED;
        }
        xml.setFixedCostAccrual(fixedCostAccrual);
        xml.setFreeSlack(DatatypeConverter.printDurationInIntegerTenthsOfMinutes(mpx.getFreeSlack()));
        xml.setGUID(mpx.getGUID());
        xml.setHideBar(mpx.getHideBar());
        xml.setIsNull(mpx.getNull());
        xml.setIsSubproject(mpx.getSubProject() != null);
        xml.setIsSubprojectReadOnly(mpx.getSubprojectReadOnly());
        xml.setHyperlink(mpx.getHyperlink());
        xml.setHyperlinkAddress(mpx.getHyperlinkAddress());
        xml.setHyperlinkSubAddress(mpx.getHyperlinkSubAddress());
        xml.setID(NumberHelper.getBigInteger(mpx.getID()));
        xml.setIgnoreResourceCalendar(mpx.getIgnoreResourceCalendar());
        xml.setLateFinish(mpx.getLateFinish());
        xml.setLateStart(mpx.getLateStart());
        xml.setLevelAssignments(mpx.getLevelAssignments());
        xml.setLevelingCanSplit(mpx.getLevelingCanSplit());
        if (mpx.getLevelingDelay() == null) {
            if (mpx.getLevelingDelayFormat() != null) {
                xml.setLevelingDelayFormat(DatatypeConverter.printDurationTimeUnits(mpx.getLevelingDelayFormat(), false));
            }
        } else {
            Duration levelingDelay = mpx.getLevelingDelay();
            double tenthMinutes = 10.0 * Duration.convertUnits(levelingDelay.getDuration(), levelingDelay.getUnits(), TimeUnit.MINUTES, this.m_projectFile.getProjectProperties()).getDuration();
            xml.setLevelingDelay(BigInteger.valueOf((long)tenthMinutes));
            xml.setLevelingDelayFormat(DatatypeConverter.printDurationTimeUnits(levelingDelay, false));
        }
        xml.setManual(mpx.getTaskMode() == TaskMode.MANUALLY_SCHEDULED);
        if (mpx.getTaskMode() == TaskMode.MANUALLY_SCHEDULED) {
            xml.setManualDuration(DatatypeConverter.printDuration(this, mpx.getDuration()));
            xml.setManualFinish(mpx.getFinish());
            xml.setManualStart(mpx.getStart());
        }
        xml.setMilestone(mpx.getMilestone());
        xml.setName(mpx.getName());
        if (!mpx.getNotes().isEmpty()) {
            xml.setNotes(mpx.getNotes());
        }
        xml.setOutlineLevel(NumberHelper.getBigInteger(mpx.getOutlineLevel()));
        xml.setOutlineNumber(mpx.getOutlineNumber());
        xml.setOverAllocated(mpx.getOverAllocated());
        xml.setOvertimeCost(DatatypeConverter.printCurrency(mpx.getOvertimeCost()));
        xml.setOvertimeWork(DatatypeConverter.printDuration(this, mpx.getOvertimeWork()));
        xml.setPercentComplete(NumberHelper.getBigInteger(mpx.getPercentageComplete()));
        xml.setPercentWorkComplete(NumberHelper.getBigInteger(mpx.getPercentageWorkComplete()));
        xml.setPhysicalPercentComplete(NumberHelper.getBigInteger(mpx.getPhysicalPercentComplete()));
        xml.setPriority(DatatypeConverter.printPriority(mpx.getPriority()));
        xml.setRecurring(mpx.getRecurring());
        xml.setRegularWork(DatatypeConverter.printDuration(this, mpx.getRegularWork()));
        xml.setRemainingCost(DatatypeConverter.printCurrency(mpx.getRemainingCost()));
        if (mpx.getRemainingDuration() == null) {
            Duration duration = mpx.getDuration();
            if (duration != null) {
                double amount = duration.getDuration();
                amount -= amount * NumberHelper.getDouble(mpx.getPercentageComplete()) / 100.0;
                xml.setRemainingDuration(DatatypeConverter.printDuration(this, Duration.getInstance(amount, duration.getUnits())));
            }
        } else {
            xml.setRemainingDuration(DatatypeConverter.printDuration(this, mpx.getRemainingDuration()));
        }
        xml.setRemainingOvertimeCost(DatatypeConverter.printCurrency(mpx.getRemainingOvertimeCost()));
        xml.setRemainingOvertimeWork(DatatypeConverter.printDuration(this, mpx.getRemainingOvertimeWork()));
        xml.setRemainingWork(DatatypeConverter.printDuration(this, mpx.getRemainingWork()));
        xml.setResume(mpx.getResume());
        xml.setResumeValid(mpx.getResumeValid());
        xml.setRollup(mpx.getRollup());
        xml.setStart(mpx.getStart());
        xml.setStartSlack(DatatypeConverter.printDurationInIntegerTenthsOfMinutes(mpx.getStartSlack()));
        xml.setStartText(mpx.getStartText());
        xml.setStartVariance(DatatypeConverter.printDurationInIntegerThousandthsOfMinutes(mpx.getStartVariance()));
        xml.setStop(mpx.getStop());
        xml.setSubprojectName(mpx.getSubprojectName());
        xml.setSummary(mpx.hasChildTasks());
        xml.setTotalSlack(DatatypeConverter.printDurationInIntegerTenthsOfMinutes(mpx.getTotalSlack()));
        xml.setType(mpx.getType());
        xml.setUID(mpx.getUniqueID());
        xml.setWBS(mpx.getWBS());
        xml.setWork(DatatypeConverter.printDuration(this, mpx.getWork()));
        xml.setWorkVariance(DatatypeConverter.printDurationInDecimalThousandthsOfMinutes(mpx.getWorkVariance()));
        if (mpx.getTaskMode() == TaskMode.MANUALLY_SCHEDULED) {
            xml.setManualDuration(DatatypeConverter.printDuration(this, mpx.getManualDuration()));
        }
        this.writePredecessors(xml, mpx);
        this.writeTaskExtendedAttributes(xml, mpx);
        this.writeTaskOutlineCodes(xml, mpx);
        this.writeTaskBaselines(xml, mpx);
        return xml;
    }

    private void writeTaskBaselines(Project.Tasks.Task xmlTask, Task mpxjTask) {
        Date date;
        Duration duration;
        Project.Tasks.Task.Baseline baseline = this.m_factory.createProjectTasksTaskBaseline();
        boolean populated = false;
        Number cost = mpxjTask.getBaselineCost();
        if (cost != null && cost.intValue() != 0) {
            populated = true;
            baseline.setCost(DatatypeConverter.printCurrency(cost));
        }
        if ((duration = mpxjTask.getBaselineDuration()) != null && duration.getDuration() != 0.0) {
            populated = true;
            baseline.setDuration(DatatypeConverter.printDuration(this, duration));
            baseline.setDurationFormat(DatatypeConverter.printDurationTimeUnits(duration, false));
        }
        if ((date = mpxjTask.getBaselineFinish()) != null) {
            populated = true;
            baseline.setFinish(date);
        }
        if ((date = mpxjTask.getBaselineStart()) != null) {
            populated = true;
            baseline.setStart(date);
        }
        if ((duration = mpxjTask.getBaselineWork()) != null && duration.getDuration() != 0.0) {
            populated = true;
            baseline.setWork(DatatypeConverter.printDuration(this, duration));
        }
        if (populated) {
            baseline.setNumber(BigInteger.ZERO);
            xmlTask.getBaseline().add(baseline);
        }
        for (int loop = 1; loop <= 10; ++loop) {
            baseline = this.m_factory.createProjectTasksTaskBaseline();
            populated = false;
            cost = mpxjTask.getBaselineCost(loop);
            if (cost != null && cost.intValue() != 0) {
                populated = true;
                baseline.setCost(DatatypeConverter.printCurrency(cost));
            }
            if ((duration = mpxjTask.getBaselineDuration(loop)) != null && duration.getDuration() != 0.0) {
                populated = true;
                baseline.setDuration(DatatypeConverter.printDuration(this, duration));
                baseline.setDurationFormat(DatatypeConverter.printDurationTimeUnits(duration, false));
            }
            if ((date = mpxjTask.getBaselineFinish(loop)) != null) {
                populated = true;
                baseline.setFinish(date);
            }
            if ((date = mpxjTask.getBaselineStart(loop)) != null) {
                populated = true;
                baseline.setStart(date);
            }
            if ((duration = mpxjTask.getBaselineWork(loop)) != null && duration.getDuration() != 0.0) {
                populated = true;
                baseline.setWork(DatatypeConverter.printDuration(this, duration));
            }
            if (!populated) continue;
            baseline.setNumber(BigInteger.valueOf(loop));
            xmlTask.getBaseline().add(baseline);
        }
    }

    private void writeTaskExtendedAttributes(Project.Tasks.Task xml, Task mpx) {
        List<Project.Tasks.Task.ExtendedAttribute> extendedAttributes = xml.getExtendedAttribute();
        for (TaskField mpxFieldID : TaskFieldLists.EXTENDED_FIELDS) {
            Object value = mpx.getCachedValue(mpxFieldID);
            if (!FieldTypeHelper.valueIsNotDefault(mpxFieldID, value)) continue;
            this.m_extendedAttributesInUse.add(mpxFieldID);
            Integer xmlFieldID = MPPTaskField.getID(mpxFieldID) | 0xB400000;
            String formattedValue = DatatypeConverter.printExtendedAttribute(this, value, mpxFieldID.getDataType());
            Project.Tasks.Task.ExtendedAttribute attrib = this.m_factory.createProjectTasksTaskExtendedAttribute();
            extendedAttributes.add(attrib);
            attrib.setFieldID(xmlFieldID.toString());
            attrib.setValue(formattedValue);
            attrib.setDurationFormat(this.printExtendedAttributeDurationFormat(value));
            this.setValueGUID(attrib, (FieldType)mpxFieldID, formattedValue);
        }
    }

    private void writeTaskOutlineCodes(Project.Tasks.Task xml, Task mpx) {
        List<Project.Tasks.Task.OutlineCode> outlineCodes = xml.getOutlineCode();
        for (TaskField mpxFieldID : TaskFieldLists.CUSTOM_OUTLINE_CODE) {
            Object value = mpx.getCachedValue(mpxFieldID);
            if (!FieldTypeHelper.valueIsNotDefault(mpxFieldID, value)) continue;
            this.m_extendedAttributesInUse.add(mpxFieldID);
            Integer xmlFieldID = MPPTaskField.getID(mpxFieldID) | 0xB400000;
            String formattedValue = DatatypeConverter.printExtendedAttribute(this, value, mpxFieldID.getDataType());
            Project.Tasks.Task.OutlineCode attrib = this.m_factory.createProjectTasksTaskOutlineCode();
            outlineCodes.add(attrib);
            attrib.setFieldID(xmlFieldID.toString());
            this.setValueID(attrib, (FieldType)mpxFieldID, formattedValue);
        }
    }

    private void setValueGUID(Project.Tasks.Task.ExtendedAttribute attrib, FieldType fieldType, String formattedValue) {
        CustomFieldValueItem valueItem = this.getValueItem(fieldType, formattedValue);
        if (valueItem != null) {
            attrib.setValueGUID(valueItem.getGUID());
        }
    }

    private void setValueID(Project.Tasks.Task.OutlineCode attrib, FieldType fieldType, String formattedValue) {
        CustomFieldValueItem valueItem = this.getValueItem(fieldType, formattedValue);
        if (valueItem != null) {
            attrib.setValueID(NumberHelper.getBigInteger(valueItem.getUniqueID()));
        }
    }

    private CustomFieldValueItem getValueItem(FieldType fieldType, String formattedValue) {
        CustomFieldValueItem result = null;
        CustomField field = this.m_projectFile.getCustomFields().getCustomField(fieldType);
        CustomFieldLookupTable items = field.getLookupTable();
        if (!items.isEmpty()) {
            result = (CustomFieldValueItem)((Map)this.m_customFieldValueItems.getOrDefault(fieldType, this.getCustomFieldValueItemMap(fieldType, items))).get(formattedValue);
        }
        return result;
    }

    private HashMap<String, CustomFieldValueItem> getCustomFieldValueItemMap(FieldType fieldType, List<CustomFieldValueItem> items) {
        DataType dataType = fieldType.getDataType();
        HashMap<String, CustomFieldValueItem> result = new HashMap<String, CustomFieldValueItem>();
        items.forEach(item -> result.put(DatatypeConverter.printExtendedAttribute(this, item.getValue(), dataType), (CustomFieldValueItem)item));
        return result;
    }

    private BigInteger printExtendedAttributeDurationFormat(Object value) {
        BigInteger result = null;
        if (value instanceof Duration) {
            result = DatatypeConverter.printDurationTimeUnits(((Duration)value).getUnits(), false);
        }
        return result;
    }

    private BigInteger getTaskCalendarID(Task mpx) {
        BigInteger result = null;
        ProjectCalendar cal = mpx.getCalendar();
        result = cal != null ? NumberHelper.getBigInteger(cal.getUniqueID()) : NULL_CALENDAR_ID;
        return result;
    }

    private void writePredecessors(Project.Tasks.Task xml, Task mpx) {
        List<Project.Tasks.Task.PredecessorLink> list = xml.getPredecessorLink();
        List<Relation> predecessors = mpx.getPredecessors();
        for (Relation rel : predecessors) {
            Integer taskUniqueID = rel.getTargetTask().getUniqueID();
            list.add(this.writePredecessor(taskUniqueID, rel.getType(), rel.getLag()));
            this.m_eventManager.fireRelationWrittenEvent(rel);
        }
    }

    private Project.Tasks.Task.PredecessorLink writePredecessor(Integer taskID, RelationType type, Duration lag) {
        Project.Tasks.Task.PredecessorLink link = this.m_factory.createProjectTasksTaskPredecessorLink();
        link.setPredecessorUID(NumberHelper.getBigInteger(taskID));
        link.setType(BigInteger.valueOf(type.getValue()));
        link.setCrossProject(Boolean.FALSE);
        if (lag != null && lag.getDuration() != 0.0) {
            double linkLag = lag.getDuration();
            if (lag.getUnits() != TimeUnit.PERCENT && lag.getUnits() != TimeUnit.ELAPSED_PERCENT) {
                linkLag = 10.0 * Duration.convertUnits(linkLag, lag.getUnits(), TimeUnit.MINUTES, this.m_projectFile.getProjectProperties()).getDuration();
            }
            link.setLinkLag(BigInteger.valueOf((long)linkLag));
            link.setLagFormat(DatatypeConverter.printDurationTimeUnits(lag.getUnits(), false));
        } else {
            link.setLinkLag(BIGINTEGER_ZERO);
            link.setLagFormat(DatatypeConverter.printDurationTimeUnits(this.m_projectFile.getProjectProperties().getDefaultDurationUnits(), false));
        }
        return link;
    }

    private void writeAssignments(Project project) {
        Project.Assignments assignments = this.m_factory.createProjectAssignments();
        project.setAssignments(assignments);
        List<Project.Assignments.Assignment> list = assignments.getAssignment();
        for (ResourceAssignment assignment : this.m_projectFile.getResourceAssignments()) {
            list.add(this.writeAssignment(assignment));
        }
        ProjectConfig config = this.m_projectFile.getProjectConfig();
        boolean autoUniqueID = config.getAutoAssignmentUniqueID();
        if (!autoUniqueID) {
            config.setAutoAssignmentUniqueID(true);
        }
        for (Task task : this.m_projectFile.getTasks()) {
            double percentComplete = NumberHelper.getDouble(task.getPercentageComplete());
            if (percentComplete == 0.0 || !task.getResourceAssignments().isEmpty()) continue;
            ResourceAssignment dummy = new ResourceAssignment(this.m_projectFile, task);
            Duration duration = task.getDuration();
            if (duration == null) {
                duration = Duration.getInstance(0, TimeUnit.HOURS);
            }
            double durationValue = duration.getDuration();
            TimeUnit durationUnits = duration.getUnits();
            double actualWork = durationValue * percentComplete / 100.0;
            double remainingWork = durationValue - actualWork;
            dummy.setResourceUniqueID(NULL_RESOURCE_ID);
            dummy.setWork(duration);
            dummy.setActualWork(Duration.getInstance(actualWork, durationUnits));
            dummy.setRemainingWork(Duration.getInstance(remainingWork, durationUnits));
            if (percentComplete == 100.0 && duration.getDuration() == 0.0) {
                dummy.setActualFinish(task.getActualStart());
            }
            list.add(this.writeAssignment(dummy));
        }
        config.setAutoAssignmentUniqueID(autoUniqueID);
    }

    private Project.Assignments.Assignment writeAssignment(ResourceAssignment mpx) {
        Project.Assignments.Assignment xml = this.m_factory.createProjectAssignmentsAssignment();
        xml.setActualCost(DatatypeConverter.printCurrency(mpx.getActualCost()));
        xml.setActualFinish(mpx.getActualFinish());
        xml.setActualOvertimeCost(DatatypeConverter.printCurrency(mpx.getActualOvertimeCost()));
        xml.setActualOvertimeWork(DatatypeConverter.printDuration(this, mpx.getActualOvertimeWork()));
        xml.setActualStart(mpx.getActualStart());
        xml.setActualWork(DatatypeConverter.printDuration(this, mpx.getActualWork()));
        xml.setACWP(DatatypeConverter.printCurrency(mpx.getACWP()));
        xml.setBCWP(DatatypeConverter.printCurrency(mpx.getBCWP()));
        xml.setBCWS(DatatypeConverter.printCurrency(mpx.getBCWS()));
        xml.setBudgetCost(DatatypeConverter.printCurrency(mpx.getBudgetCost()));
        xml.setBudgetWork(DatatypeConverter.printDuration(this, mpx.getBudgetWork()));
        xml.setCost(DatatypeConverter.printCurrency(mpx.getCost()));
        if (mpx.getCostRateTableIndex() != 0) {
            xml.setCostRateTable(BigInteger.valueOf(mpx.getCostRateTableIndex()));
        }
        xml.setCreationDate(mpx.getCreateDate());
        xml.setCV(DatatypeConverter.printCurrency(mpx.getCV()));
        xml.setDelay(DatatypeConverter.printDurationInIntegerTenthsOfMinutes(mpx.getDelay()));
        xml.setFinish(mpx.getFinish());
        xml.setGUID(mpx.getGUID());
        xml.setHasFixedRateUnits(mpx.getVariableRateUnits() == null);
        xml.setFixedMaterial(mpx.getResource() != null && mpx.getResource().getType() == ResourceType.MATERIAL);
        xml.setHyperlink(mpx.getHyperlink());
        xml.setHyperlinkAddress(mpx.getHyperlinkAddress());
        xml.setHyperlinkSubAddress(mpx.getHyperlinkSubAddress());
        xml.setLevelingDelay(DatatypeConverter.printDurationInIntegerTenthsOfMinutes(mpx.getLevelingDelay()));
        xml.setLevelingDelayFormat(DatatypeConverter.printDurationTimeUnits(mpx.getLevelingDelay(), false));
        if (!mpx.getNotes().isEmpty()) {
            xml.setNotes(mpx.getNotes());
        }
        xml.setOvertimeCost(DatatypeConverter.printCurrency(mpx.getOvertimeCost()));
        xml.setOvertimeWork(DatatypeConverter.printDuration(this, mpx.getOvertimeWork()));
        xml.setPercentWorkComplete(NumberHelper.getBigInteger(mpx.getPercentageWorkComplete()));
        xml.setRateScale(mpx.getVariableRateUnits() == null ? null : DatatypeConverter.printTimeUnit(mpx.getVariableRateUnits()));
        xml.setRegularWork(DatatypeConverter.printDuration(this, mpx.getRegularWork()));
        xml.setRemainingCost(DatatypeConverter.printCurrency(mpx.getRemainingCost()));
        xml.setRemainingOvertimeCost(DatatypeConverter.printCurrency(mpx.getRemainingOvertimeCost()));
        xml.setRemainingOvertimeWork(DatatypeConverter.printDuration(this, mpx.getRemainingOvertimeWork()));
        xml.setRemainingWork(DatatypeConverter.printDuration(this, mpx.getRemainingWork()));
        xml.setResourceUID(mpx.getResource() == null ? BigInteger.valueOf(NULL_RESOURCE_ID.intValue()) : BigInteger.valueOf(NumberHelper.getInt(mpx.getResourceUniqueID())));
        xml.setResume(mpx.getResume());
        xml.setStart(mpx.getStart());
        xml.setStop(mpx.getStop());
        xml.setSV(DatatypeConverter.printCurrency(mpx.getSV()));
        xml.setTaskUID(NumberHelper.getBigInteger(mpx.getTask().getUniqueID()));
        xml.setUID(NumberHelper.getBigInteger(mpx.getUniqueID()));
        xml.setUnits(DatatypeConverter.printUnits(mpx.getUnits()));
        xml.setVAC(DatatypeConverter.printCurrency(mpx.getVAC()));
        xml.setWork(DatatypeConverter.printDuration(this, mpx.getWork()));
        xml.setWorkContour(mpx.getWorkContour());
        xml.setCostVariance(DatatypeConverter.printCurrency(mpx.getCostVariance()));
        xml.setWorkVariance(DatatypeConverter.printDurationInDecimalThousandthsOfMinutes(mpx.getWorkVariance()));
        xml.setStartVariance(DatatypeConverter.printDurationInIntegerThousandthsOfMinutes(mpx.getStartVariance()));
        xml.setFinishVariance(DatatypeConverter.printDurationInIntegerThousandthsOfMinutes(mpx.getFinishVariance()));
        double percentComplete = NumberHelper.getDouble(mpx.getTask().getPercentageComplete());
        if (percentComplete == 100.0 && xml.getActualFinish() == null) {
            xml.setActualFinish(mpx.getTask().getActualFinish());
        }
        this.writeAssignmentBaselines(xml, mpx);
        this.writeAssignmentExtendedAttributes(xml, mpx);
        this.writeAssignmentTimephasedData(mpx, xml);
        this.m_eventManager.fireAssignmentWrittenEvent(mpx);
        return xml;
    }

    private void writeAssignmentBaselines(Project.Assignments.Assignment xml, ResourceAssignment mpxj) {
        Duration duration;
        Date date;
        Project.Assignments.Assignment.Baseline baseline = this.m_factory.createProjectAssignmentsAssignmentBaseline();
        boolean populated = false;
        Number cost = mpxj.getBaselineCost();
        if (cost != null && cost.intValue() != 0) {
            populated = true;
            baseline.setCost(DatatypeConverter.printExtendedAttributeCurrency(cost));
        }
        if ((date = mpxj.getBaselineFinish()) != null) {
            populated = true;
            baseline.setFinish(DatatypeConverter.printExtendedAttributeDate(date));
        }
        if ((date = mpxj.getBaselineStart()) != null) {
            populated = true;
            baseline.setStart(DatatypeConverter.printExtendedAttributeDate(date));
        }
        if ((duration = mpxj.getBaselineWork()) != null && duration.getDuration() != 0.0) {
            populated = true;
            baseline.setWork(DatatypeConverter.printDuration(this, duration));
        }
        if (populated) {
            baseline.setNumber("0");
            xml.getBaseline().add(baseline);
        }
        for (int loop = 1; loop <= 10; ++loop) {
            baseline = this.m_factory.createProjectAssignmentsAssignmentBaseline();
            populated = false;
            cost = mpxj.getBaselineCost(loop);
            if (cost != null && cost.intValue() != 0) {
                populated = true;
                baseline.setCost(DatatypeConverter.printExtendedAttributeCurrency(cost));
            }
            if ((date = mpxj.getBaselineFinish(loop)) != null) {
                populated = true;
                baseline.setFinish(DatatypeConverter.printExtendedAttributeDate(date));
            }
            if ((date = mpxj.getBaselineStart(loop)) != null) {
                populated = true;
                baseline.setStart(DatatypeConverter.printExtendedAttributeDate(date));
            }
            if ((duration = mpxj.getBaselineWork(loop)) != null && duration.getDuration() != 0.0) {
                populated = true;
                baseline.setWork(DatatypeConverter.printDuration(this, duration));
            }
            if (!populated) continue;
            baseline.setNumber(Integer.toString(loop));
            xml.getBaseline().add(baseline);
        }
    }

    private void writeAssignmentExtendedAttributes(Project.Assignments.Assignment xml, ResourceAssignment mpx) {
        List<Project.Assignments.Assignment.ExtendedAttribute> extendedAttributes = xml.getExtendedAttribute();
        for (AssignmentField mpxFieldID : AssignmentFieldLists.EXTENDED_FIELDS) {
            Object value = mpx.getCachedValue(mpxFieldID);
            if (!FieldTypeHelper.valueIsNotDefault(mpxFieldID, value)) continue;
            this.m_extendedAttributesInUse.add(mpxFieldID);
            Integer xmlFieldID = MPPAssignmentField.getID(mpxFieldID) | 0xF400000;
            Project.Assignments.Assignment.ExtendedAttribute attrib = this.m_factory.createProjectAssignmentsAssignmentExtendedAttribute();
            extendedAttributes.add(attrib);
            attrib.setFieldID(xmlFieldID.toString());
            attrib.setValue(DatatypeConverter.printExtendedAttribute(this, value, mpxFieldID.getDataType()));
            attrib.setDurationFormat(this.printExtendedAttributeDurationFormat(value));
        }
    }

    private void writeAssignmentTimephasedData(ResourceAssignment mpx, Project.Assignments.Assignment xml) {
        if (this.m_writeTimphasedData && mpx.getHasTimephasedData()) {
            List<TimephasedDataType> list = xml.getTimephasedData();
            ProjectCalendar calendar = mpx.getCalendar();
            BigInteger assignmentID = xml.getUID();
            List<TimephasedWork> complete = mpx.getTimephasedActualWork();
            List<TimephasedWork> planned = mpx.getTimephasedWork();
            if (this.m_splitTimephasedAsDays) {
                TimephasedWork lastComplete = null;
                if (complete != null && !complete.isEmpty()) {
                    lastComplete = complete.get(complete.size() - 1);
                }
                TimephasedWork firstPlanned = null;
                if (planned != null && !planned.isEmpty()) {
                    firstPlanned = planned.get(0);
                }
                if (planned != null) {
                    planned = this.splitDays(calendar, mpx.getTimephasedWork(), null, lastComplete);
                }
                if (complete != null) {
                    complete = this.splitDays(calendar, complete, firstPlanned, null);
                }
            }
            if (planned != null) {
                this.writeAssignmentTimephasedData(assignmentID, list, planned, 1);
            }
            if (complete != null) {
                this.writeAssignmentTimephasedData(assignmentID, list, complete, 2);
            }
        }
    }

    private List<TimephasedWork> splitDays(ProjectCalendar calendar, List<TimephasedWork> list, TimephasedWork first, TimephasedWork last) {
        ArrayList<TimephasedWork> result = new ArrayList<TimephasedWork>();
        for (TimephasedWork assignment : list) {
            Date currentFinish;
            Date endTime;
            Date startDate = assignment.getStart();
            Date finishDate = assignment.getFinish();
            Date startDay = DateHelper.getDayStartDate(startDate);
            Date finishDay = DateHelper.getDayStartDate(finishDate);
            if (startDay.getTime() == finishDay.getTime()) {
                Date startTime = calendar.getStartTime(startDay);
                Date currentStart = DateHelper.setTime(startDay, startTime);
                if (startDate.getTime() > currentStart.getTime()) {
                    boolean paddingRequired = true;
                    if (last != null) {
                        Date lastFinish = last.getFinish();
                        if (lastFinish.getTime() == startDate.getTime()) {
                            paddingRequired = false;
                        } else {
                            Date lastFinishDay = DateHelper.getDayStartDate(lastFinish);
                            if (startDay.getTime() == lastFinishDay.getTime()) {
                                currentStart = lastFinish;
                            }
                        }
                    }
                    if (paddingRequired) {
                        Duration zeroHours = Duration.getInstance(0, TimeUnit.HOURS);
                        TimephasedWork padding = new TimephasedWork();
                        padding.setStart(currentStart);
                        padding.setFinish(startDate);
                        padding.setTotalAmount(zeroHours);
                        padding.setAmountPerDay(zeroHours);
                        result.add(padding);
                    }
                }
                result.add(assignment);
                endTime = calendar.getFinishTime(startDay);
                currentFinish = DateHelper.setTime(startDay, endTime);
                if (finishDate.getTime() >= currentFinish.getTime()) continue;
                boolean paddingRequired = true;
                if (first != null) {
                    Date firstStart = first.getStart();
                    if (firstStart.getTime() == finishDate.getTime()) {
                        paddingRequired = false;
                    } else {
                        Date firstStartDay = DateHelper.getDayStartDate(firstStart);
                        if (finishDay.getTime() == firstStartDay.getTime()) {
                            currentFinish = firstStart;
                        }
                    }
                }
                if (!paddingRequired) continue;
                Duration zeroHours = Duration.getInstance(0, TimeUnit.HOURS);
                TimephasedWork padding = new TimephasedWork();
                padding.setStart(finishDate);
                padding.setFinish(currentFinish);
                padding.setTotalAmount(zeroHours);
                padding.setAmountPerDay(zeroHours);
                result.add(padding);
                continue;
            }
            Date currentStart = startDate;
            boolean isWorking = calendar.isWorkingDate(currentStart);
            while (currentStart.getTime() < finishDate.getTime()) {
                if (isWorking) {
                    endTime = calendar.getFinishTime(currentStart);
                    currentFinish = DateHelper.setTime(currentStart, endTime);
                    if (currentFinish.getTime() > finishDate.getTime()) {
                        currentFinish = finishDate;
                    }
                    TimephasedWork split = new TimephasedWork();
                    split.setStart(currentStart);
                    split.setFinish(currentFinish);
                    split.setTotalAmount(assignment.getAmountPerDay());
                    split.setAmountPerDay(assignment.getAmountPerDay());
                    result.add(split);
                }
                Calendar cal = DateHelper.popCalendar(currentStart);
                cal.add(6, 1);
                currentStart = cal.getTime();
                isWorking = calendar.isWorkingDate(currentStart);
                if (isWorking) {
                    Date startTime = calendar.getStartTime(currentStart);
                    DateHelper.setTime(cal, startTime);
                    currentStart = cal.getTime();
                }
                DateHelper.pushCalendar(cal);
            }
        }
        return result;
    }

    private void writeAssignmentTimephasedData(BigInteger assignmentID, List<TimephasedDataType> list, List<TimephasedWork> data, int type) {
        for (TimephasedWork mpx : data) {
            TimephasedDataType xml = this.m_factory.createTimephasedDataType();
            list.add(xml);
            xml.setStart(mpx.getStart());
            xml.setFinish(mpx.getFinish());
            xml.setType(BigInteger.valueOf(type));
            xml.setUID(assignmentID);
            xml.setUnit(DatatypeConverter.printDurationTimeUnits((Duration)mpx.getTotalAmount(), false));
            xml.setValue(DatatypeConverter.printDuration(this, (Duration)mpx.getTotalAmount()));
        }
    }

    ProjectFile getProjectFile() {
        return this.m_projectFile;
    }

    static {
        try {
            System.setProperty("com.sun.xml.bind.v2.runtime.JAXBContextImpl.fastBoot", "true");
            CONTEXT = JAXBContext.newInstance((String)"net.sf.mpxj.mspdi.schema", (ClassLoader)MSPDIWriter.class.getClassLoader());
        }
        catch (JAXBException ex) {
            CONTEXT_EXCEPTION = ex;
            CONTEXT = null;
        }
        DAY_MASKS = new int[]{0, 1, 2, 4, 8, 16, 32, 64};
        BIGINTEGER_ZERO = BigInteger.valueOf(0L);
        NULL_RESOURCE_ID = -65535;
        NULL_CALENDAR_ID = BigInteger.valueOf(-1L);
        ENTERPRISE_CUSTOM_FIELDS = new HashSet<FieldType>();
        ENTERPRISE_CUSTOM_FIELDS.addAll(Arrays.asList(TaskFieldLists.ENTERPRISE_CUSTOM_FIELD));
        ENTERPRISE_CUSTOM_FIELDS.addAll(Arrays.asList(ResourceFieldLists.ENTERPRISE_CUSTOM_FIELD));
        ENTERPRISE_CUSTOM_FIELDS.addAll(Arrays.asList(AssignmentFieldLists.ENTERPRISE_CUSTOM_FIELD));
        ENTERPRISE_CUSTOM_FIELDS.addAll(Arrays.asList(ProjectFieldLists.ENTERPRISE_CUSTOM_FIELD));
    }
}

