/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectCalendarWeek;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.common.Pair;
import net.sf.mpxj.mpp.CalendarFactory;
import net.sf.mpxj.mpp.DocumentInputStreamFactory;
import net.sf.mpxj.mpp.FixedData;
import net.sf.mpxj.mpp.FixedMeta;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.Props;
import net.sf.mpxj.mpp.Var2Data;
import net.sf.mpxj.mpp.VarMeta;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;

abstract class AbstractCalendarFactory
implements CalendarFactory {
    private static final boolean[] DEFAULT_WORKING_WEEK = new boolean[]{false, true, true, true, true, true, false};
    private final ProjectFile m_file;

    public AbstractCalendarFactory(ProjectFile file) {
        this.m_file = file;
    }

    @Override
    public void processCalendarData(DirectoryEntry projectDir, Props projectProps, DocumentInputStreamFactory inputStreamFactory, HashMap<Integer, ProjectCalendar> resourceMap) throws IOException {
        DirectoryEntry calDir = (DirectoryEntry)projectDir.getEntry("TBkndCal");
        VarMeta calVarMeta = this.getCalendarVarMeta(calDir);
        Var2Data calVarData = new Var2Data(calVarMeta, (InputStream)new DocumentInputStream((DocumentEntry)calDir.getEntry("Var2Data")));
        FixedMeta calFixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)calDir.getEntry("FixedMeta")), 10);
        FixedData calFixedData = new FixedData(calFixedMeta, inputStreamFactory.getInstance(calDir, "FixedData"), 12);
        HashMap<Integer, ProjectCalendar> calendarMap = new HashMap<Integer, ProjectCalendar>();
        int items = calFixedData.getItemCount();
        ArrayList<Pair<ProjectCalendar, Integer>> baseCalendars = new ArrayList<Pair<ProjectCalendar, Integer>>();
        byte[] defaultCalendarData = projectProps.getByteArray(Props.DEFAULT_CALENDAR_HOURS);
        ProjectCalendar defaultCalendar = new ProjectCalendar(this.m_file);
        this.processCalendarHours(defaultCalendarData, null, defaultCalendar, true);
        EventManager eventManager = this.m_file.getEventManager();
        for (int loop = 0; loop < items; ++loop) {
            byte[] fixedData = calFixedData.getByteArrayValue(loop);
            if (fixedData == null || fixedData.length < 8) continue;
            int offset = 0;
            while (offset + 12 <= fixedData.length) {
                Integer calendarID = MPPUtility.getInt(fixedData, offset + this.getCalendarIDOffset());
                int baseCalendarID = MPPUtility.getInt(fixedData, offset + this.getBaseIDOffset());
                if (calendarID > 0 && !calendarMap.containsKey(calendarID)) {
                    ProjectCalendar cal;
                    byte[] varData = calVarData.getByteArray(calendarID, this.getCalendarDataVarDataType());
                    if (baseCalendarID == 0 || baseCalendarID == -1 || baseCalendarID == calendarID) {
                        if (varData != null || defaultCalendarData != null) {
                            cal = this.m_file.addCalendar();
                            if (varData == null) {
                                varData = defaultCalendarData;
                            }
                        } else {
                            cal = this.m_file.addDefaultBaseCalendar();
                        }
                        cal.setName(calVarData.getUnicodeString(calendarID, this.getCalendarNameVarDataType()));
                    } else {
                        cal = varData != null ? this.m_file.addCalendar() : this.m_file.addDefaultDerivedCalendar();
                        baseCalendars.add(new Pair<ProjectCalendar, Integer>(cal, baseCalendarID));
                        Integer resourceID = MPPUtility.getInt(fixedData, offset + this.getResourceIDOffset());
                        resourceMap.put(resourceID, cal);
                    }
                    cal.setUniqueID(calendarID);
                    if (varData != null) {
                        this.processCalendarHours(varData, defaultCalendar, cal, baseCalendarID == -1);
                        this.processCalendarExceptions(varData, cal);
                    }
                    calendarMap.put(calendarID, cal);
                    eventManager.fireCalendarReadEvent(cal);
                }
                offset += 12;
            }
        }
        this.updateBaseCalendarNames(baseCalendars, calendarMap);
    }

    private void processCalendarHours(byte[] data, ProjectCalendar defaultCalendar, ProjectCalendar cal, boolean isBaseCalendar) {
        ArrayList<DateRange> dateRanges = new ArrayList<DateRange>(5);
        for (int index = 0; index < 7; ++index) {
            ProjectCalendarHours hours;
            int offset = this.getCalendarHoursOffset() + 60 * index;
            int defaultFlag = data == null ? 1 : MPPUtility.getShort(data, offset);
            Day day = Day.getInstance(index + 1);
            if (defaultFlag == 1) {
                if (isBaseCalendar) {
                    if (defaultCalendar == null) {
                        cal.setWorkingDay(day, DEFAULT_WORKING_WEEK[index]);
                        if (!cal.isWorkingDay(day)) continue;
                        hours = cal.addCalendarHours(Day.getInstance(index + 1));
                        hours.addRange(ProjectCalendarWeek.DEFAULT_WORKING_MORNING);
                        hours.addRange(ProjectCalendarWeek.DEFAULT_WORKING_AFTERNOON);
                        continue;
                    }
                    boolean workingDay = defaultCalendar.isWorkingDay(day);
                    cal.setWorkingDay(day, workingDay);
                    if (!workingDay) continue;
                    hours = cal.addCalendarHours(Day.getInstance(index + 1));
                    for (DateRange range : defaultCalendar.getHours(day)) {
                        hours.addRange(range);
                    }
                    continue;
                }
                cal.setWorkingDay(day, DayType.DEFAULT);
                continue;
            }
            dateRanges.clear();
            int periodCount = MPPUtility.getShort(data, offset + 2);
            for (int periodIndex = 0; periodIndex < periodCount; ++periodIndex) {
                int startOffset = offset + 8 + periodIndex * 2;
                Date start = MPPUtility.getTime(data, startOffset);
                int durationOffset = offset + 20 + periodIndex * 4;
                long duration = MPPUtility.getDuration(data, durationOffset);
                Date end = new Date(start.getTime() + duration);
                dateRanges.add(new DateRange(start, end));
            }
            if (dateRanges.isEmpty()) {
                cal.setWorkingDay(day, false);
                continue;
            }
            cal.setWorkingDay(day, true);
            hours = cal.addCalendarHours(Day.getInstance(index + 1));
            for (DateRange range : dateRanges) {
                hours.addRange(range);
            }
        }
    }

    private void updateBaseCalendarNames(List<Pair<ProjectCalendar, Integer>> baseCalendars, HashMap<Integer, ProjectCalendar> map) {
        for (Pair<ProjectCalendar, Integer> pair : baseCalendars) {
            ProjectCalendar cal = pair.getFirst();
            Integer baseCalendarID = pair.getSecond();
            ProjectCalendar baseCal = map.get(baseCalendarID);
            if (baseCal != null && baseCal.getName() != null) {
                cal.setParent(baseCal);
                continue;
            }
            this.m_file.removeCalendar(cal);
        }
    }

    protected abstract int getCalendarIDOffset();

    protected abstract int getBaseIDOffset();

    protected abstract int getResourceIDOffset();

    protected abstract VarMeta getCalendarVarMeta(DirectoryEntry var1) throws IOException;

    protected abstract int getCalendarHoursOffset();

    protected abstract Integer getCalendarNameVarDataType();

    protected abstract Integer getCalendarDataVarDataType();

    protected abstract void processCalendarExceptions(byte[] var1, ProjectCalendar var2);
}

