/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.explorer;

import com.jgoodies.binding.beans.PropertyAdapter;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.explorer.FileChooserController;
import net.sf.mpxj.explorer.FileChooserModel;
import net.sf.mpxj.explorer.FileChooserView;
import net.sf.mpxj.explorer.FileCleanerController;
import net.sf.mpxj.explorer.FileCleanerModel;
import net.sf.mpxj.explorer.FileCleanerView;
import net.sf.mpxj.explorer.FileSaverController;
import net.sf.mpxj.explorer.FileSaverModel;
import net.sf.mpxj.explorer.FileSaverView;
import net.sf.mpxj.explorer.ProjectFilePanel;
import net.sf.mpxj.reader.UniversalProjectReader;

public class ProjectExplorer {
    protected JFrame m_frame;
    private static final String[] READ_EXTENSIONS = new String[]{"cdpx", "cdpz", "exe", "fts", "gan", "gnt", "mdb", "mpd", "mpp", "mpx", "pc", "pep", "planner", "pmxml", "pod", "pp", "ppx", "prx", "schedule_grid", "sdef", "sp", "stx", "xer", "xml", "zip"};
    private static final String[] WRITE_EXTENSIONS = new String[]{"sdef", "sdef", "mpx", "mpx", "planner", "xml", "pmxml", "xml", "json", "json", "mspdi", "xml"};

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    ProjectExplorer window = new ProjectExplorer();
                    window.m_frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public ProjectExplorer() {
        this.initialize();
    }

    private void initialize() {
        this.m_frame = new JFrame();
        this.m_frame.setBounds(100, 100, 900, 451);
        this.m_frame.setDefaultCloseOperation(3);
        this.m_frame.getContentPane().setLayout(new GridLayout(1, 0, 0, 0));
        final FileChooserModel fileChooserModel = new FileChooserModel();
        final FileChooserController fileChooserController = new FileChooserController(fileChooserModel);
        FileChooserView fileChooserView = new FileChooserView(this.m_frame, fileChooserModel);
        fileChooserModel.setExtensions(READ_EXTENSIONS);
        final FileChooserModel openAllFileChooserModel = new FileChooserModel();
        final FileChooserController openAllFileChooserController = new FileChooserController(openAllFileChooserModel);
        FileChooserView openAllFileChooserView = new FileChooserView(this.m_frame, openAllFileChooserModel);
        openAllFileChooserModel.setExtensions(READ_EXTENSIONS);
        final FileSaverModel fileSaverModel = new FileSaverModel();
        final FileSaverController fileSaverController = new FileSaverController(fileSaverModel);
        FileSaverView fileSaverView = new FileSaverView(this.m_frame, fileSaverModel);
        fileSaverModel.setExtensions(WRITE_EXTENSIONS);
        final FileCleanerModel fileCleanerModel = new FileCleanerModel();
        final FileCleanerController fileCleanerController = new FileCleanerController(fileCleanerModel);
        FileCleanerView fileCleanerView = new FileCleanerView(this.m_frame, fileCleanerModel);
        JMenuBar menuBar = new JMenuBar();
        this.m_frame.setJMenuBar(menuBar);
        JMenu mnFile = new JMenu("File");
        menuBar.add(mnFile);
        JMenuItem mntmOpen = new JMenuItem("Open...");
        mnFile.add(mntmOpen);
        JMenuItem mntmOpenAll = new JMenuItem("Open All...");
        mnFile.add(mntmOpenAll);
        final JMenuItem mntmSave = new JMenuItem("Save As...");
        mntmSave.setEnabled(false);
        mnFile.add(mntmSave);
        final JMenuItem mntmClean = new JMenuItem("Clean...");
        mntmClean.setEnabled(false);
        mnFile.add(mntmClean);
        mntmOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fileChooserController.openFileChooser();
            }
        });
        mntmOpenAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                openAllFileChooserController.openFileChooser();
            }
        });
        mntmSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fileSaverController.openFileSaver();
            }
        });
        mntmClean.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fileCleanerController.openFileCleaner();
            }
        });
        final JTabbedPane tabbedPane = new JTabbedPane(1);
        this.m_frame.getContentPane().add(tabbedPane);
        PropertyAdapter openAdapter = new PropertyAdapter((Object)fileChooserModel, "file", true);
        openAdapter.addValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                try {
                    File file = fileChooserModel.getFile();
                    ProjectFile projectFile = new UniversalProjectReader().read(file);
                    if (projectFile == null) {
                        throw new IllegalArgumentException("Unsupported file type");
                    }
                    tabbedPane.add(file.getName(), new ProjectFilePanel(file, projectFile));
                    mntmSave.setEnabled(true);
                    mntmClean.setEnabled(true);
                }
                catch (MPXJException ex) {
                    throw new IllegalArgumentException("Failed to read file", ex);
                }
            }
        });
        PropertyAdapter openAllAdapter = new PropertyAdapter((Object)openAllFileChooserModel, "file", true);
        openAllAdapter.addValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                try {
                    File file = openAllFileChooserModel.getFile();
                    List<ProjectFile> projectFiles = new UniversalProjectReader().readAll(file);
                    if (projectFiles.isEmpty()) {
                        throw new IllegalArgumentException("Unsupported file type");
                    }
                    int index = 1;
                    for (ProjectFile projectFile : projectFiles) {
                        String name = projectFiles.size() == 1 ? file.getName() : file.getName() + " (" + index++ + ")";
                        tabbedPane.add(name, new ProjectFilePanel(file, projectFile));
                    }
                    mntmSave.setEnabled(true);
                    mntmClean.setEnabled(true);
                }
                catch (MPXJException ex) {
                    throw new IllegalArgumentException("Failed to read file", ex);
                }
            }
        });
        PropertyAdapter saveAdapter = new PropertyAdapter((Object)fileSaverModel, "file", true);
        saveAdapter.addValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ProjectFilePanel panel = (ProjectFilePanel)tabbedPane.getSelectedComponent();
                panel.saveFile(fileSaverModel.getFile(), fileSaverModel.getType());
            }
        });
        PropertyAdapter cleanAdapter = new PropertyAdapter((Object)fileCleanerModel, "file", true);
        cleanAdapter.addValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ProjectFilePanel panel = (ProjectFilePanel)tabbedPane.getSelectedComponent();
                panel.cleanFile(fileCleanerModel.getFile());
            }
        });
    }
}

