/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.conceptdraw;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sf.mpxj.CurrencySymbolPosition;
import net.sf.mpxj.Day;
import net.sf.mpxj.Priority;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;

public final class DatatypeConverter {
    private static final Map<String, CurrencySymbolPosition> MAP_TO_CURRENCY_SYMBOL_POSITION = new HashMap<String, CurrencySymbolPosition>();
    private static final Map<CurrencySymbolPosition, String> MAP_FROM_CURRENCY_SYMBOL_POSITION;
    private static final Map<String, TimeUnit> MAP_TO_TIME_UNIT;
    private static final Map<String, ResourceType> MAP_TO_RESOURCE_TYPE;
    private static final Map<String, Priority> MAP_TO_PRIORITY;
    private static final Map<String, TaskType> MAP_TO_TASK_TYPE;
    private static final Map<String, RelationType> MAP_TO_RELATION_TYPE;
    private static final ThreadLocal<DateFormat> TIME_FORMAT;
    private static final ThreadLocal<DateFormat> DATE_FORMAT;
    private static final ThreadLocal<DateFormat> DATE_TIME_FORMAT;

    public static final Integer parseInteger(String value) {
        return Integer.valueOf(value);
    }

    public static final String printInteger(Integer value) {
        throw new UnsupportedOperationException();
    }

    public static final Double parseDouble(String value) {
        return Double.valueOf(value);
    }

    public static final String printDouble(Double value) {
        throw new UnsupportedOperationException();
    }

    public static final Double parsePercent(String value) {
        return Double.parseDouble(value) * 100.0;
    }

    public static final String printPercent(Double value) {
        throw new UnsupportedOperationException();
    }

    public static final Integer parseMinutesFromHours(String value) {
        Integer result = null;
        if (value != null) {
            result = Integer.parseInt(value) * 60;
        }
        return result;
    }

    public static final String printHoursFromMinutes(Integer value) {
        throw new UnsupportedOperationException();
    }

    public static final CurrencySymbolPosition parseCurrencySymbolPosition(String value) {
        return MAP_TO_CURRENCY_SYMBOL_POSITION.getOrDefault(value, CurrencySymbolPosition.BEFORE_WITH_SPACE);
    }

    public static final String printCurrencySymbolPosition(CurrencySymbolPosition value) {
        throw new UnsupportedOperationException();
    }

    public static final Day parseDay(String value) {
        return Day.getInstance(Integer.parseInt(value) + 1);
    }

    public static final String printDay(Day value) {
        throw new UnsupportedOperationException();
    }

    public static final Date parseTime(String value) {
        Date result = null;
        try {
            if (value != null && !value.isEmpty()) {
                result = TIME_FORMAT.get().parse(value);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return result;
    }

    public static final String printTime(Date value) {
        throw new UnsupportedOperationException();
    }

    public static final Date parseDate(String value) {
        Date result = null;
        try {
            if (value != null && !value.isEmpty()) {
                result = DATE_FORMAT.get().parse(value);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return result;
    }

    public static final String printDate(Date value) {
        throw new UnsupportedOperationException();
    }

    public static final Date parseDateTime(String value) {
        Date result = null;
        try {
            if (value != null && !value.isEmpty()) {
                result = DATE_TIME_FORMAT.get().parse(value);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return result;
    }

    public static final String printDateTime(Date value) {
        throw new UnsupportedOperationException();
    }

    public static final TimeUnit parseTimeUnit(String value) {
        return MAP_TO_TIME_UNIT.get(value);
    }

    public static final String printTimeUnit(TimeUnit value) {
        throw new UnsupportedOperationException();
    }

    public static final ResourceType parseResourceType(String value) {
        return MAP_TO_RESOURCE_TYPE.get(value);
    }

    public static final String printResourceType(ResourceType value) {
        throw new UnsupportedOperationException();
    }

    public static final Priority parsePriority(String value) {
        return MAP_TO_PRIORITY.get(value);
    }

    public static final String printPriority(Priority value) {
        throw new UnsupportedOperationException();
    }

    public static final TaskType parseTaskType(String value) {
        return MAP_TO_TASK_TYPE.get(value);
    }

    public static final String printTaskType(TaskType value) {
        throw new UnsupportedOperationException();
    }

    public static final RelationType parseRelationType(String value) {
        return MAP_TO_RELATION_TYPE.get(value);
    }

    public static final String printRelationType(RelationType value) {
        throw new UnsupportedOperationException();
    }

    static {
        MAP_TO_CURRENCY_SYMBOL_POSITION.put("0", CurrencySymbolPosition.BEFORE);
        MAP_TO_CURRENCY_SYMBOL_POSITION.put("1", CurrencySymbolPosition.AFTER);
        MAP_TO_CURRENCY_SYMBOL_POSITION.put("2", CurrencySymbolPosition.BEFORE_WITH_SPACE);
        MAP_TO_CURRENCY_SYMBOL_POSITION.put("3", CurrencySymbolPosition.AFTER_WITH_SPACE);
        MAP_FROM_CURRENCY_SYMBOL_POSITION = new HashMap<CurrencySymbolPosition, String>();
        MAP_FROM_CURRENCY_SYMBOL_POSITION.put(CurrencySymbolPosition.BEFORE, "0");
        MAP_FROM_CURRENCY_SYMBOL_POSITION.put(CurrencySymbolPosition.AFTER, "1");
        MAP_FROM_CURRENCY_SYMBOL_POSITION.put(CurrencySymbolPosition.BEFORE_WITH_SPACE, "2");
        MAP_FROM_CURRENCY_SYMBOL_POSITION.put(CurrencySymbolPosition.AFTER_WITH_SPACE, "3");
        MAP_TO_TIME_UNIT = new HashMap<String, TimeUnit>();
        MAP_TO_TIME_UNIT.put("0", TimeUnit.MINUTES);
        MAP_TO_TIME_UNIT.put("1", TimeUnit.HOURS);
        MAP_TO_TIME_UNIT.put("2", TimeUnit.DAYS);
        MAP_TO_TIME_UNIT.put("3", TimeUnit.WEEKS);
        MAP_TO_TIME_UNIT.put("4", TimeUnit.MONTHS);
        MAP_TO_RESOURCE_TYPE = new HashMap<String, ResourceType>();
        MAP_TO_RESOURCE_TYPE.put("0", ResourceType.MATERIAL);
        MAP_TO_RESOURCE_TYPE.put("1", ResourceType.WORK);
        MAP_TO_RESOURCE_TYPE.put("work", ResourceType.WORK);
        MAP_TO_RESOURCE_TYPE.put("material", ResourceType.MATERIAL);
        MAP_TO_RESOURCE_TYPE.put("cost", ResourceType.COST);
        MAP_TO_PRIORITY = new HashMap<String, Priority>();
        MAP_TO_PRIORITY.put("veryLow", Priority.getInstance(100));
        MAP_TO_PRIORITY.put("low", Priority.getInstance(400));
        MAP_TO_PRIORITY.put("normal", Priority.getInstance(500));
        MAP_TO_PRIORITY.put("high", Priority.getInstance(600));
        MAP_TO_PRIORITY.put("veryHigh", Priority.getInstance(900));
        MAP_TO_TASK_TYPE = new HashMap<String, TaskType>();
        MAP_TO_TASK_TYPE.put("fixedDuration", TaskType.FIXED_DURATION);
        MAP_TO_TASK_TYPE.put("fixedUnits", TaskType.FIXED_UNITS);
        MAP_TO_TASK_TYPE.put("fixedWork", TaskType.FIXED_WORK);
        MAP_TO_RELATION_TYPE = new HashMap<String, RelationType>();
        MAP_TO_RELATION_TYPE.put("0", RelationType.START_START);
        MAP_TO_RELATION_TYPE.put("1", RelationType.START_FINISH);
        MAP_TO_RELATION_TYPE.put("2", RelationType.FINISH_START);
        MAP_TO_RELATION_TYPE.put("3", RelationType.FINISH_FINISH);
        TIME_FORMAT = new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
                df.setLenient(false);
                return df;
            }
        };
        DATE_FORMAT = new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                df.setLenient(false);
                return df;
            }
        };
        DATE_TIME_FORMAT = new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                df.setLenient(false);
                return df;
            }
        };
    }
}

