/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.asta;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sf.mpxj.DayType;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.asta.AstaReader;
import net.sf.mpxj.asta.DatatypeConverter;
import net.sf.mpxj.asta.MapRow;
import net.sf.mpxj.asta.Row;
import net.sf.mpxj.asta.SqliteResultSetRow;
import net.sf.mpxj.common.AutoCloseableHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.reader.AbstractProjectFileReader;
import org.sqlite.JDBC;

public final class AstaDatabaseFileReader
extends AbstractProjectFileReader {
    private AstaReader m_reader;
    private Integer m_projectID = 1;
    private Connection m_connection;
    private PreparedStatement m_ps;
    private ResultSet m_rs;
    private Map<String, Integer> m_meta = new HashMap<String, Integer>();

    @Override
    public ProjectFile read(File file) throws MPXJException {
        try {
            String url = "jdbc:sqlite:" + file.getAbsolutePath();
            Properties props = new Properties();
            props.setProperty("date_string_format", "yyyy-MM-dd HH:mm:ss");
            this.m_connection = JDBC.createConnection((String)url, (Properties)props);
            this.m_projectID = 0;
            ProjectFile projectFile = this.read();
            return projectFile;
        }
        catch (SQLException ex) {
            throw new MPXJException("Failed to create connection", ex);
        }
        finally {
            AutoCloseableHelper.closeQuietly(this.m_connection);
        }
    }

    @Override
    public List<ProjectFile> readAll(File file) throws MPXJException {
        return Arrays.asList(this.read(file));
    }

    public ProjectFile read() throws MPXJException {
        try {
            this.m_reader = new AstaReader();
            ProjectFile project = this.m_reader.getProject();
            this.addListenersToProject(project);
            this.processProjectProperties();
            this.processCalendars();
            this.processResources();
            this.processTasks();
            this.processPredecessors();
            this.processAssignments();
            this.m_reader = null;
            return project;
        }
        catch (SQLException ex) {
            throw new MPXJException("Error reading file", ex);
        }
        catch (ParseException ex) {
            throw new MPXJException("Error reading file", ex);
        }
    }

    private void processProjectProperties() throws SQLException {
        List<Row> projectSummaryRows = this.getRows("select duration as durationhours, project_start as staru, project_end as ene, * from project_summary where projid=?", this.m_projectID);
        List<Row> progressPeriodRows = this.getRows("select id as progress_periodid, * from progress_period where projid=?", this.m_projectID);
        Row projectSummary = projectSummaryRows.isEmpty() ? null : projectSummaryRows.get(0);
        List<Row> progressPeriods = progressPeriodRows.isEmpty() ? null : progressPeriodRows;
        this.m_reader.processProjectProperties(projectSummary, progressPeriods);
    }

    private void processCalendars() throws SQLException, ParseException {
        List<Row> rows = this.getRows("select id as exceptionnid, * from exceptionn");
        Map<Integer, DayType> exceptionTypeMap = this.m_reader.createExceptionTypeMap(rows);
        rows = this.getRows("select id as work_patternid, name as namn, * from work_pattern");
        Map<Integer, Row> workPatternMap = this.m_reader.createWorkPatternMap(rows);
        rows = this.getRows("select id, work_patterns from calendar");
        Map<Integer, List<Row>> workPatternAssignmentMap = this.createWorkPatternAssignmentMap(rows);
        rows = this.getRows("select id, exceptions from calendar");
        Map<Integer, List<Row>> exceptionAssignmentMap = this.createExceptionAssignmentMap(rows);
        rows = this.getRows("select id, shifts from work_pattern");
        Map<Integer, List<Row>> timeEntryMap = this.createTimeEntryMap(rows);
        rows = this.getRows("select id as calendarid, name as namk, * from calendar where projid=? order by id", this.m_projectID);
        for (Row row : rows) {
            this.m_reader.processCalendar(row, workPatternMap, workPatternAssignmentMap, exceptionAssignmentMap, timeEntryMap, exceptionTypeMap);
        }
        this.m_reader.getProject().getProjectConfig().updateUniqueCounters();
    }

    private void processResources() throws SQLException {
        List<Row> permanentRows = this.getRows("select id as permanent_resourceid, name as nase, calendar as calendav, * from permanent_resource where projid=? order by id", this.m_projectID);
        List<Row> consumableRows = this.getRows("select id as consumable_resourceid, name as nase, calendar as calendav, * from consumable_resource where projid=? order by id", this.m_projectID);
        this.m_reader.processResources(permanentRows, consumableRows);
    }

    private void processTasks() throws SQLException {
        List<Row> bars = this.getRows("select id as barid, bar_start as starv, bar_finish as enf, name as namh, * from bar where projid=?", this.m_projectID);
        List<Row> expandedTasks = this.getRows("select id as expanded_taskid, constraint_flag as constrainu, * from expanded_task where projid=?", this.m_projectID);
        List<Row> tasks = this.getRows("select id as taskid, given_duration as given_durationhours, actual_duration as actual_durationhours, overall_percent_complete as overall_percenv_complete, name as nare, calendar as calendau, linkable_start as starz, linkable_finish as enj, notes as notet, wbs as wbt, natural_order as naturao_order, constraint_flag as constrainu, * from task where projid=?", this.m_projectID);
        List<Row> milestones = this.getRows("select id as milestoneid, name as nare, calendar as calendau, wbs as wbt, natural_order as naturao_order, constraint_flag as constrainu, * from milestone where projid=?", this.m_projectID);
        this.m_reader.processTasks(bars, expandedTasks, tasks, milestones);
    }

    private void processPredecessors() throws SQLException {
        List<Row> rows = this.getRows("select start_lag_time as start_lag_timehours, end_lag_time as end_lag_timehours, link_kind as typi, * from link where projid=? order by id", this.m_projectID);
        List<Row> completedSections = this.getRows("select id as task_completed_sectionid, * from task_completed_section where projid=? order by id", this.m_projectID);
        this.m_reader.processPredecessors(rows, completedSections);
    }

    private void processAssignments() throws SQLException {
        List<Row> permanentAssignments = this.getRows("select allocated_to as allocatee_to, player, percent_complete, effort as efforw, permanent_schedul_allocation.id as permanent_schedul_allocationid, linkable_start as starz, linkable_finish as enj, given_allocation, delay as delaahours from permanent_schedul_allocation inner join perm_resource_skill on permanent_schedul_allocation.allocation_of = perm_resource_skill.id where permanent_schedul_allocation.projid=? order by permanent_schedul_allocation.id", this.m_projectID);
        this.m_reader.processAssignments(permanentAssignments);
    }

    private List<Row> getRows(String sql) throws SQLException {
        ArrayList<Row> result = new ArrayList<Row>();
        this.m_ps = this.m_connection.prepareStatement(sql);
        this.m_rs = this.m_ps.executeQuery();
        this.populateMetaData();
        while (this.m_rs.next()) {
            result.add(new SqliteResultSetRow(this.m_rs, this.m_meta));
        }
        return result;
    }

    private List<Row> getRows(String sql, Integer var) throws SQLException {
        ArrayList<Row> result = new ArrayList<Row>();
        this.m_ps = this.m_connection.prepareStatement(sql);
        this.m_ps.setInt(1, NumberHelper.getInt(var));
        this.m_rs = this.m_ps.executeQuery();
        this.populateMetaData();
        while (this.m_rs.next()) {
            result.add(new SqliteResultSetRow(this.m_rs, this.m_meta));
        }
        return result;
    }

    private void populateMetaData() throws SQLException {
        this.m_meta.clear();
        ResultSetMetaData meta = this.m_rs.getMetaData();
        int columnCount = meta.getColumnCount() + 1;
        for (int loop = 1; loop < columnCount; ++loop) {
            String name = meta.getColumnName(loop);
            Integer type = meta.getColumnType(loop);
            this.m_meta.put(name, type);
        }
    }

    private Map<Integer, List<Row>> createWorkPatternAssignmentMap(List<Row> rows) throws ParseException {
        HashMap<Integer, List<Row>> map = new HashMap<Integer, List<Row>>();
        for (Row row : rows) {
            Integer calendarID = row.getInteger("ID");
            String workPatterns = row.getString("WORK_PATTERNS");
            map.put(calendarID, this.createWorkPatternAssignmentRowList(workPatterns));
        }
        return map;
    }

    private List<Row> createWorkPatternAssignmentRowList(String workPatterns) throws ParseException {
        ArrayList<Row> list = new ArrayList<Row>();
        String[] patterns = workPatterns.split(",|:");
        for (int index = 1; index < patterns.length; index += 5) {
            Integer workPattern = Integer.valueOf(patterns[index + 1]);
            Date startDate = DatatypeConverter.parseBasicTimestamp(patterns[index + 3]);
            Date endDate = DatatypeConverter.parseBasicTimestamp(patterns[index + 4]);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("WORK_PATTERN", workPattern);
            map.put("START_DATE", startDate);
            map.put("END_DATE", endDate);
            list.add(new MapRow(map));
        }
        return list;
    }

    private Map<Integer, List<Row>> createExceptionAssignmentMap(List<Row> rows) {
        HashMap<Integer, List<Row>> map = new HashMap<Integer, List<Row>>();
        for (Row row : rows) {
            Integer calendarID = row.getInteger("ID");
            String exceptions = row.getString("EXCEPTIONS");
            map.put(calendarID, this.createExceptionAssignmentRowList(exceptions));
        }
        return map;
    }

    private List<Row> createExceptionAssignmentRowList(String exceptionData) {
        ArrayList<Row> list = new ArrayList<Row>();
        String[] exceptions = exceptionData.split(",|:");
        for (int index = 1; index < exceptions.length; index += 3) {
            Date startDate = DatatypeConverter.parseEpochTimestamp(exceptions[index + 0]);
            Date endDate = DatatypeConverter.parseEpochTimestamp(exceptions[index + 1]);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("STARU_DATE", startDate);
            map.put("ENE_DATE", endDate);
            list.add(new MapRow(map));
        }
        return list;
    }

    private Map<Integer, List<Row>> createTimeEntryMap(List<Row> rows) throws ParseException {
        HashMap<Integer, List<Row>> map = new HashMap<Integer, List<Row>>();
        for (Row row : rows) {
            Integer workPatternID = row.getInteger("ID");
            String shifts = row.getString("SHIFTS");
            map.put(workPatternID, this.createTimeEntryRowList(shifts));
        }
        return map;
    }

    private List<Row> createTimeEntryRowList(String shiftData) throws ParseException {
        ArrayList<Row> list = new ArrayList<Row>();
        String[] shifts = shiftData.split(",|:");
        int index = 1;
        while (index < shifts.length) {
            int entryCount = Integer.parseInt(shifts[index += 2]);
            ++index;
            for (int entryIndex = 0; entryIndex < entryCount; ++entryIndex) {
                Integer exceptionTypeID = Integer.valueOf(shifts[index + 0]);
                Date startTime = DatatypeConverter.parseBasicTime(shifts[index + 1]);
                Date endTime = DatatypeConverter.parseBasicTime(shifts[index + 2]);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("START_TIME", startTime);
                map.put("END_TIME", endTime);
                map.put("EXCEPTIOP", exceptionTypeID);
                list.add(new MapRow(map));
                index += 3;
            }
        }
        return list;
    }
}

