/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.ArrayList;
import java.util.List;
import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.CustomFieldLookupTable;
import net.sf.mpxj.CustomFieldValueMask;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.GraphicalIndicator;

public class CustomField {
    private final FieldType m_field;
    private final CustomFieldContainer m_parent;
    private final CustomFieldLookupTable m_table;
    private final GraphicalIndicator m_indicator;
    private final List<CustomFieldValueMask> m_masks;
    private String m_alias;

    public CustomField(FieldType field, CustomFieldContainer parent) {
        this.m_field = field;
        this.m_parent = parent;
        this.m_table = new CustomFieldLookupTable();
        this.m_indicator = new GraphicalIndicator();
        this.m_masks = new ArrayList<CustomFieldValueMask>();
    }

    public FieldType getFieldType() {
        return this.m_field;
    }

    public CustomFieldLookupTable getLookupTable() {
        return this.m_table;
    }

    public GraphicalIndicator getGraphicalIndicator() {
        return this.m_indicator;
    }

    public String getAlias() {
        return this.m_alias;
    }

    public CustomField setAlias(String alias) {
        this.m_alias = alias;
        this.m_parent.registerAlias(this.m_field, alias);
        return this;
    }

    public List<CustomFieldValueMask> getMasks() {
        return this.m_masks;
    }

    public String toString() {
        return "[CustomField field=" + this.m_field + " alias=" + this.m_alias + "]";
    }
}

