"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Network = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_ec2_1 = require("aws-cdk-lib/aws-ec2");
const constructs_1 = require("constructs");
/**
 * Network settings for the manager and runners
 *
 *  All EC2 instances should belong to the same subnet, availability zone and vpc.
 */
class Network extends constructs_1.Construct {
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        this.vpc = (_b = props === null || props === void 0 ? void 0 : props.vpc) !== null && _b !== void 0 ? _b : new aws_ec2_1.Vpc(scope, `Vpc`, {
            maxAzs: 1,
        });
        this.subnet = this.findSubnet(this.vpc, props === null || props === void 0 ? void 0 : props.subnetSelection);
        this.availabilityZone = this.subnet.availabilityZone;
        if (!this.hasPrivateSubnets()) {
            aws_cdk_lib_1.Annotations.of(this).addWarning(`No private network found in ${this.vpc.vpcId}, using public addresses.`);
        }
    }
    hasPrivateSubnets() {
        return !!this.vpc.privateSubnets.length;
    }
    /**
     * Returns the first private or public subnet. Optionally filters by AZ.
     *
     * @exception Throws an error if no private or public is found.
     */
    findSubnet(vpc, subnetSelection) {
        const selectedSubnets = vpc.selectSubnets(subnetSelection || {
            subnetType: this.hasPrivateSubnets() ? aws_ec2_1.SubnetType.PRIVATE_WITH_NAT : aws_ec2_1.SubnetType.PUBLIC,
            availabilityZones: vpc.availabilityZones,
        });
        const subnet = selectedSubnets.subnets.find(() => true);
        if (!subnet) {
            throw new Error(`Neither a private nor a public subnet is found in ${vpc.vpcId}`);
        }
        return subnet;
    }
}
exports.Network = Network;
_a = JSII_RTTI_SYMBOL_1;
Network[_a] = { fqn: "@pepperize/cdk-autoscaling-gitlab-runner.Network", version: "0.2.26" };
//# sourceMappingURL=data:application/json;base64,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