# Contributing Guide

Development and running tests requires a local SQL Server with the ability to connect using Windows account credentials. [SQL Express](https://www.microsoft.com/en-us/sql-server/sql-server-downloads) can be downloaded for free. The LocalDB package should be selected as LocalDB is readily avialable in Azure DevOps pipelines for the continuous integration and continuous delivery process. To install LocalDB, select Download Media during the installation process, download, and then run SqlLocalDB.msi.

selected during the installation process, as LocalDB is also used for testing within Azure DevOps pipelines.

Run all terminal commands in the top level mssql_dataframe folder. The below commands are specific to a Windows systems.

## Run Tests and Code Coverage Report

<!-- TODO: define git tag, setuptools_scm, and build steps -->

<!-- 
# install build package
python -m pip install --upgrade build
# if releasing from a branch, increment the version tag on the master branch
git tag -a v1.2dev
# add a tag for the new release
git tag -a v1.2.0 -m "tag based versioning"
# check release version number generated by git tag
python -m setuptools_scm
# build the package using pyproject.toml and setup.cfg
python -m build 
-->

1. Fork mssql_dataframe in GitHub.

2. Create python virtual environment.

    ``` cmd
    python -m venv env
    ```

3. Activate virtual environment.

    ``` cmd
    .\env\Scripts\activate
    ```

4. Install development depenancies.

    ``` cmd
    pip install -r requirements-dev.txt
    ```

5. Install mssql_dataframe in editable mode and make changes to code and tests.

    ``` cmd
    pip install -e .
    ```

6. Ensure code will pass later CI processes. This will run coverage, tests, and other build tasks.

    ``` cmd
    python continuous_integration.py
    ```

    Steps such as pytest can be ran manually during development. Pytest will accept the same arguments as `mssql_dataframe.connect.py`.

    ``` cmd
    pytest --server='localhost'
    ```

7. Install git hooks using pre-commit to check files before committing.

    ```cmd
    pre-commit install
    ```

    Optionally test the pre-commit steps before actually preforming the commit.

    ``` cmd
    pre-commit run --all-files
    ```

8. Commit and push the new branch. Create a pull request.

## CICD Build Pipelines

Continuous Integration Continous Delievery can be accomplished in multiple ways.

1. Remote Azure DevOps pipeline. This is the default build process that happens with a pull request.
2. Local Azure DevOps pipeline for testing.
3. Local `continous_integration.py` for local continous integration testing build without Azure.

<!-- # https://docs.microsoft.com/en-us/azure/devops/pipelines/?view=azure-devops
# https://docs.microsoft.com/en-us/azure/devops/pipelines/yaml-schema?view=azure-devops&tabs=schema%2Cparameter-schema
# https://docs.microsoft.com/azure/devops/pipelines/languages/python
# https://docs.microsoft.com/en-us/azure/devops/pipelines/repos/github?view=azure-devops&tabs=yaml
#
# Remote Execution
# 1 Run pipeline in Azure DevOps with remote_agent option selected
#
# Local Execution
# 1 Open PowerShell
# 2 Start the local Azure DevOps agent if previously configured (if not see Contributing.md > CICD Build Pipelines > Local Azure DevOps)
# 2a cd azure-local-pipeline; .\run.cmd;
# 3 Run pipeline in Azure DevOps with remote_agent option deselected -->

### 1. Remote Azure DevOps

<!-- #TODO: document default build process -->
[Azure Pipeline Agents](https://docs.microsoft.com/en-us/azure/devops/pipelines/agents/agents?view=azure-devops&tabs=browser#install)

### 2. Local Azure DevOps

[Local Windows Agent](https://docs.microsoft.com/en-us/azure/devops/pipelines/agents/v2-windows?view=azure-devops)

If you have previously configured the agent, simply start it. The agent should then show online in Azure DevOps > Organization settings >  Agent pools > Agent.

``` ps
cd azure-local-pipeline;
.\run.cmd;
```

Otherwise complete the following steps, starting with opening [Azure DevOps](https://dev.azure.com/jasoncook1989/) to begin setting up the local machine.

#### Add New Agent Pool

1. Orgnaization settings > Agent pools > Add pool
2. Pool type = self-hosted
3. Name = Local Laptop

#### Download Agent

1. Select the newly created pool.
2. Download the agent.

#### Create Agent Locally in PowerShell

First change the directory to the mssql_dataframe repository so the agent directory is created there.

``` ps
cd C:\Users\jacoo\Desktop\Code\python-lib\mssql_dataframe
```

Second extract the downloaded zip file containing the agent. Note the System.IO.Compression.ZipFile command depends on the downloaded version.

``` ps
mkdir azure-local-pipeline;
cd azure-local-pipeline;
Add-Type -AssemblyName System.IO.Compression.FileSystem;
[System.IO.Compression.ZipFile]::ExtractToDirectory("$HOME\Downloads\vsts-agent-win-x64-2.196.1.zip", "$PWD")
```

#### Configure the Agent in PowerShell

``` ps
.\config.cmd
Server URL = https://dev.azure.com/jasoncook1989
```

Press enter to select the personal access token (PAT) method.

#### Create PAT for PowerShell

1. Azure DevOps homepage > user settings (intials icon) > Security > Personal access tokens > New Token
2. Name = azure-local-pipeline
3. Scope = Agent Pools > Read & manage

#### Register Agent

``` ps
agent pool = Local Laptop
agent name > use default by pressing enter
work folder > use default by pressing enter
run agent as service > N
```

#### Run Agent

``` ps
cd azure-local-pipeline;
.\run.cmd;
```

### 3. Local continuous_integration.py

Simply run the script.

``` cmd
python continuous_integration.py
```

## Python Package Index (PyPI)

1. Increment the version in setup.py as appropriate. Given example version A.B.C

    <!--#TODO: where to handle incrementing the version-->

    ```txt
    A.B.C

    A: major version (backwards incompatiable changes)
    B: minor version (added backwards-compatible functionality)
    C: patch version (bug fixes)
    ```

2. Install/update Building & Uploading Packages

    ``` cmd
    pip install --upgrade twine setuptools wheel
    ```

3. Remove Old Build Files

    Ensure the ./dist folder does not contain .gz and .whl files for previous build versions.

4. Build Package & Test

    ``` cmd
    python setup.py sdist bdist_wheel
    twine check dist/*
    ```

5. Upload Package to Test PyPI

    ``` cmd
    twine upload --repository-url https://test.pypi.org/legacy/ dist/*
    ```

6. Test Installation Locally

    ```cmd
    python -m venv TestDeployment
    ./TestDeployment/Scripts/activate
    pip install --index-url https://test.pypi.org/simple/ --extra-index-url https://pypi.org/simple/ mssql_dataframe
    ```

7. Upload Package to PyPI

    ``` cmd
    twine upload dist/*
    ```
