from sqlalchemy import Column, Integer
from uuid import uuid4

from sqlalchemy.dialects.postgresql.base import UUID
from sqlalchemy.orm import relationship

from app.db.base_class import Base
from sqlalchemy.sql.sqltypes import Boolean


class Subscription(Base):
    id = Column(
        UUID(as_uuid=True), primary_key=True, index=True, default=uuid4
    )
    qnt_user = Column(Integer, index=True)
    team_work = Column(Boolean, index=True)
    social_medias = Column(Integer, index=True)
    profiles_analyses = Column(Integer, index=True)
    hashtags_search = Column(Integer, index=True)
    segments = Column(Integer, index=True)
    trends = Column(Boolean, index=True)
    sentiment_analysis = Column(Boolean, index=True)
    apis_access = Column(Boolean, index=True)
    reports = Column(Boolean, index=True)

    accounts = relationship("Account", back_populates="subscriptions")
    