from datetime import datetime

from sqlalchemy.sql.sqltypes import DateTime
from app import (
    crud, 
    schemas
)
from app.core.config import settings
from app.constants.role import Role

from sqlalchemy.orm import Session
# make sure all SQL Alchemy models are imported (app.db.base) before initializing DB
# otherwise, SQL Alchemy might fail to initialize relationships properly
# for more details: https://github.com/tiangolo/full-stack-fastapi-postgresql/issues/28


def init_db(db: Session) -> None:

    # Create Super Admin Account
    account = crud.account.get_by_doc_id(
        db, doc_id=settings.FIRST_SUPER_ADMIN_DOC_ID
    )
    if not account:
        account_in = schemas.AccountCreate(
            company_name=settings.FIRST_SUPER_ADMIN_ACCOUNT_NAME,
            doc_id=settings.FIRST_SUPER_ADMIN_DOC_ID
        )
        crud.account.create(db, obj_in=account_in)

    # Create 1st Superuser
    user = crud.user.get_by_email(db, email=settings.FIRST_SUPER_ADMIN_EMAIL)
    if not user:
        account = crud.account.get_by_doc_id(
            db, doc_id=settings.FIRST_SUPER_ADMIN_DOC_ID
        )
        user_in = schemas.UserCreate(
            email=settings.FIRST_SUPER_ADMIN_EMAIL,
            password=settings.FIRST_SUPER_ADMIN_PASSWORD,
            name=settings.FIRST_SUPER_ADMIN_ACCOUNT_NAME,
            last_name=settings.FIRST_SUPER_ADMIN_ACCOUNT_LAST_NAME,
            phone_number=settings.FIRST_SUPER_ADMIN_PHONE_NUMBER,
            account_id=account.id,
        )
        user = crud.user.create(db, obj_in=user_in)

    # Create Role If They Don't Exist
    guest_role = crud.role.get_by_name(db, name=Role.GUEST["name"])
    if not guest_role:
        guest_role_in = schemas.RoleCreate(
            name=Role.GUEST["name"], description=Role.GUEST["description"]
        )
        crud.role.create(db, obj_in=guest_role_in)

    account_admin_role = crud.role.get_by_name(
        db, name=Role.ACCOUNT_ADMIN["name"]
    )
    if not account_admin_role:
        account_admin_role_in = schemas.RoleCreate(
            name=Role.ACCOUNT_ADMIN["name"],
            description=Role.ACCOUNT_ADMIN["description"],
        )
        crud.role.create(db, obj_in=account_admin_role_in)

    account_manager_role = crud.role.get_by_name(
        db, name=Role.ACCOUNT_MANAGER["name"]
    )
    if not account_manager_role:
        account_manager_role_in = schemas.RoleCreate(
            name=Role.ACCOUNT_MANAGER["name"],
            description=Role.ACCOUNT_MANAGER["description"],
        )
        crud.role.create(db, obj_in=account_manager_role_in)

    admin_role = crud.role.get_by_name(db, name=Role.ADMIN["name"])
    if not admin_role:
        admin_role_in = schemas.RoleCreate(
            name=Role.ADMIN["name"], description=Role.ADMIN["description"]
        )
        crud.role.create(db, obj_in=admin_role_in)

    super_admin_role = crud.role.get_by_name(db, name=Role.SUPER_ADMIN["name"])
    if not super_admin_role:
        super_admin_role_in = schemas.RoleCreate(
            name=Role.SUPER_ADMIN["name"],
            description=Role.SUPER_ADMIN["description"],
        )
        crud.role.create(db, obj_in=super_admin_role_in)

    # Assign super_admin role to user
    user_role = crud.user_role.get_by_user_id(db, user_id=user.id)
    if not user_role:
        role = crud.role.get_by_name(db, name=Role.SUPER_ADMIN["name"])
        user_role_in = schemas.UserRoleCreate(user_id=user.id, role_id=role.id)
        crud.user_role.create(db, obj_in=user_role_in)