from typing import List

from sqlalchemy.orm import Session

from app.crud.base import CRUDBase
from app.models.address import Address
from app.schemas.address import AddressCreate, AddressUpdate


class CRUDItem(CRUDBase[Address, AddressCreate, AddressUpdate]):
    def get_multi_by_owner(
        self, db: Session, *, user_id: int, skip: int = 0, limit: int = 100
    ) -> List[Address]:
        return (
            db.query(self.model)
            .filter(Address.user_id == user_id)
            .offset(skip)
            .limit(limit)
            .all()
        )


address = CRUDItem(Address)