from fastapi import APIRouter

from app.api.api_v1.endpoints import login, users, utils, roles, user_roles, accounts, address

router = APIRouter()


router.include_router(login.router, tags=["login"])
router.include_router(accounts.router, prefix="/accounts", tags=["accounts"])
router.include_router(users.router, prefix="/users", tags=["users"])
router.include_router(roles.router, prefix="/roles", tags=["roles"])
router.include_router(user_roles.router, prefix="/user-roles", tags=["user-roles"])
router.include_router(address.router, prefix="/address", tags=["address"])
router.include_router(utils.router, prefix="/utils", tags=["utils"])