"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_s3_1 = require("monocdk/aws-s3");
const common_1 = require("../../../common");
/**
 * S3 Buckets prohibit public read access through their Block Public Access configurations and bucket ACLs - (Control IDs: AC-3, AC-4, AC-6, AC-21(b), SC-7, SC-7(3))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_s3_1.CfnBucket) {
        const publicAccessBlockConfiguration = monocdk_1.Stack.of(node).resolve(node.publicAccessBlockConfiguration);
        if (publicAccessBlockConfiguration === undefined ||
            common_1.resolveIfPrimitive(node, publicAccessBlockConfiguration.blockPublicPolicy) !== true) {
            return false;
        }
        const accessControl = common_1.resolveIfPrimitive(node, node.accessControl);
        const blockPublicAcls = common_1.resolveIfPrimitive(node, publicAccessBlockConfiguration.blockPublicAcls);
        if ((accessControl === 'PublicRead' || accessControl === 'PublicReadWrite') &&
            blockPublicAcls !== true) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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