"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_s3_1 = require("monocdk/aws-s3");
const common_1 = require("../../../common");
/**
 * S3 Buckets have object lock enabled - (Control ID: SC-28)
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_s3_1.CfnBucket) {
        const objectLockEnabled = common_1.resolveIfPrimitive(node, node.objectLockEnabled);
        const objectLockConfiguration = monocdk_1.Stack.of(node).resolve(node.objectLockConfiguration);
        if (objectLockEnabled !== true ||
            objectLockConfiguration === undefined ||
            common_1.resolveIfPrimitive(node, objectLockConfiguration.objectLockEnabled) !==
                'Enabled') {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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