"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const monocdk_1 = require("monocdk");
const aws_elasticsearch_1 = require("monocdk/aws-elasticsearch");
/**
 * OpenSearch Service domains are within VPCs - (Control IDs: AC-4, SC-7, SC-7(3))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_elasticsearch_1.CfnDomain) {
        //Is the VPC property set?
        const vpcOptions = monocdk_1.Stack.of(node).resolve(node.vpcOptions);
        if (vpcOptions != undefined) {
            if (vpcOptions.subnetIds == undefined ||
                vpcOptions.subnetIds.length == 0) {
                return false;
            }
        }
        else {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmlzdDgwMDUzT3BlblNlYXJjaFJ1bm5pbmdXaXRoaW5WUEMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9zcmMvTklTVC04MDAtNTMvcnVsZXMvb3BlbnNlYXJjaC9uaXN0ODAwNTNPcGVuU2VhcmNoUnVubmluZ1dpdGhpblZQQy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUE7OztFQUdFOztBQUVGLHFDQUE2QztBQUM3QyxpRUFBc0Q7QUFFdEQ7OztHQUdHO0FBQ0gsbUJBQXlCLElBQWlCO0lBQ3hDLElBQUksSUFBSSxZQUFZLDZCQUFTLEVBQUU7UUFDN0IsMEJBQTBCO1FBQzFCLE1BQU0sVUFBVSxHQUFHLGVBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsQ0FBQztRQUMzRCxJQUFJLFVBQVUsSUFBSSxTQUFTLEVBQUU7WUFDM0IsSUFDRSxVQUFVLENBQUMsU0FBUyxJQUFJLFNBQVM7Z0JBQ2pDLFVBQVUsQ0FBQyxTQUFTLENBQUMsTUFBTSxJQUFJLENBQUMsRUFDaEM7Z0JBQ0EsT0FBTyxLQUFLLENBQUM7YUFDZDtTQUNGO2FBQU07WUFDTCxPQUFPLEtBQUssQ0FBQztTQUNkO0tBQ0Y7SUFDRCxPQUFPLElBQUksQ0FBQztBQUNkLENBQUM7QUFoQkQsNEJBZ0JDIiwic291cmNlc0NvbnRlbnQiOlsiLypcbkNvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiovXG5cbmltcG9ydCB7IENmblJlc291cmNlLCBTdGFjayB9IGZyb20gJ21vbm9jZGsnO1xuaW1wb3J0IHsgQ2ZuRG9tYWluIH0gZnJvbSAnbW9ub2Nkay9hd3MtZWxhc3RpY3NlYXJjaCc7XG5cbi8qKlxuICogT3BlblNlYXJjaCBTZXJ2aWNlIGRvbWFpbnMgYXJlIHdpdGhpbiBWUENzIC0gKENvbnRyb2wgSURzOiBBQy00LCBTQy03LCBTQy03KDMpKVxuICogQHBhcmFtIG5vZGUgdGhlIENmblJlc291cmNlIHRvIGNoZWNrXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIChub2RlOiBDZm5SZXNvdXJjZSk6IGJvb2xlYW4ge1xuICBpZiAobm9kZSBpbnN0YW5jZW9mIENmbkRvbWFpbikge1xuICAgIC8vSXMgdGhlIFZQQyBwcm9wZXJ0eSBzZXQ/XG4gICAgY29uc3QgdnBjT3B0aW9ucyA9IFN0YWNrLm9mKG5vZGUpLnJlc29sdmUobm9kZS52cGNPcHRpb25zKTtcbiAgICBpZiAodnBjT3B0aW9ucyAhPSB1bmRlZmluZWQpIHtcbiAgICAgIGlmIChcbiAgICAgICAgdnBjT3B0aW9ucy5zdWJuZXRJZHMgPT0gdW5kZWZpbmVkIHx8XG4gICAgICAgIHZwY09wdGlvbnMuc3VibmV0SWRzLmxlbmd0aCA9PSAwXG4gICAgICApIHtcbiAgICAgICAgcmV0dXJuIGZhbHNlO1xuICAgICAgfVxuICAgIH0gZWxzZSB7XG4gICAgICByZXR1cm4gZmFsc2U7XG4gICAgfVxuICB9XG4gIHJldHVybiB0cnVlO1xufVxuIl19