"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const monocdk_1 = require("monocdk");
const aws_elasticloadbalancingv2_1 = require("monocdk/aws-elasticloadbalancingv2");
/**
 * ALBs, NLBs, and GLBs have deletion protection enabled - (Control IDs: CM-2, CP-10)
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_elasticloadbalancingv2_1.CfnLoadBalancer) {
        const attributes = monocdk_1.Stack.of(node).resolve(node.loadBalancerAttributes);
        if (attributes != undefined) {
            var deletionProtectionEnabled = false;
            for (const attr of attributes) {
                const resolvedAttr = monocdk_1.Stack.of(node).resolve(attr);
                if (resolvedAttr.key != undefined &&
                    resolvedAttr.key == 'deletion_protection.enabled') {
                    if (resolvedAttr.value == 'true') {
                        deletionProtectionEnabled = true;
                    }
                }
            }
            if (!deletionProtectionEnabled) {
                return false;
            }
        }
        else {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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