"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const monocdk_1 = require("monocdk");
const aws_ec2_1 = require("monocdk/aws-ec2");
const common_1 = require("../../../common");
/**
 * Security Groups do not allow for unrestricted SSH traffic - (Control IDs: AC-4, SC-7, SC-7(3))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_ec2_1.CfnSecurityGroup) {
        const ingressRules = monocdk_1.Stack.of(node).resolve(node.securityGroupIngress);
        if (ingressRules != undefined) {
            //For each ingress rule, ensure that it does not allow unrestricted SSH traffic.
            for (const rule of ingressRules) {
                const resolvedRule = monocdk_1.Stack.of(node).resolve(rule);
                const ipProtocol = common_1.resolveIfPrimitive(node, resolvedRule.ipProtocol);
                const cidrIp = common_1.resolveIfPrimitive(node, resolvedRule.cidrIp);
                const cidrIpv6 = common_1.resolveIfPrimitive(node, resolvedRule.cidrIpv6);
                const fromPort = common_1.resolveIfPrimitive(node, resolvedRule.fromPort);
                const toPort = common_1.resolveIfPrimitive(node, resolvedRule.toPort);
                if ((cidrIp != undefined && cidrIp.includes('/0')) ||
                    (cidrIpv6 != undefined && cidrIpv6.includes('/0'))) {
                    if (fromPort != undefined && toPort != undefined) {
                        if ((fromPort <= 22 && toPort >= 22) ||
                            fromPort == -1 ||
                            toPort == -1 ||
                            ipProtocol == '-1') {
                            return false;
                        }
                    }
                    else {
                        if (fromPort == 22 || ipProtocol == '-1') {
                            return false;
                        }
                    }
                }
            }
        }
    }
    else if (node instanceof aws_ec2_1.CfnSecurityGroupIngress) {
        const ipProtocol = common_1.resolveIfPrimitive(node, node.ipProtocol);
        const cidrIp = common_1.resolveIfPrimitive(node, node.cidrIp);
        const cidrIpv6 = common_1.resolveIfPrimitive(node, node.cidrIpv6);
        const fromPort = common_1.resolveIfPrimitive(node, node.fromPort);
        const toPort = common_1.resolveIfPrimitive(node, node.toPort);
        if ((cidrIp != undefined && cidrIp.includes('/0')) ||
            (cidrIpv6 != undefined && cidrIpv6.includes('/0'))) {
            //Is a port range specified?
            if (fromPort != undefined && toPort != undefined) {
                if ((fromPort <= 22 && toPort >= 22) ||
                    fromPort == -1 ||
                    toPort == -1 ||
                    ipProtocol == '-1') {
                    return false;
                }
            }
            else {
                if (fromPort == 22 || ipProtocol == '-1') {
                    return false;
                }
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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