"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const monocdk_1 = require("monocdk");
const aws_ec2_1 = require("monocdk/aws-ec2");
const common_1 = require("../../../common");
/**
 * EC2 instances do not have public IPs - (Control IDs: AC-4, AC-6, AC-21(b), SC-7, SC-7(3))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_ec2_1.CfnInstance) {
        const networkInterfaces = monocdk_1.Stack.of(node).resolve(node.networkInterfaces);
        if (networkInterfaces != undefined) {
            //Iterate through network interfaces, checking if public IPs are enabled
            for (const networkInterface of networkInterfaces) {
                const resolvedInterface = monocdk_1.Stack.of(node).resolve(networkInterface);
                const associatePublicIpAddress = common_1.resolveIfPrimitive(node, resolvedInterface.associatePublicIpAddress);
                if (associatePublicIpAddress === true) {
                    return false;
                }
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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