"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const aws_autoscaling_1 = require("monocdk/aws-autoscaling");
const aws_ec2_1 = require("monocdk/aws-ec2");
const common_1 = require("../../../common");
/**
 * EC2 instances have detailed monitoring enabled - (Control IDs: CA-7(a)(b), SI-4(2), SI-4(a)(b)(c)).
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_ec2_1.CfnInstance) {
        const monitoring = common_1.resolveIfPrimitive(node, node.monitoring);
        if (monitoring == undefined || monitoring == false) {
            return false;
        }
    }
    else if (node instanceof aws_autoscaling_1.CfnLaunchConfiguration) {
        const monitoring = common_1.resolveIfPrimitive(node, node.instanceMonitoring);
        if (monitoring != undefined && monitoring == false) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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