"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const monocdk_1 = require("monocdk");
const aws_codebuild_1 = require("monocdk/aws-codebuild");
const common_1 = require("../../../common");
/**
 * CodeBuild projects DO NOT store AWS credentials as plaintext environment variables - (Control IDs: AC-6, IA-5(7), SA-3(a))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_codebuild_1.CfnProject) {
        //Check for the presence of OAUTH
        const environment = monocdk_1.Stack.of(node).resolve(node.environment);
        const environmentVars = monocdk_1.Stack.of(node).resolve(environment.environmentVariables);
        if (environmentVars != undefined) {
            //For each envvar, check if its a sensitive credential being stored
            for (const envVar of environmentVars) {
                const resolvedEnvVar = monocdk_1.Stack.of(node).resolve(envVar);
                const name = common_1.resolveIfPrimitive(node, resolvedEnvVar.name);
                const type = common_1.resolveIfPrimitive(node, resolvedEnvVar.type);
                if (name == 'AWS_ACCESS_KEY_ID' || name == 'AWS_SECRET_ACCESS_KEY') {
                    //is this credential being stored as plaintext?
                    if (type == undefined || type == 'PLAINTEXT') {
                        return false;
                    }
                }
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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