"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const monocdk_1 = require("monocdk");
const aws_autoscaling_1 = require("monocdk/aws-autoscaling");
const common_1 = require("../../../common");
/**
 * Auto Scaling groups which are associated with load balancers utilize ELB health checks - (Control IDs: SC-5)
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_autoscaling_1.CfnAutoScalingGroup) {
        //get all associated CLBs
        const classicLBs = monocdk_1.Stack.of(node).resolve(node.loadBalancerNames);
        //get all associated Application LBs, Gateway LBs, and Network LBs
        const otherLBs = monocdk_1.Stack.of(node).resolve(node.targetGroupArns);
        if ((otherLBs != undefined && otherLBs.length > 0) ||
            (classicLBs != undefined && classicLBs.length > 0)) {
            const healthCheckType = common_1.resolveIfPrimitive(node, node.healthCheckType);
            //Do we use ELB health checks?
            if (healthCheckType != undefined) {
                if (healthCheckType != 'ELB') {
                    return false;
                }
            }
            else {
                return false;
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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