"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const aws_ec2_1 = require("monocdk/aws-ec2");
const common_1 = require("../../../common");
/**
 * Subnets do not auto-assign public IP addresses - (Control IDs: 164.308(a)(3)(i), 164.308(a)(4)(ii)(A), 164.308(a)(4)(ii)(C), 164.312(a)(1), 164.312(e)(1))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_ec2_1.CfnSubnet) {
        const mapPublicIpOnLaunch = common_1.resolveIfPrimitive(node, node.mapPublicIpOnLaunch);
        const assignIpv6AddressOnCreation = common_1.resolveIfPrimitive(node, node.assignIpv6AddressOnCreation);
        if (mapPublicIpOnLaunch === true || assignIpv6AddressOnCreation === true) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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