"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const aws_ec2_1 = require("monocdk/aws-ec2");
const common_1 = require("../../../common");
/**
 * Route tables do not have unrestricted routes ('0.0.0.0/0' or '::/0') to IGWs - (Control ID: 164.312(e)(1))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_ec2_1.CfnRoute) {
        if (node.gatewayId != undefined) {
            const destinationCidrBlock = common_1.resolveIfPrimitive(node, node.destinationCidrBlock);
            const destinationIpv6CidrBlock = common_1.resolveIfPrimitive(node, node.destinationIpv6CidrBlock);
            if (destinationCidrBlock != undefined &&
                destinationCidrBlock.includes('/0')) {
                return false;
            }
            if (destinationIpv6CidrBlock != undefined &&
                destinationIpv6CidrBlock.includes('/0')) {
                return false;
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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