"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const aws_secretsmanager_1 = require("monocdk/aws-secretsmanager");
const common_1 = require("../../../common");
/**
 * Secrets are encrypted with KMS Customer managed keys - (Control IDs: 164.312(a)(2)(iv), 164.312(e)(2)(ii))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_secretsmanager_1.CfnSecret) {
        const kmsKeyId = common_1.resolveIfPrimitive(node, node.kmsKeyId);
        if (kmsKeyId === undefined || kmsKeyId === 'aws/secretsmanager') {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaGlwYWFTZWN1cml0eVNlY3JldHNNYW5hZ2VyVXNpbmdLTVNLZXkuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9zcmMvSElQQUEtU2VjdXJpdHkvcnVsZXMvc2VjcmV0c21hbmFnZXIvaGlwYWFTZWN1cml0eVNlY3JldHNNYW5hZ2VyVXNpbmdLTVNLZXkudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBOzs7RUFHRTs7QUFHRixtRUFBdUQ7QUFDdkQsNENBQXFEO0FBRXJEOzs7R0FHRztBQUNILG1CQUF5QixJQUFpQjtJQUN4QyxJQUFJLElBQUksWUFBWSw4QkFBUyxFQUFFO1FBQzdCLE1BQU0sUUFBUSxHQUFHLDJCQUFrQixDQUFDLElBQUksRUFBRSxJQUFJLENBQUMsUUFBUSxDQUFDLENBQUM7UUFDekQsSUFBSSxRQUFRLEtBQUssU0FBUyxJQUFJLFFBQVEsS0FBSyxvQkFBb0IsRUFBRTtZQUMvRCxPQUFPLEtBQUssQ0FBQztTQUNkO0tBQ0Y7SUFDRCxPQUFPLElBQUksQ0FBQztBQUNkLENBQUM7QUFSRCw0QkFRQyIsInNvdXJjZXNDb250ZW50IjpbIi8qXG5Db3B5cmlnaHQgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cblNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4qL1xuXG5pbXBvcnQgeyBDZm5SZXNvdXJjZSB9IGZyb20gJ21vbm9jZGsnO1xuaW1wb3J0IHsgQ2ZuU2VjcmV0IH0gZnJvbSAnbW9ub2Nkay9hd3Mtc2VjcmV0c21hbmFnZXInO1xuaW1wb3J0IHsgcmVzb2x2ZUlmUHJpbWl0aXZlIH0gZnJvbSAnLi4vLi4vLi4vY29tbW9uJztcblxuLyoqXG4gKiBTZWNyZXRzIGFyZSBlbmNyeXB0ZWQgd2l0aCBLTVMgQ3VzdG9tZXIgbWFuYWdlZCBrZXlzIC0gKENvbnRyb2wgSURzOiAxNjQuMzEyKGEpKDIpKGl2KSwgMTY0LjMxMihlKSgyKShpaSkpXG4gKiBAcGFyYW0gbm9kZSB0aGUgQ2ZuUmVzb3VyY2UgdG8gY2hlY2tcbiAqL1xuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gKG5vZGU6IENmblJlc291cmNlKTogYm9vbGVhbiB7XG4gIGlmIChub2RlIGluc3RhbmNlb2YgQ2ZuU2VjcmV0KSB7XG4gICAgY29uc3Qga21zS2V5SWQgPSByZXNvbHZlSWZQcmltaXRpdmUobm9kZSwgbm9kZS5rbXNLZXlJZCk7XG4gICAgaWYgKGttc0tleUlkID09PSB1bmRlZmluZWQgfHwga21zS2V5SWQgPT09ICdhd3Mvc2VjcmV0c21hbmFnZXInKSB7XG4gICAgICByZXR1cm4gZmFsc2U7XG4gICAgfVxuICB9XG4gIHJldHVybiB0cnVlO1xufVxuIl19