"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_s3_1 = require("monocdk/aws-s3");
const common_1 = require("../../../common");
/**
 * S3 Buckets prohibit public access through bucket level settings - (Control IDs: 164.308(a)(3)(i), 164.308(a)(4)(ii)(A), 164.308(a)(4)(ii)(C), 164.312(a)(1), 164.312(e)(1))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_s3_1.CfnBucket) {
        if (node.publicAccessBlockConfiguration == undefined) {
            return false;
        }
        const publicAccess = monocdk_1.Stack.of(node).resolve(node.publicAccessBlockConfiguration);
        const blockPublicAcls = common_1.resolveIfPrimitive(node, publicAccess.blockPublicAcls);
        const blockPublicPolicy = common_1.resolveIfPrimitive(node, publicAccess.blockPublicPolicy);
        const ignorePublicAcls = common_1.resolveIfPrimitive(node, publicAccess.ignorePublicAcls);
        const restrictPublicBuckets = common_1.resolveIfPrimitive(node, publicAccess.restrictPublicBuckets);
        if (blockPublicAcls !== true ||
            blockPublicPolicy !== true ||
            ignorePublicAcls !== true ||
            restrictPublicBuckets !== true) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaGlwYWFTZWN1cml0eVMzQnVja2V0TGV2ZWxQdWJsaWNBY2Nlc3NQcm9oaWJpdGVkLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vc3JjL0hJUEFBLVNlY3VyaXR5L3J1bGVzL3MzL2hpcGFhU2VjdXJpdHlTM0J1Y2tldExldmVsUHVibGljQWNjZXNzUHJvaGliaXRlZC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBOzs7RUFHRTtBQUNGLHFDQUE2QztBQUM3QywyQ0FBMkM7QUFDM0MsNENBQXFEO0FBRXJEOzs7R0FHRztBQUNILG1CQUF5QixJQUFpQjtJQUN4QyxJQUFJLElBQUksWUFBWSxrQkFBUyxFQUFFO1FBQzdCLElBQUksSUFBSSxDQUFDLDhCQUE4QixJQUFJLFNBQVMsRUFBRTtZQUNwRCxPQUFPLEtBQUssQ0FBQztTQUNkO1FBQ0QsTUFBTSxZQUFZLEdBQUcsZUFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxPQUFPLENBQ3pDLElBQUksQ0FBQyw4QkFBOEIsQ0FDcEMsQ0FBQztRQUNGLE1BQU0sZUFBZSxHQUFHLDJCQUFrQixDQUN4QyxJQUFJLEVBQ0osWUFBWSxDQUFDLGVBQWUsQ0FDN0IsQ0FBQztRQUNGLE1BQU0saUJBQWlCLEdBQUcsMkJBQWtCLENBQzFDLElBQUksRUFDSixZQUFZLENBQUMsaUJBQWlCLENBQy9CLENBQUM7UUFDRixNQUFNLGdCQUFnQixHQUFHLDJCQUFrQixDQUN6QyxJQUFJLEVBQ0osWUFBWSxDQUFDLGdCQUFnQixDQUM5QixDQUFDO1FBQ0YsTUFBTSxxQkFBcUIsR0FBRywyQkFBa0IsQ0FDOUMsSUFBSSxFQUNKLFlBQVksQ0FBQyxxQkFBcUIsQ0FDbkMsQ0FBQztRQUNGLElBQ0UsZUFBZSxLQUFLLElBQUk7WUFDeEIsaUJBQWlCLEtBQUssSUFBSTtZQUMxQixnQkFBZ0IsS0FBSyxJQUFJO1lBQ3pCLHFCQUFxQixLQUFLLElBQUksRUFDOUI7WUFDQSxPQUFPLEtBQUssQ0FBQztTQUNkO0tBQ0Y7SUFDRCxPQUFPLElBQUksQ0FBQztBQUNkLENBQUM7QUFsQ0QsNEJBa0NDIiwic291cmNlc0NvbnRlbnQiOlsiLypcbkNvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiovXG5pbXBvcnQgeyBDZm5SZXNvdXJjZSwgU3RhY2sgfSBmcm9tICdtb25vY2RrJztcbmltcG9ydCB7IENmbkJ1Y2tldCB9IGZyb20gJ21vbm9jZGsvYXdzLXMzJztcbmltcG9ydCB7IHJlc29sdmVJZlByaW1pdGl2ZSB9IGZyb20gJy4uLy4uLy4uL2NvbW1vbic7XG5cbi8qKlxuICogUzMgQnVja2V0cyBwcm9oaWJpdCBwdWJsaWMgYWNjZXNzIHRocm91Z2ggYnVja2V0IGxldmVsIHNldHRpbmdzIC0gKENvbnRyb2wgSURzOiAxNjQuMzA4KGEpKDMpKGkpLCAxNjQuMzA4KGEpKDQpKGlpKShBKSwgMTY0LjMwOChhKSg0KShpaSkoQyksIDE2NC4zMTIoYSkoMSksIDE2NC4zMTIoZSkoMSkpXG4gKiBAcGFyYW0gbm9kZSB0aGUgQ2ZuUmVzb3VyY2UgdG8gY2hlY2tcbiAqL1xuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gKG5vZGU6IENmblJlc291cmNlKTogYm9vbGVhbiB7XG4gIGlmIChub2RlIGluc3RhbmNlb2YgQ2ZuQnVja2V0KSB7XG4gICAgaWYgKG5vZGUucHVibGljQWNjZXNzQmxvY2tDb25maWd1cmF0aW9uID09IHVuZGVmaW5lZCkge1xuICAgICAgcmV0dXJuIGZhbHNlO1xuICAgIH1cbiAgICBjb25zdCBwdWJsaWNBY2Nlc3MgPSBTdGFjay5vZihub2RlKS5yZXNvbHZlKFxuICAgICAgbm9kZS5wdWJsaWNBY2Nlc3NCbG9ja0NvbmZpZ3VyYXRpb24sXG4gICAgKTtcbiAgICBjb25zdCBibG9ja1B1YmxpY0FjbHMgPSByZXNvbHZlSWZQcmltaXRpdmUoXG4gICAgICBub2RlLFxuICAgICAgcHVibGljQWNjZXNzLmJsb2NrUHVibGljQWNscyxcbiAgICApO1xuICAgIGNvbnN0IGJsb2NrUHVibGljUG9saWN5ID0gcmVzb2x2ZUlmUHJpbWl0aXZlKFxuICAgICAgbm9kZSxcbiAgICAgIHB1YmxpY0FjY2Vzcy5ibG9ja1B1YmxpY1BvbGljeSxcbiAgICApO1xuICAgIGNvbnN0IGlnbm9yZVB1YmxpY0FjbHMgPSByZXNvbHZlSWZQcmltaXRpdmUoXG4gICAgICBub2RlLFxuICAgICAgcHVibGljQWNjZXNzLmlnbm9yZVB1YmxpY0FjbHMsXG4gICAgKTtcbiAgICBjb25zdCByZXN0cmljdFB1YmxpY0J1Y2tldHMgPSByZXNvbHZlSWZQcmltaXRpdmUoXG4gICAgICBub2RlLFxuICAgICAgcHVibGljQWNjZXNzLnJlc3RyaWN0UHVibGljQnVja2V0cyxcbiAgICApO1xuICAgIGlmIChcbiAgICAgIGJsb2NrUHVibGljQWNscyAhPT0gdHJ1ZSB8fFxuICAgICAgYmxvY2tQdWJsaWNQb2xpY3kgIT09IHRydWUgfHxcbiAgICAgIGlnbm9yZVB1YmxpY0FjbHMgIT09IHRydWUgfHxcbiAgICAgIHJlc3RyaWN0UHVibGljQnVja2V0cyAhPT0gdHJ1ZVxuICAgICkge1xuICAgICAgcmV0dXJuIGZhbHNlO1xuICAgIH1cbiAgfVxuICByZXR1cm4gdHJ1ZTtcbn1cbiJdfQ==