"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_rds_1 = require("monocdk/aws-rds");
const common_1 = require("../../../common");
/**
 *  Non-Aurora RDS DB instances have multi-AZ support enabled - (Control IDs: 164.308(a)(7)(i), 164.308(a)(7)(ii)(C))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_rds_1.CfnDBInstance) {
        const multiAz = common_1.resolveIfPrimitive(node, node.multiAz);
        const engine = common_1.resolveIfPrimitive(node, node.engine);
        if (!multiAz &&
            (engine == undefined || !engine.toLowerCase().includes('aurora'))) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaGlwYWFTZWN1cml0eVJEU0luc3RhbmNlTXVsdGlBWlN1cHBvcnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9zcmMvSElQQUEtU2VjdXJpdHkvcnVsZXMvcmRzL2hpcGFhU2VjdXJpdHlSRFNJbnN0YW5jZU11bHRpQVpTdXBwb3J0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBS0EsNkNBQWdEO0FBQ2hELDRDQUFxRDtBQUVyRDs7O0dBR0c7QUFDSCxtQkFBeUIsSUFBaUI7SUFDeEMsSUFBSSxJQUFJLFlBQVksdUJBQWEsRUFBRTtRQUNqQyxNQUFNLE9BQU8sR0FBRywyQkFBa0IsQ0FBQyxJQUFJLEVBQUUsSUFBSSxDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBQ3ZELE1BQU0sTUFBTSxHQUFHLDJCQUFrQixDQUFDLElBQUksRUFBRSxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUM7UUFDckQsSUFDRSxDQUFDLE9BQU87WUFDUixDQUFDLE1BQU0sSUFBSSxTQUFTLElBQUksQ0FBQyxNQUFNLENBQUMsV0FBVyxFQUFFLENBQUMsUUFBUSxDQUFDLFFBQVEsQ0FBQyxDQUFDLEVBQ2pFO1lBQ0EsT0FBTyxLQUFLLENBQUM7U0FDZDtLQUNGO0lBQ0QsT0FBTyxJQUFJLENBQUM7QUFDZCxDQUFDO0FBWkQsNEJBWUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG5TUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuKi9cbmltcG9ydCB7IENmblJlc291cmNlIH0gZnJvbSAnbW9ub2Nkayc7XG5pbXBvcnQgeyBDZm5EQkluc3RhbmNlIH0gZnJvbSAnbW9ub2Nkay9hd3MtcmRzJztcbmltcG9ydCB7IHJlc29sdmVJZlByaW1pdGl2ZSB9IGZyb20gJy4uLy4uLy4uL2NvbW1vbic7XG5cbi8qKlxuICogIE5vbi1BdXJvcmEgUkRTIERCIGluc3RhbmNlcyBoYXZlIG11bHRpLUFaIHN1cHBvcnQgZW5hYmxlZCAtIChDb250cm9sIElEczogMTY0LjMwOChhKSg3KShpKSwgMTY0LjMwOChhKSg3KShpaSkoQykpXG4gKiBAcGFyYW0gbm9kZSB0aGUgQ2ZuUmVzb3VyY2UgdG8gY2hlY2tcbiAqL1xuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gKG5vZGU6IENmblJlc291cmNlKTogYm9vbGVhbiB7XG4gIGlmIChub2RlIGluc3RhbmNlb2YgQ2ZuREJJbnN0YW5jZSkge1xuICAgIGNvbnN0IG11bHRpQXogPSByZXNvbHZlSWZQcmltaXRpdmUobm9kZSwgbm9kZS5tdWx0aUF6KTtcbiAgICBjb25zdCBlbmdpbmUgPSByZXNvbHZlSWZQcmltaXRpdmUobm9kZSwgbm9kZS5lbmdpbmUpO1xuICAgIGlmIChcbiAgICAgICFtdWx0aUF6ICYmXG4gICAgICAoZW5naW5lID09IHVuZGVmaW5lZCB8fCAhZW5naW5lLnRvTG93ZXJDYXNlKCkuaW5jbHVkZXMoJ2F1cm9yYScpKVxuICAgICkge1xuICAgICAgcmV0dXJuIGZhbHNlO1xuICAgIH1cbiAgfVxuICByZXR1cm4gdHJ1ZTtcbn1cbiJdfQ==