"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const monocdk_1 = require("monocdk");
const aws_elasticsearch_1 = require("monocdk/aws-elasticsearch");
/**
 * OpenSearch Service domains are within VPCs - (Control IDs: 164.308(a)(3)(i), 164.308(a)(4)(ii)(A), 164.308(a)(4)(ii)(C), 164.312(a)(1), 164.312(e)(1))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_elasticsearch_1.CfnDomain) {
        const vpcOptions = monocdk_1.Stack.of(node).resolve(node.vpcOptions);
        if (vpcOptions != undefined) {
            if (vpcOptions.subnetIds == undefined ||
                vpcOptions.subnetIds.length == 0) {
                return false;
            }
        }
        else {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaGlwYWFTZWN1cml0eU9wZW5TZWFyY2hJblZQQ09ubHkuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9zcmMvSElQQUEtU2VjdXJpdHkvcnVsZXMvb3BlbnNlYXJjaC9oaXBhYVNlY3VyaXR5T3BlblNlYXJjaEluVlBDT25seS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUE7OztFQUdFOztBQUVGLHFDQUE2QztBQUM3QyxpRUFBc0Q7QUFFdEQ7OztHQUdHO0FBQ0gsbUJBQXlCLElBQWlCO0lBQ3hDLElBQUksSUFBSSxZQUFZLDZCQUFTLEVBQUU7UUFDN0IsTUFBTSxVQUFVLEdBQUcsZUFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBQzNELElBQUksVUFBVSxJQUFJLFNBQVMsRUFBRTtZQUMzQixJQUNFLFVBQVUsQ0FBQyxTQUFTLElBQUksU0FBUztnQkFDakMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxNQUFNLElBQUksQ0FBQyxFQUNoQztnQkFDQSxPQUFPLEtBQUssQ0FBQzthQUNkO1NBQ0Y7YUFBTTtZQUNMLE9BQU8sS0FBSyxDQUFDO1NBQ2Q7S0FDRjtJQUNELE9BQU8sSUFBSSxDQUFDO0FBQ2QsQ0FBQztBQWZELDRCQWVDIiwic291cmNlc0NvbnRlbnQiOlsiLypcbkNvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiovXG5cbmltcG9ydCB7IENmblJlc291cmNlLCBTdGFjayB9IGZyb20gJ21vbm9jZGsnO1xuaW1wb3J0IHsgQ2ZuRG9tYWluIH0gZnJvbSAnbW9ub2Nkay9hd3MtZWxhc3RpY3NlYXJjaCc7XG5cbi8qKlxuICogT3BlblNlYXJjaCBTZXJ2aWNlIGRvbWFpbnMgYXJlIHdpdGhpbiBWUENzIC0gKENvbnRyb2wgSURzOiAxNjQuMzA4KGEpKDMpKGkpLCAxNjQuMzA4KGEpKDQpKGlpKShBKSwgMTY0LjMwOChhKSg0KShpaSkoQyksIDE2NC4zMTIoYSkoMSksIDE2NC4zMTIoZSkoMSkpXG4gKiBAcGFyYW0gbm9kZSB0aGUgQ2ZuUmVzb3VyY2UgdG8gY2hlY2tcbiAqL1xuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gKG5vZGU6IENmblJlc291cmNlKTogYm9vbGVhbiB7XG4gIGlmIChub2RlIGluc3RhbmNlb2YgQ2ZuRG9tYWluKSB7XG4gICAgY29uc3QgdnBjT3B0aW9ucyA9IFN0YWNrLm9mKG5vZGUpLnJlc29sdmUobm9kZS52cGNPcHRpb25zKTtcbiAgICBpZiAodnBjT3B0aW9ucyAhPSB1bmRlZmluZWQpIHtcbiAgICAgIGlmIChcbiAgICAgICAgdnBjT3B0aW9ucy5zdWJuZXRJZHMgPT0gdW5kZWZpbmVkIHx8XG4gICAgICAgIHZwY09wdGlvbnMuc3VibmV0SWRzLmxlbmd0aCA9PSAwXG4gICAgICApIHtcbiAgICAgICAgcmV0dXJuIGZhbHNlO1xuICAgICAgfVxuICAgIH0gZWxzZSB7XG4gICAgICByZXR1cm4gZmFsc2U7XG4gICAgfVxuICB9XG4gIHJldHVybiB0cnVlO1xufVxuIl19