"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_ecs_1 = require("monocdk/aws-ecs");
const common_1 = require("../../../common");
/**
 * Containers in ECS task definitions configured for host networking have 'privileged' set to true and a non-empty non-root 'user' - (Control IDs: 164.308(a)(3)(i), 164.308(a)(3)(ii)(A), 164.308(a)(4)(ii)(A), 164.308(a)(4)(ii)(C), 164.312(a)(1))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_ecs_1.CfnTaskDefinition) {
        if (node.networkMode === aws_ecs_1.NetworkMode.HOST) {
            const containerDefinitions = monocdk_1.Stack.of(node).resolve(node.containerDefinitions);
            if (containerDefinitions !== undefined) {
                for (const containerDefinition of containerDefinitions) {
                    const resolvedDefinition = monocdk_1.Stack.of(node).resolve(containerDefinition);
                    const privileged = common_1.resolveIfPrimitive(node, resolvedDefinition.privileged);
                    const user = common_1.resolveIfPrimitive(node, resolvedDefinition.user);
                    if (privileged !== true || user === undefined) {
                        return false;
                    }
                    const rootIdentifiers = ['root', '0'];
                    const userParts = user.split(':');
                    for (const userPart of userParts) {
                        if (rootIdentifiers.includes(userPart.toLowerCase())) {
                            return false;
                        }
                    }
                }
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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