"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const monocdk_1 = require("monocdk");
const aws_ec2_1 = require("monocdk/aws-ec2");
const common_1 = require("../../../common");
/**
 * EC2 instances do not have public IPs - (Control IDs: 164.308(a)(3)(i), 164.308(a)(4)(ii)(A), 164.308(a)(4)(ii)(C), 164.312(a)(1), 164.312(e)(1))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_ec2_1.CfnInstance) {
        const networkInterfaces = monocdk_1.Stack.of(node).resolve(node.networkInterfaces);
        if (networkInterfaces != undefined) {
            //Iterate through network interfaces, checking if public IPs are enabled
            for (const networkInterface of networkInterfaces) {
                const resolvedInterface = monocdk_1.Stack.of(node).resolve(networkInterface);
                const associatePublicIpAddress = common_1.resolveIfPrimitive(node, resolvedInterface.associatePublicIpAddress);
                if (associatePublicIpAddress === true) {
                    return false;
                }
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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