"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const aws_autoscaling_1 = require("monocdk/aws-autoscaling");
const aws_ec2_1 = require("monocdk/aws-ec2");
const common_1 = require("../../../common");
/**
 * EC2 instances have detailed monitoring enabled - (Control ID: 164.312(b))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_ec2_1.CfnInstance) {
        const monitoring = common_1.resolveIfPrimitive(node, node.monitoring);
        if (monitoring == undefined || monitoring == false) {
            return false;
        }
    }
    else if (node instanceof aws_autoscaling_1.CfnLaunchConfiguration) {
        const monitoring = common_1.resolveIfPrimitive(node, node.instanceMonitoring);
        if (monitoring != undefined && monitoring == false) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaGlwYWFTZWN1cml0eUVDMkluc3RhbmNlRGV0YWlsZWRNb25pdG9yaW5nRW5hYmxlZC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9ISVBBQS1TZWN1cml0eS9ydWxlcy9lYzIvaGlwYWFTZWN1cml0eUVDMkluc3RhbmNlRGV0YWlsZWRNb25pdG9yaW5nRW5hYmxlZC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUE7OztFQUdFOztBQUdGLDZEQUFpRTtBQUNqRSw2Q0FBOEM7QUFDOUMsNENBQXFEO0FBRXJEOzs7R0FHRztBQUNILG1CQUF5QixJQUFpQjtJQUN4QyxJQUFJLElBQUksWUFBWSxxQkFBVyxFQUFFO1FBQy9CLE1BQU0sVUFBVSxHQUFHLDJCQUFrQixDQUFDLElBQUksRUFBRSxJQUFJLENBQUMsVUFBVSxDQUFDLENBQUM7UUFDN0QsSUFBSSxVQUFVLElBQUksU0FBUyxJQUFJLFVBQVUsSUFBSSxLQUFLLEVBQUU7WUFDbEQsT0FBTyxLQUFLLENBQUM7U0FDZDtLQUNGO1NBQU0sSUFBSSxJQUFJLFlBQVksd0NBQXNCLEVBQUU7UUFDakQsTUFBTSxVQUFVLEdBQUcsMkJBQWtCLENBQUMsSUFBSSxFQUFFLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO1FBQ3JFLElBQUksVUFBVSxJQUFJLFNBQVMsSUFBSSxVQUFVLElBQUksS0FBSyxFQUFFO1lBQ2xELE9BQU8sS0FBSyxDQUFDO1NBQ2Q7S0FDRjtJQUNELE9BQU8sSUFBSSxDQUFDO0FBQ2QsQ0FBQztBQWJELDRCQWFDIiwic291cmNlc0NvbnRlbnQiOlsiLypcbkNvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiovXG5cbmltcG9ydCB7IENmblJlc291cmNlIH0gZnJvbSAnbW9ub2Nkayc7XG5pbXBvcnQgeyBDZm5MYXVuY2hDb25maWd1cmF0aW9uIH0gZnJvbSAnbW9ub2Nkay9hd3MtYXV0b3NjYWxpbmcnO1xuaW1wb3J0IHsgQ2ZuSW5zdGFuY2UgfSBmcm9tICdtb25vY2RrL2F3cy1lYzInO1xuaW1wb3J0IHsgcmVzb2x2ZUlmUHJpbWl0aXZlIH0gZnJvbSAnLi4vLi4vLi4vY29tbW9uJztcblxuLyoqXG4gKiBFQzIgaW5zdGFuY2VzIGhhdmUgZGV0YWlsZWQgbW9uaXRvcmluZyBlbmFibGVkIC0gKENvbnRyb2wgSUQ6IDE2NC4zMTIoYikpXG4gKiBAcGFyYW0gbm9kZSB0aGUgQ2ZuUmVzb3VyY2UgdG8gY2hlY2tcbiAqL1xuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gKG5vZGU6IENmblJlc291cmNlKTogYm9vbGVhbiB7XG4gIGlmIChub2RlIGluc3RhbmNlb2YgQ2ZuSW5zdGFuY2UpIHtcbiAgICBjb25zdCBtb25pdG9yaW5nID0gcmVzb2x2ZUlmUHJpbWl0aXZlKG5vZGUsIG5vZGUubW9uaXRvcmluZyk7XG4gICAgaWYgKG1vbml0b3JpbmcgPT0gdW5kZWZpbmVkIHx8IG1vbml0b3JpbmcgPT0gZmFsc2UpIHtcbiAgICAgIHJldHVybiBmYWxzZTtcbiAgICB9XG4gIH0gZWxzZSBpZiAobm9kZSBpbnN0YW5jZW9mIENmbkxhdW5jaENvbmZpZ3VyYXRpb24pIHtcbiAgICBjb25zdCBtb25pdG9yaW5nID0gcmVzb2x2ZUlmUHJpbWl0aXZlKG5vZGUsIG5vZGUuaW5zdGFuY2VNb25pdG9yaW5nKTtcbiAgICBpZiAobW9uaXRvcmluZyAhPSB1bmRlZmluZWQgJiYgbW9uaXRvcmluZyA9PSBmYWxzZSkge1xuICAgICAgcmV0dXJuIGZhbHNlO1xuICAgIH1cbiAgfVxuICByZXR1cm4gdHJ1ZTtcbn1cbiJdfQ==