"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_s3_1 = require("monocdk/aws-s3");
const common_1 = require("../../../common");
/**
 * S3 Buckets should have public access restricted and blocked.
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_s3_1.CfnBucket) {
        if (node.publicAccessBlockConfiguration == undefined) {
            return false;
        }
        const publicAccess = monocdk_1.Stack.of(node).resolve(node.publicAccessBlockConfiguration);
        const blockPublicAcls = common_1.resolveIfPrimitive(node, publicAccess.blockPublicAcls);
        const blockPublicPolicy = common_1.resolveIfPrimitive(node, publicAccess.blockPublicPolicy);
        const ignorePublicAcls = common_1.resolveIfPrimitive(node, publicAccess.ignorePublicAcls);
        const restrictPublicBuckets = common_1.resolveIfPrimitive(node, publicAccess.restrictPublicBuckets);
        if (blockPublicAcls !== true ||
            blockPublicPolicy !== true ||
            ignorePublicAcls !== true ||
            restrictPublicBuckets !== true) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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