"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_stepfunctions_1 = require("monocdk/aws-stepfunctions");
const common_1 = require("../../../common");
/**
 * Step Function log "ALL" events to CloudWatch Logs
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_stepfunctions_1.CfnStateMachine) {
        const loggingConfiguration = monocdk_1.Stack.of(node).resolve(node.loggingConfiguration);
        if (loggingConfiguration == undefined) {
            return false;
        }
        const level = common_1.resolveIfPrimitive(node, loggingConfiguration.level);
        if (level == undefined || level != aws_stepfunctions_1.LogLevel.ALL) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiU0YxLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vc3JjL0F3c1NvbHV0aW9ucy9ydWxlcy9zZXJ2ZXJsZXNzL1NGMS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBOzs7RUFHRTtBQUNGLHFDQUE2QztBQUM3QyxpRUFBc0U7QUFDdEUsNENBQXFEO0FBRXJEOzs7R0FHRztBQUNILG1CQUF5QixJQUFpQjtJQUN4QyxJQUFJLElBQUksWUFBWSxtQ0FBZSxFQUFFO1FBQ25DLE1BQU0sb0JBQW9CLEdBQUcsZUFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxPQUFPLENBQ2pELElBQUksQ0FBQyxvQkFBb0IsQ0FDMUIsQ0FBQztRQUNGLElBQUksb0JBQW9CLElBQUksU0FBUyxFQUFFO1lBQ3JDLE9BQU8sS0FBSyxDQUFDO1NBQ2Q7UUFDRCxNQUFNLEtBQUssR0FBRywyQkFBa0IsQ0FBQyxJQUFJLEVBQUUsb0JBQW9CLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDbkUsSUFBSSxLQUFLLElBQUksU0FBUyxJQUFJLEtBQUssSUFBSSw0QkFBUSxDQUFDLEdBQUcsRUFBRTtZQUMvQyxPQUFPLEtBQUssQ0FBQztTQUNkO0tBQ0Y7SUFDRCxPQUFPLElBQUksQ0FBQztBQUNkLENBQUM7QUFkRCw0QkFjQyIsInNvdXJjZXNDb250ZW50IjpbIi8qXG5Db3B5cmlnaHQgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cblNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4qL1xuaW1wb3J0IHsgQ2ZuUmVzb3VyY2UsIFN0YWNrIH0gZnJvbSAnbW9ub2Nkayc7XG5pbXBvcnQgeyBDZm5TdGF0ZU1hY2hpbmUsIExvZ0xldmVsIH0gZnJvbSAnbW9ub2Nkay9hd3Mtc3RlcGZ1bmN0aW9ucyc7XG5pbXBvcnQgeyByZXNvbHZlSWZQcmltaXRpdmUgfSBmcm9tICcuLi8uLi8uLi9jb21tb24nO1xuXG4vKipcbiAqIFN0ZXAgRnVuY3Rpb24gbG9nIFwiQUxMXCIgZXZlbnRzIHRvIENsb3VkV2F0Y2ggTG9nc1xuICogQHBhcmFtIG5vZGUgdGhlIENmblJlc291cmNlIHRvIGNoZWNrXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIChub2RlOiBDZm5SZXNvdXJjZSk6IGJvb2xlYW4ge1xuICBpZiAobm9kZSBpbnN0YW5jZW9mIENmblN0YXRlTWFjaGluZSkge1xuICAgIGNvbnN0IGxvZ2dpbmdDb25maWd1cmF0aW9uID0gU3RhY2sub2Yobm9kZSkucmVzb2x2ZShcbiAgICAgIG5vZGUubG9nZ2luZ0NvbmZpZ3VyYXRpb24sXG4gICAgKTtcbiAgICBpZiAobG9nZ2luZ0NvbmZpZ3VyYXRpb24gPT0gdW5kZWZpbmVkKSB7XG4gICAgICByZXR1cm4gZmFsc2U7XG4gICAgfVxuICAgIGNvbnN0IGxldmVsID0gcmVzb2x2ZUlmUHJpbWl0aXZlKG5vZGUsIGxvZ2dpbmdDb25maWd1cmF0aW9uLmxldmVsKTtcbiAgICBpZiAobGV2ZWwgPT0gdW5kZWZpbmVkIHx8IGxldmVsICE9IExvZ0xldmVsLkFMTCkge1xuICAgICAgcmV0dXJuIGZhbHNlO1xuICAgIH1cbiAgfVxuICByZXR1cm4gdHJ1ZTtcbn1cbiJdfQ==